/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import com.google.common.primitives.Ints;
import de.qfm.erp.common.request.quotation.QEntityAliasUpdateRequest;
import de.qfm.erp.common.request.quotation.QEntityUpdateRequest;
import de.qfm.erp.common.response.quotation.EntityCommon;
import de.qfm.erp.common.response.quotation.EntityDashboardListCommon;
import de.qfm.erp.common.response.quotation.QEntityAutoCompleteResponse;
import de.qfm.erp.common.response.quotation.QEntityNextAddendumNumberResponse;
import de.qfm.erp.common.response.quotation.QEntityTreePageCommon;
import de.qfm.erp.common.response.quotation.QStageTreeItemCommon;
import de.qfm.erp.common.response.quotation.QStagesTreeListCommon;
import de.qfm.erp.common.response.quotation.StageListCommon;
import de.qfm.erp.service.helper.DateRangeHelper;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.helper.QEntityHelper;
import de.qfm.erp.service.helper.QuotationHelper;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.internal.quotation.EEntitySort;
import de.qfm.erp.service.model.internal.quotation.EQEntityAutoCompleteMode;
import de.qfm.erp.service.model.internal.quotation.QEntityTreeStatistics;
import de.qfm.erp.service.model.internal.quotation.QEntityUpdateBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.invoice.EntityNumber;
import de.qfm.erp.service.model.jpa.quotation.EQEntityState;
import de.qfm.erp.service.model.jpa.quotation.EQStageState;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.EQTreeRootStage;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.service.handler.CustomerHandler;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.EntityHandler;
import de.qfm.erp.service.service.handler.ProjectHandler;
import de.qfm.erp.service.service.handler.StageHandler;
import de.qfm.erp.service.service.handler.UserHandler;
import de.qfm.erp.service.service.mapper.QEntityMapper;
import de.qfm.erp.service.service.mapper.StageMapper;
import de.qfm.erp.service.service.route.EntityRoute;
import de.qfm.erp.service.service.route.impl.EntityRouteImpl;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.service.QNumberService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EntityRouteImpl
implements EntityRoute {
    private static final Logger log = LogManager.getLogger(EntityRouteImpl.class);
    private static final Comparator<QEntityTreeStatistics> QENTITY_TREE_COMPARATOR = (left, right) -> {
        String leftString = QuotationHelper.stageName((QEntityTreeStatistics)left);
        String rightString = QuotationHelper.stageName((QEntityTreeStatistics)right);
        return StringUtils.compareIgnoreCase((String)leftString, (String)rightString);
    };
    private static final Comparator<QEntityTreeStatistics> QENTITY_VERSION_TREE_COMPARATOR = (left, right) -> {
        Integer leftVersion = (Integer)MoreObjects.firstNonNull((Object)left.getVersion(), (Object)0);
        Integer rightVersion = (Integer)MoreObjects.firstNonNull((Object)right.getVersion(), (Object)0);
        int versionCompare = Ints.compare((int)leftVersion, (int)rightVersion);
        if (0 != versionCompare) {
            return versionCompare;
        }
        String leftString = QuotationHelper.stageName((QEntityTreeStatistics)left);
        String rightString = QuotationHelper.stageName((QEntityTreeStatistics)right);
        return StringUtils.compareIgnoreCase((String)leftString, (String)rightString);
    };
    private final EntityFactory entityFactory;
    private final CustomerHandler customerHandler;
    private final MessageService messageService;
    private final QEntityMapper entityMapper;
    private final StageMapper stageMapper;
    private final EntityHandler entityHandler;
    private final StageHandler stageHandler;
    private final QNumberService qNumberService;
    private final ProjectHandler projectHandler;
    private final UserHandler userHandler;

    @Nonnull
    @Transactional(readOnly=true)
    public EntityCommon byId(long qEntityId) {
        QEntity entity = (QEntity)this.entityHandler.byIdFailing(Long.valueOf(qEntityId));
        return this.entityMapper.mapToCommon(entity);
    }

    @Nonnull
    public StageListCommon stagesById(long id) {
        QEntity entity = (QEntity)this.entityHandler.byIdFailing(Long.valueOf(id));
        Set stages = (Set)MoreObjects.firstNonNull((Object)entity.getStages(), (Object)ImmutableSet.of());
        return this.stageMapper.mapToList((Iterable)stages, true);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public QEntityTreePageCommon pageAsTree(int page, int size, @NonNull String filterText, Long filterCustomerId, boolean flagShowCostUnits, boolean includeArchived) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        ImmutableSet customers = null != filterCustomerId ? ImmutableSet.of((Object)((Customer)this.customerHandler.byIdFailing(filterCustomerId))) : ImmutableSet.of();
        Iterable entityStates = includeArchived ? EQEntityState.ALL : EQEntityState.ALL_NON_ARCHIVED;
        Collection stageStates = includeArchived ? EQStageState.ALL_VALID : EQStageState.ALL_STATES_WITHOUT_ARCHIVED;
        Iterable statistics = this.entityHandler.stagesStatistics(page, size, filterText, Range.all(), Range.all(), Range.all(), (Iterable)customers, (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), entityStates, (Iterable)stageStates, true, true, EEntitySort.STAGE_NUMBER_DESC);
        return this.entityMapper.mapPageToCommon((Pageable)PageRequest.of((int)page, (int)size), flagShowCostUnits, statistics);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public EntityDashboardListCommon pageAsList(int page, int size, @NonNull String filterText, @Nullable LocalDateTime submissionDateTimeUntil, @Nullable LocalDate plannedSubmissionDateUntil, @Nullable LocalDate executionPeriodFrom, @Nullable LocalDate executionPeriodTo, Iterable<Long> filterProjectTeamIds, Iterable<Long> filterPersonResponsibleIds, Iterable<Long> filterCustomerIds, Iterable<String> filterEntityStates, String sort) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        EEntitySort entitySort = EEntitySort.lookupFailing((String)sort);
        Iterable customers = this.customerHandler.allByIds(filterCustomerIds);
        Iterable projects = this.projectHandler.allByIds(filterProjectTeamIds);
        Iterable responsibleUsers = this.userHandler.allByIds(filterPersonResponsibleIds);
        Iterable entityStates = Streams.stream(filterEntityStates).filter(Objects::nonNull).map(item -> EQEntityState.lookup((String)item, (EQEntityState)EQEntityState.UNKNOWN)).collect(Collectors.toSet());
        Range submissionDateTimeRange = DateRangeHelper.dateTimeRange(null, (LocalDateTime)submissionDateTimeUntil);
        Range plannedSubmissionDateRange = DateRangeHelper.dateRange(null, (LocalDate)plannedSubmissionDateUntil);
        Range executionPeriodRange = DateRangeHelper.dateRange((LocalDate)executionPeriodFrom, (LocalDate)executionPeriodTo);
        Iterable entityStatistics = this.entityHandler.primaryStageStatistics(page, size, filterText, submissionDateTimeRange, plannedSubmissionDateRange, executionPeriodRange, customers, projects, responsibleUsers, entityStates, (Iterable)EQStageState.ALL_VALID, true, true, entitySort);
        return this.entityMapper.mapToDashboardCommon(entityStatistics);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public QStagesTreeListCommon treeById(long id, boolean filterArchived) {
        Iterable statistics = this.entityHandler.stagesStatistics(id, filterArchived);
        Iterable stagesWithParent = (Iterable)Streams.stream((Iterable)statistics).filter(item -> null != item.getParentId()).collect(ImmutableSet.toImmutableSet());
        ImmutableList.Builder itemCommonBuilder = ImmutableList.builder();
        ImmutableListMultimap stagesByStageType = Multimaps.index((Iterable)statistics, QEntityTreeStatistics::getStageType);
        Map stagesById = MapsHelper.mapFirst((Iterable)statistics, QEntityTreeStatistics::getStageId);
        ImmutableListMultimap stagesByReferenceId = Multimaps.index((Iterable)stagesWithParent, QEntityTreeStatistics::getParentId);
        AtomicLong rootId = new AtomicLong(1L);
        for (EQTreeRootStage rootStage : EQTreeRootStage.ROOT_STAGE_TYPES) {
            ImmutableCollection stageTypes = EQTreeRootStage.ROOT_STAGE_TYPE_CHILDREN.get((Object)rootStage);
            ImmutableList stagesForStage = (ImmutableList)stageTypes.stream().flatMap(arg_0 -> EntityRouteImpl.lambda$treeById$4((Multimap)stagesByStageType, arg_0)).collect(ImmutableList.toImmutableList());
            ImmutableList stagesForStageSorted = ImmutableList.sortedCopyOf((Comparator)QENTITY_VERSION_TREE_COMPARATOR, (Iterable)stagesForStage);
            String stageTypeName = this.messageService.get((Translatable)rootStage, new Object[0]);
            if (!stagesForStageSorted.isEmpty()) {
                itemCommonBuilder.addAll((Iterable)this.treeItemsForStages((Iterable)ImmutableList.of((Object)stageTypeName), (Iterable)stagesForStageSorted, (Multimap)stagesByStageType, stagesById, (Multimap)stagesByReferenceId));
                continue;
            }
            itemCommonBuilder.add((Object)EntityRouteImpl.treeItem((Long)rootId.getAndIncrement(), (List)ImmutableList.of((Object)stageTypeName), (String)stageTypeName, (String)"", null, (String)"", (String)rootStage.name(), (EQStageState)EQStageState.UNKNOWN, (String)"", (String)"", (String)""));
        }
        ImmutableList qStageTreeItemCommons = itemCommonBuilder.build();
        return new QStagesTreeListCommon(qStageTreeItemCommons.size(), (List)qStageTreeItemCommons);
    }

    @Nonnull
    private ImmutableList<QStageTreeItemCommon> treeItemsForStages(@NonNull Iterable<String> path, @NonNull Iterable<QEntityTreeStatistics> stages, @NonNull Multimap<EQStageType, QEntityTreeStatistics> allStages, @NonNull Map<Long, QEntityTreeStatistics> stagesById, @NonNull Multimap<Long, QEntityTreeStatistics> stagesByReferenceId) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (stages == null) {
            throw new NullPointerException("stages is marked non-null but is null");
        }
        if (allStages == null) {
            throw new NullPointerException("allStages is marked non-null but is null");
        }
        if (stagesById == null) {
            throw new NullPointerException("stagesById is marked non-null but is null");
        }
        if (stagesByReferenceId == null) {
            throw new NullPointerException("stagesByReferenceId is marked non-null but is null");
        }
        ImmutableList.Builder itemCommonBuilder = ImmutableList.builder();
        if (!Iterables.isEmpty(stages)) {
            for (QEntityTreeStatistics parentStage : stages) {
                EQStageType parentStageType = parentStage.getStageType();
                List pathToBeUsed = EntityRouteImpl.pathToBeUsed((QEntityTreeStatistics)parentStage, path);
                QStageTreeItemCommon parent = EntityRouteImpl.treeItem((Iterable)pathToBeUsed, (QEntityTreeStatistics)parentStage);
                itemCommonBuilder.add((Object)parent);
                List parentPath = parent.getPath();
                Collection childStageTypes = EQStageType.CHILD_STAGE_TYPES.get((Object)parentStageType);
                for (EQStageType childStageType : childStageTypes) {
                    Collection childStagesForType = parentStageType == EQStageType.COMMISSION ? (Collection)allStages.get((Object)childStageType).stream().filter(item -> Objects.equals(parentStage, EntityRouteImpl.rootCommission((Map)stagesById, (QEntityTreeStatistics)item))).sorted(QENTITY_VERSION_TREE_COMPARATOR).collect(ImmutableList.toImmutableList()) : (Collection)allStages.get((Object)childStageType).stream().sorted(QENTITY_VERSION_TREE_COMPARATOR).collect(ImmutableList.toImmutableList());
                    for (QEntityTreeStatistics childStage : childStagesForType) {
                        List childPathToBeUsed = EntityRouteImpl.pathToBeUsed((QEntityTreeStatistics)childStage, (Iterable)parentPath);
                        EQStageType stageType = childStage.getStageType();
                        Long childStageId = childStage.getStageId();
                        Collection childChildStageTypes = EQStageType.CHILD_STAGE_TYPES.get((Object)stageType);
                        QStageTreeItemCommon self = EntityRouteImpl.treeItem((Iterable)childPathToBeUsed, (QEntityTreeStatistics)childStage);
                        itemCommonBuilder.add((Object)self);
                        List selfPath = self.getPath();
                        for (EQStageType childChildStageType : childChildStageTypes) {
                            Iterable childrenOfStage = (Iterable)stagesByReferenceId.get((Object)childStageId).stream().filter(item -> childChildStageType == item.getStageType()).sorted(QENTITY_VERSION_TREE_COMPARATOR).collect(ImmutableList.toImmutableList());
                            ImmutableList childTreeItems = this.treeItemsForStages((Iterable)selfPath, childrenOfStage, allStages, stagesById, stagesByReferenceId);
                            itemCommonBuilder.addAll((Iterable)childTreeItems);
                        }
                    }
                }
            }
        }
        return itemCommonBuilder.build();
    }

    @Nullable
    private static QEntityTreeStatistics rootCommission(@NonNull Map<Long, QEntityTreeStatistics> stagesById, @NonNull QEntityTreeStatistics item) {
        if (stagesById == null) {
            throw new NullPointerException("stagesById is marked non-null but is null");
        }
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        Long referenceId = item.getParentId();
        QEntityTreeStatistics supposedParent = stagesById.get(referenceId);
        while (null != supposedParent) {
            EQStageType stageType = supposedParent.getStageType();
            if (stageType == EQStageType.COMMISSION) {
                return supposedParent;
            }
            referenceId = supposedParent.getParentId();
            supposedParent = stagesById.get(referenceId);
        }
        return null;
    }

    @Nonnull
    private static List<String> pathToBeUsed(@NonNull QEntityTreeStatistics stage, @NonNull Iterable<String> parentPath) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (parentPath == null) {
            throw new NullPointerException("parentPath is marked non-null but is null");
        }
        String subProjectName = stage.getSubProjectName();
        Long subProjectId = stage.getSubProjectId();
        ImmutableList pathToBeUsed = null != subProjectId ? ImmutableList.builder().addAll(parentPath).add((Object)subProjectName).build() : ImmutableList.copyOf(parentPath);
        return pathToBeUsed;
    }

    @Nonnull
    private static QStageTreeItemCommon treeItem(@NonNull Iterable<String> path, @NonNull QEntityTreeStatistics treeStatistics) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (treeStatistics == null) {
            throw new NullPointerException("treeStatistics is marked non-null but is null");
        }
        String referenceAlias = StringUtils.trimToEmpty((String)treeStatistics.getReferenceAlias());
        String referenceQNumber = StringUtils.trimToEmpty((String)treeStatistics.getReferenceQNumber());
        String referenceName = StringUtils.isNotBlank((CharSequence)referenceAlias) ? referenceAlias : referenceQNumber;
        Long referenceId = treeStatistics.getParentId();
        Long stageId = treeStatistics.getStageId();
        String stageQNumber = StringUtils.trimToEmpty((String)treeStatistics.getStageQNumber());
        String orderDescriptionCustomer = StringUtils.trimToEmpty((String)treeStatistics.getOrderDescriptionCustomer());
        String orderDescriptionInternal = StringUtils.trimToEmpty((String)treeStatistics.getOrderDescriptionInternal());
        String orderNumber = StringUtils.trimToEmpty((String)treeStatistics.getOrderNumber());
        EQStageType stageType = (EQStageType)MoreObjects.firstNonNull((Object)treeStatistics.getStageType(), (Object)EQStageType.UNKNOWN);
        EQStageState stageState = (EQStageState)MoreObjects.firstNonNull((Object)treeStatistics.getStageState(), (Object)EQStageState.UNKNOWN);
        String stageName = QuotationHelper.stageName((QEntityTreeStatistics)treeStatistics);
        ImmutableList localPath = (ImmutableList)Stream.concat(Streams.stream(path), Stream.of(stageName + "[S" + stageId + "]")).collect(ImmutableList.toImmutableList());
        return EntityRouteImpl.treeItem((Long)stageId, (List)localPath, (String)stageName, (String)stageQNumber, (Long)referenceId, (String)referenceName, (String)stageType.name(), (EQStageState)stageState, (String)orderDescriptionCustomer, (String)orderDescriptionInternal, (String)orderNumber);
    }

    @Transactional
    @Nonnull
    public EntityCommon update(@NonNull QEntityUpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        QEntity entity = this.entityFactory.qEntity();
        return this.mergeAndPersist(entity, updateRequest);
    }

    @Transactional
    @Nonnull
    public EntityCommon update(@NonNull Long id, @NonNull QEntityUpdateRequest updateRequest) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        QEntity entity = (QEntity)this.entityHandler.byIdFailing(id);
        return this.mergeAndPersist(entity, updateRequest);
    }

    @Transactional
    @Nonnull
    public EntityCommon update(@NonNull Long id, @NonNull QEntityAliasUpdateRequest aliasUpdateRequest) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (aliasUpdateRequest == null) {
            throw new NullPointerException("aliasUpdateRequest is marked non-null but is null");
        }
        QEntity entity = (QEntity)this.entityHandler.byIdFailing(id);
        entity.setAlias(StringUtils.trimToEmpty((String)aliasUpdateRequest.getAlias()));
        QEntity entityUpdated = (QEntity)this.entityHandler.update((EntityBase)entity);
        return this.entityMapper.mapToCommon(entityUpdated);
    }

    @Nonnull
    public QEntityNextAddendumNumberResponse nextAddendumNumber(@NonNull Long id, @Nullable Long stageId) {
        Quotation stage;
        Long addendumNumber;
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (null != stageId && null != (addendumNumber = (stage = (Quotation)this.stageHandler.byIdFailing(stageId)).getAddendumNumber())) {
            return QEntityNextAddendumNumberResponse.of((Long)addendumNumber);
        }
        QEntity entity = (QEntity)this.entityHandler.byIdFailing(id);
        Long nextAddendumNumber = QEntityHelper.determineAvailableAddendumNumber((QEntity)entity);
        return QEntityNextAddendumNumberResponse.of((Long)nextAddendumNumber);
    }

    @Nonnull
    public QEntityAutoCompleteResponse standardAutoComplete(@NonNull String filterText, @NonNull String autoCompleteMode) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        if (autoCompleteMode == null) {
            throw new NullPointerException("autoCompleteMode is marked non-null but is null");
        }
        EQEntityAutoCompleteMode entityAutoCompleteMode = EQEntityAutoCompleteMode.lookup((String)autoCompleteMode, (EQEntityAutoCompleteMode)EQEntityAutoCompleteMode.ALL);
        ImmutableSet.Builder entityStatesBuilder = ImmutableSet.builder();
        switch (1.$SwitchMap$de$qfm$erp$service$model$internal$quotation$EQEntityAutoCompleteMode[entityAutoCompleteMode.ordinal()]) {
            case 1: {
                entityStatesBuilder.addAll((Iterable)ImmutableSet.of((Object)EQEntityState.COMMISSION_ACTIVE, (Object)EQEntityState.COMMISSION_CLOSED, (Object)EQEntityState.COMMISSION_REWORK, (Object)EQEntityState.COMMISSION_ARCHIVED, (Object)EQEntityState.QUOTATION_SUBMITTED));
                break;
            }
        }
        ImmutableSet entityStates = entityStatesBuilder.build();
        Page page = this.entityHandler.page(0, 25, filterText, Range.all(), Range.all(), Range.all(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)entityStates, true, false, false);
        return this.entityMapper.mapAutoComplete(page);
    }

    @Nonnull
    private EntityCommon mergeAndPersist(@NonNull QEntity entity, QEntityUpdateRequest updateRequest) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        QEntityUpdateBucket updateBucket = QEntityUpdateBucket.of((QEntity)entity, (QEntityUpdateRequest)updateRequest);
        QEntity entityMerged = this.entityMapper.merge(entity, updateBucket);
        EntityNumber entityNumber = this.qNumberService.determineNextQNumber();
        String entityNumberAsString = this.qNumberService.format(entityNumber);
        entityMerged.setQNumber(entityNumberAsString);
        QEntity entityUpdated = (QEntity)this.entityHandler.update((EntityBase)entityMerged);
        return this.entityMapper.mapToCommon(entityUpdated);
    }

    @Nonnull
    private static QStageTreeItemCommon treeItem(@NonNull Long id, @NonNull List<String> path, @NonNull String name, @NonNull String qnumber, Long referenceId, @NonNull String referenceName, @NonNull String stageTypeString, @NonNull EQStageState stageState, @NonNull String orderDescriptionCustomer, @NonNull String orderDescriptionInternal, @NonNull String orderNumber) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (qnumber == null) {
            throw new NullPointerException("qnumber is marked non-null but is null");
        }
        if (referenceName == null) {
            throw new NullPointerException("referenceName is marked non-null but is null");
        }
        if (stageTypeString == null) {
            throw new NullPointerException("stageTypeString is marked non-null but is null");
        }
        if (stageState == null) {
            throw new NullPointerException("stageState is marked non-null but is null");
        }
        if (orderDescriptionCustomer == null) {
            throw new NullPointerException("orderDescriptionCustomer is marked non-null but is null");
        }
        if (orderDescriptionInternal == null) {
            throw new NullPointerException("orderDescriptionInternal is marked non-null but is null");
        }
        if (orderNumber == null) {
            throw new NullPointerException("orderNumber is marked non-null but is null");
        }
        QStageTreeItemCommon treeItemCommon = new QStageTreeItemCommon();
        treeItemCommon.setId(id);
        treeItemCommon.setName(name);
        treeItemCommon.setQentityNumber(qnumber);
        treeItemCommon.setStageType(stageTypeString);
        String stageStateString = stageState.name();
        treeItemCommon.setStageState(stageStateString);
        treeItemCommon.setPath(path);
        treeItemCommon.setReferenceId(referenceId);
        treeItemCommon.setReferenceName(referenceName);
        treeItemCommon.setOrderDescriptionCustomer(orderDescriptionCustomer);
        treeItemCommon.setOrderDescriptionInternal(orderDescriptionInternal);
        treeItemCommon.setOrderNumber(orderNumber);
        return treeItemCommon;
    }

    public EntityRouteImpl(EntityFactory entityFactory, CustomerHandler customerHandler, MessageService messageService, QEntityMapper entityMapper, StageMapper stageMapper, EntityHandler entityHandler, StageHandler stageHandler, QNumberService qNumberService, ProjectHandler projectHandler, UserHandler userHandler) {
        this.entityFactory = entityFactory;
        this.customerHandler = customerHandler;
        this.messageService = messageService;
        this.entityMapper = entityMapper;
        this.stageMapper = stageMapper;
        this.entityHandler = entityHandler;
        this.stageHandler = stageHandler;
        this.qNumberService = qNumberService;
        this.projectHandler = projectHandler;
        this.userHandler = userHandler;
    }

    private static /* synthetic */ Stream lambda$treeById$4(Multimap stagesByStageType, EQStageType item) {
        return stagesByStageType.get((Object)item).stream();
    }
}

