/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.service.configuration.NodeConfig;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.search.ECustomerIndexField;
import de.qfm.erp.service.model.search.EIndexEntryType;
import de.qfm.erp.service.model.search.IndexDocument;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.IndexResult;
import de.qfm.erp.service.service.handler.CustomerHandler;
import de.qfm.erp.service.service.mapper.CustomerSearchMapper;
import de.qfm.erp.service.service.mapper.search.InternalQueryHelper;
import de.qfm.erp.service.service.route.AbstractSyncable;
import de.qfm.erp.service.service.service.search.IndexService;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Query;
import org.springframework.stereotype.Service;

@Service
public class CustomerSearchRoute
extends AbstractSyncable<Customer> {
    private static final Logger log = LogManager.getLogger(CustomerSearchRoute.class);
    private final CustomerHandler customerHandler;
    private final CustomerSearchMapper customerSearchMapper;
    private final IndexService indexService;

    public CustomerSearchRoute(@NonNull NodeConfig nodeConfig, @NonNull CustomerHandler customerHandler, @NonNull CustomerSearchMapper CustomerSearchMapper2, @NonNull IndexService indexService) {
        super(nodeConfig);
        if (nodeConfig == null) {
            throw new NullPointerException("nodeConfig is marked non-null but is null");
        }
        if (customerHandler == null) {
            throw new NullPointerException("customerHandler is marked non-null but is null");
        }
        if (CustomerSearchMapper2 == null) {
            throw new NullPointerException("CustomerSearchMapper is marked non-null but is null");
        }
        if (indexService == null) {
            throw new NullPointerException("indexService is marked non-null but is null");
        }
        this.customerHandler = customerHandler;
        this.customerSearchMapper = CustomerSearchMapper2;
        this.indexService = indexService;
    }

    @Nonnull
    public EIndexEntryType indexEntryType() {
        return EIndexEntryType.CUSTOMER;
    }

    @Nonnull
    public Iterable<Customer> refresh(@NonNull Iterable<Customer> itemStream) {
        if (itemStream == null) {
            throw new NullPointerException("itemStream is marked non-null but is null");
        }
        ImmutableList.Builder entriesUpdatedBuilder = ImmutableList.builder();
        itemStream.forEach(item -> this.refresh(item).ifPresent(arg_0 -> ((ImmutableList.Builder)entriesUpdatedBuilder).add(arg_0)));
        return entriesUpdatedBuilder.build();
    }

    @Nonnull
    public Optional<Customer> refresh(@NonNull Customer Customer2) {
        if (Customer2 == null) {
            throw new NullPointerException("Customer is marked non-null but is null");
        }
        String entryId = Customer2.getReferenceId();
        try {
            IndexResult index = this.index(Customer2);
            log.debug("Refreshed Entity: {} in Index", (Object)Customer2);
            return Optional.of(Customer2);
        }
        catch (Exception ioe) {
            log.error("Error Refreshing Index for EntryId: {}, Entry: {}", (Object)entryId, (Object)Customer2, (Object)ioe);
            return Optional.empty();
        }
    }

    public boolean dirty() {
        return this.customerHandler.dirty();
    }

    @Nonnull
    public Iterable<Customer> streamDirty(int max) {
        return this.customerHandler.dirtyPage(max);
    }

    @Nonnull
    public Long id(@NonNull Customer item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item.getId();
    }

    @Nonnull
    public Iterable<Long> ids(@NonNull Iterable<Customer> items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        return (Iterable)Streams.stream(items).map(Customer::getId).collect(ImmutableSet.toImmutableSet());
    }

    public void start() {
        log.info("Detected Dirty Entries - refreshing Entries in Index");
    }

    public void finish(@NonNull Iterable<Customer> itemsProcessed, @NonNull Stopwatch stopwatch) {
        if (itemsProcessed == null) {
            throw new NullPointerException("itemsProcessed is marked non-null but is null");
        }
        if (stopwatch == null) {
            throw new NullPointerException("stopwatch is marked non-null but is null");
        }
        int size = Iterables.size(itemsProcessed);
        long elapsedInMs = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        int markedAsIndexed = this.customerHandler.markIndexed(itemsProcessed);
        log.info("Finished Refreshing Dirty Entries, amount: {}, took: {} ms", (Object)size, (Object)elapsedInMs);
    }

    @Nonnull
    private Optional<String> delete(@NonNull Customer customer) {
        if (customer == null) {
            throw new NullPointerException("customer is marked non-null but is null");
        }
        try {
            String documentId = CustomerSearchMapper.documentId((EIndexEntryType)this.indexEntryType(), (Long)customer.getId());
            long indexGeneration = this.indexService.deleteFromIndex((Query)InternalQueryHelper.termQuery((IndexField)ECustomerIndexField._ID, (String)documentId));
            log.debug("Deleted Entity: {}", (Object)customer);
            return Optional.of(customer.getReferenceId());
        }
        catch (IOException e) {
            log.error("Error Deleting Entry from Index, error: {}", (Object)e.getMessage());
            return Optional.of(e.getMessage());
        }
    }

    @Nonnull
    private IndexResult index(@NonNull Customer customer) throws IOException {
        if (customer == null) {
            throw new NullPointerException("customer is marked non-null but is null");
        }
        IndexDocument indexDocument = this.customerSearchMapper.mapToDocument(customer, this.indexEntryType());
        return this.indexService.updateIndex(indexDocument);
    }

    @Nonnull
    private Iterable<IndexResult> index(@NonNull Iterable<Customer> customers) throws IOException {
        if (customers == null) {
            throw new NullPointerException("customers is marked non-null but is null");
        }
        Iterable indexDocuments = this.customerSearchMapper.mapToDocument(customers, this.indexEntryType());
        return this.indexService.updateIndex(indexDocuments);
    }
}

