/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.common.request.customer.v2.AddressUpdateItem;
import de.qfm.erp.common.request.customer.v2.ContactPersonUpdateItem;
import de.qfm.erp.common.request.customer.v2.CustomerUpdateRequest;
import de.qfm.erp.common.response.customer.AddressAutoCompleteResponse;
import de.qfm.erp.common.response.customer.AddressCommon;
import de.qfm.erp.common.response.customer.ContactPersonAutoCompleteResponse;
import de.qfm.erp.common.response.customer.CustomerAutoCompleteResponse;
import de.qfm.erp.common.response.customer.CustomerCommon;
import de.qfm.erp.common.response.customer.CustomerPageCommon;
import de.qfm.erp.common.response.customer.CustomerQEntitiesPageCommon;
import de.qfm.erp.common.response.customer.CustomerSharepointResponse;
import de.qfm.erp.service.configuration.ApplicationConfig;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.model.internal.customer.AddressUpdateBucket;
import de.qfm.erp.service.model.internal.customer.ContactPersonUpdateBucket;
import de.qfm.erp.service.model.internal.customer.CustomerUpdateBucket;
import de.qfm.erp.service.model.internal.eventbus.CustomerChangeMessage;
import de.qfm.erp.service.model.internal.sharepoint.ESharepointState;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.customer.Address;
import de.qfm.erp.service.model.jpa.customer.ContactPerson;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.customer.EAddressType;
import de.qfm.erp.service.model.jpa.customer.ECustomerState;
import de.qfm.erp.service.model.jpa.customer.ECustomerType;
import de.qfm.erp.service.model.jpa.quotation.EQEntityState;
import de.qfm.erp.service.service.handler.AddressHandler;
import de.qfm.erp.service.service.handler.ContactPersonHandler;
import de.qfm.erp.service.service.handler.CustomerHandler;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.EntityHandler;
import de.qfm.erp.service.service.mapper.CustomerMapper;
import de.qfm.erp.service.service.route.CustomerRoute;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CustomerRouteImpl
implements CustomerRoute {
    public static final Splitter COMMA_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();
    private ApplicationEventPublisher applicationEventPublisher;
    private final ApplicationConfig applicationConfig;
    private final AddressHandler addressHandler;
    private final ContactPersonHandler contactPersonHandler;
    private final CustomerMapper mapper;
    private final CustomerHandler handler;
    private final EntityHandler entityHandler;
    private final EntityFactory entityFactory;

    @Transactional(readOnly=true)
    @Nonnull
    public CustomerCommon byId(long id) {
        return this.mapper.map((Customer)this.handler.byIdFailing(Long.valueOf(id)));
    }

    @Transactional(readOnly=true)
    @Nonnull
    public CustomerQEntitiesPageCommon qEntitiesById(long id) {
        Customer customer = (Customer)this.handler.byIdFailing(Long.valueOf(id));
        Page qEntityPage = this.entityHandler.page(0, 100, "", Range.all(), Range.all(), Range.all(), (Iterable)ImmutableSet.of((Object)customer), (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of(), EQEntityState.ALL, false, true, true);
        return this.mapper.mapCustomerQEntity(qEntityPage);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public CustomerPageCommon page(int page, int size, @NonNull String filterText, boolean flagIncludeArchived) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        return this.mapper.map(this.handler.page(page, size, filterText, flagIncludeArchived));
    }

    @Transactional(readOnly=true)
    @Nonnull
    public CustomerAutoCompleteResponse autoComplete(boolean flagIncludeArchived, @NonNull String filterText) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        Page customersPage = this.handler.page(0, 100, filterText, flagIncludeArchived);
        return this.mapper.mapAutoComplete(customersPage);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public AddressCommon addressById(@NonNull Long id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        Address address = (Address)this.addressHandler.byIdFailing(id);
        return this.mapper.map(address);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public AddressAutoCompleteResponse addressAutoComplete(@Nullable Long filterCustomerId, @NonNull String filterText, @NonNull String filterAddressTypeString) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        if (filterAddressTypeString == null) {
            throw new NullPointerException("filterAddressTypeString is marked non-null but is null");
        }
        List filterAddressTypes = COMMA_SPLITTER.splitToList((CharSequence)filterAddressTypeString);
        ImmutableSet.Builder addressTypeBuilder = ImmutableSet.builder();
        filterAddressTypes.forEach(item -> EAddressType.lookup((String)item).ifPresent(arg_0 -> ((ImmutableSet.Builder)addressTypeBuilder).add(arg_0)));
        ImmutableSet addressTypes = addressTypeBuilder.build();
        ImmutableSet customers = null != filterCustomerId ? this.handler.allByIds((Iterable)ImmutableSet.of((Object)filterCustomerId)) : ImmutableSet.of();
        Page addressPage = this.addressHandler.page(0, 100, (Iterable)customers, (Iterable)addressTypes, filterText);
        return this.mapper.mapAddressAutoComplete(addressPage);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public ContactPersonAutoCompleteResponse contactPersonAutoComplete(@Nullable Long filterCustomerId, @NonNull String filterText) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        ImmutableSet customers = null != filterCustomerId ? this.handler.allByIds((Iterable)ImmutableSet.of((Object)filterCustomerId)) : ImmutableSet.of();
        Page contactPersonPage = this.contactPersonHandler.page(0, 100, (Iterable)customers, filterText);
        return this.mapper.mapContactPersonAutoComplete(contactPersonPage);
    }

    @Transactional
    @Nonnull
    public CustomerCommon update(@NonNull CustomerUpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        Customer customer = this.entityFactory.customer();
        CustomerUpdateBucket customerUpdateBucket = this.getCustomerUpdateBucket(updateRequest, customer, false);
        return this.mergeAndPersist(customerUpdateBucket, false);
    }

    @Transactional
    @Nonnull
    public CustomerCommon update(long id, @NonNull CustomerUpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        Customer customer = (Customer)this.handler.byIdFailing(Long.valueOf(id));
        CustomerUpdateBucket customerUpdateBucket = this.getCustomerUpdateBucket(updateRequest, customer, false);
        return this.mergeAndPersist(customerUpdateBucket, false);
    }

    @Transactional
    @Nonnull
    public CustomerCommon fromInquiry(@NonNull CustomerUpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        Customer customer = this.entityFactory.customer();
        CustomerUpdateBucket customerUpdateBucket = this.getCustomerUpdateBucket(updateRequest, customer, true);
        return this.mergeAndPersist(customerUpdateBucket, false);
    }

    @Transactional
    @Nonnull
    public CustomerCommon fromInquiry(long id, @NonNull CustomerUpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        Customer customer = (Customer)this.handler.byIdFailing(Long.valueOf(id));
        CustomerUpdateBucket customerUpdateBucket = this.getCustomerUpdateBucket(updateRequest, customer, true);
        return this.mergeAndPersist(customerUpdateBucket, true);
    }

    @Transactional
    @Nonnull
    public CustomerCommon updateStateForId(long id, @NonNull String newStateCandidate) {
        if (newStateCandidate == null) {
            throw new NullPointerException("newStateCandidate is marked non-null but is null");
        }
        ECustomerState customerState = ECustomerState.lookupFailing((String)newStateCandidate);
        Customer customer = (Customer)this.handler.byIdFailing(Long.valueOf(id));
        customer.setCustomerState(customerState);
        Customer customerUpdated = this.updateAndEmitMessage(customer);
        return this.mapper.map(customerUpdated);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public CustomerSharepointResponse sharepointById(long customerId) {
        Customer customer = (Customer)this.handler.byIdFailing(Long.valueOf(customerId));
        ESharepointState sharepointState = (ESharepointState)MoreObjects.firstNonNull((Object)customer.getSharepointState(), (Object)ESharepointState.UNKNOWN);
        String sharepointUrl = customer.getSharepointUrl();
        return CustomerSharepointResponse.of((long)customerId, (String)sharepointState.name(), (String)sharepointUrl);
    }

    @Nonnull
    private CustomerUpdateBucket getCustomerUpdateBucket(@NonNull CustomerUpdateRequest updateRequest, @NonNull Customer customer, boolean modal) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        if (customer == null) {
            throw new NullPointerException("customer is marked non-null but is null");
        }
        String customerTypeString = StringUtils.trimToEmpty((String)updateRequest.getCustomerType());
        ECustomerType customerType = ECustomerType.lookup((String)customerTypeString, (ECustomerType)ECustomerType.UNKNOWN);
        ImmutableList.Builder addressUpdateBucketBuilder = ImmutableList.builder();
        List addressUpdateItems = (List)MoreObjects.firstNonNull((Object)updateRequest.getAddresses(), (Object)ImmutableList.of());
        ImmutableSet addressIds = (ImmutableSet)addressUpdateItems.stream().map(AddressUpdateItem::getId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Iterable addresses = this.addressHandler.allByIds((Iterable)addressIds);
        Map addressById = MapsHelper.mapFirst((Iterable)addresses, Address::getId);
        boolean isNewCustomer = null == customer.getId();
        boolean initAddressType = modal || isNewCustomer;
        boolean hasPrimary = ((Set)MoreObjects.firstNonNull((Object)customer.getAddresses(), (Object)ImmutableSet.of())).stream().anyMatch(item -> (item.getValidEnd().isEqual(DateTimeHelper.today()) || item.getValidEnd().isAfter(DateTimeHelper.today())) && item.getAddressType() == EAddressType.PRIMARY);
        EAddressType addressTypeDefault = !hasPrimary ? EAddressType.PRIMARY : EAddressType.SECONDARY;
        for (AddressUpdateItem addressUpdateItem : addressUpdateItems) {
            LocalDate validEnd;
            Long addressId = addressUpdateItem.getId();
            String addressTypeString = StringUtils.trimToEmpty((String)addressUpdateItem.getAddressType());
            EAddressType addressTypeCandidate = EAddressType.lookup((String)addressTypeString, (EAddressType)EAddressType.UNKNOWN);
            EAddressType addressType = initAddressType || EAddressType.UNKNOWN == addressTypeCandidate ? addressTypeDefault : addressTypeCandidate;
            Address address = null != addressId ? addressById.getOrDefault(addressId, this.entityFactory.address()) : this.entityFactory.address();
            boolean changed = CustomerRouteImpl.existingChanged((AddressUpdateItem)addressUpdateItem, (Address)address, (EAddressType)addressType);
            LocalDate localDate = validEnd = null != addressUpdateItem.getValidEnd() ? addressUpdateItem.getValidEnd() : this.applicationConfig.getDefaultEndDate();
            if (changed) {
                Object reference = null != address.getReferenceAddress() ? address.getReferenceAddress() : address;
                addressUpdateBucketBuilder.add((Object)AddressUpdateBucket.of((Long)address.getId(), (Address)address, (Address)address.getReferenceAddress(), (EAddressType)address.getAddressType(), (String)address.getName(), (String)address.getAddressSuffix(), (String)address.getPoBox(), (String)address.getStreet(), (String)address.getStreetNo(), (String)address.getZipCode(), (String)address.getCity(), (String)address.getEmail(), (String)address.getPortal(), (String)address.getRemarks(), (LocalDate)address.getValidBegin(), (LocalDate)DateTimeHelper.today()));
                addressUpdateBucketBuilder.add((Object)AddressUpdateBucket.of(null, (Address)address, (Address)reference, (EAddressType)addressType, (String)addressUpdateItem.getName(), (String)addressUpdateItem.getAddressSuffix(), (String)addressUpdateItem.getPoBox(), (String)addressUpdateItem.getStreet(), (String)addressUpdateItem.getStreetNo(), (String)addressUpdateItem.getZipCode(), (String)addressUpdateItem.getCity(), (String)addressUpdateItem.getEmail(), (String)addressUpdateItem.getPortal(), (String)addressUpdateItem.getRemarks(), (LocalDate)addressUpdateItem.getValidBegin(), (LocalDate)validEnd));
                continue;
            }
            addressUpdateBucketBuilder.add((Object)AddressUpdateBucket.of((Long)addressUpdateItem.getId(), (Address)address, null, (EAddressType)addressType, (String)addressUpdateItem.getName(), (String)addressUpdateItem.getAddressSuffix(), (String)addressUpdateItem.getPoBox(), (String)addressUpdateItem.getStreet(), (String)addressUpdateItem.getStreetNo(), (String)addressUpdateItem.getZipCode(), (String)addressUpdateItem.getCity(), (String)addressUpdateItem.getEmail(), (String)addressUpdateItem.getPortal(), (String)addressUpdateItem.getRemarks(), (LocalDate)addressUpdateItem.getValidBegin(), (LocalDate)validEnd));
        }
        ImmutableList addressUpdateBuckets = addressUpdateBucketBuilder.build();
        ImmutableList.Builder contactPersonUpdateBucketBuilder = ImmutableList.builder();
        List contactPersonUpdateItems = (List)MoreObjects.firstNonNull((Object)updateRequest.getContactPersons(), (Object)ImmutableList.of());
        ImmutableSet contactPersonIds = (ImmutableSet)contactPersonUpdateItems.stream().map(ContactPersonUpdateItem::getId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Iterable contactPersons = this.contactPersonHandler.allByIds((Iterable)contactPersonIds);
        Map contactPersonsById = MapsHelper.mapFirst((Iterable)contactPersons, ContactPerson::getId);
        for (ContactPersonUpdateItem contactPersonUpdateItem : contactPersonUpdateItems) {
            LocalDate validEnd;
            Long contactPersonId = contactPersonUpdateItem.getId();
            ContactPerson contactPerson = null != contactPersonId ? contactPersonsById.getOrDefault(contactPersonId, this.entityFactory.contactPerson()) : this.entityFactory.contactPerson();
            boolean changed = CustomerRouteImpl.existingChanged((ContactPersonUpdateItem)contactPersonUpdateItem, (ContactPerson)contactPerson);
            LocalDate localDate = validEnd = null != contactPersonUpdateItem.getValidEnd() ? contactPersonUpdateItem.getValidEnd() : this.applicationConfig.getDefaultEndDate();
            if (changed) {
                ContactPerson reference = null != contactPerson.getReferenceContactPerson() ? contactPerson.getReferenceContactPerson() : contactPerson;
                contactPersonUpdateBucketBuilder.add((Object)ContactPersonUpdateBucket.of((Long)contactPerson.getId(), (ContactPerson)contactPerson, (ContactPerson)reference, (String)contactPerson.getSalutation(), (String)contactPerson.getTitle(), (String)contactPerson.getFirstName(), (String)contactPerson.getLastName(), (String)contactPerson.getDepartment(), (String)contactPerson.getPosition(), (String)contactPerson.getPhone(), (String)contactPerson.getCellular(), (String)contactPerson.getEmail(), (String)contactPerson.getRemarks(), (LocalDate)contactPerson.getBirthDayDate(), (LocalDate)contactPerson.getValidBegin(), (LocalDate)DateTimeHelper.today()));
                contactPersonUpdateBucketBuilder.add((Object)ContactPersonUpdateBucket.of(null, (ContactPerson)contactPerson, (ContactPerson)reference, (String)contactPersonUpdateItem.getSalutation(), (String)contactPersonUpdateItem.getTitle(), (String)contactPersonUpdateItem.getFirstName(), (String)contactPersonUpdateItem.getLastName(), (String)contactPersonUpdateItem.getDepartment(), (String)contactPersonUpdateItem.getPosition(), (String)contactPersonUpdateItem.getPhone(), (String)contactPersonUpdateItem.getCellular(), (String)contactPersonUpdateItem.getEmail(), (String)contactPersonUpdateItem.getRemarks(), (LocalDate)contactPersonUpdateItem.getBirthDayDate(), (LocalDate)contactPersonUpdateItem.getValidBegin(), (LocalDate)validEnd));
                continue;
            }
            contactPersonUpdateBucketBuilder.add((Object)ContactPersonUpdateBucket.of((Long)contactPersonUpdateItem.getId(), (ContactPerson)contactPerson, null, (String)contactPersonUpdateItem.getSalutation(), (String)contactPersonUpdateItem.getTitle(), (String)contactPersonUpdateItem.getFirstName(), (String)contactPersonUpdateItem.getLastName(), (String)contactPersonUpdateItem.getDepartment(), (String)contactPersonUpdateItem.getPosition(), (String)contactPersonUpdateItem.getPhone(), (String)contactPersonUpdateItem.getCellular(), (String)contactPersonUpdateItem.getEmail(), (String)contactPersonUpdateItem.getRemarks(), (LocalDate)contactPersonUpdateItem.getBirthDayDate(), (LocalDate)contactPersonUpdateItem.getValidBegin(), (LocalDate)validEnd));
        }
        ImmutableList contactPersonUpdateBuckets = contactPersonUpdateBucketBuilder.build();
        CustomerUpdateBucket customerUpdateBucket = CustomerUpdateBucket.of((CustomerUpdateRequest)updateRequest, (Customer)customer, (ECustomerType)customerType, (List)addressUpdateBuckets, (List)contactPersonUpdateBuckets);
        return customerUpdateBucket;
    }

    @VisibleForTesting
    static boolean existingChanged(@NonNull AddressUpdateItem addressUpdateItem, @NonNull Address address, @NonNull EAddressType addressTypeNew) {
        if (addressUpdateItem == null) {
            throw new NullPointerException("addressUpdateItem is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (addressTypeNew == null) {
            throw new NullPointerException("addressTypeNew is marked non-null but is null");
        }
        Long id = address.getId();
        if (null == id) {
            return false;
        }
        EAddressType addressTypeExisting = address.getAddressType();
        String nameExisting = address.getName();
        String cityExisting = address.getCity();
        String zipCodeExisting = address.getZipCode();
        String addressSuffixExisting = address.getAddressSuffix();
        String poBoxExisting = address.getPoBox();
        String streetExisting = address.getStreet();
        String streetNoExisting = address.getStreetNo();
        String emailExisting = address.getEmail();
        String nameNew = addressUpdateItem.getName();
        String cityNew = addressUpdateItem.getCity();
        String zipCodeNew = addressUpdateItem.getZipCode();
        String addressSuffixNew = addressUpdateItem.getAddressSuffix();
        String poBoxNew = addressUpdateItem.getPoBox();
        String streetNew = addressUpdateItem.getStreet();
        String streetNoNew = addressUpdateItem.getStreetNo();
        String emailNew = addressUpdateItem.getEmail();
        boolean addressTypeChanged = addressTypeExisting != addressTypeNew;
        boolean nameChanged = CustomerRouteImpl.changed((String)nameExisting, (String)nameNew);
        boolean cityChanged = CustomerRouteImpl.changed((String)cityExisting, (String)cityNew);
        boolean zipCodeChanged = CustomerRouteImpl.changed((String)zipCodeExisting, (String)zipCodeNew);
        boolean addressSuffixChanged = CustomerRouteImpl.changed((String)addressSuffixExisting, (String)addressSuffixNew);
        boolean poBoxChanged = CustomerRouteImpl.changed((String)poBoxExisting, (String)poBoxNew);
        boolean streetChanged = CustomerRouteImpl.changed((String)streetExisting, (String)streetNew);
        boolean streetNoChanged = CustomerRouteImpl.changed((String)streetNoExisting, (String)streetNoNew);
        boolean emailChanged = CustomerRouteImpl.changed((String)emailExisting, (String)emailNew);
        return addressTypeChanged || nameChanged || cityChanged || zipCodeChanged || addressSuffixChanged || poBoxChanged || streetChanged || streetNoChanged || emailChanged;
    }

    @VisibleForTesting
    static boolean existingChanged(@NonNull ContactPersonUpdateItem contactPersonUpdateItem, @NonNull ContactPerson contactPerson) {
        if (contactPersonUpdateItem == null) {
            throw new NullPointerException("contactPersonUpdateItem is marked non-null but is null");
        }
        if (contactPerson == null) {
            throw new NullPointerException("contactPerson is marked non-null but is null");
        }
        Long id = contactPerson.getId();
        if (null == id) {
            return false;
        }
        String titleExisting = contactPerson.getTitle();
        String salutationExisting = contactPerson.getSalutation();
        String firstNameExisting = contactPerson.getFirstName();
        String lastNameExisting = contactPerson.getLastName();
        String departmentExisting = contactPerson.getDepartment();
        String positionExisting = contactPerson.getPosition();
        String phoneExisting = contactPerson.getPhone();
        String cellularExisting = contactPerson.getCellular();
        String emailExisting = contactPerson.getEmail();
        LocalDate birthDateExisting = contactPerson.getBirthDayDate();
        String titleNew = contactPersonUpdateItem.getTitle();
        String salutationNew = contactPersonUpdateItem.getSalutation();
        String firstNameNew = contactPersonUpdateItem.getFirstName();
        String lastNameNew = contactPersonUpdateItem.getLastName();
        String departmentNew = contactPersonUpdateItem.getDepartment();
        String positionNew = contactPersonUpdateItem.getPosition();
        String phoneNew = contactPersonUpdateItem.getPhone();
        String cellularNew = contactPersonUpdateItem.getCellular();
        String emailNew = contactPersonUpdateItem.getEmail();
        LocalDate birthDateNew = contactPersonUpdateItem.getBirthDayDate();
        boolean titleChanged = CustomerRouteImpl.changed((String)titleExisting, (String)titleNew);
        boolean salutationChanged = CustomerRouteImpl.changed((String)salutationExisting, (String)salutationNew);
        boolean firstNameChanged = CustomerRouteImpl.changed((String)firstNameExisting, (String)firstNameNew);
        boolean lastNameChanged = CustomerRouteImpl.changed((String)lastNameExisting, (String)lastNameNew);
        boolean departmentChanged = CustomerRouteImpl.changed((String)departmentExisting, (String)departmentNew);
        boolean positionChanged = CustomerRouteImpl.changed((String)positionExisting, (String)positionNew);
        boolean phoneChanged = CustomerRouteImpl.changed((String)phoneExisting, (String)phoneNew);
        boolean cellularChanged = CustomerRouteImpl.changed((String)cellularExisting, (String)cellularNew);
        boolean emailChanged = CustomerRouteImpl.changed((String)emailExisting, (String)emailNew);
        boolean birthDayChanged = CustomerRouteImpl.changed((LocalDate)birthDateExisting, (LocalDate)birthDateNew);
        return titleChanged || salutationChanged || firstNameChanged || lastNameChanged || departmentChanged || positionChanged || phoneChanged || cellularChanged || emailChanged || birthDayChanged;
    }

    @VisibleForTesting
    static boolean changed(@Nullable String left, @Nullable String right) {
        return !StringUtils.equalsIgnoreCase((CharSequence)StringUtils.trimToEmpty((String)left), (CharSequence)StringUtils.trimToEmpty((String)right));
    }

    @VisibleForTesting
    static boolean changed(@Nullable LocalDate left, @Nullable LocalDate right) {
        return !Objects.equals(left, right);
    }

    @Nonnull
    private CustomerCommon mergeAndPersist(@NonNull CustomerUpdateBucket updateBucket, boolean append) {
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        Customer customerMerged = this.mapper.merge(updateBucket, append);
        Customer customerUpdated = this.updateAndEmitMessage(customerMerged);
        return this.mapper.map(customerUpdated);
    }

    @Nonnull
    private Customer updateAndEmitMessage(@NonNull Customer entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        Customer itemUpdated = (Customer)this.handler.update((EntityBase)entity);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)CustomerChangeMessage.of((Object)this, (Customer)itemUpdated));
        return itemUpdated;
    }

    public CustomerRouteImpl(ApplicationEventPublisher applicationEventPublisher, ApplicationConfig applicationConfig, AddressHandler addressHandler, ContactPersonHandler contactPersonHandler, CustomerMapper mapper, CustomerHandler handler, EntityHandler entityHandler, EntityFactory entityFactory) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.applicationConfig = applicationConfig;
        this.addressHandler = addressHandler;
        this.contactPersonHandler = contactPersonHandler;
        this.mapper = mapper;
        this.handler = handler;
        this.entityHandler = entityHandler;
        this.entityFactory = entityFactory;
    }
}

