/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.collect.ImmutableSet;
import de.qfm.erp.common.response.user.JWTTokenResponse;
import de.qfm.erp.common.response.user.UserCommon;
import de.qfm.erp.service.helper.UserHelper;
import de.qfm.erp.service.model.exception.request.JwtTokenException;
import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.UserGetBucket;
import de.qfm.erp.service.model.internal.authentication.JwtToken;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.UserHandler;
import de.qfm.erp.service.service.mapper.JwtTokenMapper;
import de.qfm.erp.service.service.mapper.UserMapper;
import de.qfm.erp.service.service.route.AuthenticationRoute;
import de.qfm.erp.service.service.security.AuthenticationHelper;
import de.qfm.erp.service.service.security.JwtTokenProvider;
import io.jsonwebtoken.Claims;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthenticationRouteImpl
implements AuthenticationRoute {
    private static final Set<String> UNTOUCH_PASSWORD_USER_NAMES = ImmutableSet.of((Object)"admin", (Object)"sync");
    private final AuthenticationHelper authenticationHelper;
    private final UserHandler userHandler;
    private final UserMapper userMapper;
    private final JwtTokenProvider jwtTokenProvider;
    private final AuthenticationManager authenticationManager;
    private final JwtTokenMapper jwtTokenMapper;
    private static final String BCRYPT_PREFIX = "{bcrypt_12}";

    @Transactional
    @Nonnull
    public JWTTokenResponse signIn(@NonNull String username, @NonNull String password) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        String handledUserName = StringUtils.lowerCase((String)username);
        String passwordDecoded = this.authenticationHelper.decodePassword(password);
        Optional userCandidate = this.userHandler.byNameNotFailing(username);
        String passwordEncrypted = userCandidate.map(User::getPassword).orElse("");
        boolean shouldBeUntouched = StringUtils.startsWith((CharSequence)passwordEncrypted, (CharSequence)BCRYPT_PREFIX);
        String passwordHandled = shouldBeUntouched || UNTOUCH_PASSWORD_USER_NAMES.contains(handledUserName) ? passwordDecoded : StringUtils.upperCase((String)passwordDecoded);
        this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)passwordHandled));
        if (userCandidate.isEmpty()) {
            throw ResourceNotFoundException.of((String)User.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.USER__NAME), (String)username);
        }
        User user = (User)userCandidate.get();
        if (!Objects.equals(user.getAllowedToLogin(), Boolean.TRUE)) {
            throw new DisabledException(String.format("User %s is disabled", user.getUsername()));
        }
        Iterable allRoles = UserHelper.allRoles((User)user);
        JwtToken jwtToken = this.jwtTokenProvider.signInToken(username, allRoles);
        return this.jwtTokenMapper.map(jwtToken);
    }

    @Transactional
    @Nonnull
    public UserCommon whoAmI(@NonNull HttpServletRequest req) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String token = this.jwtTokenProvider.resolveToken(req);
        String username = this.jwtTokenProvider.getUsername(token);
        User user = this.userHandler.byNameFailing(username);
        UserGetBucket userGetBucket = this.userHandler.userGetBucket(user);
        return this.userMapper.mapUser(userGetBucket);
    }

    @Transactional
    @Nonnull
    public JWTTokenResponse refresh(@NonNull HttpServletRequest req) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String token = this.jwtTokenProvider.resolveToken(req);
        Claims claims = this.jwtTokenProvider.claims(token);
        Date issuedAt = claims.getIssuedAt();
        Date expirationDate = claims.getExpiration();
        Date now = Date.from(Instant.now(Clock.systemUTC()));
        if (now.compareTo(expirationDate) >= 0) {
            throw new JwtTokenException("Refresh Token Expired");
        }
        JwtToken.JwtTokenPart refreshToken = JwtToken.JwtTokenPart.of((LocalDateTime)LocalDateTime.ofInstant(issuedAt.toInstant(), ZoneOffset.UTC), (LocalDateTime)LocalDateTime.ofInstant(expirationDate.toInstant(), ZoneOffset.UTC), (String)token);
        String username = this.jwtTokenProvider.getUsername(token);
        User user = this.userHandler.byNameFailing(username);
        Iterable allRoles = UserHelper.allRoles((User)user);
        JwtToken jwtToken = this.jwtTokenProvider.refreshToken(refreshToken, username, allRoles);
        return this.jwtTokenMapper.map(jwtToken);
    }

    public AuthenticationRouteImpl(AuthenticationHelper authenticationHelper, UserHandler userHandler, UserMapper userMapper, JwtTokenProvider jwtTokenProvider, AuthenticationManager authenticationManager, JwtTokenMapper jwtTokenMapper) {
        this.authenticationHelper = authenticationHelper;
        this.userHandler = userHandler;
        this.userMapper = userMapper;
        this.jwtTokenProvider = jwtTokenProvider;
        this.authenticationManager = authenticationManager;
        this.jwtTokenMapper = jwtTokenMapper;
    }
}

