/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.psx;

import com.google.common.collect.Streams;
import de.qfm.erp.service.model.external.psx.ExtPsxEntityType;
import de.qfm.erp.service.model.external.psx.search.PsxSearchResponse;
import de.qfm.erp.service.service.psx.PsxBaseClientService;
import de.qfm.erp.service.service.psx.PsxClientService;
import de.qfm.erp.service.service.psx.PsxPaths;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class PsxSearchClientService
extends PsxBaseClientService
implements PsxPaths {
    @Autowired
    public PsxSearchClientService(PsxClientService clientService) {
        super(clientService);
    }

    @Nonnull
    public PsxSearchResponse search(@NonNull String query, @NonNull Iterable<ExtPsxEntityType> entityTypes, int size) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (entityTypes == null) {
            throw new NullPointerException("entityTypes is marked non-null but is null");
        }
        Locale locale = LocaleContextHolder.getLocale();
        String localeString = locale.toString();
        String entityTypesAsString = Streams.stream(entityTypes).map(Enum::name).collect(Collectors.joining(","));
        return (PsxSearchResponse)((Response)((ResponseSpecification)((RequestSpecification)this.authContext().authorizedRequest().urlEncodingEnabled(true).accept(ContentType.JSON).header("Accept-Language", (Object)localeString, new Object[0]).queryParam("q", new Object[]{query}).queryParam("size", new Object[]{size}).queryParam("entity_types", new Object[]{entityTypesAsString}).log().all()).expect().statusCode(200).log().all()).when().get("/api/v1/psx/search/_autocomplete/", new Object[0])).as(PsxSearchResponse.class);
    }
}

