/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.psx;

import de.qfm.erp.service.configuration.PsxConfig;
import de.qfm.erp.service.model.external.psx.ExtPsxOrderNumberPageCommon;
import de.qfm.erp.service.model.external.psx.ExtPsxReleaseOrderBudgetListCommon;
import de.qfm.erp.service.model.external.psx.ExtPsxReleaseOrderCommon;
import de.qfm.erp.service.model.external.psx.ExtPsxReleaseOrderPageCommon;
import de.qfm.erp.service.service.psx.PsxBaseClientService;
import de.qfm.erp.service.service.psx.PsxClientService;
import de.qfm.erp.service.service.psx.PsxPaths;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PsxReleaseOrderClientService
extends PsxBaseClientService
implements PsxPaths {
    @Autowired
    public PsxReleaseOrderClientService(PsxClientService clientService) {
        super(clientService);
    }

    @Nonnull
    public ExtPsxReleaseOrderPageCommon releaseOrders(@NonNull String filterText, @NonNull Iterable<String> filterStageReferenceIds, @NonNull Iterable<String> filterUserReferenceIds) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        if (filterStageReferenceIds == null) {
            throw new NullPointerException("filterStageReferenceIds is marked non-null but is null");
        }
        if (filterUserReferenceIds == null) {
            throw new NullPointerException("filterUserReferenceIds is marked non-null but is null");
        }
        PsxConfig config = this.clientService.getConfig();
        Iterable measurementReleaseOrderStates = config.getMeasurementReleaseOrderStates();
        return (ExtPsxReleaseOrderPageCommon)((Response)((ResponseSpecification)((RequestSpecification)this.authContext().authorizedRequest().queryParam("page", new Object[]{0}).queryParam("size", new Object[]{1000}).queryParam("filter_text", new Object[]{filterText}).queryParam("filter_stage_reference_ids", new Object[]{REF_ID_JOINER.join(filterStageReferenceIds)}).queryParam("filter_user_reference_ids", new Object[]{REF_ID_JOINER.join(filterUserReferenceIds)}).queryParam("filter_release_order_state", new Object[]{REF_ID_JOINER.join(measurementReleaseOrderStates)}).log().all()).expect().statusCode(200).log().all()).when().get("/api/v1/psx/releaseorders/", new Object[0])).as(ExtPsxReleaseOrderPageCommon.class);
    }

    @Nonnull
    public ExtPsxReleaseOrderCommon releaseOrder(@NonNull String psxReleaseOrderReferenceId) {
        if (psxReleaseOrderReferenceId == null) {
            throw new NullPointerException("psxReleaseOrderReferenceId is marked non-null but is null");
        }
        return (ExtPsxReleaseOrderCommon)((Response)((ResponseSpecification)((RequestSpecification)this.authContext().authorizedRequest().log().all()).expect().statusCode(200).log().all()).when().get("/api/v1/psx/releaseorders/{referenceId}/", new Object[]{psxReleaseOrderReferenceId})).as(ExtPsxReleaseOrderCommon.class);
    }

    @Nonnull
    public ExtPsxOrderNumberPageCommon orderNumbers(long stageId) {
        return (ExtPsxOrderNumberPageCommon)((Response)((ResponseSpecification)((RequestSpecification)this.authContext().authorizedRequest().log().all()).expect().statusCode(200).log().all()).when().get("/api/v1/psx/releaseorders/stage_reference_id={stageReferenceId}/_order_numbers/", new Object[]{stageId})).as(ExtPsxOrderNumberPageCommon.class);
    }

    @Nonnull
    public ExtPsxReleaseOrderBudgetListCommon budgets(long stageId) {
        return (ExtPsxReleaseOrderBudgetListCommon)((Response)((ResponseSpecification)((RequestSpecification)this.authContext().authorizedRequest().log().all()).expect().statusCode(200).log().all()).when().get("/api/v1/psx/releaseorders/stage_reference_id={stageReferenceId}/_budgets/", new Object[]{stageId})).as(ExtPsxReleaseOrderBudgetListCommon.class);
    }
}

