/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.psx;

import com.google.common.io.BaseEncoding;
import de.leancoders.common.jackson.ObjectMapperFactory;
import de.qfm.erp.common.request.user.UserLoginRequest;
import de.qfm.erp.common.response.user.JWTTokenResponse;
import de.qfm.erp.service.configuration.PsxConfig;
import de.qfm.erp.service.model.external.psx.PsxAuthContext;
import io.restassured.RestAssured;
import io.restassured.config.ObjectMapperConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class PsxClientService {
    @Nonnull
    private static final RestAssuredConfig REST_ASSURED_CONFIG = RestAssuredConfig.config().objectMapperConfig(new ObjectMapperConfig().jackson2ObjectMapperFactory((type, s) -> ObjectMapperFactory.createDefaultObjectMapper()));
    @NonNull
    private final PsxConfig config;
    @NonNull
    private PsxAuthContext authContext;

    public PsxClientService(@Nonnull PsxConfig config) {
        this.config = config;
        this.authContext = PsxAuthContext.empty();
    }

    @Nonnull
    protected PsxAuthContext obtainAccessToken() {
        return this.obtainAccessToken(this.config.getUsername(), this.config.getPassword(), "/api/v1/psx/auth/_signin/");
    }

    @Nonnull
    protected PsxAuthContext obtainAccessToken(@NonNull String username, @NonNull String password, @NonNull String path) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        UserLoginRequest userLoginRequest = UserLoginRequest.of((String)username, (String)BaseEncoding.base64().encode(password.getBytes()));
        JWTTokenResponse token = (JWTTokenResponse)((Response)((ResponseSpecification)((RequestSpecification)this.given().accept(ContentType.JSON).contentType(ContentType.JSON).body((Object)userLoginRequest).log().all()).expect().statusCode(200).log().all()).when().post(path, new Object[0])).as(JWTTokenResponse.class);
        this.authContext = PsxAuthContext.success((String)username, (String)password, (JWTTokenResponse)token, () -> this.given());
        return this.authContext;
    }

    @Nonnull
    private RequestSpecification given() {
        return RestAssured.given().port(this.config.getPort()).baseUri(this.config.getBaseUri()).config(REST_ASSURED_CONFIG);
    }

    @Nonnull
    public PsxAuthContext validateAndGet() {
        if (!this.authContext.isAuthenticated()) {
            this.obtainAccessToken();
        }
        return this.authContext;
    }

    @NonNull
    public PsxConfig getConfig() {
        return this.config;
    }

    @NonNull
    public PsxAuthContext getAuthContext() {
        return this.authContext;
    }
}

