/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.psx;

import com.google.common.base.Joiner;
import de.qfm.erp.service.model.external.psx.PsxAuthContext;
import de.qfm.erp.service.service.psx.PsxClientService;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import lombok.NonNull;

public abstract class PsxBaseClientService {
    public static final Joiner REF_ID_JOINER = Joiner.on((String)",").skipNulls();
    protected final PsxClientService clientService;

    @Nonnull
    protected PsxAuthContext authContext() {
        return this.clientService.validateAndGet();
    }

    @Nonnull
    protected String encode(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return URLEncoder.encode(text, StandardCharsets.UTF_8);
    }

    protected PsxBaseClientService(PsxClientService clientService) {
        this.clientService = clientService;
    }

    public PsxClientService getClientService() {
        return this.clientService;
    }
}

