/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper.search;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import de.qfm.erp.service.model.search.EIndexEntryType;
import de.qfm.erp.service.model.search.EMeasurementIndexField;
import de.qfm.erp.service.model.search.IndexField;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.LongRange;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

/*
 * Exception performing whole class analysis ignored.
 */
public class InternalQueryHelper {
    @Nonnull
    public static TermQuery documentTypeQuery(@NonNull EIndexEntryType entryType) {
        if (entryType == null) {
            throw new NullPointerException("entryType is marked non-null but is null");
        }
        return InternalQueryHelper.termQuery((IndexField)EMeasurementIndexField._TYPE, (String)entryType.name());
    }

    @Nonnull
    public static PrefixQuery prefixQuery(@NonNull IndexField field, @NonNull String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new PrefixQuery(new Term(field.fieldName(), value));
    }

    @Nonnull
    public static BooleanQuery prefixQuery(@NonNull IndexField field, @NonNull Iterable<String> values) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        BooleanQuery.Builder booleanClauses = new BooleanQuery.Builder();
        booleanClauses.setMinimumNumberShouldMatch(1);
        values.forEach(value -> booleanClauses.add((Query)InternalQueryHelper.prefixQuery((IndexField)field, (String)value), BooleanClause.Occur.SHOULD));
        return booleanClauses.build();
    }

    @Nonnull
    public static PhraseQuery phraseQuery(@NonNull IndexField field, @NonNull String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        String[] split = Splitter.on((CharMatcher)CharMatcher.whitespace()).splitToList((CharSequence)value).toArray(new String[0]);
        return new PhraseQuery(field.fieldName(), split);
    }

    @Nonnull
    public static TermQuery termQuery(@NonNull IndexField field, @NonNull String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new TermQuery(new Term(field.fieldName(), value));
    }

    @Nonnull
    public static BooleanQuery allTermsWildCardQuery(@NonNull IndexField field, @NonNull Iterable<String> values) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return InternalQueryHelper.allTermsWildCardQuery((IndexField)field, values, (int)Iterables.size(values));
    }

    @Nonnull
    public static BooleanQuery allTermsWildCardQuery(@NonNull IndexField field, @NonNull Iterable<String> values, int minimumMustMatch) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        BooleanQuery.Builder booleanClauses = new BooleanQuery.Builder();
        booleanClauses.setMinimumNumberShouldMatch(minimumMustMatch);
        values.forEach(value -> booleanClauses.add(InternalQueryHelper.wildCardQuery((IndexField)field, (String)value), BooleanClause.Occur.SHOULD));
        return booleanClauses.build();
    }

    @Nonnull
    public static Optional<Query> allTermsQuery(@NonNull IndexField field, @NonNull Iterable<String> values) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return InternalQueryHelper.termsQuery((IndexField)field, values, (int)Iterables.size(values));
    }

    @Nonnull
    public static Optional<Query> termsQuery(@NonNull IndexField field, @NonNull Iterable<String> values) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return InternalQueryHelper.termsQuery((IndexField)field, values, (int)1);
    }

    @Nonnull
    public static Optional<Query> termsQuery(@NonNull IndexField field, @NonNull Iterable<String> values, int minimumMustMatch) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (!Iterables.isEmpty(values)) {
            BooleanQuery.Builder booleanClauses = new BooleanQuery.Builder();
            booleanClauses.setMinimumNumberShouldMatch(minimumMustMatch);
            values.forEach(value -> booleanClauses.add((Query)InternalQueryHelper.termQuery((IndexField)field, (String)value), BooleanClause.Occur.SHOULD));
            return Optional.of(booleanClauses.build());
        }
        return Optional.empty();
    }

    @Nonnull
    public static Query wildCardQuery(@NonNull IndexField field, @NonNull String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new WildcardQuery(new Term(field.fieldName(), "*" + value + "*"));
    }

    @Nonnull
    public static Query numericRangeQuery(@NonNull IndexField field, @NonNull Long lowerValue, @NonNull Long upperValue) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (lowerValue == null) {
            throw new NullPointerException("lowerValue is marked non-null but is null");
        }
        if (upperValue == null) {
            throw new NullPointerException("upperValue is marked non-null but is null");
        }
        return LongPoint.newRangeQuery((String)field.fieldName(), (long)lowerValue, (long)upperValue);
    }

    @Nonnull
    public static BooleanQuery numericRangesQuery(@NonNull IndexField field, @NonNull Iterable<Long> values) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        BooleanQuery.Builder booleanClauses = new BooleanQuery.Builder();
        booleanClauses.setMinimumNumberShouldMatch(1);
        values.forEach(value -> booleanClauses.add(InternalQueryHelper.numericRangeQuery((IndexField)field, (Long)value, (Long)value), BooleanClause.Occur.SHOULD));
        return booleanClauses.build();
    }

    @Nonnull
    public static Query numericQuery(@NonNull IndexField field, @NonNull Long value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        long[] d1 = new long[]{value};
        return LongRange.newContainsQuery((String)field.fieldName(), (long[])d1, (long[])d1);
    }

    @Nonnull
    public static Optional<Query> longsQuery(@NonNull IndexField field, @NonNull Iterable<Long> values) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (!Iterables.isEmpty(values)) {
            BooleanQuery.Builder booleanClauses = new BooleanQuery.Builder();
            booleanClauses.setMinimumNumberShouldMatch(1);
            values.forEach(value -> booleanClauses.add(InternalQueryHelper.numericQuery((IndexField)field, (Long)value), BooleanClause.Occur.SHOULD));
            return Optional.of(booleanClauses.build());
        }
        return Optional.empty();
    }

    @Nonnull
    public static String prettyPrint(@NonNull Query query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        String notPretty = query.toString();
        int openBrackets = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < notPretty.length(); ++i) {
            char c = notPretty.charAt(i);
            if (c == '(') {
                sb.append(System.lineSeparator());
                sb.append(StringUtils.repeat((char)' ', (int)(++openBrackets * 2)));
                sb.append(c);
                continue;
            }
            if (c == ')') {
                --openBrackets;
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

