/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.profile.UserSettingCommon;
import de.qfm.erp.common.response.profile.UserSettingListCommon;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.profile.UserSetting;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.mapper.BaseMapper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class UserSettingMapper {
    private static final Logger log = LogManager.getLogger(UserSettingMapper.class);

    @Nonnull
    public UserSettingCommon map(@NonNull UserSetting userSetting) {
        if (userSetting == null) {
            throw new NullPointerException("userSetting is marked non-null but is null");
        }
        UserSettingCommon common = new UserSettingCommon();
        BaseMapper.map((EntityBase)userSetting, (EntityBaseCommon)common);
        common.setId(userSetting.getId());
        common.setKey(userSetting.getKey());
        common.setValue(userSetting.getValue());
        return common;
    }

    @Nonnull
    public UserSettingListCommon map(@NonNull Iterable<UserSetting> userConfigurations) {
        if (userConfigurations == null) {
            throw new NullPointerException("userConfigurations is marked non-null but is null");
        }
        ImmutableList commons = ImmutableList.copyOf(Streams.stream(userConfigurations).map(arg_0 -> this.map(arg_0)).iterator());
        return new UserSettingListCommon(commons.size(), (List)commons);
    }

    @Nonnull
    public UserSetting merge(@NonNull UserSetting userSetting, @NonNull User user, @NonNull String key, @Nullable String value) {
        if (userSetting == null) {
            throw new NullPointerException("userSetting is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        userSetting.setUser(user);
        userSetting.setKey(key);
        userSetting.setValue(value);
        return userSetting;
    }
}

