/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.search.LuceneHelper;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.model.search.EIndexEntryType;
import de.qfm.erp.service.model.search.EUserIndexField;
import de.qfm.erp.service.model.search.IndexDocument;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.UserIndexEntry;
import de.qfm.erp.service.service.mapper.search.UserIndexEntrySerializer;
import java.time.LocalDateTime;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class UserSearchMapper {
    private static final Logger log = LogManager.getLogger(UserSearchMapper.class);
    private static final Joiner ALL_JOINER = Joiner.on((char)' ').skipNulls();
    private static final Joiner ID_JOINER = Joiner.on((char)'_').useForNull("x");
    private static final Splitter NAME_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"-,")).trimResults();
    private final UserIndexEntrySerializer userIndexEntrySerializer;
    private final Analyzer indexAnalyzer;

    @Nonnull
    public IndexDocument mapToDocument(@NonNull User user, @NonNull EIndexEntryType indexEntryType) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        return this.mapToDocument(this.mapToIndexEntry(user, indexEntryType));
    }

    @Nonnull
    public Iterable<IndexDocument> mapToDocument(@NonNull Iterable<User> users, @NonNull EIndexEntryType indexEntryType) {
        if (users == null) {
            throw new NullPointerException("users is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        return (Iterable)Streams.stream(users).map(item -> this.mapToIndexEntry(item, indexEntryType)).map(arg_0 -> this.mapToDocument(arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public UserIndexEntry mapToIndexEntry(@NonNull User user, @NonNull EIndexEntryType indexEntryType) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        UserIndexEntry indexEntry = new UserIndexEntry();
        indexEntry.setId(user.getId());
        indexEntry.setIndexEntryType(indexEntryType);
        indexEntry.setCreatedOn(user.getCreatedOn());
        indexEntry.setCreatedBy(user.getCreatedBy());
        indexEntry.setUpdatedOn(user.getUpdatedOn());
        indexEntry.setUpdatedBy(user.getUpdatedBy());
        indexEntry.setEntityState(user.getEntityState());
        indexEntry.setFullName(user.getFullName());
        Integer personalNumber = user.getPersonalNumber();
        indexEntry.setPersonalNumber(personalNumber);
        if (null != personalNumber) {
            String personalNumberTxt = Integer.toString(personalNumber);
            indexEntry.setPersonalNumberTxt(personalNumberTxt);
        }
        indexEntry.setEmail(user.getEmail());
        return indexEntry;
    }

    @Nonnull
    public IndexDocument mapToDocument(@Nonnull UserIndexEntry userIndexEntry) {
        String source;
        Document document = new Document();
        String documentId = UserSearchMapper.documentId((UserIndexEntry)userIndexEntry);
        String type = userIndexEntry.getIndexEntryType().name();
        try {
            source = this.userIndexEntrySerializer.serialize(userIndexEntry);
        }
        catch (JsonProcessingException e) {
            source = "";
        }
        LuceneHelper.notTokenized((IndexField)EUserIndexField._ID, (String)documentId).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EUserIndexField._TYPE, (String)type).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        document.add((IndexableField)LuceneHelper.store((IndexField)EUserIndexField._SOURCE, (String)source));
        LuceneHelper.notTokenized((IndexField)EUserIndexField.ENTRY_TYPE, (String)type).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.dateTimeStr((IndexField)EUserIndexField.USER__CREATED_ON, (LocalDateTime)userIndexEntry.getCreatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.dateTimeStr((IndexField)EUserIndexField.USER__UPDATED_ON, (LocalDateTime)userIndexEntry.getUpdatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EUserIndexField.USER__CREATED_BY, (String)userIndexEntry.getCreatedBy()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EUserIndexField.USER__UPDATED_BY, (String)userIndexEntry.getUpdatedBy()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EUserIndexField.USER__ENTITY_STATE, (String)userIndexEntry.getEntityState().name()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        Integer personalNumber = userIndexEntry.getPersonalNumber();
        if (null != personalNumber) {
            Long personalNumberAsLong = (long)personalNumber;
            LuceneHelper.numeric((IndexField)EUserIndexField.USER__PERSONAL_NUMBER, (Long)personalNumberAsLong).ifPresent(arg_0 -> ((Document)document).add(arg_0));
            String personalNumberAsTxt = Integer.toString(personalNumber);
            LuceneHelper.notTokenized((IndexField)EUserIndexField.USER__PERSONAL_NUMBER_TXT, (String)personalNumberAsTxt).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        }
        LuceneHelper.tokenized((IndexField)EUserIndexField.USER__FULL_NAME, (String)userIndexEntry.getFullName()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EUserIndexField.USER__EMAIL, (String)userIndexEntry.getEmail()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        String allFromDocument = UserSearchMapper.allFromDocument((Document)document);
        LuceneHelper.tokenized((IndexField)EUserIndexField._ALL, (String)allFromDocument).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.sort((IndexField)EUserIndexField.SORT_USER__CREATED_ON, (LocalDateTime)userIndexEntry.getCreatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.sort((IndexField)EUserIndexField.SORT_USER__UPDATED_ON, (LocalDateTime)userIndexEntry.getUpdatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        return IndexDocument.of((String)documentId, (String)type, (Document)document);
    }

    @Nonnull
    @VisibleForTesting
    public static String documentId(@NonNull UserIndexEntry indexEntry) {
        if (indexEntry == null) {
            throw new NullPointerException("indexEntry is marked non-null but is null");
        }
        return UserSearchMapper.documentId((EIndexEntryType)indexEntry.getIndexEntryType(), (Long)indexEntry.getId());
    }

    @Nonnull
    public static String documentId(@NonNull EIndexEntryType indexEntryType, @NonNull Long id) {
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return ID_JOINER.join((Object)indexEntryType, (Object)id, new Object[0]);
    }

    @Nonnull
    @VisibleForTesting
    Iterable<String> handleName(@NonNull EUserIndexField field, @NonNull String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        String normalizedValue = LuceneHelper.normalize((Analyzer)this.indexAnalyzer, (IndexField)field, (String)value);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)normalizedValue);
        Streams.stream((Iterable)NAME_SPLITTER.split((CharSequence)normalizedValue)).filter(StringUtils::isNotBlank).forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Nonnull
    private static String allFromDocument(@NonNull Document document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        LinkedHashSet allFieldValuesCollector = Sets.newLinkedHashSet();
        EUserIndexField.CATCH_ALL_FIELDS.forEach(EIndexField -> {
            String fieldName = EIndexField.fieldName();
            String value = StringUtils.trimToEmpty((String)document.get(fieldName));
            if (StringUtils.isNotBlank((CharSequence)value)) {
                allFieldValuesCollector.add(value);
            }
        });
        return ALL_JOINER.join((Iterable)allFieldValuesCollector);
    }

    public UserSearchMapper(UserIndexEntrySerializer userIndexEntrySerializer, Analyzer indexAnalyzer) {
        this.userIndexEntrySerializer = userIndexEntrySerializer;
        this.indexAnalyzer = indexAnalyzer;
    }
}

