/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import de.leancoders.common.helper.DateTimeHelper;
import de.leancoders.common.helper.IterableHelper;
import de.leancoders.common.response.PageCommon;
import de.qfm.erp.common.request.user.EmployeeContractModificationItem;
import de.qfm.erp.common.request.user.UserCostCenterUpdateItem;
import de.qfm.erp.common.request.user.UserUpdateRequest;
import de.qfm.erp.common.request.user.WageAccountModificationItem;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.search.EmployeeSearchItem;
import de.qfm.erp.common.response.user.EmployeeContractCommon;
import de.qfm.erp.common.response.user.EmployeeContractListCommon;
import de.qfm.erp.common.response.user.UserBusinessUnitCommon;
import de.qfm.erp.common.response.user.UserBusinessUnitListCommon;
import de.qfm.erp.common.response.user.UserCommon;
import de.qfm.erp.common.response.user.UserCostCenterCommon;
import de.qfm.erp.common.response.user.UserCostCenterListCommon;
import de.qfm.erp.common.response.user.UserPageCommon;
import de.qfm.erp.common.response.user.WageAccountCommon;
import de.qfm.erp.service.configuration.ApplicationConfig;
import de.qfm.erp.service.configuration.CompanyConfig;
import de.qfm.erp.service.helper.EmployeeHelper;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.helper.UserHelper;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.internal.UserGetBucket;
import de.qfm.erp.service.model.internal.UserUpdateBucket;
import de.qfm.erp.service.model.internal.search.Highlight;
import de.qfm.erp.service.model.internal.search.UserSearchItemBucket;
import de.qfm.erp.service.model.internal.user.EmployeeContractUpdateBucket;
import de.qfm.erp.service.model.internal.user.EmployeeContractsUpdateBucket;
import de.qfm.erp.service.model.internal.user.UserCostCenterUpdateBucket;
import de.qfm.erp.service.model.internal.user.UserCostCentersUpdateBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.businessunit.BusinessUnit;
import de.qfm.erp.service.model.jpa.businessunit.UserBusinessUnit;
import de.qfm.erp.service.model.jpa.businessunit.UserCostCenter;
import de.qfm.erp.service.model.jpa.employee.contract.EmployeeContract;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContract;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionWageGroup;
import de.qfm.erp.service.model.jpa.employee.payroll.WageAccount;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.ERole;
import de.qfm.erp.service.model.jpa.user.Role;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.model.jpa.user.UserPrivilege;
import de.qfm.erp.service.model.jpa.user.UserRole;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.UserIndexEntry;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.mapper.HighlightMapper;
import de.qfm.erp.service.service.mapper.PrivilegeMapper;
import de.qfm.erp.service.service.mapper.RoleMapper;
import de.qfm.erp.service.service.mapper.WageAccountMapper;
import de.qfm.erp.service.service.security.AuthenticationHelper;
import de.qfm.erp.service.service.security.PrivilegeService;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.ConfigService;
import de.qfm.erp.service.service.service.MessageService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class UserMapper {
    private static final Logger log = LogManager.getLogger(UserMapper.class);
    public static final Ordering<Comparable> DATE_DESCENDING = Ordering.natural().reverse();
    public static final Joiner FULL_NAME_JOINER = Joiner.on((String)", ").skipNulls();
    private final ApplicationConfig applicationConfig;
    private final AuthenticationHelper authenticationHelper;
    private final ConfigService configService;
    private final MessageService messageService;
    private final EntityFactory entityFactory;
    private final HighlightMapper highlightMapper;
    private final PrivilegeService privilegeService;
    private final PrivilegeMapper privilegeMapper;
    private final RoleMapper roleMapper;
    private final WageAccountMapper wageAccountMapper;
    private final UserService userService;
    private final CompanyConfig companyConfig;
    private static final BiConsumer<UserCostCenter, UserCostCenterUpdateBucket> NO_USER_CC_CALLBACK = (x, y) -> {};
    private static final BiConsumer<EmployeeContract, EmployeeContractUpdateBucket> NO_EC_CALLBACK = (x, y) -> {};

    @Nonnull
    public UserCommon mapUser(@NonNull UserGetBucket userGetBucket) {
        if (userGetBucket == null) {
            throw new NullPointerException("userGetBucket is marked non-null but is null");
        }
        return this.mapUser(userGetBucket, true, true);
    }

    @Nonnull
    public UserCommon mapUser(@NonNull UserGetBucket userGetBucket, boolean mapPrivileges, boolean mapWageAccount) {
        if (userGetBucket == null) {
            throw new NullPointerException("userGetBucket is marked non-null but is null");
        }
        User user = (User)userGetBucket.getEntity();
        User manager = userGetBucket.getCurrentManager();
        String currentCostCenter = userGetBucket.getCurrentCostCenter();
        UserCommon userCommon = new UserCommon();
        BaseMapper.map((EntityBase)user, (EntityBaseCommon)userCommon);
        userCommon.setId(user.getId());
        userCommon.setReferenceId(user.getReferenceId());
        userCommon.setSequenceNumber(user.getSequenceNumber());
        userCommon.setPersonalNumber(user.getPersonalNumber());
        userCommon.setSocialSecurityNumber(user.getSocialSecurityNumber());
        userCommon.setSalutation(user.getSalutation());
        userCommon.setFirstName(user.getFirstName());
        userCommon.setLastName(user.getLastName());
        userCommon.setFullName(user.getFullName());
        userCommon.setName(user.getFullName());
        userCommon.setPhone(user.getPhone());
        userCommon.setFax(user.getFax());
        userCommon.setEmail(user.getEmail());
        userCommon.setLocation(user.getLocation());
        userCommon.setCellular(user.getCellular());
        userCommon.setAuthorityToSign(user.getAuthorityToSign());
        LocalDate disableDate = user.getDisableDate();
        LocalDate disableAtDate = user.getDisableAtDate();
        LocalDate disableReferenceDate = null != disableDate ? disableDate : disableAtDate;
        userCommon.setDisableDate(disableReferenceDate);
        userCommon.setAllowedToLogin((Boolean)MoreObjects.firstNonNull((Object)user.getAllowedToLogin(), (Object)false));
        userCommon.setUsername(user.getUsername());
        ERole eRole = (ERole)MoreObjects.firstNonNull((Object)user.getRoleDeprecated(), (Object)ERole.ROLE_NONE);
        String roleAuthority = eRole.getAuthority();
        userCommon.setRole(roleAuthority);
        Role roleNew = user.getRole();
        Long roleId = null != roleNew ? roleNew.getId() : null;
        String roleName = null != roleNew ? roleNew.getName() : "";
        userCommon.setRoleId(roleId);
        userCommon.setRoleName(roleName);
        Iterable allRoles = UserHelper.allRoles((User)user);
        Set roleCommons = (Set)IterableHelper.stream((Iterable)allRoles).map(item -> this.roleMapper.map(item, false)).collect(ImmutableSet.toImmutableSet());
        userCommon.setRoles(roleCommons);
        if (mapPrivileges) {
            Iterable allPrivileges = this.privilegeService.privileges(user);
            Set privilegeNames = (Set)IterableHelper.stream((Iterable)allPrivileges).map(Enum::name).collect(ImmutableSet.toImmutableSet());
            userCommon.setPrivileges(privilegeNames);
            Iterable rolePrivileges = this.privilegeService.rolePrivileges(user);
            Set rolePrivilegeNames = (Set)IterableHelper.stream((Iterable)rolePrivileges).map(Enum::name).collect(ImmutableSet.toImmutableSet());
            Iterable userPrivileges = this.privilegeService.userPrivileges(user);
            Set userPrivilegeCommon = (Set)IterableHelper.stream((Iterable)userPrivileges).map(arg_0 -> ((PrivilegeMapper)this.privilegeMapper).map(arg_0)).collect(ImmutableSet.toImmutableSet());
            userCommon.setUserPrivileges(userPrivilegeCommon);
            userCommon.setRolePrivileges(rolePrivilegeNames);
        } else {
            userCommon.setPrivileges((Set)ImmutableSet.of());
            userCommon.setUserPrivileges((Set)ImmutableSet.of());
            userCommon.setRolePrivileges((Set)ImmutableSet.of());
        }
        userCommon.setSquadName(user.getSquadName());
        userCommon.setSquadNumber(user.getSquadNumber());
        userCommon.setSquadReferenceId(user.getSquadReferenceId());
        User squadLeader = user.getSquadLeader();
        if (null != squadLeader) {
            userCommon.setSquadLeaderUserId(squadLeader.getId());
            userCommon.setSquadLeaderFullName(squadLeader.getFullName());
            userCommon.setSquadLeaderPersonalNumber(squadLeader.getPersonalNumber());
        }
        if (null != manager) {
            userCommon.setManagerUserId(manager.getId());
            userCommon.setManagerPersonalNumber(manager.getPersonalNumber());
            userCommon.setManagerFullName(manager.getFullName());
        }
        userCommon.setCurrentCostCenter(currentCostCenter);
        Set safeUserCostCenters = (Set)MoreObjects.firstNonNull((Object)user.getUserCostCenters(), (Object)ImmutableSet.of());
        userCommon.setUserCostCenters(this.mapUserCostCenters((Iterable)safeUserCostCenters).getItems());
        Optional employeeContractCandidate = EmployeeHelper.currentEmployeeContractNotFailing((User)user, (LocalDate)DateTimeHelper.today());
        if (employeeContractCandidate.isPresent()) {
            LaborUnionWageGroup laborUnionWageGroup;
            EmployeeContract employeeContract = (EmployeeContract)employeeContractCandidate.get();
            LaborUnionContract laborUnionContract = employeeContract.getLaborUnionContract();
            if (null != laborUnionContract) {
                userCommon.setLaborUnionContractId(laborUnionContract.getId());
                userCommon.setLaborUnionContractName(laborUnionContract.getName());
            }
            if (null != (laborUnionWageGroup = employeeContract.getLaborUnionWageGroup())) {
                userCommon.setLaborUnionWageGroupId(laborUnionWageGroup.getId());
                userCommon.setLaborUnionWageGroupName(laborUnionWageGroup.getName());
            }
            Optional laborUnionWageGroupRate = EmployeeHelper.currentWageGroupRateNotFailing((User)user, (LocalDate)DateTimeHelper.today());
            BigDecimal valueOrDefaultFromRate = laborUnionWageGroupRate.map(item -> (BigDecimal)MoreObjects.firstNonNull((Object)item.getWageRatePerHour(), (Object)BigDecimal.ZERO)).orElse(BigDecimal.ZERO);
            BigDecimal nonTariffHourlyWage = (BigDecimal)MoreObjects.firstNonNull((Object)employeeContract.getNonTariffHourlyWage(), (Object)BigDecimal.ZERO);
            BigDecimal currentHourlyWage = valueOrDefaultFromRate.max(nonTariffHourlyWage);
            userCommon.setCurrentHourlyWage(currentHourlyWage);
            userCommon.setCurrentTariffHourlyWage(valueOrDefaultFromRate);
            userCommon.setCurrentNonTariffHourlyWage(nonTariffHourlyWage);
        }
        Set employeeContracts = (Set)MoreObjects.firstNonNull((Object)user.getEmployeeContracts(), (Object)ImmutableSet.of());
        userCommon.setEmployeeContracts(this.mapEmployeeContracts((Iterable)employeeContracts).getItems());
        userCommon.setCurrentEffectiveHourlyWage(userGetBucket.getCurrentEffectiveWage());
        if (mapWageAccount) {
            WageAccountCommon wageAccountCommon = this.wageAccountMapper.map(user.getWageAccount());
            userCommon.setWageAccount(wageAccountCommon);
        }
        return userCommon;
    }

    @Nonnull
    public UserPageCommon mapUser(@NonNull Page<UserGetBucket> page) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        long totalElements = page.getTotalElements();
        int totalPages = page.getTotalPages();
        Pageable pageable = page.getPageable();
        int pageSize = pageable.getPageSize();
        int pageNumber = pageable.getPageNumber();
        List content = page.getContent();
        List itemsCommon = (List)content.stream().map(item -> this.mapUser(item, false, false)).collect(ImmutableList.toImmutableList());
        return new UserPageCommon(pageNumber, pageSize, totalPages, totalElements, itemsCommon);
    }

    @Nonnull
    public User merge(@NonNull UserUpdateBucket userUpdateBucket) {
        boolean editUserDetails;
        if (userUpdateBucket == null) {
            throw new NullPointerException("userUpdateBucket is marked non-null but is null");
        }
        UserUpdateRequest updateRequest = (UserUpdateRequest)userUpdateBucket.getRequest();
        User user = (User)userUpdateBucket.getEntity();
        boolean changePassword = userUpdateBucket.isChangePassword();
        User squadLeader = userUpdateBucket.getSquadLeader();
        boolean newUser = user.getId() == null;
        user.setReferenceId(updateRequest.getReferenceId());
        boolean userDisable = this.userService.hasPrivilege(EPrivilege.SECURITY_USER_DISABLE);
        if (userDisable) {
            // empty if block
        }
        if (editUserDetails = this.userService.hasPrivilege(EPrivilege.SECURITY_USER_LOGIN_EDIT)) {
            user.setUsername(updateRequest.getUsername());
            if (changePassword) {
                user.setPassword(userUpdateBucket.getEncryptedPassword());
            }
            Role role = userUpdateBucket.getRole();
            user.setRole(role);
            Iterable userRoles = userUpdateBucket.getUserRoles();
            this.mergeUserRoles(user, userRoles);
            Iterable userPrivileges = userUpdateBucket.getUserPrivileges();
            this.mergeUserPrivileges(user, userPrivileges);
            boolean allowedToLogin = (Boolean)MoreObjects.firstNonNull((Object)updateRequest.getAllowedToLogin(), (Object)false);
            user.setAllowedToLogin(Boolean.valueOf(allowedToLogin));
        } else if (newUser) {
            Iterable userRoles = (Iterable)MoreObjects.firstNonNull((Object)userUpdateBucket.getUserRoles(), (Object)ImmutableList.of());
            this.mergeUserRoles(user, userRoles);
        }
        user.setSalutation(updateRequest.getSalutation());
        String firstName = updateRequest.getFirstName();
        user.setFirstName(firstName);
        String lastName = updateRequest.getLastName();
        user.setLastName(lastName);
        String fullName = UserMapper.fullName((String)firstName, (String)lastName);
        user.setFullName(fullName);
        user.setShortName(updateRequest.getShortName());
        user.setPersonalNumber(updateRequest.getPersonalNumber());
        user.setSocialSecurityNumber(updateRequest.getSocialSecurityNumber());
        user.setSequenceNumber(updateRequest.getSequenceNumber());
        user.setPhone(updateRequest.getPhone());
        user.setFax(updateRequest.getFax());
        user.setEmail(updateRequest.getEmail());
        user.setLocation(updateRequest.getLocation());
        user.setCellular(updateRequest.getCellular());
        user.setAuthorityToSign(updateRequest.getAuthorityToSign());
        Integer personalNumber = updateRequest.getPersonalNumber();
        String squadReferenceId = null != personalNumber ? Integer.toString(personalNumber) : "";
        user.setSquadReferenceId(squadReferenceId);
        user.setVisibleInMeasurement(Boolean.valueOf(true));
        user.setSquadLeader(squadLeader);
        WageAccount wageAccount = userUpdateBucket.getWageAccount();
        user.setWageAccount(wageAccount);
        WageAccountModificationItem wageAccountModificationItem = updateRequest.getWageAccount();
        if (null != wageAccountModificationItem) {
            wageAccount.setLimit(wageAccountModificationItem.getLimit());
        }
        return user;
    }

    @Nonnull
    static String fullName(@NonNull String firstName, @NonNull String lastName) {
        if (firstName == null) {
            throw new NullPointerException("firstName is marked non-null but is null");
        }
        if (lastName == null) {
            throw new NullPointerException("lastName is marked non-null but is null");
        }
        ArrayList nameParts = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)lastName)) {
            nameParts.add(lastName);
        }
        if (StringUtils.isNotBlank((CharSequence)firstName)) {
            nameParts.add(firstName);
        }
        return StringUtils.left((String)FULL_NAME_JOINER.join((Iterable)nameParts), (int)50);
    }

    @Nonnull
    public User mergeUserRoles(@NonNull User user, @NonNull Iterable<Role> rolesToPersistCandidates) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (rolesToPersistCandidates == null) {
            throw new NullPointerException("rolesToPersistCandidates is marked non-null but is null");
        }
        Set safeUserRolesExisting = (Set)MoreObjects.firstNonNull((Object)user.getUserRoles(), (Object)ImmutableSet.of());
        ImmutableMap rolesToAddByRoleId = Maps.uniqueIndex(rolesToPersistCandidates, Role::getId);
        ImmutableMap userRoleExistingByRoleId = Maps.uniqueIndex((Iterable)safeUserRolesExisting, item -> item.getRole().getId());
        ImmutableSet roleIdsToPersist = ImmutableSet.copyOf((Collection)((Collection)IterableHelper.stream(rolesToPersistCandidates).map(Role::getId).collect(ImmutableSet.toImmutableSet())));
        ImmutableSet roleIdsExisting = ImmutableSet.copyOf(userRoleExistingByRoleId.keySet());
        Sets.SetView toAdd = Sets.difference((Set)roleIdsToPersist, (Set)roleIdsExisting);
        Sets.SetView toUpdate = Sets.intersection((Set)roleIdsToPersist, (Set)roleIdsExisting);
        Sets.SetView toRemove = Sets.difference((Set)roleIdsExisting, (Set)roleIdsToPersist);
        if (null == user.getUserRoles()) {
            user.setUserRoles((Set)Sets.newHashSet());
        }
        toAdd.forEach(roleId -> {
            Role role = (Role)rolesToAddByRoleId.get(roleId);
            UserRole userRole = this.entityFactory.userRole(role);
            userRole.setUser(user);
            user.getUserRoles().add(userRole);
        });
        toRemove.forEach(arg_0 -> UserMapper.lambda$mergeUserRoles$5((Map)userRoleExistingByRoleId, user, arg_0));
        return user;
    }

    @Nonnull
    public User mergeUserPrivileges(@NonNull User user, @NonNull Iterable<EPrivilege> privilegesToPersistCandidates) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (privilegesToPersistCandidates == null) {
            throw new NullPointerException("privilegesToPersistCandidates is marked non-null but is null");
        }
        Set safeUserPrivilegesExisting = (Set)MoreObjects.firstNonNull((Object)user.getUserPrivileges(), (Object)ImmutableSet.of());
        Map userPrivilegesExistingByPrivilege = MapsHelper.mapFirst((Iterable)safeUserPrivilegesExisting, UserPrivilege::getPrivilege);
        ImmutableSet privilegesToPersist = ImmutableSet.copyOf(privilegesToPersistCandidates);
        ImmutableSet privilegesExisting = ImmutableSet.copyOf(userPrivilegesExistingByPrivilege.keySet());
        Sets.SetView toAdd = Sets.difference((Set)privilegesToPersist, (Set)privilegesExisting);
        Sets.SetView toUpdate = Sets.intersection((Set)privilegesToPersist, (Set)privilegesExisting);
        Sets.SetView toRemove = Sets.difference((Set)privilegesExisting, (Set)privilegesToPersist);
        if (null == user.getUserPrivileges()) {
            user.setUserPrivileges((Set)Sets.newHashSet());
        }
        toAdd.forEach(privilege -> {
            UserPrivilege userPrivilege = this.entityFactory.userPrivilege(privilege);
            userPrivilege.setUser(user);
            user.getUserPrivileges().add(userPrivilege);
        });
        toRemove.forEach(userIdToRemove -> {
            UserPrivilege userPrivilegeToRemove = (UserPrivilege)userPrivilegesExistingByPrivilege.get(userIdToRemove);
            userPrivilegeToRemove.setUser(null);
            user.getUserPrivileges().remove(userPrivilegeToRemove);
        });
        return user;
    }

    @Nonnull
    public UserBusinessUnitListCommon mapUserBusinessUnits(@NonNull Iterable<UserBusinessUnit> userBusinessUnits) {
        if (userBusinessUnits == null) {
            throw new NullPointerException("userBusinessUnits is marked non-null but is null");
        }
        List commons = (List)IterableHelper.stream(userBusinessUnits).map(arg_0 -> this.mapUserBusinessUnit(arg_0)).collect(ImmutableList.toImmutableList());
        return new UserBusinessUnitListCommon(commons.size(), commons);
    }

    @Nonnull
    public UserBusinessUnitCommon mapUserBusinessUnit(@NonNull UserBusinessUnit userBusinessUnit) {
        BusinessUnit businessUnit;
        if (userBusinessUnit == null) {
            throw new NullPointerException("userBusinessUnit is marked non-null but is null");
        }
        UserBusinessUnitCommon common = (UserBusinessUnitCommon)BaseMapper.map((EntityBase)userBusinessUnit, (EntityBaseCommon)new UserBusinessUnitCommon());
        common.setId(userBusinessUnit.getId());
        common.setValidBegin(userBusinessUnit.getValidBegin());
        common.setValidEnd(userBusinessUnit.getValidEnd());
        common.setFlagLead(userBusinessUnit.getFlagLead());
        common.setRemarks(userBusinessUnit.getRemarks());
        common.setPercent(userBusinessUnit.getPercent());
        User user = userBusinessUnit.getUser();
        if (null != user) {
            common.setUserId(user.getId());
            common.setUserFullName(user.getFullName());
        }
        if (null != (businessUnit = userBusinessUnit.getBusinessUnit())) {
            common.setBusinessUnitId(businessUnit.getId());
            common.setBusinessUnitShortName(businessUnit.getShortName());
            common.setBusinessUnitCostCenter(businessUnit.getCostCenter());
        }
        return common;
    }

    @Nonnull
    public UserCostCenterListCommon mapUserCostCenters(@NonNull Iterable<UserCostCenter> userCostCenters) {
        if (userCostCenters == null) {
            throw new NullPointerException("userCostCenters is marked non-null but is null");
        }
        ImmutableList userCostCentersSorted = (ImmutableList)IterableHelper.stream(userCostCenters).sorted((l, r) -> DATE_DESCENDING.compare((Object)l.getValidEnd(), (Object)r.getValidEnd())).collect(ImmutableList.toImmutableList());
        List commons = (List)IterableHelper.stream((Iterable)userCostCentersSorted).map(arg_0 -> this.mapUserCostCenter(arg_0)).collect(ImmutableList.toImmutableList());
        return new UserCostCenterListCommon(commons.size(), commons);
    }

    @Nonnull
    public UserCostCenterCommon mapUserCostCenter(@NonNull UserCostCenter userCostCenter) {
        if (userCostCenter == null) {
            throw new NullPointerException("userCostCenter is marked non-null but is null");
        }
        UserCostCenterCommon common = (UserCostCenterCommon)BaseMapper.map((EntityBase)userCostCenter, (EntityBaseCommon)new UserCostCenterCommon());
        common.setId(userCostCenter.getId());
        LocalDate validBegin = userCostCenter.getValidBegin();
        common.setValidBegin(validBegin);
        LocalDate validEnd = userCostCenter.getValidEnd();
        if (!Objects.equals(this.applicationConfig.getDefaultEndDate(), validEnd)) {
            common.setValidEnd(validEnd);
        } else {
            common.setValidEnd(null);
        }
        common.setRemarks(userCostCenter.getRemarks());
        User user = userCostCenter.getUser();
        if (null != user) {
            common.setUserId(user.getId());
            common.setUserFullName(user.getFullName());
        }
        common.setCostCenter(StringUtils.trimToEmpty((String)userCostCenter.getCostCenter()));
        Boolean flagLead = (Boolean)MoreObjects.firstNonNull((Object)userCostCenter.getFlagLead(), (Object)false);
        common.setFlagLead(flagLead);
        return common;
    }

    @Nonnull
    public EmployeeContractCommon mapEmployeeContract(@NonNull EmployeeContract employeeContract) {
        LaborUnionWageGroup laborUnionWageGroup;
        LaborUnionContract laborUnionContract;
        if (employeeContract == null) {
            throw new NullPointerException("employeeContract is marked non-null but is null");
        }
        EmployeeContractCommon common = (EmployeeContractCommon)BaseMapper.map((EntityBase)employeeContract, (EntityBaseCommon)new EmployeeContractCommon());
        common.setId(employeeContract.getId());
        LocalDate validBegin = employeeContract.getValidBegin();
        common.setValidBegin(validBegin);
        LocalDate validEnd = employeeContract.getValidEnd();
        if (!Objects.equals(this.applicationConfig.getDefaultEndDate(), validEnd)) {
            common.setValidEnd(validEnd);
        } else {
            common.setValidEnd(null);
        }
        BigDecimal nonTariffHourlyWage = employeeContract.getNonTariffHourlyWage();
        common.setNonTariffHourlyWage(nonTariffHourlyWage);
        User user = employeeContract.getUser();
        if (null != user) {
            common.setUserId(user.getId());
            common.setUserFullName(user.getFullName());
        }
        if (null != (laborUnionContract = employeeContract.getLaborUnionContract())) {
            common.setLaborUnionContractId(laborUnionContract.getId());
            common.setLaborUnionContractName(laborUnionContract.getName());
        }
        if (null != (laborUnionWageGroup = employeeContract.getLaborUnionWageGroup())) {
            common.setLaborUnionWageGroupId(laborUnionWageGroup.getId());
            common.setLaborUnionWageGroupName(laborUnionWageGroup.getName());
            Optional laborUnionWageGroupRateCandidate = EmployeeHelper.lastWageGroupRateNotFailing((LaborUnionWageGroup)laborUnionWageGroup, (Range)Range.closed((Comparable)validBegin, (Comparable)validEnd));
            laborUnionWageGroupRateCandidate.ifPresent(value -> {
                BigDecimal wageRatePerHour = value.getWageRatePerHour();
                common.setTariffHourlyWage(wageRatePerHour);
            });
        }
        return common;
    }

    @Nonnull
    public EmployeeContractListCommon mapEmployeeContracts(@NonNull Iterable<EmployeeContract> employeeContracts) {
        if (employeeContracts == null) {
            throw new NullPointerException("employeeContracts is marked non-null but is null");
        }
        ImmutableList employeeContractsSorted = (ImmutableList)IterableHelper.stream(employeeContracts).sorted((l, r) -> DATE_DESCENDING.compare((Object)l.getValidEnd(), (Object)r.getValidEnd())).collect(ImmutableList.toImmutableList());
        List commons = (List)IterableHelper.stream((Iterable)employeeContractsSorted).map(arg_0 -> this.mapEmployeeContract(arg_0)).collect(ImmutableList.toImmutableList());
        return new EmployeeContractListCommon(commons.size(), commons);
    }

    @Nonnull
    private UserCostCenter mergeUserCostCenter(@NonNull UserCostCenter userCostCenter, @NonNull UserCostCenterUpdateBucket userCostCenterUpdateBucket) {
        if (userCostCenter == null) {
            throw new NullPointerException("userCostCenter is marked non-null but is null");
        }
        if (userCostCenterUpdateBucket == null) {
            throw new NullPointerException("userCostCenterUpdateBucket is marked non-null but is null");
        }
        UserCostCenterUpdateItem userCostCenterUpdateItem = userCostCenterUpdateBucket.getUserCostCenterUpdateItem();
        LocalDate validBegin = userCostCenterUpdateBucket.getValidBegin();
        LocalDate validEnd = userCostCenterUpdateBucket.getValidEnd();
        String costCenter = StringUtils.trimToEmpty((String)userCostCenterUpdateItem.getCostCenter());
        String remarks = StringUtils.trimToEmpty((String)userCostCenterUpdateItem.getRemarks());
        Boolean flagLead = (Boolean)MoreObjects.firstNonNull((Object)userCostCenterUpdateItem.getFlagLead(), (Object)false);
        userCostCenter.setCostCenter(costCenter);
        userCostCenter.setRemarks(remarks);
        userCostCenter.setFlagLead(flagLead);
        userCostCenter.setValidBegin(validBegin);
        userCostCenter.setValidEnd(validEnd);
        return userCostCenter;
    }

    @Nonnull
    public MergedBucket<UserCostCenter> mergeUserCostCenters(@NonNull UserCostCentersUpdateBucket userCostCentersUpdateBucket) {
        if (userCostCentersUpdateBucket == null) {
            throw new NullPointerException("userCostCentersUpdateBucket is marked non-null but is null");
        }
        User user = userCostCentersUpdateBucket.getUser();
        Iterable userCostCenterUpdateItemsToPersist = userCostCentersUpdateBucket.getUserCostCenterUpdateBuckets();
        MergedBucket mergedBucket = BaseMapper.merge((EntityBase)user, User::getUserCostCenters, arg_0 -> ((User)user).setUserCostCenters(arg_0), (Iterable)userCostCenterUpdateItemsToPersist, UserCostCenterUpdateBucket::getId, UserCostCenter::getId, () -> ((EntityFactory)this.entityFactory).userCostCenter(), (arg_0, arg_1) -> this.mergeUserCostCenter(arg_0, arg_1), UserCostCenter::setUser, () -> ((AuthenticationHelper)this.authenticationHelper).currentUserName(), (BiConsumer)NO_USER_CC_CALLBACK);
        MergedBucket.printMergeBucket((Object)user, UserCostCenter.class, (MergedBucket)mergedBucket);
        return mergedBucket;
    }

    @Nonnull
    public MergedBucket<EmployeeContract> mergeEmployeeContracts(@NonNull EmployeeContractsUpdateBucket employeeContractsUpdateBucket) {
        if (employeeContractsUpdateBucket == null) {
            throw new NullPointerException("employeeContractsUpdateBucket is marked non-null but is null");
        }
        User user = employeeContractsUpdateBucket.getUser();
        Iterable employeeContractsToPersist = employeeContractsUpdateBucket.getEmployeeContractUpdateBuckets();
        MergedBucket mergedBucket = BaseMapper.merge((EntityBase)user, User::getEmployeeContracts, arg_0 -> ((User)user).setEmployeeContracts(arg_0), (Iterable)employeeContractsToPersist, EmployeeContractUpdateBucket::getId, EmployeeContract::getId, () -> ((EntityFactory)this.entityFactory).employeeContract(), (arg_0, arg_1) -> this.mergeEmployeeContract(arg_0, arg_1), EmployeeContract::setUser, () -> ((AuthenticationHelper)this.authenticationHelper).currentUserName(), (BiConsumer)NO_EC_CALLBACK);
        MergedBucket.printMergeBucket((Object)user, EmployeeContract.class, (MergedBucket)mergedBucket);
        return mergedBucket;
    }

    @Nonnull
    public EmployeeContract mergeEmployeeContract(@NonNull EmployeeContract employeeContract, @NonNull EmployeeContractUpdateBucket employeeContractUpdateBucket) {
        if (employeeContract == null) {
            throw new NullPointerException("employeeContract is marked non-null but is null");
        }
        if (employeeContractUpdateBucket == null) {
            throw new NullPointerException("employeeContractUpdateBucket is marked non-null but is null");
        }
        LaborUnionContract laborUnionContract = employeeContractUpdateBucket.getLaborUnionContract();
        LaborUnionWageGroup laborUnionWageGroup = employeeContractUpdateBucket.getLaborUnionWageGroup();
        EmployeeContractModificationItem employeeContractModificationItem = employeeContractUpdateBucket.getEmployeeContractModificationItem();
        LocalDate validBegin = employeeContractUpdateBucket.getValidBegin();
        LocalDate validEnd = employeeContractUpdateBucket.getValidEnd();
        employeeContract.setLaborUnionContract(laborUnionContract);
        employeeContract.setLaborUnionWageGroup(laborUnionWageGroup);
        employeeContract.setValidBegin(validBegin);
        employeeContract.setValidEnd(validEnd);
        employeeContract.setNonTariffHourlyWage(employeeContractModificationItem.getNonTariffHourlyWage());
        return employeeContract;
    }

    @Nonnull
    public List<UserCommon> mapUser(@NonNull Iterable<User> entities) {
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        return (List)IterableHelper.stream(entities).map(arg_0 -> this.mapUser(arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public UserCommon mapUser(@NonNull User entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        UserCommon userCommon = new UserCommon();
        BaseMapper.map((EntityBase)entity, (EntityBaseCommon)userCommon);
        userCommon.setId(entity.getId());
        userCommon.setPersonalNumber(entity.getPersonalNumber());
        userCommon.setSalutation(entity.getSalutation());
        userCommon.setFirstName(entity.getFirstName());
        userCommon.setLastName(entity.getLastName());
        userCommon.setFullName(entity.getFullName());
        return userCommon;
    }

    @Nonnull
    public PageCommon<EmployeeSearchItem> mapToSearchItem(@NonNull Page<UserSearchItemBucket> buckets) {
        if (buckets == null) {
            throw new NullPointerException("buckets is marked non-null but is null");
        }
        return BaseMapper.map(buckets, arg_0 -> this.mapToSearchItem(arg_0), (pageNumber, pageSize, totalElements, totalPages, items) -> new PageCommon(pageNumber, pageSize, totalPages, totalElements, items));
    }

    @Nonnull
    public EmployeeSearchItem mapToSearchItem(@NonNull UserSearchItemBucket bucket) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        UserIndexEntry userIndexEntry = bucket.getUserIndexEntry();
        String details = bucket.getDetails();
        Highlight rootHighlight = bucket.getRootHighlight();
        Highlight detailHighlight = bucket.getDetailHighlight();
        String companyName = this.companyConfig.getCompanyName();
        String stageOrEntityNumberPrefix = this.configService.getStageOrEntityNumberPrefix();
        IndexField field = detailHighlight.getField();
        String fieldName = this.messageService.get(field, new Object[]{companyName, stageOrEntityNumberPrefix});
        Iterable rootHighlightCommon = this.highlightMapper.map(rootHighlight);
        Iterable detailHighlightCommon = this.highlightMapper.map(detailHighlight);
        return EmployeeSearchItem.of((long)userIndexEntry.getId(), (String)userIndexEntry.getFullName(), (Iterable)rootHighlightCommon, (String)details, (String)field.fieldName(), (String)fieldName, (Iterable)detailHighlightCommon);
    }

    public UserMapper(ApplicationConfig applicationConfig, AuthenticationHelper authenticationHelper, ConfigService configService, MessageService messageService, EntityFactory entityFactory, HighlightMapper highlightMapper, PrivilegeService privilegeService, PrivilegeMapper privilegeMapper, RoleMapper roleMapper, WageAccountMapper wageAccountMapper, UserService userService, CompanyConfig companyConfig) {
        this.applicationConfig = applicationConfig;
        this.authenticationHelper = authenticationHelper;
        this.configService = configService;
        this.messageService = messageService;
        this.entityFactory = entityFactory;
        this.highlightMapper = highlightMapper;
        this.privilegeService = privilegeService;
        this.privilegeMapper = privilegeMapper;
        this.roleMapper = roleMapper;
        this.wageAccountMapper = wageAccountMapper;
        this.userService = userService;
        this.companyConfig = companyConfig;
    }

    private static /* synthetic */ void lambda$mergeUserRoles$5(Map userRoleExistingByRoleId, User user, Long roleIdToRemove) {
        UserRole userRoleToRemove = (UserRole)userRoleExistingByRoleId.get(roleIdToRemove);
        userRoleToRemove.setUser(null);
        user.getUserRoles().remove(userRoleToRemove);
    }
}

