/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import de.leancoders.common.response.PageCommon;
import de.qfm.erp.common.request.project.SubProjectUpdateRequest;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.project.SubProjectCommon;
import de.qfm.erp.common.response.project.SubProjectPageCommon;
import de.qfm.erp.common.response.search.SubProjectSearchItem;
import de.qfm.erp.service.configuration.CompanyConfig;
import de.qfm.erp.service.model.internal.search.Highlight;
import de.qfm.erp.service.model.internal.search.SubProjectSearchItemBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.project.SubProject;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.SubProjectIndexEntry;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.mapper.HighlightMapper;
import de.qfm.erp.service.service.service.ConfigService;
import de.qfm.erp.service.service.service.MessageService;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class SubProjectMapper {
    private final ConfigService configService;
    private final HighlightMapper highlightMapper;
    private final MessageService messageService;
    private final CompanyConfig companyConfig;

    @Nonnull
    public SubProjectCommon map(@NonNull SubProject entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        SubProjectCommon common = new SubProjectCommon();
        BaseMapper.map((EntityBase)entity, (EntityBaseCommon)common);
        common.setId(entity.getId());
        common.setName(entity.getName());
        QEntity qEntity = entity.getQEntity();
        if (null != qEntity) {
            common.setQentityId(qEntity.getId());
        }
        return common;
    }

    @Nonnull
    public SubProjectPageCommon map(@NonNull Page<SubProject> page) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        return (SubProjectPageCommon)BaseMapper.map(page, arg_0 -> this.map(arg_0), (pageNumber, pageSize, totalElements, totalPages, items) -> new SubProjectPageCommon(pageNumber, pageSize, totalPages, totalElements, items));
    }

    @Nonnull
    public SubProject merge(@NonNull SubProject subProject, @NonNull QEntity qEntity, @NonNull SubProjectUpdateRequest request) {
        if (subProject == null) {
            throw new NullPointerException("subProject is marked non-null but is null");
        }
        if (qEntity == null) {
            throw new NullPointerException("qEntity is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        subProject.setQEntity(qEntity);
        subProject.setName(StringUtils.trimToEmpty((String)request.getName()));
        return subProject;
    }

    @Nonnull
    public PageCommon<SubProjectSearchItem> mapToSearchItem(Page<SubProjectSearchItemBucket> bucketPage) {
        return BaseMapper.map(bucketPage, arg_0 -> this.mapToSearchItem(arg_0), (pageNumber, pageSize, totalElements, totalPages, items) -> new PageCommon(pageNumber, pageSize, totalPages, totalElements, items));
    }

    @Nonnull
    public SubProjectSearchItem mapToSearchItem(@NonNull SubProjectSearchItemBucket bucket) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        SubProjectIndexEntry indexEntry = bucket.getSubProjectIndexEntry();
        String details = bucket.getDetails();
        Highlight rootHighlight = bucket.getRootHighlight();
        Highlight detailHighlight = bucket.getDetailHighlight();
        String companyName = this.companyConfig.getCompanyName();
        String stageOrEntityNumberPrefix = this.configService.getStageOrEntityNumberPrefix();
        IndexField field = detailHighlight.getField();
        String fieldName = this.messageService.get(field, new Object[]{companyName, stageOrEntityNumberPrefix});
        Iterable rootHighlightCommon = this.highlightMapper.map(rootHighlight);
        Iterable detailHighlightCommon = this.highlightMapper.map(detailHighlight);
        String entityNumber = StringUtils.trimToEmpty((String)indexEntry.getEntityNumber());
        String stageNumber = StringUtils.trimToEmpty((String)indexEntry.getPrimaryStageNumber());
        String name = indexEntry.getName();
        String text = String.format("%s (%s)", name, entityNumber);
        return SubProjectSearchItem.of((long)indexEntry.getId(), (String)text, (Iterable)rootHighlightCommon, (String)details, (String)field.fieldName(), (String)fieldName, (Iterable)detailHighlightCommon, (String)entityNumber, (String)stageNumber);
    }

    public SubProjectMapper(ConfigService configService, HighlightMapper highlightMapper, MessageService messageService, CompanyConfig companyConfig) {
        this.configService = configService;
        this.highlightMapper = highlightMapper;
        this.messageService = messageService;
        this.companyConfig = companyConfig;
    }
}

