/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Streams;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.quotation.StagePropagationCommon;
import de.qfm.erp.common.response.quotation.StagePropagationListCommon;
import de.qfm.erp.service.configuration.ApplicationConfig;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.queue.EProcessingState;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.quotation.StagePropagation;
import de.qfm.erp.service.model.jpa.quotation.StagePropagationItem;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.mapper.StagePropagationMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class StagePropagationMapper {
    private static final Logger log = LogManager.getLogger(StagePropagationMapper.class);
    private static final BigDecimal STAGE_PROCESSING_TIME_IN_SEC = BigDecimal.valueOf(5L);
    private final ApplicationConfig applicationConfig;
    private static final Ordering<Comparable<Long>> ASC = Ordering.natural().nullsLast();
    private static final Ordering<Comparable<Long>> DESC = Ordering.natural().nullsLast().reverse();

    @Nonnull
    public StagePropagationCommon mapToCommon(@NonNull StagePropagation stagePropagation) {
        if (stagePropagation == null) {
            throw new NullPointerException("stagePropagation is marked non-null but is null");
        }
        Quotation source = stagePropagation.getStageFrom();
        Quotation target = stagePropagation.getStageTo();
        EProcessingState processingState = stagePropagation.getProcessingState();
        List items = (List)MoreObjects.firstNonNull((Object)stagePropagation.getItems(), (Object)ImmutableList.of());
        ImmutableSet positions = (ImmutableSet)items.stream().map(StagePropagationItem::getPosition).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        List positionsTxt = (List)positions.stream().map(QuotationPosition::getSurrogatePositionNumber).sorted().collect(ImmutableList.toImmutableList());
        StagePropagationCommon common = new StagePropagationCommon();
        common.setId(stagePropagation.getId());
        BaseMapper.map((EntityBase)stagePropagation, (EntityBaseCommon)common);
        common.setBatch(stagePropagation.getBatch());
        common.setProcessingState(processingState.name());
        common.setStageNumber(source.getQNumber());
        common.setStageAlias(source.getAlias());
        common.setTargetStageNumber(target.getQNumber());
        common.setTargetStageAlias(target.getAlias());
        common.setPositions(positionsTxt);
        return common;
    }

    @Nonnull
    public StagePropagationListCommon mapToList(@NonNull Iterable<StagePropagation> stagePropagations) {
        if (stagePropagations == null) {
            throw new NullPointerException("stagePropagations is marked non-null but is null");
        }
        int size = Iterables.size(stagePropagations);
        ImmutableList commons = (ImmutableList)Streams.stream(stagePropagations).map(arg_0 -> this.mapToCommon(arg_0)).collect(ImmutableList.toImmutableList());
        StagePropagationListCommon stagePropagationList = new StagePropagationListCommon(size, (List)commons);
        ImmutableList unprocessed = (ImmutableList)Streams.stream(stagePropagations).filter(item -> item.getProcessingState() == EProcessingState.UNPROCESSED).sorted((Comparator<StagePropagation>)StagePropagationComparator.ASC).map(item -> item.getStageTo().getQNumber()).collect(ImmutableList.toImmutableList());
        ImmutableList processed = (ImmutableList)Streams.stream(stagePropagations).filter(item -> item.getProcessingState() == EProcessingState.PROCESSED).limit(25L).sorted((Comparator<StagePropagation>)StagePropagationComparator.DESC).map(item -> item.getStageTo().getQNumber()).collect(ImmutableList.toImmutableList());
        stagePropagationList.setUnprocessedAmount((long)unprocessed.size());
        BigDecimal stagePropagationJobDelayMS = BigDecimal.valueOf(this.applicationConfig.getStagePropagationJobDelayMS());
        BigDecimal unprocessedAmount = BigDecimal.valueOf(unprocessed.size());
        BigDecimal eta = unprocessedAmount.multiply(stagePropagationJobDelayMS.divide(BigDecimal.valueOf(1000L), RoundingMode.HALF_UP).add(STAGE_PROCESSING_TIME_IN_SEC));
        stagePropagationList.setEtaInSec(eta.longValue());
        if (!unprocessed.isEmpty()) {
            String next = (String)unprocessed.get(0);
            stagePropagationList.setNextPropagation(next);
        } else {
            stagePropagationList.setNextPropagation("");
        }
        stagePropagationList.setRecentPropagationsProcessed((List)processed);
        stagePropagationList.setPropagationsUnprocessed((List)unprocessed);
        return stagePropagationList;
    }

    public StagePropagationMapper(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
    }
}

