/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.qfm.erp.common.request.quotation.StageOrderNumberUpdateItem;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.quotation.StageOrderNumberCommon;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.internal.quotation.StageOrderNumberBucket;
import de.qfm.erp.service.model.internal.quotation.StageUpdateBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.quotation.EOrderNumberOrigin;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.StageOrderNumber;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.security.AuthenticationHelper;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class StageOrderNumberMapper {
    private static final Logger log = LogManager.getLogger(StageOrderNumberMapper.class);
    private final AuthenticationHelper authenticationHelper;
    private final EntityFactory entityFactory;
    public static final BiConsumer<StageOrderNumber, StageOrderNumberBucket> NOOP = (entity, updateItem) -> {};

    @Nonnull
    public MergedBucket<StageOrderNumber> merge(@NonNull StageUpdateBucket stageUpdateBucket) {
        if (stageUpdateBucket == null) {
            throw new NullPointerException("stageUpdateBucket is marked non-null but is null");
        }
        Quotation stage = (Quotation)stageUpdateBucket.getEntity();
        Iterable allBuckets = stageUpdateBucket.getOrderNumberBuckets();
        Iterable buckets = (Iterable)Streams.stream((Iterable)allBuckets).filter(item -> EOrderNumberOrigin.APPX == item.getOrigin()).collect(ImmutableList.toImmutableList());
        MergedBucket mergedBucket = BaseMapper.merge((EntityBase)stage, Quotation::getOrderNumbers, arg_0 -> ((Quotation)stage).setOrderNumbers(arg_0), (Iterable)buckets, StageOrderNumberBucket::getId, StageOrderNumber::getId, () -> ((EntityFactory)this.entityFactory).stageOrderNumber(), (arg_0, arg_1) -> this.mergeOrderNumber(arg_0, arg_1), StageOrderNumber::setQuotation, () -> ((AuthenticationHelper)this.authenticationHelper).currentUserName(), (BiConsumer)NOOP);
        MergedBucket.printMergeBucket((Object)stage, StageOrderNumber.class, (MergedBucket)mergedBucket);
        return mergedBucket;
    }

    @Nonnull
    public StageOrderNumber mergeOrderNumber(@NonNull StageOrderNumber stageOrderNumber, @NonNull StageOrderNumberBucket updateBucket) {
        if (stageOrderNumber == null) {
            throw new NullPointerException("stageOrderNumber is marked non-null but is null");
        }
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        StageOrderNumberUpdateItem updateItem = updateBucket.getUpdateItem();
        stageOrderNumber.setOrderNumber(StringUtils.trimToEmpty((String)updateItem.getOrderNumber()));
        stageOrderNumber.setRemarks(StringUtils.trimToEmpty((String)updateItem.getRemarks()));
        return stageOrderNumber;
    }

    @Nonnull
    public List<StageOrderNumberCommon> map(@NonNull Iterable<StageOrderNumber> entities) {
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        return (List)Streams.stream(entities).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public StageOrderNumberCommon map(@NonNull StageOrderNumber entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        StageOrderNumberCommon common = new StageOrderNumberCommon();
        BaseMapper.map((EntityBase)entity, (EntityBaseCommon)common);
        common.setId(entity.getId());
        common.setOrigin(EOrderNumberOrigin.APPX.name());
        common.setOrderNumber(entity.getOrderNumber());
        common.setRemarks(entity.getRemarks());
        return common;
    }

    public StageOrderNumberMapper(AuthenticationHelper authenticationHelper, EntityFactory entityFactory) {
        this.authenticationHelper = authenticationHelper;
        this.entityFactory = entityFactory;
    }
}

