/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.measurement.ReleaseOrderCommonV1;
import de.qfm.erp.common.response.measurement.ReleaseOrderCommonV2;
import de.qfm.erp.common.response.measurement.ReleaseOrdersCommonV1;
import de.qfm.erp.service.model.internal.ReleaseOrderUpdateBucket;
import de.qfm.erp.service.model.internal.psx.PsxBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.PssReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.ReleaseOrder;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.mapper.BaseMapper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ReleaseOrderMapper {
    @Nonnull
    public ReleaseOrdersCommonV1 mapV1(@NonNull Page<ReleaseOrder> releaseOrdersPage) {
        if (releaseOrdersPage == null) {
            throw new NullPointerException("releaseOrdersPage is marked non-null but is null");
        }
        long totalElements = releaseOrdersPage.getTotalElements();
        int totalPages = releaseOrdersPage.getTotalPages();
        Pageable pageable = releaseOrdersPage.getPageable();
        int pageSize = pageable.getPageSize();
        int pageNumber = pageable.getPageNumber();
        List content = releaseOrdersPage.getContent();
        List commons = (List)content.stream().map(arg_0 -> this.mapV1(arg_0)).collect(ImmutableList.toImmutableList());
        return new ReleaseOrdersCommonV1(pageNumber, pageSize, totalPages, totalElements, commons);
    }

    @Nonnull
    public ReleaseOrderCommonV1 mapV1(@NonNull ReleaseOrder releaseOrder) {
        PssReleaseOrder pssReleaseOrder;
        Quotation stage;
        if (releaseOrder == null) {
            throw new NullPointerException("releaseOrder is marked non-null but is null");
        }
        ReleaseOrderCommonV1 releaseOrderCommonV1 = new ReleaseOrderCommonV1();
        BaseMapper.map((EntityBase)releaseOrder, (EntityBaseCommon)releaseOrderCommonV1);
        releaseOrderCommonV1.setId(releaseOrder.getId());
        releaseOrderCommonV1.setReferenceId(releaseOrder.getReferenceId());
        releaseOrderCommonV1.setName(releaseOrder.getName());
        Measurement measurement = releaseOrder.getMeasurement();
        if (null != measurement) {
            releaseOrderCommonV1.setMeasurementId(measurement.getId());
            releaseOrderCommonV1.setMeasurementNumber(measurement.getMeasurementNumber());
            User assignedUser = measurement.getAssignedUser();
            if (null != assignedUser) {
                releaseOrderCommonV1.setMeasurementAssignedUserId(assignedUser.getId());
                releaseOrderCommonV1.setMeasurementAssignedUserFirstName(assignedUser.getFirstName());
                releaseOrderCommonV1.setMeasurementAssignedUserLastName(assignedUser.getLastName());
                releaseOrderCommonV1.setMeasurementAssignedUserPersonalNumber(assignedUser.getPersonalNumber());
            }
        }
        if (null != (stage = releaseOrder.getQuotation())) {
            releaseOrderCommonV1.setQuotationId(stage.getId());
            releaseOrderCommonV1.setQuotationNumber(stage.getQuotationNumber());
        }
        if (null != (pssReleaseOrder = releaseOrder.getPssReleaseOrder())) {
            releaseOrderCommonV1.setState(pssReleaseOrder.getPssState());
            releaseOrderCommonV1.setPssReleaseOrderId(pssReleaseOrder.getPssId());
            releaseOrderCommonV1.setExternalPssReleaseOrderId(pssReleaseOrder.getPssId());
        }
        releaseOrderCommonV1.setOrderNumber(releaseOrder.getOrderNumber());
        return releaseOrderCommonV1;
    }

    @Nonnull
    public ReleaseOrder merge(@NonNull ReleaseOrderUpdateBucket bucket) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        String referenceId = bucket.getReferenceId();
        Measurement measurement = bucket.getMeasurement();
        Quotation stage = bucket.getStage();
        ReleaseOrder releaseOrder = bucket.getReleaseOrder();
        String name = StringUtils.trimToEmpty((String)bucket.getName());
        String orderNumber = StringUtils.trimToEmpty((String)bucket.getOrderNumber());
        PssReleaseOrder pssReleaseOrder = bucket.getPssReleaseOrder();
        PsxBucket psxBucket = bucket.getPsxBucket();
        return this.merge(referenceId, measurement, stage, releaseOrder, name, orderNumber, pssReleaseOrder, psxBucket);
    }

    @Nonnull
    private ReleaseOrder merge(@NonNull String referenceId, @NonNull Measurement measurement, @NonNull Quotation stage, @NonNull ReleaseOrder releaseOrder, @NonNull String name, @NonNull String orderNumber, @Nullable PssReleaseOrder pssReleaseOrder, @NonNull PsxBucket psxBucket) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (releaseOrder == null) {
            throw new NullPointerException("releaseOrder is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (orderNumber == null) {
            throw new NullPointerException("orderNumber is marked non-null but is null");
        }
        if (psxBucket == null) {
            throw new NullPointerException("psxBucket is marked non-null but is null");
        }
        releaseOrder.setReferenceId(referenceId);
        measurement.setReleaseOrder(releaseOrder);
        releaseOrder.setMeasurement(measurement);
        releaseOrder.setQuotation(stage);
        releaseOrder.setName(name);
        releaseOrder.setOrderNumber(orderNumber);
        releaseOrder.setPssReleaseOrder(pssReleaseOrder);
        releaseOrder.setPsxEntityId(psxBucket.getPsxEntityId());
        releaseOrder.setPsxEntityType(psxBucket.getPsxEntityType());
        releaseOrder.setPsxNumber(psxBucket.getPsxNumber());
        releaseOrder.setPsxConstructionSitePsxNumber(psxBucket.getPsxConstructionSitePsxNumber());
        releaseOrder.setPsxReleaseOrderPsxNumber(psxBucket.getPsxReleaseOrderPsxNumber());
        releaseOrder.setPsxConstructionSiteReferenceId(psxBucket.getPsxConstructionSiteReferenceId());
        releaseOrder.setPsxReleaseOrderReferenceId(psxBucket.getPsxReleaseOrderReferenceId());
        releaseOrder.setPsxProjectNumber(psxBucket.getPsxProjectNumber());
        releaseOrder.setPsxConstructionSiteProjectNumber(psxBucket.getPsxConstructionSiteProjectNumber());
        releaseOrder.setPsxReleaseOrderProjectNumber("");
        releaseOrder.setPsxReleaseOrderOrderNumber(psxBucket.getPsxReleaseOrderOrderNumber());
        releaseOrder.setPsxConstructionSiteLocation(psxBucket.getPsxConstructionSiteLocation());
        releaseOrder.setPsxConstructionSiteStateName(psxBucket.getPsxConstructionSiteStateName());
        releaseOrder.setPsxReleaseOrderStateName(psxBucket.getPsxReleaseOrderStateName());
        return releaseOrder;
    }

    @Nonnull
    public ReleaseOrderCommonV2 mapV2(@NonNull ReleaseOrder releaseOrder) {
        Quotation stage;
        if (releaseOrder == null) {
            throw new NullPointerException("releaseOrder is marked non-null but is null");
        }
        ReleaseOrderCommonV2 releaseOrderCommonV2 = new ReleaseOrderCommonV2();
        BaseMapper.map((EntityBase)releaseOrder, (EntityBaseCommon)releaseOrderCommonV2);
        releaseOrderCommonV2.setId(releaseOrder.getId());
        releaseOrderCommonV2.setName(releaseOrder.getName());
        Measurement measurement = releaseOrder.getMeasurement();
        if (null != measurement) {
            releaseOrderCommonV2.setMeasurementId(measurement.getId());
            releaseOrderCommonV2.setMeasurementNumber(measurement.getMeasurementNumber());
            User assignedUser = measurement.getAssignedUser();
            if (null != assignedUser) {
                releaseOrderCommonV2.setMeasurementAssignedUserId(assignedUser.getId());
                releaseOrderCommonV2.setMeasurementAssignedUserFirstName(assignedUser.getFirstName());
                releaseOrderCommonV2.setMeasurementAssignedUserLastName(assignedUser.getLastName());
                releaseOrderCommonV2.setMeasurementAssignedUserPersonalNumber(assignedUser.getPersonalNumber());
            }
        }
        if (null != (stage = releaseOrder.getQuotation())) {
            releaseOrderCommonV2.setStageId(stage.getId());
            releaseOrderCommonV2.setStageNumber(stage.getQNumber());
        }
        releaseOrderCommonV2.setOrderNumber(releaseOrder.getOrderNumber());
        releaseOrderCommonV2.setPsxEntityId(releaseOrder.getPsxEntityId());
        releaseOrderCommonV2.setPsxEntityType(releaseOrder.getPsxEntityType());
        releaseOrderCommonV2.setPsxNumber(releaseOrder.getPsxNumber());
        String psxConstructionSitePsxNumber = releaseOrder.getPsxConstructionSitePsxNumber();
        releaseOrderCommonV2.setPsxConstructionSitePsxNumber(psxConstructionSitePsxNumber);
        String psxReleaseOrderPsxNumber = releaseOrder.getPsxReleaseOrderPsxNumber();
        releaseOrderCommonV2.setPsxReleaseOrderPsxNumber(psxReleaseOrderPsxNumber);
        String effectivePsxNumber = StringUtils.isNotBlank((CharSequence)psxConstructionSitePsxNumber) ? psxConstructionSitePsxNumber : psxReleaseOrderPsxNumber;
        releaseOrderCommonV2.setPsxEffectivePsxNumber(effectivePsxNumber);
        releaseOrderCommonV2.setPsxConstructionSiteReferenceId(releaseOrder.getPsxConstructionSiteReferenceId());
        releaseOrderCommonV2.setPsxReleaseOrderReferenceId(releaseOrder.getPsxReleaseOrderReferenceId());
        releaseOrderCommonV2.setPsxProjectNumber(releaseOrder.getPsxProjectNumber());
        releaseOrderCommonV2.setPsxConstructionSiteProjectNumber(releaseOrder.getPsxConstructionSiteProjectNumber());
        releaseOrderCommonV2.setPsxReleaseOrderProjectNumber(releaseOrder.getPsxReleaseOrderProjectNumber());
        releaseOrderCommonV2.setPsxReleaseOrderOrderNumber(releaseOrder.getPsxReleaseOrderOrderNumber());
        releaseOrderCommonV2.setPsxConstructionSiteLocation(releaseOrder.getPsxConstructionSiteLocation());
        String psxConstructionSiteStateName = releaseOrder.getPsxConstructionSiteStateName();
        releaseOrderCommonV2.setPsxConstructionSiteStateName(psxConstructionSiteStateName);
        String psxReleaseOrderStateName = releaseOrder.getPsxReleaseOrderStateName();
        releaseOrderCommonV2.setPsxReleaseOrderStateName(psxReleaseOrderStateName);
        String effectivePsxStateName = StringUtils.isNotBlank((CharSequence)psxConstructionSiteStateName) ? psxConstructionSiteStateName : psxReleaseOrderStateName;
        releaseOrderCommonV2.setPsxEffectiveStateName(effectivePsxStateName);
        releaseOrderCommonV2.setPsxFlagDisabled((Boolean)MoreObjects.firstNonNull((Object)releaseOrder.getPsxFlagDisabled(), (Object)false));
        return releaseOrderCommonV2;
    }
}

