/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.psx.PsxConstructionSiteCommon;
import de.qfm.erp.common.response.psx.PsxEntryCommon;
import de.qfm.erp.common.response.psx.PsxEntryListCommon;
import de.qfm.erp.common.response.psx.PsxOrderValueCommon;
import de.qfm.erp.common.response.psx.PsxOrderValueListCommon;
import de.qfm.erp.common.response.psx.PsxReleaseOrderCommon;
import de.qfm.erp.common.response.psx.PsxSaveAllResponse;
import de.qfm.erp.common.response.psx.PsxWorkSpaceCommon;
import de.qfm.erp.common.response.psx.PsxWorkSpaceListCommon;
import de.qfm.erp.service.model.external.psx.ExtPsxConstructionSiteCommon;
import de.qfm.erp.service.model.external.psx.ExtPsxConstructionSitePageCommon;
import de.qfm.erp.service.model.external.psx.ExtPsxReleaseOrderCommon;
import de.qfm.erp.service.model.external.psx.ExtPsxReleaseOrderPageCommon;
import de.qfm.erp.service.model.external.psx.ExtPsxSaveAllUpdateResponse;
import de.qfm.erp.service.model.external.psx.ExtPsxWorkSpaceCommon;
import de.qfm.erp.service.model.external.psx.ExtPsxWorkSpacePageCommon;
import de.qfm.erp.service.model.jpa.measurement.PsxReleaseOrder;
import de.qfm.erp.service.service.mapper.BaseMapper;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PsxMapper {
    private static final Joiner MINUS_JOINER = Joiner.on((String)" - ").skipNulls();

    @Nonnull
    public PsxEntryListCommon mapToEntries(@NonNull ExtPsxConstructionSitePageCommon extPsxConstructionSitePageCommon, @NonNull ExtPsxReleaseOrderPageCommon psxReleaseOrderPageCommon, @NonNull Function<PsxEntryCommon, Boolean> fnDisabled) {
        if (extPsxConstructionSitePageCommon == null) {
            throw new NullPointerException("extPsxConstructionSitePageCommon is marked non-null but is null");
        }
        if (psxReleaseOrderPageCommon == null) {
            throw new NullPointerException("psxReleaseOrderPageCommon is marked non-null but is null");
        }
        if (fnDisabled == null) {
            throw new NullPointerException("fnDisabled is marked non-null but is null");
        }
        List csItems = extPsxConstructionSitePageCommon.getItems();
        List roItems = psxReleaseOrderPageCommon.getItems();
        ImmutableList psxEntryCSCommons = (ImmutableList)csItems.stream().map((? super T item) -> this.map(item, fnDisabled)).collect(ImmutableList.toImmutableList());
        ImmutableList psxEntryROCommons = (ImmutableList)roItems.stream().map((? super T item) -> this.mapToEntry(item, fnDisabled)).collect(ImmutableList.toImmutableList());
        ImmutableList allEntries = (ImmutableList)FluentIterable.from((Iterable)psxEntryCSCommons).append((Iterable)psxEntryROCommons).stream().collect(ImmutableList.toImmutableList());
        return new PsxEntryListCommon(allEntries.size(), (List)allEntries);
    }

    @Nonnull
    public PsxEntryCommon map(@NonNull ExtPsxConstructionSiteCommon item, @NonNull Function<PsxEntryCommon, Boolean> fnDisabled) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (fnDisabled == null) {
            throw new NullPointerException("fnDisabled is marked non-null but is null");
        }
        PsxEntryCommon common = new PsxEntryCommon();
        BaseMapper.map((EntityBaseCommon)item, (EntityBaseCommon)common);
        common.setId(item.getId());
        common.setEntityId(item.getId());
        common.setEntityType("CONSTRUCTION_SITE");
        String constructionSiteReferenceId = Long.toString(item.getId());
        common.setConstructionSiteReferenceId(constructionSiteReferenceId);
        String psxReleaseOrderReferenceId = Long.toString(item.getReleaseOrderId());
        common.setReleaseOrderReferenceId(psxReleaseOrderReferenceId);
        String constructionSitePsxNumber = StringUtils.trimToEmpty((String)item.getPsxNumber());
        common.setPsxNumber(constructionSitePsxNumber);
        common.setConstructionSitePsxNumber(constructionSitePsxNumber);
        String releaseOrderPsxNumber = StringUtils.trimToEmpty((String)item.getReleaseOrderPsxNumber());
        common.setReleaseOrderPsxNumber(releaseOrderPsxNumber);
        String effectivePsxNumber = StringUtils.isNotBlank((CharSequence)constructionSitePsxNumber) ? constructionSitePsxNumber : releaseOrderPsxNumber;
        common.setEffectivePsxNumber(effectivePsxNumber);
        String projectNumber = StringUtils.trimToEmpty((String)item.getProjectNumber());
        common.setProjectNumber(projectNumber);
        common.setConstructionSiteProjectNumber(projectNumber);
        common.setReleaseOrderProjectNumber("");
        String releaseOrderOrderNumber = StringUtils.trimToEmpty((String)item.getReleaseOrderOrderNumber());
        common.setReleaseOrderOrderNumber(releaseOrderOrderNumber);
        String releaseOrderStateName = StringUtils.trimToEmpty((String)item.getReleaseOrderStateName());
        common.setReleaseOrderStateName(releaseOrderStateName);
        String constructionSiteStateName = StringUtils.trimToEmpty((String)item.getConstructionSiteStateName());
        common.setConstructionSiteStateName(constructionSiteStateName);
        common.setConstructionSiteProjectNumber(StringUtils.trimToEmpty((String)item.getProjectNumber()));
        String location = PsxMapper.buildLocation((ExtPsxConstructionSiteCommon)item);
        common.setLocation(location);
        String effectiveStateName = StringUtils.isNotBlank((CharSequence)constructionSiteStateName) ? constructionSiteStateName : releaseOrderStateName;
        common.setEffectiveStateName(effectiveStateName);
        ImmutableList valuesToJoin = ImmutableList.of((Object)constructionSitePsxNumber, (Object)projectNumber, (Object)releaseOrderOrderNumber, (Object)location);
        String namePreview = "Baustelle: " + MINUS_JOINER.join((Iterable)valuesToJoin);
        String nameSelect = MINUS_JOINER.join((Iterable)valuesToJoin);
        common.setNamePreview(namePreview);
        common.setNameSelect(nameSelect);
        Boolean disabled = fnDisabled.apply(common);
        common.setFlagDisabled(disabled);
        String stageReferenceId = item.getStageReferenceId();
        common.setStageId(Longs.tryParse((String)stageReferenceId));
        return common;
    }

    @Nonnull
    public PsxEntryCommon mapToEntry(@NonNull ExtPsxReleaseOrderCommon item, @NonNull Function<PsxEntryCommon, Boolean> fnDisabled) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (fnDisabled == null) {
            throw new NullPointerException("fnDisabled is marked non-null but is null");
        }
        PsxEntryCommon common = new PsxEntryCommon();
        BaseMapper.map((EntityBaseCommon)item, (EntityBaseCommon)common);
        common.setId(item.getId());
        common.setEntityId(item.getId());
        common.setEntityType("RELEASE_ORDER");
        String psxReleaseOrderReferenceId = Long.toString(item.getId());
        common.setReleaseOrderReferenceId(psxReleaseOrderReferenceId);
        String psxNumber = StringUtils.trimToEmpty((String)item.getPsxNumber());
        common.setPsxNumber(psxNumber);
        common.setReleaseOrderPsxNumber(psxNumber);
        common.setEffectivePsxNumber(psxNumber);
        common.setProjectNumber("");
        common.setReleaseOrderProjectNumber("");
        String orderNumber = StringUtils.trimToEmpty((String)item.getOrderNumber());
        common.setReleaseOrderOrderNumber(orderNumber);
        String releaseOrderStateName = StringUtils.trimToEmpty((String)item.getReleaseOrderStateName());
        common.setReleaseOrderStateName(releaseOrderStateName);
        common.setEffectiveStateName(releaseOrderStateName);
        common.setConstructionSiteStateName("");
        common.setConstructionSiteReferenceId("");
        common.setConstructionSitePsxNumber("");
        common.setConstructionSiteProjectNumber("");
        common.setLocation("");
        ImmutableList valuesToJoin = ImmutableList.of((Object)psxNumber, (Object)orderNumber);
        Joiner joiner = Joiner.on((String)" - ").skipNulls();
        String namePreview = "Abruf: " + joiner.join((Iterable)valuesToJoin);
        String nameSelect = joiner.join((Iterable)valuesToJoin);
        common.setNamePreview(namePreview);
        common.setNameSelect(nameSelect);
        Boolean disabled = fnDisabled.apply(common);
        common.setFlagDisabled(disabled);
        String stageReferenceId = item.getStageReferenceId();
        common.setStageId(Longs.tryParse((String)stageReferenceId));
        return common;
    }

    @Nonnull
    public PsxOrderValueListCommon mapToOrderValues(@NonNull ExtPsxReleaseOrderPageCommon psxReleaseOrdersPage) {
        if (psxReleaseOrdersPage == null) {
            throw new NullPointerException("psxReleaseOrdersPage is marked non-null but is null");
        }
        ImmutableList commons = (ImmutableList)psxReleaseOrdersPage.getItems().stream().map(arg_0 -> this.mapToOrderValue(arg_0)).collect(ImmutableList.toImmutableList());
        return new PsxOrderValueListCommon(commons.size(), (List)commons);
    }

    @Nonnull
    public PsxOrderValueCommon mapToOrderValue(@NonNull ExtPsxReleaseOrderCommon item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        PsxOrderValueCommon common = new PsxOrderValueCommon();
        BaseMapper.map((EntityBaseCommon)item, (EntityBaseCommon)common);
        common.setId(item.getId());
        String psxReleaseOrderReferenceId = Long.toString(item.getId());
        common.setReleaseOrderReferenceId(psxReleaseOrderReferenceId);
        String psxNumber = StringUtils.trimToEmpty((String)item.getPsxNumber());
        common.setReleaseOrderPsxNumber(psxNumber);
        common.setReleaseOrderOrderValue(item.getOrderValue());
        common.setReleaseOrderProjectNumber("");
        String orderNumber = StringUtils.trimToEmpty((String)item.getOrderNumber());
        common.setReleaseOrderOrderNumber(orderNumber);
        String releaseOrderStateName = StringUtils.trimToEmpty((String)item.getReleaseOrderStateName());
        common.setReleaseOrderStateName(releaseOrderStateName);
        return common;
    }

    @Nonnull
    public PsxReleaseOrder merge(@NonNull PsxReleaseOrder entity, @NonNull ExtPsxReleaseOrderCommon extPsxReleaseOrderCommon) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (extPsxReleaseOrderCommon == null) {
            throw new NullPointerException("extPsxReleaseOrderCommon is marked non-null but is null");
        }
        String releaseOrderStateName = extPsxReleaseOrderCommon.getReleaseOrderStateName();
        entity.setStateName(releaseOrderStateName);
        entity.setFlagDisabled(Boolean.valueOf(false));
        String psxNumber = extPsxReleaseOrderCommon.getPsxNumber();
        entity.setPsxNumber(psxNumber);
        String psxReleaseOrderReferenceId = "" + extPsxReleaseOrderCommon.getId();
        entity.setReferenceId(psxReleaseOrderReferenceId);
        entity.setProjectNumber("");
        String orderNumber = extPsxReleaseOrderCommon.getOrderNumber();
        entity.setOrderNumber(orderNumber);
        entity.setPlace("TODO (Construction Site?)");
        String selectWithId = psxNumber + " - " + orderNumber + " - " + psxReleaseOrderReferenceId;
        String selectWOId = psxNumber + " - " + orderNumber;
        entity.setReleaseOrderNameSelectCurrent(selectWOId);
        entity.setReleaseOrderNamePreviewCurrent(selectWithId);
        entity.setReleaseOrderNameSelectPrevious(selectWOId);
        entity.setReleaseOrderNamePreviewPrevious(selectWithId);
        return entity;
    }

    @Nonnull
    public PsxWorkSpaceListCommon map(@NonNull ExtPsxWorkSpacePageCommon workspaces) {
        if (workspaces == null) {
            throw new NullPointerException("workspaces is marked non-null but is null");
        }
        List workSpaceCommons = (List)workspaces.getItems().stream().map(arg_0 -> this.map(arg_0)).sorted((a, b) -> StringUtils.compareIgnoreCase((String)a.getName(), (String)b.getName())).collect(ImmutableList.toImmutableList());
        return new PsxWorkSpaceListCommon(workSpaceCommons.size(), workSpaceCommons);
    }

    @Nonnull
    public PsxWorkSpaceCommon map(@NonNull ExtPsxWorkSpaceCommon item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        PsxWorkSpaceCommon common = new PsxWorkSpaceCommon();
        BaseMapper.map((EntityBaseCommon)item, (EntityBaseCommon)common);
        common.setId(item.getId());
        common.setName(item.getName());
        common.setPrimarySpaceId(item.getPrimarySpaceId());
        return common;
    }

    @Nonnull
    public PsxConstructionSiteCommon map(@NonNull ExtPsxConstructionSiteCommon item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        PsxConstructionSiteCommon common = new PsxConstructionSiteCommon();
        common.setReferenceId(item.getId());
        String constructionSiteReferenceId = Long.toString(item.getId());
        common.setConstructionSiteReferenceId(constructionSiteReferenceId);
        String psxReleaseOrderReferenceId = Long.toString(item.getReleaseOrderId());
        common.setReleaseOrderReferenceId(psxReleaseOrderReferenceId);
        String constructionSitePsxNumber = StringUtils.trimToEmpty((String)item.getPsxNumber());
        common.setPsxNumber(constructionSitePsxNumber);
        common.setConstructionSitePsxNumber(constructionSitePsxNumber);
        String releaseOrderPsxNumber = StringUtils.trimToEmpty((String)item.getReleaseOrderPsxNumber());
        common.setReleaseOrderPsxNumber(releaseOrderPsxNumber);
        String projectNumber = StringUtils.trimToEmpty((String)item.getProjectNumber());
        common.setProjectNumber(projectNumber);
        common.setConstructionSiteProjectNumber(projectNumber);
        common.setReleaseOrderProjectNumber("");
        String releaseOrderOrderNumber = StringUtils.trimToEmpty((String)item.getReleaseOrderOrderNumber());
        common.setReleaseOrderOrderNumber(releaseOrderOrderNumber);
        String releaseOrderStateName = StringUtils.trimToEmpty((String)item.getReleaseOrderStateName());
        common.setReleaseOrderStateName(releaseOrderStateName);
        String constructionSiteStateName = StringUtils.trimToEmpty((String)item.getConstructionSiteStateName());
        common.setConstructionSiteStateName(constructionSiteStateName);
        common.setConstructionSiteProjectNumber(StringUtils.trimToEmpty((String)item.getProjectNumber()));
        String location = PsxMapper.buildLocation((ExtPsxConstructionSiteCommon)item);
        common.setLocation(location);
        String effectiveStateName = StringUtils.isNotBlank((CharSequence)constructionSiteStateName) ? constructionSiteStateName : releaseOrderStateName;
        common.setEffectiveStateName(effectiveStateName);
        ImmutableList valuesToJoin = ImmutableList.of((Object)constructionSitePsxNumber, (Object)projectNumber, (Object)releaseOrderOrderNumber, (Object)location);
        String nameSelect = MINUS_JOINER.join((Iterable)valuesToJoin);
        common.setName(nameSelect);
        return common;
    }

    private static String buildLocation(ExtPsxConstructionSiteCommon item) {
        return StringUtils.trimToEmpty((String)(item.getStreet() + " " + item.getStreetNo())) + ", " + StringUtils.trimToEmpty((String)item.getZipCode()) + " " + StringUtils.trimToEmpty((String)item.getCity());
    }

    @Nonnull
    public PsxReleaseOrderCommon map(@NonNull ExtPsxReleaseOrderCommon item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        PsxReleaseOrderCommon common = new PsxReleaseOrderCommon();
        common.setReferenceId(item.getId());
        String psxReleaseOrderReferenceId = Long.toString(item.getId());
        common.setReleaseOrderReferenceId(psxReleaseOrderReferenceId);
        String psxNumber = StringUtils.trimToEmpty((String)item.getPsxNumber());
        common.setPsxNumber(psxNumber);
        common.setReleaseOrderPsxNumber(psxNumber);
        common.setProjectNumber("");
        common.setReleaseOrderProjectNumber("");
        String orderNumber = StringUtils.trimToEmpty((String)item.getOrderNumber());
        common.setReleaseOrderOrderNumber(orderNumber);
        String releaseOrderStateName = StringUtils.trimToEmpty((String)item.getReleaseOrderStateName());
        common.setReleaseOrderStateName(releaseOrderStateName);
        common.setEffectiveStateName(releaseOrderStateName);
        ImmutableList valuesToJoin = ImmutableList.of((Object)psxNumber, (Object)orderNumber);
        Joiner joiner = Joiner.on((String)" - ").skipNulls();
        String nameSelect = joiner.join((Iterable)valuesToJoin);
        common.setName(nameSelect);
        return common;
    }

    @Nonnull
    public PsxSaveAllResponse map(ExtPsxSaveAllUpdateResponse extPsxSaveAllResponse) {
        ExtPsxReleaseOrderCommon releaseOrder = extPsxSaveAllResponse.getReleaseOrder();
        ExtPsxConstructionSiteCommon constructionSite = extPsxSaveAllResponse.getConstructionSite();
        PsxSaveAllResponse saveAllResponse = new PsxSaveAllResponse();
        PsxReleaseOrderCommon releaseOrderPsx = null != releaseOrder ? this.map(releaseOrder) : null;
        PsxConstructionSiteCommon constructionSiteCommon = null != constructionSite ? this.map(constructionSite) : null;
        saveAllResponse.setConstructionSite(constructionSiteCommon);
        saveAllResponse.setReleaseOrder(releaseOrderPsx);
        return saveAllResponse;
    }
}

