/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.leancoders.common.response.PageCommon;
import de.qfm.erp.common.request.measurement.MeasurementUpdateRequest;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.invoice.MeasurementValidationItem;
import de.qfm.erp.common.response.invoice.MeasurementValidationResponse;
import de.qfm.erp.common.response.measurement.MeasurementAvailableStatesCommon;
import de.qfm.erp.common.response.measurement.MeasurementCommon;
import de.qfm.erp.common.response.measurement.MeasurementImportResultCommon;
import de.qfm.erp.common.response.measurement.MeasurementImportResultListCommon;
import de.qfm.erp.common.response.measurement.MeasurementNumberExistsResponse;
import de.qfm.erp.common.response.measurement.MeasurementPageCommon;
import de.qfm.erp.common.response.measurement.MeasurementSearchResultCommon;
import de.qfm.erp.common.response.measurement.MeasurementSearchResultItemCommon;
import de.qfm.erp.common.response.measurement.MeasurementTransposedRemarkCommon;
import de.qfm.erp.common.response.measurement.ReleaseOrderCommonV2;
import de.qfm.erp.common.response.project.ProjectCommon;
import de.qfm.erp.common.response.search.MeasurementSearchItem;
import de.qfm.erp.service.configuration.CompanyConfig;
import de.qfm.erp.service.helper.EmployeeHelper;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.helper.MeasurementHelper;
import de.qfm.erp.service.helper.StageHelper;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.internal.ReleaseOrderUpdateBucket;
import de.qfm.erp.service.model.internal.measurement.AvailableMeasurementStates;
import de.qfm.erp.service.model.internal.measurement.IMeasurementListingItem;
import de.qfm.erp.service.model.internal.measurement.MeasurementPositionUpdateBucket;
import de.qfm.erp.service.model.internal.measurement.MeasurementPositionsUpdateBucket;
import de.qfm.erp.service.model.internal.measurement.MeasurementTransposedRemarkUpdateBucket;
import de.qfm.erp.service.model.internal.measurement.MeasurementTransposedRemarksUpdateBucket;
import de.qfm.erp.service.model.internal.measurement.MeasurementUpdateBucket;
import de.qfm.erp.service.model.internal.measurement.MeasurementXlsImportResult;
import de.qfm.erp.service.model.internal.quotation.ECostUnitCEViewMode;
import de.qfm.erp.service.model.internal.search.Highlight;
import de.qfm.erp.service.model.internal.search.MeasurementSearchItemBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.businessunit.UserCostCenter;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.measurement.MeasurementState;
import de.qfm.erp.service.model.jpa.measurement.MeasurementTransposedRemark;
import de.qfm.erp.service.model.jpa.measurement.ReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementOrigin;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementType;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementValidationFlag;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementViewType;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.MeasurementIndexEntry;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.mapper.HighlightMapper;
import de.qfm.erp.service.service.mapper.MeasurementPositionMapper;
import de.qfm.erp.service.service.mapper.MeasurementStateMapper;
import de.qfm.erp.service.service.mapper.ProjectMapper;
import de.qfm.erp.service.service.mapper.ReleaseOrderMapper;
import de.qfm.erp.service.service.security.AuthenticationHelper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.ConfigService;
import de.qfm.erp.service.service.service.MessageService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MeasurementMapper {
    private static final Logger log = LogManager.getLogger(MeasurementMapper.class);
    private final EntityFactory entityFactory;
    private final ConfigService configService;
    private final MessageService messageService;
    private final MeasurementPositionMapper measurementPositionMapper;
    private final MeasurementStateMapper measurementStateMapper;
    private final ProjectMapper projectMapper;
    private final ReleaseOrderMapper releaseOrderMapper;
    private final HighlightMapper highlightMapper;
    private final AuthenticationHelper authenticationHelper;
    private final UserService userService;
    private final CompanyConfig companyConfig;
    private static final BiConsumer<MeasurementTransposedRemark, MeasurementTransposedRemarkUpdateBucket> NO_CALLBACK_IPM = (x, y) -> {};

    @Nonnull
    public MeasurementPageCommon map(@NonNull Page<IMeasurementListingItem> measurementListingItemPage) {
        if (measurementListingItemPage == null) {
            throw new NullPointerException("measurementListingItemPage is marked non-null but is null");
        }
        boolean allAttributesVisible = this.userService.hasPrivilege(EPrivilege.MEASUREMENT__ALL_ATTRIBUTES_VISIBLE);
        boolean valueOverallVisible = this.userService.hasPrivilege(EPrivilege.MEASUREMENT__VALUE_OVERALL_VISIBLE);
        long totalElements = measurementListingItemPage.getTotalElements();
        int totalPages = measurementListingItemPage.getTotalPages();
        Pageable pageable = measurementListingItemPage.getPageable();
        int pageSize = pageable.isPaged() ? pageable.getPageSize() : 0;
        int pageNumber = pageable.isPaged() ? pageable.getPageNumber() : 0;
        List content = measurementListingItemPage.getContent();
        ImmutableList measurementCommons = ImmutableList.copyOf(content.stream().map((? super T item) -> this.map(item, allAttributesVisible, valueOverallVisible)).iterator());
        return new MeasurementPageCommon(pageNumber, pageSize, totalPages, totalElements, (List)measurementCommons);
    }

    @Nonnull
    public MeasurementCommon map(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        boolean allAttributesVisible = this.userService.hasPrivilege(EPrivilege.MEASUREMENT__ALL_ATTRIBUTES_VISIBLE);
        boolean valueOverallVisible = this.userService.hasPrivilege(EPrivilege.MEASUREMENT__VALUE_OVERALL_VISIBLE);
        return this.map(measurement, true, true, true, allAttributesVisible, valueOverallVisible);
    }

    @Nonnull
    private MeasurementCommon map(@NonNull IMeasurementListingItem measurement, boolean allAttributesVisible, boolean valueOverallVisible) {
        MeasurementCommon measurementCommon;
        block6: {
            block5: {
                if (measurement == null) {
                    throw new NullPointerException("measurement is marked non-null but is null");
                }
                measurementCommon = new MeasurementCommon();
                measurementCommon.setId(measurement.getId());
                measurementCommon.setCreatedOn(measurement.getCreatedOn());
                measurementCommon.setCreatedBy(measurement.getCreatedBy());
                measurementCommon.setUpdatedOn(measurement.getUpdatedOn());
                measurementCommon.setUpdatedBy(measurement.getUpdatedBy());
                measurementCommon.setMeasurementNumber(measurement.getMeasurementNumber());
                String measurementType = ((EMeasurementType)MoreObjects.firstNonNull((Object)measurement.getMeasurementType(), (Object)EMeasurementType.NONE)).getValue();
                measurementCommon.setMeasurementType(measurementType);
                EMeasurementState measurementState = measurement.getMeasurementState();
                String measurementStateString = ((EMeasurementState)MoreObjects.firstNonNull((Object)measurementState, (Object)EMeasurementState.UNKNOWN)).name();
                measurementCommon.setMeasurementState(measurementStateString);
                measurementCommon.setMeasurementStateSince(measurement.getMeasurementStateSince());
                measurementCommon.setMeasurementStateBy(measurement.getMeasurementStateBy());
                measurementCommon.setAssignedUserFullName(measurement.getAssignedUserFullName());
                measurementCommon.setAssignedUserCostCenter(measurement.getAssignedUserCostCenter());
                measurementCommon.setConstructionSite(measurement.getConstructionSite());
                measurementCommon.setStageId(measurement.getStageId());
                measurementCommon.setAlias(measurement.getStageAlias());
                measurementCommon.setQentityNumber(measurement.getStageNumber());
                measurementCommon.setStageVersion(measurement.getStageVersion());
                measurementCommon.setStageCustomerId(measurement.getStageCustomerId());
                measurementCommon.setStageCustomerName(measurement.getStageCustomerName());
                measurementCommon.setStageOrderNumber(measurement.getStageOrderNumber());
                measurementCommon.setInvoiceDate(measurement.getInvoiceDate());
                measurementCommon.setInvoicePostingDate(measurement.getInvoicePostingDate());
                measurementCommon.setInvoicePrimaryResponsibleUserFullName(measurement.getInvoicePrimaryResponsibleUserName());
                measurementCommon.setInvoiceNumber(measurement.getInvoiceNumber());
                measurementCommon.setPersonResponsibleAtCustomer(measurement.getPersonResponsibleAtCustomer());
                measurementCommon.setProjectExecutionStartDate(measurement.getProjectExecutionStartDate());
                measurementCommon.setProjectExecutionEndDate(measurement.getProjectExecutionEndDate());
                measurementCommon.setAccountingMonth(measurement.getAccountingMonth());
                measurementCommon.setAccountingMonthPlanned(measurement.getAccountingMonthPlanned());
                measurementCommon.setAddendumNumbers(measurement.getAddendumNumbers());
                if (allAttributesVisible) break block5;
                if (!valueOverallVisible) break block6;
            }
            BaseMapper.apply(() -> ((IMeasurementListingItem)measurement).getValueOverall(), arg_0 -> ((MeasurementCommon)measurementCommon).setValueOverall(arg_0), (Object)BigDecimal.ZERO);
        }
        if (allAttributesVisible) {
            BaseMapper.apply(() -> ((IMeasurementListingItem)measurement).getMaterialPurchasePriceOverall(), arg_0 -> ((MeasurementCommon)measurementCommon).setMaterialPurchasePriceOverall(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((IMeasurementListingItem)measurement).getMaterialSellingPriceOverall(), arg_0 -> ((MeasurementCommon)measurementCommon).setMaterialSellingPriceOverall(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((IMeasurementListingItem)measurement).getCompanyWageOverall(), arg_0 -> ((MeasurementCommon)measurementCommon).setCompanyWageOverall(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((IMeasurementListingItem)measurement).getExternalServicePurchasePriceOverall(), arg_0 -> ((MeasurementCommon)measurementCommon).setExternalServicePurchasePriceOverall(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((IMeasurementListingItem)measurement).getExternalServiceSellingPriceOverall(), arg_0 -> ((MeasurementCommon)measurementCommon).setExternalServiceSellingPriceOverall(arg_0), (Object)BigDecimal.ZERO);
            BigDecimal wagePercentage = MeasurementHelper.wagePercentage((IMeasurementListingItem)measurement);
            BaseMapper.apply(() -> wagePercentage, arg_0 -> ((MeasurementCommon)measurementCommon).setWagePercentage(arg_0), (Object)BigDecimal.ZERO);
            BigDecimal companyWagePlusMaterialPurchasePriceOverall = MeasurementHelper.notAccountedPurchasePrice((IMeasurementListingItem)measurement);
            BaseMapper.apply(() -> companyWagePlusMaterialPurchasePriceOverall, arg_0 -> ((MeasurementCommon)measurementCommon).setCompanyWagePlusMaterialPurchasePriceOverall(arg_0), (Object)BigDecimal.ZERO);
            BigDecimal companyWagePlusMaterialSellingPriceOverall = MeasurementHelper.notAccountedSellingPrice((IMeasurementListingItem)measurement);
            BaseMapper.apply(() -> companyWagePlusMaterialSellingPriceOverall, arg_0 -> ((MeasurementCommon)measurementCommon).setCompanyWagePlusMaterialSellingPriceOverall(arg_0), (Object)BigDecimal.ZERO);
        }
        BaseMapper.apply(() -> ((IMeasurementListingItem)measurement).getSquadWageOverall(), arg_0 -> ((MeasurementCommon)measurementCommon).setSquadWageOverall(arg_0), (Object)BigDecimal.ZERO);
        Long releaseOrderId = measurement.getReleaseOrderId();
        String releaseOrderName = measurement.getReleaseOrderName();
        Long psxEntityId = measurement.getPsxEntityId();
        String psxEntityType = measurement.getPsxEntityType();
        String psxNumber = measurement.getPsxNumber();
        String psxConstructionSitePsxNumber = measurement.getPsxConstructionSitePsxNumber();
        String psxReleaseOrderPsxNumber = measurement.getPsxReleaseOrderPsxNumber();
        String psxConstructionSiteReferenceId = measurement.getPsxConstructionSiteReferenceId();
        String psxReleaseOrderReferenceId = measurement.getPsxReleaseOrderReferenceId();
        String psxConstructionSiteStateName = measurement.getPsxConstructionSiteStateName();
        String psxReleaseOrderStateName = measurement.getPsxReleaseOrderStateName();
        ReleaseOrderCommonV2 releaseOrderCommonV2 = new ReleaseOrderCommonV2();
        releaseOrderCommonV2.setId(releaseOrderId);
        releaseOrderCommonV2.setName(releaseOrderName);
        releaseOrderCommonV2.setPsxEntityId(psxEntityId);
        releaseOrderCommonV2.setPsxEntityType(psxEntityType);
        releaseOrderCommonV2.setPsxNumber(psxNumber);
        releaseOrderCommonV2.setPsxConstructionSitePsxNumber(psxConstructionSitePsxNumber);
        releaseOrderCommonV2.setPsxReleaseOrderPsxNumber(psxReleaseOrderPsxNumber);
        releaseOrderCommonV2.setPsxConstructionSiteStateName(psxConstructionSiteStateName);
        releaseOrderCommonV2.setPsxReleaseOrderStateName(psxReleaseOrderStateName);
        releaseOrderCommonV2.setPsxConstructionSiteReferenceId(psxConstructionSiteReferenceId);
        releaseOrderCommonV2.setPsxReleaseOrderReferenceId(psxReleaseOrderReferenceId);
        String effectivePsxNumber = StringUtils.isNotBlank((CharSequence)psxConstructionSitePsxNumber) ? psxConstructionSitePsxNumber : psxReleaseOrderPsxNumber;
        releaseOrderCommonV2.setPsxEffectivePsxNumber(effectivePsxNumber);
        String effectivePsxStateName = StringUtils.isNotBlank((CharSequence)psxConstructionSiteStateName) ? psxConstructionSiteStateName : psxReleaseOrderStateName;
        releaseOrderCommonV2.setPsxEffectiveStateName(effectivePsxStateName);
        measurementCommon.setReleaseOrder(releaseOrderCommonV2);
        ProjectCommon projectCommon = new ProjectCommon();
        projectCommon.setId(measurement.getProjectId());
        projectCommon.setName(measurement.getProjectName());
        projectCommon.setReferenceId(measurement.getProjectReferenceId());
        measurementCommon.setProject(projectCommon);
        measurementCommon.setRemarks(measurement.getRemarks());
        measurementCommon.setRemarksInternal(measurement.getRemarksInternal());
        return measurementCommon;
    }

    @Nonnull
    private MeasurementCommon map(@NonNull Measurement measurement, boolean mapPositions, boolean mapTranspose, boolean mapStates, boolean allAttributesVisible, boolean valueOverallVisible) {
        ReleaseOrder releaseOrder;
        MeasurementCommon measurementCommon;
        block17: {
            block16: {
                Invoice invoice;
                Quotation stage;
                User assignedUser;
                if (measurement == null) {
                    throw new NullPointerException("measurement is marked non-null but is null");
                }
                measurementCommon = new MeasurementCommon();
                BaseMapper.map((EntityBase)measurement, (EntityBaseCommon)measurementCommon);
                measurementCommon.setId(measurement.getId());
                measurementCommon.setReferenceId(measurement.getReferenceId());
                String origin = ((EMeasurementOrigin)MoreObjects.firstNonNull((Object)measurement.getOrigin(), (Object)EMeasurementOrigin.UNKNOWN)).getValue();
                measurementCommon.setOrigin(origin);
                String lastOrigin = ((EMeasurementOrigin)MoreObjects.firstNonNull((Object)measurement.getLastOrigin(), (Object)EMeasurementOrigin.UNKNOWN)).getValue();
                measurementCommon.setLastOrigin(lastOrigin);
                measurementCommon.setMeasurementNumber(measurement.getMeasurementNumber());
                measurementCommon.setOriginalMeasurementNumber(measurement.getOriginalMeasurementNumber());
                measurementCommon.setSheetNumber(measurement.getSheetNumberValue());
                String measurementViewType = ((EMeasurementViewType)MoreObjects.firstNonNull((Object)measurement.getMeasurementViewType(), (Object)EMeasurementViewType.STANDARD)).getValue();
                measurementCommon.setMeasurementViewType(measurementViewType);
                String measurementType = ((EMeasurementType)MoreObjects.firstNonNull((Object)measurement.getMeasurementType(), (Object)EMeasurementType.NONE)).getValue();
                measurementCommon.setMeasurementType(measurementType);
                String costUnitCEViewMode = ((ECostUnitCEViewMode)MoreObjects.firstNonNull((Object)measurement.getCostUnitCEViewMode(), (Object)ECostUnitCEViewMode.COMMISSION__COST_UNIT_CE)).name();
                measurementCommon.setCostUnitCeViewMode(costUnitCEViewMode);
                MeasurementState measurementState = measurement.getMeasurementState();
                if (null != measurementState) {
                    String measurementStateString = MeasurementMapper.measurementStateToCommon((Measurement)measurement);
                    measurementCommon.setMeasurementState(measurementStateString);
                    measurementCommon.setMeasurementStateSince(measurementState.getMeasurementStateSince());
                }
                measurementCommon.setImportErrors(measurement.getImportErrors());
                measurementCommon.setImportFileName(measurement.getImportFileName());
                User createdByUser = measurement.getCreatedByUser();
                if (null != createdByUser) {
                    measurementCommon.setCreatedByUserId(createdByUser.getId());
                    measurementCommon.setCreatedByUserFullName(createdByUser.getFullName());
                }
                if (null != (assignedUser = measurement.getAssignedUser())) {
                    measurementCommon.setAssignedUserId(assignedUser.getId());
                    measurementCommon.setAssignedUserFullName(assignedUser.getFullName());
                    LocalDate projectExecutionStartDate = measurement.getProjectExecutionStartDate();
                    if (null != projectExecutionStartDate) {
                        String cc = EmployeeHelper.currentUserCostCenterNotFailing((User)assignedUser, (LocalDate)projectExecutionStartDate).map(UserCostCenter::getCostCenter).orElse("");
                        measurementCommon.setAssignedUserCostCenter(cc);
                    }
                }
                if (null != (stage = measurement.getQuotation())) {
                    measurementCommon.setQuotationId(stage.getId());
                    measurementCommon.setQuotationNumber(stage.getQuotationNumber());
                    measurementCommon.setStageId(stage.getId());
                    measurementCommon.setAlias(stage.getAlias());
                    measurementCommon.setQentityNumber(stage.getQNumber());
                    measurementCommon.setStageText(StageHelper.stageText((Quotation)stage));
                    measurementCommon.setStageVersion(stage.getVersion());
                    Project project = stage.getProject();
                    if (null != project) {
                        ProjectCommon projectCommon = this.projectMapper.map(project);
                        measurementCommon.setProject(projectCommon);
                    }
                }
                if (null != (invoice = measurement.getInvoice())) {
                    measurementCommon.setInvoiceId(invoice.getId());
                    measurementCommon.setInvoiceNumber(invoice.getInvoiceNumber());
                }
                measurementCommon.setConstructionSite(measurement.getConstructionSite());
                measurementCommon.setRemarks(measurement.getRemarks());
                measurementCommon.setRemarksInternal(measurement.getRemarksInternal());
                measurementCommon.setPersonResponsibleAtCustomer(measurement.getPersonResponsibleAtCustomer());
                measurementCommon.setCustomerArea(measurement.getCustomerArea());
                measurementCommon.setProjectExecutionStartDate(measurement.getProjectExecutionStartDate());
                measurementCommon.setProjectExecutionEndDate(measurement.getProjectExecutionEndDate());
                measurementCommon.setAccountingMonth(measurement.getAccountingMonth());
                measurementCommon.setAccountingMonthPlanned(measurement.getAccountingMonthPlanned());
                measurementCommon.setAddendumNumbers(measurement.getAddendumNumbers());
                if (allAttributesVisible) break block16;
                if (!valueOverallVisible) break block17;
            }
            BaseMapper.apply(() -> ((Measurement)measurement).getValueOverall(), arg_0 -> ((MeasurementCommon)measurementCommon).setValueOverall(arg_0), (Object)BigDecimal.ZERO);
        }
        if (allAttributesVisible) {
            BaseMapper.apply(() -> ((Measurement)measurement).getMaterialPurchasePriceOverall(), arg_0 -> ((MeasurementCommon)measurementCommon).setMaterialPurchasePriceOverall(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((Measurement)measurement).getMaterialSellingPriceOverall(), arg_0 -> ((MeasurementCommon)measurementCommon).setMaterialSellingPriceOverall(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((Measurement)measurement).getCompanyWageOverall(), arg_0 -> ((MeasurementCommon)measurementCommon).setCompanyWageOverall(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((Measurement)measurement).getExternalServicePurchasePriceOverall(), arg_0 -> ((MeasurementCommon)measurementCommon).setExternalServicePurchasePriceOverall(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((Measurement)measurement).getExternalServiceSellingPriceOverall(), arg_0 -> ((MeasurementCommon)measurementCommon).setExternalServiceSellingPriceOverall(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((Measurement)measurement).getWageOverall(), arg_0 -> ((MeasurementCommon)measurementCommon).setWageOverall(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((Measurement)measurement).getInternalWageOverall(), arg_0 -> ((MeasurementCommon)measurementCommon).setInternalWageOverall(arg_0), (Object)BigDecimal.ZERO);
            BigDecimal wagePercentage = MeasurementHelper.wagePercentage((Measurement)measurement);
            BaseMapper.apply(() -> wagePercentage, arg_0 -> ((MeasurementCommon)measurementCommon).setWagePercentage(arg_0), (Object)BigDecimal.ZERO);
            BigDecimal companyWagePlusMaterialPurchasePriceOverall = MeasurementHelper.notAccountedPurchasePrice((Measurement)measurement);
            BaseMapper.apply(() -> companyWagePlusMaterialPurchasePriceOverall, arg_0 -> ((MeasurementCommon)measurementCommon).setCompanyWagePlusMaterialPurchasePriceOverall(arg_0), (Object)BigDecimal.ZERO);
            BigDecimal companyWagePlusMaterialSellingPriceOverall = MeasurementHelper.notAccountedSellingPrice((Measurement)measurement);
            BaseMapper.apply(() -> companyWagePlusMaterialSellingPriceOverall, arg_0 -> ((MeasurementCommon)measurementCommon).setCompanyWagePlusMaterialSellingPriceOverall(arg_0), (Object)BigDecimal.ZERO);
        }
        BaseMapper.apply(() -> ((Measurement)measurement).getSquadWageOverall(), arg_0 -> ((MeasurementCommon)measurementCommon).setSquadWageOverall(arg_0), (Object)BigDecimal.ZERO);
        if (mapPositions) {
            List measurementPositions = (List)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableList.of());
            List measurementPositionCommons = this.measurementPositionMapper.map(measurementPositions);
            measurementCommon.setMeasurementPositions(measurementPositionCommons);
        }
        if (mapTranspose) {
            Iterable measurementTransposedRemarks = (Iterable)MoreObjects.firstNonNull((Object)measurement.getMeasurementTransposedRemarks(), (Object)ImmutableSet.of());
            List transposedRemarksCommon = (List)Streams.stream((Iterable)measurementTransposedRemarks).map((? super T item) -> this.mapToCommon(item)).collect(ImmutableList.toImmutableList());
            measurementCommon.setTransposedRemarks(transposedRemarksCommon);
        }
        if (mapStates) {
            Iterable measurementStates = (Iterable)MoreObjects.firstNonNull((Object)measurement.getMeasurementStates(), (Object)ImmutableList.of());
            List measurementStatesMapped = this.measurementStateMapper.map(measurementStates);
            measurementCommon.setMeasurementStates(measurementStatesMapped);
        }
        ReleaseOrderCommonV2 releaseOrderCommonV2 = null != (releaseOrder = measurement.getReleaseOrder()) ? this.releaseOrderMapper.mapV2(releaseOrder) : null;
        measurementCommon.setReleaseOrder(releaseOrderCommonV2);
        Measurement copiedFromMeasurement = measurement.getCopiedFromMeasurement();
        if (null != copiedFromMeasurement) {
            Long copiedFromMeasurementId = copiedFromMeasurement.getId();
            String copiedFromMeasurementNumber = copiedFromMeasurement.getMeasurementNumber();
            measurementCommon.setCopiedFromMeasurementId(copiedFromMeasurementId);
            measurementCommon.setCopiedFromMeasurementNumber(copiedFromMeasurementNumber);
        }
        return measurementCommon;
    }

    @Nonnull
    private MeasurementTransposedRemarkCommon mapToCommon(@NonNull MeasurementTransposedRemark item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return MeasurementTransposedRemarkCommon.of((String)item.getRemark(), (Integer)item.getRowIndex());
    }

    @Nonnull
    public MeasurementSearchResultItemCommon mapSearchItem(@NonNull Measurement measurement) {
        User user;
        Invoice invoice;
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        MeasurementSearchResultItemCommon common = new MeasurementSearchResultItemCommon();
        common.setMeasurementId(measurement.getId().longValue());
        common.setMeasurementNumber(measurement.getMeasurementNumber());
        common.setConstructionSite(measurement.getConstructionSite());
        common.setRemarks(measurement.getRemarks());
        Quotation quotation = measurement.getQuotation();
        if (null != quotation) {
            common.setQuotationId(quotation.getId());
            common.setQuotationNumber(quotation.getQuotationNumber());
        }
        if (null != (invoice = measurement.getInvoice())) {
            common.setInvoiceId(invoice.getId());
            common.setInvoiceNumber(invoice.getInvoiceNumber());
        }
        if (null != (user = measurement.getAssignedUser())) {
            common.setAssignedUserId(user.getId());
            common.setAssignedUserFullName(user.getFullName());
        }
        common.setProjectExecutionStartDate(measurement.getProjectExecutionStartDate());
        common.setProjectExecutionEndDate(measurement.getProjectExecutionEndDate());
        String stateName = MeasurementMapper.measurementStateToCommon((Measurement)measurement);
        common.setMeasurementState(stateName);
        return common;
    }

    @Nonnull
    public MeasurementSearchResultCommon mapSearchItem(@NonNull Page<Measurement> measurements) {
        if (measurements == null) {
            throw new NullPointerException("measurements is marked non-null but is null");
        }
        long totalElements = measurements.getTotalElements();
        int totalPages = measurements.getTotalPages();
        Pageable pageable = measurements.getPageable();
        int pageSize = pageable.getPageSize();
        int pageNumber = pageable.getPageNumber();
        List content = measurements.getContent();
        ImmutableList measurementCommons = ImmutableList.copyOf(content.stream().map(arg_0 -> this.mapSearchItem(arg_0)).iterator());
        return new MeasurementSearchResultCommon(pageNumber, pageSize, totalPages, totalElements, (List)measurementCommons);
    }

    @Nonnull
    public Measurement mergeMeasurement(@NonNull MeasurementUpdateBucket measurementUpdateBucket) {
        if (measurementUpdateBucket == null) {
            throw new NullPointerException("measurementUpdateBucket is marked non-null but is null");
        }
        MeasurementUpdateRequest updateRequest = (MeasurementUpdateRequest)measurementUpdateBucket.getRequest();
        Measurement measurement = (Measurement)measurementUpdateBucket.getEntity();
        User createdByUser = measurementUpdateBucket.getCreatedByUser();
        User assignedUser = measurementUpdateBucket.getAssignedUser();
        Quotation stage = measurementUpdateBucket.getQuotation();
        String referenceId = measurementUpdateBucket.getReferenceId();
        EMeasurementOrigin lastOrigin = measurementUpdateBucket.getLastOrigin();
        measurement.setReferenceId(referenceId);
        measurement.setLastOrigin(lastOrigin);
        measurement.setCreatedByUser(createdByUser);
        if (measurement.getAssignedUser() == null || this.userService.hasPrivilege(EPrivilege.OP_MEASUREMENT_ASSIGN_SQUAD)) {
            measurement.setAssignedUser(assignedUser);
        }
        measurement.setQuotation(stage);
        measurement.setMeasurementNumber(measurementUpdateBucket.getMeasurementNumber());
        measurement.setRemarks(StringUtils.trimToEmpty((String)updateRequest.getRemarks()));
        measurement.setRemarksInternal(StringUtils.trimToEmpty((String)updateRequest.getRemarksInternal()));
        measurement.setConstructionSite(StringUtils.trimToEmpty((String)updateRequest.getConstructionSite()));
        measurement.setCustomerArea(StringUtils.trimToEmpty((String)updateRequest.getCustomerArea()));
        measurement.setPersonResponsibleAtCustomer(StringUtils.trimToEmpty((String)updateRequest.getPersonResponsibleAtCustomer()));
        LocalDate accountingMonth = updateRequest.getAccountingMonth();
        measurement.setAccountingMonth(accountingMonth);
        if (this.userService.hasPrivilege(EPrivilege.MEASUREMENT__ACCOUNTING_MONTH_PLANNED__VISIBLE)) {
            LocalDate accountingMonthPlanned = updateRequest.getAccountingMonthPlanned();
            measurement.setAccountingMonthPlanned(accountingMonthPlanned);
        }
        LocalDate constructionPeriodStart = updateRequest.getProjectExecutionStartDate();
        measurement.setProjectExecutionStartDate(constructionPeriodStart);
        LocalDate constructionPeriodEnd = updateRequest.getProjectExecutionEndDate();
        measurement.setProjectExecutionEndDate(constructionPeriodEnd);
        String measurementViewTypeCandidate = StringUtils.trimToEmpty((String)updateRequest.getMeasurementViewType());
        measurement.setMeasurementViewType(EMeasurementViewType.lookup((String)measurementViewTypeCandidate, (EMeasurementViewType)EMeasurementViewType.STANDARD));
        String measurementTypeCandidate = StringUtils.trimToEmpty((String)updateRequest.getMeasurementType());
        measurement.setMeasurementType(EMeasurementType.lookup((String)measurementTypeCandidate, (EMeasurementType)EMeasurementType.NONE));
        String costUnitCEViewModeCandidate = StringUtils.trimToEmpty((String)updateRequest.getCostUnitCeViewMode());
        measurement.setCostUnitCEViewMode(ECostUnitCEViewMode.lookup((String)costUnitCEViewModeCandidate, (ECostUnitCEViewMode)ECostUnitCEViewMode.COMMISSION__COST_UNIT_CE));
        ReleaseOrderUpdateBucket releaseOrderUpdateBucket = measurementUpdateBucket.getReleaseOrderUpdateBucket();
        if (null != releaseOrderUpdateBucket) {
            ReleaseOrder releaseOrder = this.releaseOrderMapper.merge(releaseOrderUpdateBucket);
        }
        return measurement;
    }

    @Nonnull
    public List<MeasurementPosition> mergeMeasurementPositions(@NonNull MeasurementPositionsUpdateBucket measurementPositionsUpdateBucket) {
        if (measurementPositionsUpdateBucket == null) {
            throw new NullPointerException("measurementPositionsUpdateBucket is marked non-null but is null");
        }
        Measurement measurement = measurementPositionsUpdateBucket.getMeasurement();
        Iterable quotationPositions = measurementPositionsUpdateBucket.getQuotationPositions();
        Iterable measurementPositionsToPersist = measurementPositionsUpdateBucket.getMeasurementPositionUpdateBuckets();
        ImmutableList measurementPositionUpdateItemsWithId = ImmutableList.copyOf(Streams.stream((Iterable)measurementPositionsToPersist).filter(item -> item.getId() != null).iterator());
        ImmutableList measurementPositionUpdateItemsWithoutId = ImmutableList.copyOf(Streams.stream((Iterable)measurementPositionsToPersist).filter(item -> item.getId() == null).iterator());
        List measurementPositionsExisting = (List)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableList.of());
        ImmutableMap updateItemsById = Maps.uniqueIndex((Iterable)measurementPositionUpdateItemsWithId, MeasurementPositionUpdateBucket::getId);
        ImmutableMap measurementPositionsExistingById = Maps.uniqueIndex((Iterable)measurementPositionsExisting, MeasurementPosition::getId);
        Iterable quotationPositionsWithId = Streams.stream((Iterable)quotationPositions).filter(item -> null != item.getId()).collect(Collectors.toList());
        Iterable quotationPositionsWithSurrogate = Streams.stream((Iterable)quotationPositions).filter(item -> null != item.getSurrogatePositionNumber()).collect(Collectors.toList());
        Map quotationPositionById = MapsHelper.mapFirst((Iterable)quotationPositionsWithId, QuotationPosition::getId);
        Map quotationPositionBySurrogatePositionNumber = MapsHelper.mapFirst((Iterable)quotationPositionsWithSurrogate, QuotationPosition::getSurrogatePositionNumber);
        if (!Iterables.isEmpty((Iterable)measurementPositionsToPersist) || !measurementPositionsExisting.isEmpty()) {
            Set idsExisting = measurementPositionsExistingById.keySet();
            Set idsToUpdate = updateItemsById.keySet();
            Sets.SetView toAdd = Sets.difference(idsToUpdate, idsExisting);
            Sets.SetView toUpdate = Sets.intersection(idsToUpdate, idsExisting);
            Sets.SetView toRemove = Sets.difference(idsExisting, idsToUpdate);
            String measurementNumber = measurement.getMeasurementNumber();
            log.debug("Add: {} Positions (1) to Measurement: {}", (Object)toAdd.size(), (Object)measurementNumber);
            log.debug("Add: {} Positions (2) to Measurement: {}", (Object)measurementPositionUpdateItemsWithoutId.size(), (Object)measurementNumber);
            log.debug("Update: {} Positions to Measurement: {}", (Object)toUpdate.size(), (Object)measurementNumber);
            log.debug("Remove: {} Positions to Measurement: {}", (Object)toRemove.size(), (Object)measurementNumber);
            ImmutableList.Builder measurementPositionsAddedBuilder = ImmutableList.builder();
            for (MeasurementPositionUpdateBucket itemToAdd : measurementPositionUpdateItemsWithoutId) {
                Optional quotationPositionCandidate = this.quotationPosition(quotationPositionById, quotationPositionBySurrogatePositionNumber, itemToAdd);
                if (quotationPositionCandidate.isEmpty()) {
                    throw new IllegalArgumentException(String.format("Passed Quotation Position Id: %s Nor Surrogate Position Number: %s cannot be found in Quotation", itemToAdd.getQuotationPositionId(), itemToAdd.getSurrogatePositionNumber()));
                }
                QuotationPosition quotationPosition = (QuotationPosition)quotationPositionCandidate.get();
                Optional jumboPositionCandidate = StageHelper.determineJumboPosition((QuotationPosition)quotationPosition);
                MeasurementPosition measurementPosition2 = itemToAdd.getMeasurementPosition();
                this.measurementPositionMapper.mergeMeasurementPositionUpdateItem(itemToAdd);
                this.measurementPositionMapper.mergeQuotationPositionIntoMeasurementPosition(measurementPosition2, quotationPosition, (QuotationPosition)jumboPositionCandidate.orElse(null));
                measurementPositionsAddedBuilder.add((Object)measurementPosition2);
            }
            ImmutableList measurementPositionsAdded = measurementPositionsAddedBuilder.build();
            ImmutableList.Builder measurementPositionsUpdatedBuilder = ImmutableList.builder();
            for (Long idToUpdate : toUpdate) {
                MeasurementPosition measurementPositionExisting = (MeasurementPosition)measurementPositionsExistingById.get(idToUpdate);
                MeasurementPositionUpdateBucket measurementPositionUpdateBucket = (MeasurementPositionUpdateBucket)updateItemsById.get(idToUpdate);
                this.measurementPositionMapper.mergeMeasurementPositionUpdateItem(measurementPositionUpdateBucket);
                measurementPositionsUpdatedBuilder.add((Object)measurementPositionExisting);
            }
            ImmutableList measurementPositionsUpdated = measurementPositionsUpdatedBuilder.build();
            String currentUsername = this.authenticationHelper.currentUserName();
            ImmutableList.Builder measurementPositionsDeletedBuilder = ImmutableList.builder();
            for (Long idToRemove : toRemove) {
                MeasurementPosition measurementPosition3 = (MeasurementPosition)measurementPositionsExistingById.get(idToRemove);
                measurementPosition3.setDeletedOn(DateTimeHelper.now());
                measurementPosition3.setDeletedBy(currentUsername);
                measurementPosition3.setEntityState(EntityState.DELETED);
                measurementPositionsDeletedBuilder.add((Object)measurementPosition3);
            }
            ImmutableList measurementPositionsDeleted = measurementPositionsDeletedBuilder.build();
            if (null == measurement.getMeasurementPositions()) {
                measurement.setMeasurementPositions((List)Lists.newArrayList());
            }
            measurementPositionsAdded.forEach(measurementPosition -> {
                measurementPosition.setMeasurement(measurement);
                measurement.getMeasurementPositions().add(measurementPosition);
            });
            measurementPositionsDeleted.forEach(measurementPosition -> {
                measurementPosition.setMeasurement(null);
                measurement.getMeasurementPositions().remove(measurementPosition);
            });
        }
        return measurement.getMeasurementPositions();
    }

    @Nonnull
    private Optional<QuotationPosition> quotationPosition(@NonNull Map<Long, QuotationPosition> quotationPositionById, @NonNull Map<String, QuotationPosition> quotationPositionBySurrogatePositionNumber, @NonNull MeasurementPositionUpdateBucket measurementPositionUpdateItem) {
        if (quotationPositionById == null) {
            throw new NullPointerException("quotationPositionById is marked non-null but is null");
        }
        if (quotationPositionBySurrogatePositionNumber == null) {
            throw new NullPointerException("quotationPositionBySurrogatePositionNumber is marked non-null but is null");
        }
        if (measurementPositionUpdateItem == null) {
            throw new NullPointerException("measurementPositionUpdateItem is marked non-null but is null");
        }
        Long quotationPositionId = measurementPositionUpdateItem.getQuotationPositionId();
        String surrogatePositionNumber = measurementPositionUpdateItem.getSurrogatePositionNumber();
        if (null != quotationPositionId && quotationPositionById.containsKey(quotationPositionId)) {
            return Optional.of(quotationPositionById.get(quotationPositionId));
        }
        if (null != surrogatePositionNumber && quotationPositionBySurrogatePositionNumber.containsKey(surrogatePositionNumber)) {
            return Optional.of(quotationPositionBySurrogatePositionNumber.get(surrogatePositionNumber));
        }
        return Optional.empty();
    }

    @Nonnull
    public Measurement mergeMeasurement(@NonNull Measurement original, @NonNull Measurement destination, @NonNull Quotation stage, @NonNull String measurementNumber, @NonNull Function<MeasurementPosition, Optional<MeasurementPosition>> fnPositions, @NonNull Function<ReleaseOrder, ReleaseOrder> fnReleaseOrder, boolean includeReleaseOrder, boolean includePositions) {
        if (original == null) {
            throw new NullPointerException("original is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (measurementNumber == null) {
            throw new NullPointerException("measurementNumber is marked non-null but is null");
        }
        if (fnPositions == null) {
            throw new NullPointerException("fnPositions is marked non-null but is null");
        }
        if (fnReleaseOrder == null) {
            throw new NullPointerException("fnReleaseOrder is marked non-null but is null");
        }
        destination.setCopiedFromMeasurement(original);
        destination.setMeasurementNumber(measurementNumber);
        destination.setReferenceId(measurementNumber);
        destination.setAssignedUser(original.getAssignedUser());
        destination.setQuotation(stage);
        destination.setMeasurementType(original.getMeasurementType());
        destination.setMeasurementViewType(original.getMeasurementViewType());
        destination.setCostUnitCEViewMode(original.getCostUnitCEViewMode());
        destination.setRemarks(StringUtils.trimToEmpty((String)original.getRemarks()));
        destination.setRemarksInternal(StringUtils.trimToEmpty((String)original.getRemarksInternal()));
        destination.setConstructionSite(StringUtils.trimToEmpty((String)original.getConstructionSite()));
        destination.setPersonResponsibleAtCustomer(StringUtils.trimToEmpty((String)original.getPersonResponsibleAtCustomer()));
        destination.setCustomerArea(StringUtils.trimToEmpty((String)original.getCustomerArea()));
        destination.setProjectExecutionStartDate(original.getProjectExecutionStartDate());
        destination.setProjectExecutionEndDate(original.getProjectExecutionEndDate());
        destination.setAccountingMonth(original.getAccountingMonth());
        destination.setAccountingMonthPlanned(original.getAccountingMonthPlanned());
        destination.setCatchAll(original.getCatchAll());
        destination.setInvoice(null);
        destination.setSheetNumberValue(Long.valueOf(0L));
        if (includeReleaseOrder) {
            ReleaseOrder releaseOrder = fnReleaseOrder.apply(original.getReleaseOrder());
            destination.setReleaseOrder(releaseOrder);
        } else {
            destination.setReleaseOrder(null);
        }
        if (includePositions) {
            List<MeasurementPosition> measurementPositions = original.getMeasurementPositions().stream().map(fnPositions).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            measurementPositions.forEach(item -> item.setMeasurement(destination));
            destination.setMeasurementPositions(measurementPositions);
            destination.setWageOverall(original.getWageOverall());
            destination.setSquadWageOverall(original.getSquadWageOverall());
            destination.setValueOverall(original.getValueOverall());
            destination.setCompanyWageOverall(original.getCompanyWageOverall());
            destination.setMaterialPurchasePriceOverall(original.getMaterialPurchasePriceOverall());
        } else {
            destination.setMeasurementPositions((List)Lists.newArrayList());
            destination.setWageOverall(BigDecimal.ZERO);
            destination.setSquadWageOverall(BigDecimal.ZERO);
            destination.setValueOverall(BigDecimal.ZERO);
            destination.setCompanyWageOverall(BigDecimal.ZERO);
            destination.setMaterialPurchasePriceOverall(BigDecimal.ZERO);
        }
        Function<MeasurementTransposedRemark, MeasurementTransposedRemark> transposedRemarkCopy = source -> {
            MeasurementTransposedRemark target = this.entityFactory.measurementTransposedRemark();
            return this.mergeTransposedRemark(source, target);
        };
        Set<MeasurementTransposedRemark> measurementTransposedRemarks = original.getMeasurementTransposedRemarks().stream().map(transposedRemarkCopy).collect(Collectors.toSet());
        measurementTransposedRemarks.forEach(item -> item.setMeasurement(destination));
        destination.setMeasurementTransposedRemarks(measurementTransposedRemarks);
        return destination;
    }

    @Nonnull
    public MeasurementNumberExistsResponse mapExists(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        Long id = measurement.getId();
        String measurementNumber = measurement.getMeasurementNumber();
        String measurementState = MeasurementMapper.measurementStateToCommon((Measurement)measurement);
        return MeasurementNumberExistsResponse.of((Long)id, (String)measurementNumber, (String)measurementState);
    }

    @Nonnull
    public static String measurementStateToCommon(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        return ((EMeasurementState)MoreObjects.firstNonNull((Object)measurement.getMeasurementState().getMeasurementState(), (Object)EMeasurementState.UNKNOWN)).name();
    }

    @Nonnull
    public MeasurementImportResultListCommon map(@NonNull Iterable<MeasurementXlsImportResult> measurementXLSImportResults) {
        if (measurementXLSImportResults == null) {
            throw new NullPointerException("measurementXLSImportResults is marked non-null but is null");
        }
        int size = Iterables.size(measurementXLSImportResults);
        ImmutableList commons = (ImmutableList)Streams.stream(measurementXLSImportResults).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
        return new MeasurementImportResultListCommon(size, (List)commons);
    }

    @Nonnull
    public MeasurementImportResultCommon map(@NonNull MeasurementXlsImportResult measurementXlsImportResult) {
        if (measurementXlsImportResult == null) {
            throw new NullPointerException("measurementXlsImportResult is marked non-null but is null");
        }
        Measurement measurement = measurementXlsImportResult.getMeasurement();
        Long measurementId = null != measurement ? measurement.getId() : null;
        String multipartFileName = measurementXlsImportResult.getMultipartFileName();
        ImmutableList errors = ImmutableList.copyOf((Iterable)measurementXlsImportResult.getErrors());
        return MeasurementImportResultCommon.of((String)multipartFileName, (Long)measurementId, (List)errors);
    }

    @Nonnull
    public MeasurementAvailableStatesCommon mapAvailableStates(@NonNull Measurement measurement, @NonNull AvailableMeasurementStates availableMeasurementStates) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (availableMeasurementStates == null) {
            throw new NullPointerException("availableMeasurementStates is marked non-null but is null");
        }
        Long measurementId = measurement.getId();
        Optional previousState = availableMeasurementStates.getPreviousState();
        Optional nextState = availableMeasurementStates.getNextState();
        Iterable allAvailableStates = availableMeasurementStates.getAllAvailableStates();
        ImmutableList sortedStates = ImmutableList.sortedCopyOf(Comparator.comparingInt(EMeasurementState::getSort), (Iterable)allAvailableStates);
        ImmutableList availableMeasurementStatesStrings = ((ImmutableSet)Streams.stream((Iterable)sortedStates).map(Enum::name).collect(ImmutableSet.toImmutableSet())).asList();
        MeasurementAvailableStatesCommon measurementAvailableStatesCommon = new MeasurementAvailableStatesCommon();
        measurementAvailableStatesCommon.setMeasurementId(measurementId);
        measurementAvailableStatesCommon.setAvailableMeasurementStates((List)availableMeasurementStatesStrings);
        String nextStateString = nextState.map(Enum::name).orElse(null);
        measurementAvailableStatesCommon.setNextState(nextStateString);
        String previousStateString = previousState.map(Enum::name).orElse(null);
        measurementAvailableStatesCommon.setPreviousState(previousStateString);
        return measurementAvailableStatesCommon;
    }

    @Nonnull
    public MeasurementValidationResponse mapToInvoiceMeasurementValidation(@NonNull List<Triple<MeasurementPosition, String, Iterable<EMeasurementValidationFlag>>> validationItems) {
        if (validationItems == null) {
            throw new NullPointerException("validationItems is marked non-null but is null");
        }
        List warnings = (List)validationItems.stream().map(arg_0 -> this.mapToInvoiceMeasurementValidation(arg_0)).collect(ImmutableList.toImmutableList());
        MeasurementValidationResponse response = new MeasurementValidationResponse();
        response.setSuccess(warnings.isEmpty());
        response.setValidationItems(warnings);
        ImmutableList positionIdsNotCommissioned = MeasurementMapper.positionIdsWithFlag(validationItems, (EMeasurementValidationFlag)EMeasurementValidationFlag.NOT_COMMISSIONED);
        ImmutableList positionIdsNotExisting = MeasurementMapper.positionIdsWithFlag(validationItems, (EMeasurementValidationFlag)EMeasurementValidationFlag.NOT_EXISTING_IN_QUOTATION);
        response.setPositionIdsNotCommissioned((List)positionIdsNotCommissioned);
        response.setPositionIdsNotExistingInQuotation((List)positionIdsNotExisting);
        return response;
    }

    @Nonnull
    private static ImmutableList<Long> positionIdsWithFlag(@NonNull List<Triple<MeasurementPosition, String, Iterable<EMeasurementValidationFlag>>> validationItems, @NonNull EMeasurementValidationFlag validationFlag) {
        if (validationItems == null) {
            throw new NullPointerException("validationItems is marked non-null but is null");
        }
        if (validationFlag == null) {
            throw new NullPointerException("validationFlag is marked non-null but is null");
        }
        return ((ImmutableSet)validationItems.stream().filter(item -> Iterables.contains((Iterable)((Iterable)item.getRight()), (Object)validationFlag)).map((? super T item) -> ((MeasurementPosition)item.getLeft()).getId()).collect(ImmutableSet.toImmutableSet())).asList();
    }

    @Nonnull
    public MeasurementValidationItem mapToInvoiceMeasurementValidation(@NonNull Triple<MeasurementPosition, String, Iterable<EMeasurementValidationFlag>> validationItems) {
        if (validationItems == null) {
            throw new NullPointerException("validationItems is marked non-null but is null");
        }
        MeasurementValidationItem measurementValidationItem = new MeasurementValidationItem();
        MeasurementPosition measurementPosition = (MeasurementPosition)validationItems.getLeft();
        Measurement measurement = measurementPosition.getMeasurement();
        String message = (String)validationItems.getMiddle();
        Iterable validationFlags = (Iterable)validationItems.getRight();
        ImmutableList flagsAsString = ((ImmutableSet)Streams.stream((Iterable)validationFlags).map(Enum::name).collect(ImmutableSet.toImmutableSet())).asList();
        measurementValidationItem.setMeasurementId(measurement.getId());
        measurementValidationItem.setMeasurementNumber(measurement.getMeasurementNumber());
        measurementValidationItem.setMeasurementPositionId(measurementPosition.getId());
        measurementValidationItem.setSurrogatePositionNumber(measurementPosition.getSurrogatePositionNumber());
        measurementValidationItem.setMessage(message);
        measurementValidationItem.setFlags((List)flagsAsString);
        return measurementValidationItem;
    }

    @Nonnull
    public MergedBucket<MeasurementTransposedRemark> mergeMeasurementTransposedRemarks(@NonNull MeasurementTransposedRemarksUpdateBucket measurementTransposedRemarksUpdateBucket) {
        if (measurementTransposedRemarksUpdateBucket == null) {
            throw new NullPointerException("measurementTransposedRemarksUpdateBucket is marked non-null but is null");
        }
        Measurement measurement = measurementTransposedRemarksUpdateBucket.getMeasurement();
        Iterable updateBuckets = measurementTransposedRemarksUpdateBucket.getMeasurementTransposedRemarkUpdateBuckets();
        MergedBucket mergeBucket = BaseMapper.merge((EntityBase)measurement, Measurement::getMeasurementTransposedRemarks, arg_0 -> ((Measurement)measurement).setMeasurementTransposedRemarks(arg_0), (Iterable)updateBuckets, MeasurementTransposedRemarkUpdateBucket::getId, MeasurementTransposedRemark::getId, () -> ((EntityFactory)this.entityFactory).measurementTransposedRemark(), (arg_0, arg_1) -> this.mergeTransposedRemark(arg_0, arg_1), MeasurementTransposedRemark::setMeasurement, () -> ((AuthenticationHelper)this.authenticationHelper).currentUserName(), (BiConsumer)NO_CALLBACK_IPM);
        MergedBucket.printMergeBucket((Object)measurement, MeasurementTransposedRemark.class, (MergedBucket)mergeBucket);
        return mergeBucket;
    }

    @Nonnull
    public MeasurementTransposedRemark mergeTransposedRemark(@NonNull MeasurementTransposedRemark entity, @NonNull MeasurementTransposedRemarkUpdateBucket updateBucket) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        Integer rowIndex = updateBucket.getRowIndex();
        String remark = updateBucket.getRemark();
        entity.setRemark(remark);
        entity.setRowIndex(rowIndex);
        return entity;
    }

    @Nonnull
    public MeasurementTransposedRemark mergeTransposedRemark(@NonNull MeasurementTransposedRemark source, @NonNull MeasurementTransposedRemark target) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        Integer rowIndex = source.getRowIndex();
        String remark = source.getRemark();
        target.setRemark(remark);
        target.setRowIndex(rowIndex);
        return target;
    }

    @Nonnull
    public PageCommon<MeasurementSearchItem> mapToSearchItem(Page<MeasurementSearchItemBucket> measurementSearchItemBuckets) {
        return BaseMapper.map(measurementSearchItemBuckets, arg_0 -> this.mapToSearchItem(arg_0), (pageNumber, pageSize, totalElements, totalPages, items) -> new PageCommon(pageNumber, pageSize, totalPages, totalElements, items));
    }

    @Nonnull
    public MeasurementSearchItem mapToSearchItem(@NonNull MeasurementSearchItemBucket bucket) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        MeasurementIndexEntry measurement = bucket.getMeasurement();
        String details = bucket.getDetails();
        Highlight rootHighlight = bucket.getRootHighlight();
        Highlight detailHighlight = bucket.getDetailHighlight();
        String companyName = this.companyConfig.getCompanyName();
        String stageOrEntityNumberPrefix = this.configService.getStageOrEntityNumberPrefix();
        IndexField field = detailHighlight.getField();
        String fieldName = this.messageService.get(field, new Object[]{companyName, stageOrEntityNumberPrefix});
        Iterable rootHighlightCommon = this.highlightMapper.map(rootHighlight);
        Iterable detailHighlightCommon = this.highlightMapper.map(detailHighlight);
        return MeasurementSearchItem.of((long)measurement.getId(), (String)measurement.getMeasurementNumber(), (Iterable)rootHighlightCommon, (String)details, (String)field.fieldName(), (String)fieldName, (Iterable)detailHighlightCommon);
    }

    @Nonnull
    public Iterable<de.qfm.erp.service.model.internal.transposition.MeasurementTransposedRemark> mapToInternal(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        Iterable entities = (Iterable)MoreObjects.firstNonNull((Object)measurement.getMeasurementTransposedRemarks(), (Object)ImmutableSet.of());
        if (!Iterables.isEmpty((Iterable)entities)) {
            return (Iterable)Streams.stream((Iterable)entities).map((? super T item) -> de.qfm.erp.service.model.internal.transposition.MeasurementTransposedRemark.of((String)item.getRemark(), (Integer)item.getRowIndex())).sorted(Comparator.comparingInt(de.qfm.erp.service.model.internal.transposition.MeasurementTransposedRemark::getRowIndex)).collect(ImmutableList.toImmutableList());
        }
        List measurementPositions = measurement.getMeasurementPositions();
        ImmutableList collect = (ImmutableList)measurementPositions.stream().peek(item -> {
            if (null == item.getSequenceNumberMeasurementTransposed()) {
                item.setSequenceNumberMeasurementTransposed(Integer.valueOf(0));
            }
        }).sorted(Comparator.comparing(MeasurementPosition::getSequenceNumberMeasurementTransposed)).collect(ImmutableList.toImmutableList());
        AtomicInteger atomicInteger = new AtomicInteger(1);
        LinkedHashMap firstOccurrence = Maps.newLinkedHashMap();
        for (MeasurementPosition measurementPosition : collect) {
            String remarks = measurementPosition.getRemarks();
            if (firstOccurrence.containsKey(remarks)) continue;
            firstOccurrence.put(remarks, atomicInteger.getAndIncrement());
        }
        return (Iterable)Streams.stream(firstOccurrence.keySet()).map((? super T remark) -> {
            Integer index = (Integer)firstOccurrence.get(remark);
            return de.qfm.erp.service.model.internal.transposition.MeasurementTransposedRemark.of((String)remark, (Integer)index);
        }).collect(ImmutableList.toImmutableList());
    }

    public MeasurementMapper(EntityFactory entityFactory, ConfigService configService, MessageService messageService, MeasurementPositionMapper measurementPositionMapper, MeasurementStateMapper measurementStateMapper, ProjectMapper projectMapper, ReleaseOrderMapper releaseOrderMapper, HighlightMapper highlightMapper, AuthenticationHelper authenticationHelper, UserService userService, CompanyConfig companyConfig) {
        this.entityFactory = entityFactory;
        this.configService = configService;
        this.messageService = messageService;
        this.measurementPositionMapper = measurementPositionMapper;
        this.measurementStateMapper = measurementStateMapper;
        this.projectMapper = projectMapper;
        this.releaseOrderMapper = releaseOrderMapper;
        this.highlightMapper = highlightMapper;
        this.authenticationHelper = authenticationHelper;
        this.userService = userService;
        this.companyConfig = companyConfig;
    }
}

