/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.common.response.user.JWTTokenResponse;
import de.qfm.erp.service.model.internal.authentication.JwtToken;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class JwtTokenMapper {
    @Nonnull
    public JWTTokenResponse map(@NonNull JwtToken jwtToken) {
        JwtToken.JwtTokenPart refreshToken;
        if (jwtToken == null) {
            throw new NullPointerException("jwtToken is marked non-null but is null");
        }
        JWTTokenResponse jwtTokenResponse = new JWTTokenResponse();
        JwtToken.JwtTokenPart accessToken = jwtToken.getAccessToken();
        if (null != accessToken) {
            jwtTokenResponse.setAccessTokenCreatedOn(DateTimeHelper.truncate((LocalDateTime)accessToken.getCreatedOn()));
            jwtTokenResponse.setAccessTokenValidUntil(DateTimeHelper.truncate((LocalDateTime)accessToken.getValidUntil()));
            jwtTokenResponse.setAccessToken(accessToken.getToken());
        }
        if (null != (refreshToken = jwtToken.getRefreshToken())) {
            jwtTokenResponse.setRefreshTokenCreatedOn(DateTimeHelper.truncate((LocalDateTime)refreshToken.getCreatedOn()));
            jwtTokenResponse.setRefreshTokenValidUntil(DateTimeHelper.truncate((LocalDateTime)refreshToken.getValidUntil()));
            jwtTokenResponse.setRefreshToken(refreshToken.getToken());
        }
        return jwtTokenResponse;
    }
}

