/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.helper.GaebHelper;
import de.qfm.erp.service.model.external.gaeb.generic.ComplBody;
import de.qfm.erp.service.model.external.gaeb.generic.ComplCaption;
import de.qfm.erp.service.model.external.gaeb.generic.ComplTail;
import de.qfm.erp.service.model.external.gaeb.generic.Paragraph;
import de.qfm.erp.service.model.external.gaeb.generic.Span;
import de.qfm.erp.service.model.external.gaeb.generic.Text;
import de.qfm.erp.service.model.external.gaeb.generic.TextComplement;
import de.qfm.erp.service.model.external.gaeb.x84.AddText;
import de.qfm.erp.service.model.external.gaeb.x84.Award;
import de.qfm.erp.service.model.external.gaeb.x84.BoQBody;
import de.qfm.erp.service.model.external.gaeb.x84.BoQCtgy;
import de.qfm.erp.service.model.external.gaeb.x84.CompleteText;
import de.qfm.erp.service.model.external.gaeb.x84.Description;
import de.qfm.erp.service.model.external.gaeb.x84.DetailAddText;
import de.qfm.erp.service.model.external.gaeb.x84.DetailTxt;
import de.qfm.erp.service.model.external.gaeb.x84.Item;
import de.qfm.erp.service.model.external.gaeb.x84.LblTx;
import de.qfm.erp.service.model.external.gaeb.x84.OutlTxt;
import de.qfm.erp.service.model.external.gaeb.x84.OutlineAddText;
import de.qfm.erp.service.model.external.gaeb.x84.OutlineText;
import de.qfm.erp.service.model.external.gaeb.x84.TextOutlTxt;
import de.qfm.erp.service.model.external.gaeb.x84.WrappedItem;
import de.qfm.erp.service.model.internal.gaeb.GaebPosition;
import de.qfm.erp.service.model.jpa.shared.EAlternativePositionType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class GaebX84Mapper {
    public static final Joiner JOINER = Joiner.on((String)"n");

    @Nonnull
    public List<GaebPosition> positions(@NonNull BoQBody boQBody, @NonNull List<Pair<String, String>> categoriesIndexes) {
        if (boQBody == null) {
            throw new NullPointerException("boQBody is marked non-null but is null");
        }
        if (categoriesIndexes == null) {
            throw new NullPointerException("categoriesIndexes is marked non-null but is null");
        }
        ImmutableList.Builder gaebPositionsBuilder = ImmutableList.builder();
        List categories = (List)MoreObjects.firstNonNull((Object)boQBody.getCategories(), (Object)ImmutableList.of());
        List itemlist = (List)MoreObjects.firstNonNull((Object)boQBody.getItemlist(), (Object)ImmutableList.of());
        for (WrappedItem wrappedItem : itemlist) {
            if (!(wrappedItem instanceof Item)) continue;
            Item item = (Item)wrappedItem;
            String id = item.getId();
            String rnoPart = item.getRNoPart();
            BigDecimal amount = item.getAmount();
            String provisionalStr = item.getProvisional();
            String unit = item.getUnit();
            List descriptions = (List)MoreObjects.firstNonNull((Object)item.getDescriptions(), (Object)ImmutableList.of());
            BigDecimal pricePerUnit = item.getPricePerUnit();
            BigDecimal priceOverall = item.getPriceOverall();
            String shortText = GaebX84Mapper.shortText((List)descriptions);
            EAlternativePositionType alternativePositionType = GaebHelper.alternatePositionType((String)provisionalStr);
            Triple bidderText = GaebX84Mapper.bidderText((List)descriptions);
            boolean hasBidderComplement = (Boolean)bidderText.getLeft();
            String longText = (String)bidderText.getMiddle();
            String bidderComplement = (String)bidderText.getRight();
            GaebPosition gaebPosition = new GaebPosition();
            int i = 0;
            for (Pair<String, String> categoriesIndex : categoriesIndexes) {
                if (1 == ++i) {
                    gaebPosition.setL1(categoriesIndex);
                    continue;
                }
                if (2 == i) {
                    gaebPosition.setL2(categoriesIndex);
                    continue;
                }
                if (3 == i) {
                    gaebPosition.setL3(categoriesIndex);
                    continue;
                }
                if (4 == i) {
                    gaebPosition.setL4(categoriesIndex);
                    continue;
                }
                if (5 != i) continue;
                gaebPosition.setL5(categoriesIndex);
            }
            gaebPosition.setStructureLvl(false);
            gaebPosition.setId(id);
            gaebPosition.setRno(rnoPart);
            gaebPosition.setAlternativePositionType(alternativePositionType);
            gaebPosition.setAmount(amount);
            gaebPosition.setPricePerUnit(pricePerUnit);
            gaebPosition.setPriceOverall(priceOverall);
            gaebPosition.setUnit(unit);
            gaebPosition.setShortText(shortText);
            gaebPosition.setLongText(longText);
            gaebPosition.setHasBidderComplement(hasBidderComplement);
            gaebPosition.setBidderComplement(bidderComplement);
            gaebPositionsBuilder.add((Object)gaebPosition);
        }
        for (BoQCtgy category : categories) {
            String categoryIndex = category.getRowNumberPart();
            String categoryLabel = GaebX84Mapper.plainText((LblTx)category.getLblTx());
            ImmutableList localCategoriesIndexes = ImmutableList.builder().addAll(categoriesIndexes).add((Object)Pair.of((Object)categoryLabel, (Object)categoryIndex)).build();
            GaebPosition gaebPosition = new GaebPosition();
            int i = 0;
            for (Pair localCategoriesIndex : localCategoriesIndexes) {
                if (1 == ++i) {
                    gaebPosition.setL1(localCategoriesIndex);
                    continue;
                }
                if (2 == i) {
                    gaebPosition.setL2(localCategoriesIndex);
                    continue;
                }
                if (3 == i) {
                    gaebPosition.setL3(localCategoriesIndex);
                    continue;
                }
                if (4 == i) {
                    gaebPosition.setL4(localCategoriesIndex);
                    continue;
                }
                if (5 != i) continue;
                gaebPosition.setL5(localCategoriesIndex);
            }
            gaebPosition.setStructureLvl(true);
            gaebPosition.setStructureLvl(true);
            gaebPosition.setShortText(categoryLabel);
            gaebPosition.setLongText("");
            gaebPositionsBuilder.add((Object)gaebPosition);
            List bodies = (List)MoreObjects.firstNonNull((Object)category.getBodies(), (Object)ImmutableList.of());
            for (BoQBody body : bodies) {
                List childPositions = this.positions(body, (List)localCategoriesIndexes);
                gaebPositionsBuilder.addAll((Iterable)childPositions);
            }
        }
        return gaebPositionsBuilder.build();
    }

    @Nonnull
    private static Triple<Boolean, String, String> bidderText(@NonNull List<Description> descriptions) {
        if (descriptions == null) {
            throw new NullPointerException("descriptions is marked non-null but is null");
        }
        boolean hasBidderComplement = false;
        ArrayList bidderComplement = Lists.newArrayList();
        ArrayList plainTexts = Lists.newArrayList();
        for (Description description : descriptions) {
            List completeTexts = (List)MoreObjects.firstNonNull((Object)description.getCompleteTexts(), (Object)ImmutableList.of());
            for (CompleteText completeText : completeTexts) {
                String complTSB = (String)MoreObjects.firstNonNull((Object)completeText.getComplTSB(), (Object)"");
                hasBidderComplement |= StringUtils.equalsIgnoreCase((CharSequence)StringUtils.trimToEmpty((String)complTSB), (CharSequence)"yes");
                List detailTxts = (List)MoreObjects.firstNonNull((Object)completeText.getDetailTxts(), (Object)ImmutableList.of());
                for (DetailTxt detailTxt : detailTxts) {
                    List textComplements = (List)MoreObjects.firstNonNull((Object)detailTxt.getTextComplements(), (Object)ImmutableList.of());
                    for (TextComplement textComplement : textComplements) {
                        ImmutableList spanStrings;
                        List spans;
                        List complBodies = (List)MoreObjects.firstNonNull((Object)textComplement.getBodies(), (Object)ImmutableList.of());
                        List complCaptions = (List)MoreObjects.firstNonNull((Object)textComplement.getCaptions(), (Object)ImmutableList.of());
                        List complTails = (List)MoreObjects.firstNonNull((Object)textComplement.getTails(), (Object)ImmutableList.of());
                        for (ComplBody complBody : complBodies) {
                            spans = (List)MoreObjects.firstNonNull((Object)complBody.getSpans(), (Object)ImmutableList.of());
                            spanStrings = (ImmutableList)spans.stream().map(Span::getContent).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
                            plainTexts.addAll(spanStrings);
                            bidderComplement.addAll(spanStrings);
                        }
                        for (ComplCaption complCaption : complCaptions) {
                            spans = (List)MoreObjects.firstNonNull((Object)complCaption.getSpans(), (Object)ImmutableList.of());
                            spanStrings = (ImmutableList)spans.stream().map(Span::getContent).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
                            plainTexts.addAll(spanStrings);
                            bidderComplement.addAll(spanStrings);
                        }
                        for (ComplTail complTail : complTails) {
                            spans = (List)MoreObjects.firstNonNull((Object)complTail.getSpans(), (Object)ImmutableList.of());
                            spanStrings = (ImmutableList)spans.stream().map(Span::getContent).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
                            plainTexts.addAll(spanStrings);
                            bidderComplement.addAll(spanStrings);
                        }
                    }
                    List texts = (List)MoreObjects.firstNonNull((Object)detailTxt.getTxts(), (Object)ImmutableList.of());
                    for (Text text : texts) {
                        List parts = text.getObjects();
                        for (Object o : parts) {
                            ImmutableList spanStrings;
                            List spans;
                            if (o instanceof Paragraph) {
                                Paragraph p = (Paragraph)o;
                                List spanStrings2 = GaebHelper.asString((Object)p);
                                plainTexts.addAll(spanStrings2);
                                continue;
                            }
                            if (!(o instanceof TextComplement)) continue;
                            TextComplement textComplement = (TextComplement)o;
                            List complBodies = (List)MoreObjects.firstNonNull((Object)textComplement.getBodies(), (Object)ImmutableList.of());
                            List complCaptions = (List)MoreObjects.firstNonNull((Object)textComplement.getCaptions(), (Object)ImmutableList.of());
                            List complTails = (List)MoreObjects.firstNonNull((Object)textComplement.getTails(), (Object)ImmutableList.of());
                            for (ComplBody complBody : complBodies) {
                                spans = (List)MoreObjects.firstNonNull((Object)complBody.getSpans(), (Object)ImmutableList.of());
                                spanStrings = (ImmutableList)spans.stream().map(Span::getContent).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
                                plainTexts.addAll(spanStrings);
                                bidderComplement.addAll(spanStrings);
                            }
                            for (ComplCaption complCaption : complCaptions) {
                                spans = (List)MoreObjects.firstNonNull((Object)complCaption.getSpans(), (Object)ImmutableList.of());
                                spanStrings = (ImmutableList)spans.stream().map(Span::getContent).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
                                plainTexts.addAll(spanStrings);
                                bidderComplement.addAll(spanStrings);
                            }
                            for (ComplTail complTail : complTails) {
                                spans = (List)MoreObjects.firstNonNull((Object)complTail.getSpans(), (Object)ImmutableList.of());
                                spanStrings = (ImmutableList)spans.stream().map(Span::getContent).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
                                plainTexts.addAll(spanStrings);
                                bidderComplement.addAll(spanStrings);
                            }
                        }
                    }
                }
            }
        }
        String bidderComplementString = Joiner.on((String)"\n").join((Iterable)bidderComplement);
        String plainTextsString = Joiner.on((String)"\n").join((Iterable)plainTexts);
        return Triple.of((Object)hasBidderComplement, (Object)plainTextsString, (Object)bidderComplementString);
    }

    @Nonnull
    private static String shortText(@NonNull List<Description> descriptions) {
        if (descriptions == null) {
            throw new NullPointerException("descriptions is marked non-null but is null");
        }
        ArrayList plainTexts = Lists.newArrayList();
        for (Description description : descriptions) {
            List completeTexts = (List)MoreObjects.firstNonNull((Object)description.getCompleteTexts(), (Object)ImmutableList.of());
            for (CompleteText completeText : completeTexts) {
                List outlineText = (List)MoreObjects.firstNonNull((Object)completeText.getOutlineText(), (Object)ImmutableList.of());
                for (OutlineText text : outlineText) {
                    List outlTxts = (List)MoreObjects.firstNonNull((Object)text.getOutlTxts(), (Object)ImmutableList.of());
                    for (OutlTxt outlTxt : outlTxts) {
                        List textOutlTxts = (List)MoreObjects.firstNonNull((Object)outlTxt.getTextOutlTxts(), (Object)ImmutableList.of());
                        for (TextOutlTxt textOutlTxt : textOutlTxts) {
                            List paragraphs = (List)MoreObjects.firstNonNull((Object)textOutlTxt.getParagraphs(), (Object)ImmutableList.of());
                            String p = GaebX84Mapper.plainText((List)paragraphs);
                            plainTexts.add(p);
                        }
                    }
                }
            }
        }
        return Joiner.on((String)"\n").join((Iterable)plainTexts);
    }

    @Nonnull
    private static String plainText(@Nullable LblTx lblTx) {
        if (null != lblTx) {
            List paragraphs = (List)MoreObjects.firstNonNull((Object)lblTx.getParagraphs(), (Object)ImmutableList.of());
            return GaebX84Mapper.plainText((List)paragraphs);
        }
        return "";
    }

    private static String plainText(@NonNull List<Paragraph> paragraphs) {
        if (paragraphs == null) {
            throw new NullPointerException("paragraphs is marked non-null but is null");
        }
        ArrayList spansContent = Lists.newArrayList();
        for (Paragraph paragraph : paragraphs) {
            List spans = GaebHelper.asString((Object)paragraph);
            for (String spanO : spans) {
                String spanC = StringUtils.trimToEmpty((String)spanO);
                if (!StringUtils.isNotBlank((CharSequence)spanC)) continue;
                spansContent.add(spanC);
            }
        }
        return Joiner.on((String)"\n").join((Iterable)spansContent);
    }

    @Nonnull
    public Iterable<Pair<String, String>> descriptions(@Nullable Award award) {
        ImmutableList.Builder descriptionsBuilder = ImmutableList.builder();
        if (null != award) {
            List textList = (List)MoreObjects.firstNonNull((Object)award.getTextList(), (Object)ImmutableList.of());
            for (AddText addText : textList) {
                List outline = (List)MoreObjects.firstNonNull((Object)addText.getOutline(), (Object)ImmutableList.of());
                ArrayList outLineTexts = Lists.newArrayList();
                for (OutlineAddText outlineAddText : outline) {
                    List paragraphs = outlineAddText.getParagraphs();
                    String p = GaebX84Mapper.plainText((List)paragraphs);
                    outLineTexts.add(p);
                }
                List detail = (List)MoreObjects.firstNonNull((Object)addText.getDetail(), (Object)ImmutableList.of());
                ArrayList detailTexts = Lists.newArrayList();
                for (DetailAddText detailAddText : detail) {
                    List paragraphs = detailAddText.getParagraphs();
                    String p = GaebX84Mapper.plainText((List)paragraphs);
                    detailTexts.add(p);
                }
                String outlineString = JOINER.join((Iterable)outLineTexts);
                String detailString = JOINER.join((Iterable)detailTexts);
                descriptionsBuilder.add((Object)Pair.of((Object)outlineString, (Object)detailString));
            }
        }
        return descriptionsBuilder.build();
    }
}

