/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import de.qfm.erp.common.request.generic.BankingHolidayUpdateRequest;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.generic.BankingHolidayCommon;
import de.qfm.erp.common.response.generic.BankingHolidayPageCommon;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.generic.BankingHoliday;
import de.qfm.erp.service.model.jpa.generic.EFederalState;
import de.qfm.erp.service.service.mapper.BaseMapper;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class BankingHolidayMapper {
    @Nonnull
    public BankingHolidayCommon map(@NonNull BankingHoliday item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        BankingHolidayCommon common = new BankingHolidayCommon();
        BaseMapper.map((EntityBase)item, (EntityBaseCommon)common);
        common.setId(item.getId());
        common.setName(item.getName());
        EFederalState federalState = (EFederalState)MoreObjects.firstNonNull((Object)item.getFederalState(), (Object)EFederalState.ALL);
        common.setFederalState(federalState.name());
        LocalDate localDate = LocalDate.of((int)item.getYear(), item.getMonth(), (int)item.getDayOfMonth());
        common.setDate(localDate);
        common.setFlagEachYear(item.getFlagEachYear());
        common.setFlagHalfDay(item.getFlagHalfDay());
        return common;
    }

    @Nonnull
    public BankingHolidayPageCommon map(@NonNull Page<BankingHoliday> page) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        return (BankingHolidayPageCommon)BaseMapper.map(page, arg_0 -> this.map(arg_0), (pageNumber, pageSize, totalElements, totalPages, items) -> new BankingHolidayPageCommon(pageNumber, pageSize, totalPages, totalElements, items));
    }

    @Nonnull
    public BankingHoliday merge(@NonNull BankingHoliday bankingHoliday, @NonNull BankingHolidayUpdateRequest updateRequest, @NonNull EFederalState federalState) {
        if (bankingHoliday == null) {
            throw new NullPointerException("bankingHoliday is marked non-null but is null");
        }
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        if (federalState == null) {
            throw new NullPointerException("federalState is marked non-null but is null");
        }
        bankingHoliday.setName(StringUtils.trimToEmpty((String)updateRequest.getName()));
        bankingHoliday.setFederalState(federalState);
        LocalDate date = updateRequest.getDate();
        int day = date.getDayOfMonth();
        int month = date.getMonthValue();
        int year = date.getYear();
        bankingHoliday.setDayOfMonth(Integer.valueOf(day));
        bankingHoliday.setMonth(Integer.valueOf(month));
        bankingHoliday.setYear(Integer.valueOf(year));
        bankingHoliday.setFlagEachYear(updateRequest.getFlagEachYear());
        bankingHoliday.setFlagHalfDay(updateRequest.getFlagHalfDay());
        return bankingHoliday;
    }
}

