/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.common.request.employee.attendance.AttendanceUpdateItem;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.employee.attendance.AttendanceCommon;
import de.qfm.erp.common.response.employee.attendance.AttendancesListCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthAutocompleteItemCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthAutocompleteItemListCommon;
import de.qfm.erp.service.helper.UserHelper;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.internal.employee.payroll.AttendanceUpdateBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceOrigin;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.generic.EDay;
import de.qfm.erp.service.model.jpa.generic.EDayType;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.calculator.attendance.AttendanceCalculators;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import de.qfm.erp.service.service.mapper.BaseMapper;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AttendanceMapper {
    private final AttendanceCalculators attendanceCalculators;
    private final StandardPersistenceHelper standardPersistenceHelper;

    @Nonnull
    public AttendanceCommon map(@NonNull Attendance attendance, @NonNull Function<User, Boolean> fnUserReleased, @NonNull Function<Attendance, Boolean> fnBadWeatherDisabled) {
        User squadLeader;
        User user;
        if (attendance == null) {
            throw new NullPointerException("attendance is marked non-null but is null");
        }
        if (fnUserReleased == null) {
            throw new NullPointerException("fnUserReleased is marked non-null but is null");
        }
        if (fnBadWeatherDisabled == null) {
            throw new NullPointerException("fnBadWeatherDisabled is marked non-null but is null");
        }
        AttendanceCommon common = new AttendanceCommon();
        BaseMapper.map((EntityBase)attendance, (EntityBaseCommon)common);
        common.setId(attendance.getId());
        common.setReferenceId(attendance.getReferenceId());
        PayrollMonth payrollMonth = attendance.getPayrollMonth();
        if (null != payrollMonth && null != (user = payrollMonth.getUser())) {
            common.setUserId(user.getId());
            common.setUserPersonalNumber(user.getPersonalNumber());
            common.setUserName(StringUtils.trimToEmpty((String)user.getFullName()));
        }
        if (null != (squadLeader = attendance.getSquadLeader())) {
            common.setSquadLeaderId(squadLeader.getId());
            common.setSquadLeaderPersonalNumber(squadLeader.getPersonalNumber());
            common.setSquadLeaderName(StringUtils.trimToEmpty((String)squadLeader.getFullName()));
            common.setFlagSquadLeaderHasReleased(fnUserReleased.apply(squadLeader));
        }
        EDayType dayType = (EDayType)ObjectUtils.firstNonNull((Object[])new EDayType[]{attendance.getDayType(), EDayType.UNKNOWN});
        common.setDayType(dayType.name());
        EAttendanceDayType attendanceDayType = (EAttendanceDayType)ObjectUtils.firstNonNull((Object[])new EAttendanceDayType[]{attendance.getEmployeeDayType(), EAttendanceDayType.NONE});
        common.setAttendanceDayType(attendanceDayType.name());
        common.setDate(attendance.getDate());
        common.setWeek(attendance.getWeek());
        common.setYear(attendance.getYear());
        common.setMonth(attendance.getMonth());
        common.setDayOfMonth(attendance.getDayOfMonth());
        EDay day = attendance.getDay();
        common.setDay(day.name());
        common.setWorkStart(attendance.getWorkStart());
        common.setWorkEnd(attendance.getWorkEnd());
        common.setWorkDuration(attendance.getWorkDuration());
        common.setBreakDuration(attendance.getBreakDuration());
        common.setBadWeatherDuration(attendance.getBadWeatherDuration());
        common.setContractualWorkTimeDuration(attendance.getContractualWorkTimeDuration());
        common.setConstructionSite(attendance.getConstructionSite());
        common.setRemarks(attendance.getRemarks());
        common.setCostBearer(attendance.getCostBearer());
        EAttendanceDayType defaultAttendanceDayType = (EAttendanceDayType)ObjectUtils.firstNonNull((Object[])new EAttendanceDayType[]{attendance.getDefaultEmployeeDayType(), EAttendanceDayType.NONE});
        common.setDefaultAttendanceDayType(defaultAttendanceDayType.name());
        common.setDefaultWorkStart(attendance.getDefaultWorkStart());
        common.setDefaultWorkEnd(attendance.getDefaultWorkEnd());
        common.setDefaultWorkDuration(attendance.getDefaultWorkDuration());
        common.setDefaultBreakDuration(attendance.getDefaultBreakDuration());
        User defaultSquadLeader = attendance.getDefaultSquadLeader();
        if (null != defaultSquadLeader) {
            common.setDefaultSquadLeaderId(defaultSquadLeader.getId());
            common.setDefaultSquadLeaderPersonalNumber(defaultSquadLeader.getPersonalNumber());
            common.setDefaultSquadLeaderName(StringUtils.trimToEmpty((String)defaultSquadLeader.getFullName()));
        }
        boolean flagBadWeatherDisabled = fnBadWeatherDisabled.apply(attendance);
        common.setFlagBadWeatherDisabled(flagBadWeatherDisabled);
        return common;
    }

    @Nonnull
    public AttendancesListCommon map(@NonNull Iterable<Attendance> attendances, @NonNull Function<User, Boolean> fnUserReleased, @NonNull Function<Attendance, Boolean> fnBadWeatherDisabled) {
        if (attendances == null) {
            throw new NullPointerException("attendances is marked non-null but is null");
        }
        if (fnUserReleased == null) {
            throw new NullPointerException("fnUserReleased is marked non-null but is null");
        }
        if (fnBadWeatherDisabled == null) {
            throw new NullPointerException("fnBadWeatherDisabled is marked non-null but is null");
        }
        int size = Iterables.size(attendances);
        List itemsCommon = (List)IterableHelper.stream(attendances).map(item -> this.map(item, fnUserReleased, fnBadWeatherDisabled)).sorted(Comparator.comparingInt(AttendanceCommon::getDayOfMonth)).collect(ImmutableList.toImmutableList());
        return new AttendancesListCommon(size, itemsCommon);
    }

    @Nonnull
    public MergedBucket<Attendance> merge(@NonNull Iterable<AttendanceUpdateBucket> attendanceUpdateBuckets) {
        if (attendanceUpdateBuckets == null) {
            throw new NullPointerException("attendanceUpdateBuckets is marked non-null but is null");
        }
        ImmutableList.Builder updatedBuilder = ImmutableList.builder();
        for (AttendanceUpdateBucket attendanceUpdateBucket : attendanceUpdateBuckets) {
            this.mergeAttendanceUpdateItem(attendanceUpdateBucket).ifPresent(arg_0 -> ((ImmutableList.Builder)updatedBuilder).add(arg_0));
        }
        ImmutableList attendanceMerged = updatedBuilder.build();
        this.attendanceCalculators.standard().calculateAndApply((Iterable)attendanceMerged);
        return MergedBucket.of((Iterable)ImmutableList.of(), (Iterable)attendanceMerged, (Iterable)ImmutableList.of());
    }

    @Nonnull
    public Optional<Attendance> mergeAttendanceUpdateItem(@NonNull AttendanceUpdateBucket attendanceUpdateBucket) {
        if (attendanceUpdateBucket == null) {
            throw new NullPointerException("attendanceUpdateBucket is marked non-null but is null");
        }
        Attendance attendance = attendanceUpdateBucket.getAttendance();
        AttendanceUpdateItem updateItem = attendanceUpdateBucket.getAttendanceUpdateItem();
        User squadLeader = attendanceUpdateBucket.getSquadLeader();
        EAttendanceOrigin origin = attendanceUpdateBucket.getOrigin();
        EAttendanceDayType employeeDayType = attendanceUpdateBucket.getAttendanceDayType();
        boolean changed = false;
        if (EAttendanceDayType.UNKNOWN != employeeDayType) {
            changed |= BaseMapper.mergeIfDifferent(() -> ((Attendance)attendance).getEmployeeDayType(), () -> employeeDayType, arg_0 -> ((Attendance)attendance).setEmployeeDayType(arg_0));
        }
        changed |= BaseMapper.mergeIfDifferent(() -> ((Attendance)attendance).getSquadLeader(), () -> squadLeader, arg_0 -> ((Attendance)attendance).setSquadLeader(arg_0));
        changed |= BaseMapper.mergeIfDifferent(() -> ((Attendance)attendance).getWorkStart(), () -> ((AttendanceUpdateItem)updateItem).getWorkStart(), arg_0 -> ((Attendance)attendance).setWorkStart(arg_0));
        changed |= BaseMapper.mergeIfDifferent(() -> ((Attendance)attendance).getWorkEnd(), () -> ((AttendanceUpdateItem)updateItem).getWorkEnd(), arg_0 -> ((Attendance)attendance).setWorkEnd(arg_0));
        changed |= BaseMapper.mergeIfDifferent(() -> ((Attendance)attendance).getBreakDuration(), () -> ((AttendanceUpdateItem)updateItem).getBreakDuration(), arg_0 -> ((Attendance)attendance).setBreakDuration(arg_0));
        changed |= BaseMapper.mergeIfDifferent(() -> ((Attendance)attendance).getConstructionSite(), () -> ((AttendanceUpdateItem)updateItem).getConstructionSite(), arg_0 -> ((Attendance)attendance).setConstructionSite(arg_0));
        changed |= BaseMapper.mergeIfDifferent(() -> ((Attendance)attendance).getRemarks(), () -> ((AttendanceUpdateItem)updateItem).getRemarks(), arg_0 -> ((Attendance)attendance).setRemarks(arg_0));
        if (changed |= BaseMapper.mergeIfDifferent(() -> ((Attendance)attendance).getCostBearer(), () -> ((AttendanceUpdateItem)updateItem).getCostBearer(), arg_0 -> ((Attendance)attendance).setCostBearer(arg_0))) {
            attendance.setLastOrigin(origin);
            this.standardPersistenceHelper.updated((EntityBase)attendance);
            return Optional.of(attendance);
        }
        return Optional.empty();
    }

    @Nonnull
    public PayrollMonthAutocompleteItemListCommon mapToPayrollMonthAutocomplete(@NonNull Iterable<PayrollMonth> payrollMonths, @NonNull String filterText) {
        if (payrollMonths == null) {
            throw new NullPointerException("payrollMonths is marked non-null but is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        String[] tokens = (String[])ImmutableSet.copyOf((Collection)Splitter.on((String)" ").trimResults().omitEmptyStrings().splitToList((CharSequence)filterText)).toArray(String[]::new);
        List commons = (List)IterableHelper.stream(payrollMonths).map(arg_0 -> this.mapToPayrollMonthAutocomplete(arg_0)).filter(item -> StringUtils.isBlank((CharSequence)filterText) || StringUtils.containsAnyIgnoreCase((CharSequence)item.getText(), (CharSequence[])tokens)).sorted(Comparator.comparing(PayrollMonthAutocompleteItemCommon::getText)).collect(ImmutableList.toImmutableList());
        return new PayrollMonthAutocompleteItemListCommon(commons.size(), commons);
    }

    @Nonnull
    public PayrollMonthAutocompleteItemCommon mapToPayrollMonthAutocomplete(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        User user = payrollMonth.getUser();
        String userAsString = UserHelper.asString((User)user);
        PayrollMonthAutocompleteItemCommon common = new PayrollMonthAutocompleteItemCommon();
        common.setId(payrollMonth.getId());
        common.setText(userAsString);
        return common;
    }

    public AttendanceMapper(AttendanceCalculators attendanceCalculators, StandardPersistenceHelper standardPersistenceHelper) {
        this.attendanceCalculators = attendanceCalculators;
        this.standardPersistenceHelper = standardPersistenceHelper;
    }
}

