/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.job;

import de.qfm.erp.service.service.route.InvoiceRoute;
import java.sql.Date;
import java.time.Clock;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.annotation.Transactional;

public class DirtyInvoiceDMSRefreshJob {
    private static final Logger log = LogManager.getLogger(DirtyInvoiceDMSRefreshJob.class);
    private final InvoiceRoute route;

    @Scheduled(initialDelayString="${scheduler.dms.exporter.dirty.processing.ms}", fixedDelayString="${scheduler.dms.exporter.dirty.processing.ms}")
    @Transactional(readOnly=false)
    public boolean triggerDMS() {
        log.debug("Triggering Dirty Invoice DMS Refresh");
        return this.route.pushToDMS();
    }

    @Scheduled(cron="${scheduler.heartbeat.cron}")
    public void schedulerHeartbeat() {
        log.info("Invoice DMS Heartbeat at {}", (Object)Date.from(Instant.now(Clock.systemUTC())));
    }

    public DirtyInvoiceDMSRefreshJob(InvoiceRoute route) {
        this.route = route;
    }
}

