/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.history;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.helper.HistoryHelper;
import de.qfm.erp.service.model.internal.history.EMeasurementHistoryField;
import de.qfm.erp.service.model.internal.history.HistoryField;
import de.qfm.erp.service.model.internal.history.MeasurementHistorySnapShot;
import de.qfm.erp.service.model.jpa.history.HistoryItem;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.model.jpa.history.type.EHistoryEntityAction;
import de.qfm.erp.service.model.jpa.history.type.EHistoryOperation;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.measurement.MeasurementState;
import de.qfm.erp.service.model.jpa.measurement.PssReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.ReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.history.HistoryPreparer;
import de.qfm.erp.service.service.service.MessageService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class MeasurementHistoryPreparer
extends HistoryPreparer<Measurement, MeasurementHistorySnapShot> {
    private final EntityFactory entityFactory;
    private final MessageService messageService;

    @Nonnull
    public MeasurementHistorySnapShot snapShot(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        LinkedHashMap historyState = Maps.newLinkedHashMap();
        historyState.put(EMeasurementHistoryField.MEASUREMENT_NUMBER, measurement.getMeasurementNumber());
        User assignedUser = measurement.getAssignedUser();
        historyState.put(EMeasurementHistoryField.ASSIGNED_USER__ID, null != assignedUser ? assignedUser.getId() : null);
        historyState.put(EMeasurementHistoryField.ASSIGNED_USER__USERNAME, null != assignedUser ? assignedUser.getUsername() : null);
        historyState.put(EMeasurementHistoryField.ASSIGNED_USER__FULL_NAME, null != assignedUser ? assignedUser.getFullName() : null);
        Quotation quotation = measurement.getQuotation();
        historyState.put(EMeasurementHistoryField.QUOTATION__ID, null != quotation ? quotation.getId() : null);
        historyState.put(EMeasurementHistoryField.QUOTATION__QUOTATION_NUMBER, null != quotation ? quotation.getQuotationNumber() : null);
        Invoice invoice = measurement.getInvoice();
        historyState.put(EMeasurementHistoryField.INVOICE__ID, null != invoice ? invoice.getId() : null);
        historyState.put(EMeasurementHistoryField.INVOICE__INVOICE_NUMBER, null != invoice ? invoice.getInvoiceNumber() : null);
        MeasurementState measurementState = (MeasurementState)MoreObjects.firstNonNull((Object)measurement.getMeasurementState(), (Object)new MeasurementState());
        EMeasurementState measurementStateE = (EMeasurementState)MoreObjects.firstNonNull((Object)measurementState.getMeasurementState(), (Object)EMeasurementState.UNKNOWN);
        historyState.put(EMeasurementHistoryField.MEASUREMENT_STATE__MEASUREMENT_STATE, measurementStateE);
        historyState.put(EMeasurementHistoryField.MEASUREMENT_TYPE, measurement.getMeasurementType());
        historyState.put(EMeasurementHistoryField.MEASUREMENT_VIEW_TYPE, measurement.getMeasurementViewType());
        historyState.put(EMeasurementHistoryField.REMARKS, measurement.getRemarks());
        historyState.put(EMeasurementHistoryField.REMARKS_INTERNAL, measurement.getRemarksInternal());
        historyState.put(EMeasurementHistoryField.CONSTRUCTION_SITE, measurement.getConstructionSite());
        historyState.put(EMeasurementHistoryField.PERSON_RESPONSIBLE_AT_CUSTOMER, measurement.getPersonResponsibleAtCustomer());
        historyState.put(EMeasurementHistoryField.CUSTOMER_AREA, measurement.getCustomerArea());
        historyState.put(EMeasurementHistoryField.PROJECT_EXECUTION_START_DATE, measurement.getProjectExecutionStartDate());
        historyState.put(EMeasurementHistoryField.PROJECT_EXECUTION_END_DATE, measurement.getProjectExecutionEndDate());
        historyState.put(EMeasurementHistoryField.ACCOUNTING_MONTH, measurement.getAccountingMonth());
        historyState.put(EMeasurementHistoryField.ACCOUNTING_MONTH_PLANNED, measurement.getAccountingMonthPlanned());
        historyState.put(EMeasurementHistoryField.SQUAD_WAGE_OVERALL, measurement.getSquadWageOverall());
        historyState.put(EMeasurementHistoryField.VALUE_OVERALL, measurement.getValueOverall());
        historyState.put(EMeasurementHistoryField.COMPANY_WAGE_OVERALL, measurement.getCompanyWageOverall());
        historyState.put(EMeasurementHistoryField.MATERIAL_PURCHASE_PRICE_OVERALL, measurement.getMaterialPurchasePriceOverall());
        ReleaseOrder releaseOrder = measurement.getReleaseOrder();
        ImmutableMap releaseOrderState = null != releaseOrder ? this.releaseOrder(releaseOrder) : ImmutableMap.of();
        List measurementPositions = measurement.getMeasurementPositions();
        ImmutableMap positionsState = null != measurementPositions ? this.positions(measurementPositions) : ImmutableMap.of();
        Long id = measurement.getId();
        return MeasurementHistorySnapShot.of((Long)id, (Map)historyState, (Map)releaseOrderState, (Map)positionsState);
    }

    @Nonnull
    public List<HistoryItem> difference(@NonNull MeasurementHistorySnapShot measurementHistorySnapShotPrevious, @NonNull Measurement measurement) {
        if (measurementHistorySnapShotPrevious == null) {
            throw new NullPointerException("measurementHistorySnapShotPrevious is marked non-null but is null");
        }
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        MeasurementHistorySnapShot measurementHistorySnapShotCurrent = this.snapShot(measurement);
        Map measurementStatePrevious = measurementHistorySnapShotPrevious.getMeasurementState();
        Map measurementStateCurrent = measurementHistorySnapShotCurrent.getMeasurementState();
        Long measurementId = measurement.getId();
        ImmutableList.Builder historyItemBuilder = ImmutableList.builder();
        Long previousId = measurementHistorySnapShotPrevious.getId();
        Long currentId = measurementHistorySnapShotCurrent.getId();
        if (null == previousId && null != currentId) {
            String importFileName = measurement.getImportFileName();
            if (StringUtils.isNotBlank((CharSequence)importFileName)) {
                historyItemBuilder.add((Object)this.createHistoryItem(measurementId, EHistoryOperation.NOTE, EHistoryEntityAction.MEASUREMENT__IMPORT, "", EMeasurementHistoryField.NOTE, "", importFileName, ""));
            }
            historyItemBuilder.add((Object)this.createHistoryItem(measurementId, EHistoryOperation.NOTE, EHistoryEntityAction.MEASUREMENT__CREATE, "", EMeasurementHistoryField.NOTE, "", measurement.getMeasurementNumber(), ""));
        } else if (null != previousId && null != currentId) {
            Long stageIdPrevious = measurementStatePrevious.getOrDefault(EMeasurementHistoryField.QUOTATION__ID, -1L);
            Long stageIdCurrent = measurementStateCurrent.getOrDefault(EMeasurementHistoryField.QUOTATION__ID, -1L);
            if (!previousId.equals(currentId)) {
                String measurementNumberPrevious = measurementStatePrevious.getOrDefault(EMeasurementHistoryField.MEASUREMENT_NUMBER, "");
                String measurementNumberCurrent = measurementStateCurrent.getOrDefault(EMeasurementHistoryField.MEASUREMENT_NUMBER, "");
                historyItemBuilder.add((Object)this.createHistoryItem(measurementId, EHistoryOperation.NOTE, EHistoryEntityAction.MEASUREMENT__COPY, "", EMeasurementHistoryField.NOTE, measurementNumberPrevious, measurementNumberCurrent, ""));
            } else if (!Objects.equals(stageIdPrevious, stageIdCurrent)) {
                String stageNumberPrevious = measurementStatePrevious.getOrDefault(EMeasurementHistoryField.QUOTATION__QUOTATION_NUMBER, "");
                Object stageNumberCurrent = measurementStateCurrent.getOrDefault(EMeasurementHistoryField.QUOTATION__QUOTATION_NUMBER, "");
                historyItemBuilder.add((Object)this.createHistoryItem(measurementId, EHistoryOperation.NOTE, EHistoryEntityAction.MEASUREMENT__MOVE, "", EMeasurementHistoryField.NOTE, stageNumberPrevious, (String)stageNumberCurrent, ""));
            }
        }
        historyItemBuilder.addAll(this.createHistoryItems(measurementId, "", "", measurementStatePrevious, measurementStateCurrent));
        Map positionsStatePrevious = measurementHistorySnapShotPrevious.getPositionsState();
        Map positionsStateCurrent = measurementHistorySnapShotCurrent.getPositionsState();
        Sets.SetView allIDs = Sets.union(positionsStatePrevious.keySet(), positionsStateCurrent.keySet());
        for (Long id : allIDs) {
            String details = Long.toString(id);
            Map positionStatePrevious = (Map)positionsStatePrevious.getOrDefault(id, ImmutableMap.of());
            Map positionStateCurrent = (Map)positionsStateCurrent.getOrDefault(id, ImmutableMap.of());
            String previousSPN = StringUtils.trimToEmpty((String)positionStatePrevious.getOrDefault(EMeasurementHistoryField.MEASUREMENT_POSITION__SPN, ""));
            String previousShortText = StringUtils.trimToEmpty((String)positionStatePrevious.getOrDefault(EMeasurementHistoryField.MEASUREMENT_POSITION__SHORT_TEXT, ""));
            String currentSPN = StringUtils.trimToEmpty((String)positionStateCurrent.getOrDefault(EMeasurementHistoryField.MEASUREMENT_POSITION__SPN, ""));
            String currentShortText = StringUtils.trimToEmpty((String)positionStateCurrent.getOrDefault(EMeasurementHistoryField.MEASUREMENT_POSITION__SHORT_TEXT, ""));
            boolean hasPreviousId = positionsStatePrevious.containsKey(id);
            boolean hasCurrentId = positionsStateCurrent.containsKey(id);
            String previousText = String.format("%s: %s", previousSPN, previousShortText);
            String currentText = String.format("%s: %s", currentSPN, currentShortText);
            if (!hasPreviousId && hasCurrentId) {
                historyItemBuilder.add((Object)this.createHistoryItem(measurementId, EHistoryOperation.NOTE, EHistoryEntityAction.MEASUREMENT_POSITION__CREATE, currentText, EMeasurementHistoryField.NOTE, "", currentText, currentSPN));
            } else if (hasPreviousId && !hasCurrentId) {
                historyItemBuilder.add((Object)this.createHistoryItem(measurementId, EHistoryOperation.NOTE, EHistoryEntityAction.MEASUREMENT_POSITION__DELETE, previousText, EMeasurementHistoryField.NOTE, previousText, "", previousSPN));
            }
            historyItemBuilder.addAll(this.createHistoryItems(measurementId, details, currentSPN, positionStatePrevious, positionStateCurrent));
        }
        Map releaseOrderPrevious = measurementHistorySnapShotPrevious.getReleaseOrder();
        Map releaseOrderCurrent = measurementHistorySnapShotCurrent.getReleaseOrder();
        historyItemBuilder.addAll(this.createHistoryItems(measurementId, "", "", releaseOrderPrevious, releaseOrderCurrent));
        return historyItemBuilder.build();
    }

    @Nonnull
    private Map<Long, Map<EMeasurementHistoryField, Object>> positions(@NonNull List<MeasurementPosition> measurementPositions) {
        if (measurementPositions == null) {
            throw new NullPointerException("measurementPositions is marked non-null but is null");
        }
        LinkedHashMap positionsState = Maps.newLinkedHashMap();
        measurementPositions.forEach(measurementPosition -> positionsState.put(measurementPosition.getId(), this.positionState(measurementPosition)));
        return positionsState;
    }

    @Nonnull
    private Map<EMeasurementHistoryField, Object> positionState(@NonNull MeasurementPosition measurementPosition) {
        if (measurementPosition == null) {
            throw new NullPointerException("measurementPosition is marked non-null but is null");
        }
        LinkedHashMap positionState = Maps.newLinkedHashMap();
        positionState.put(EMeasurementHistoryField.MEASUREMENT_POSITION__SPN, measurementPosition.getSurrogatePositionNumber());
        positionState.put(EMeasurementHistoryField.MEASUREMENT_POSITION__SHORT_TEXT, measurementPosition.getShortText());
        positionState.put(EMeasurementHistoryField.MEASUREMENT_POSITION__AMOUNT, measurementPosition.getAmount());
        positionState.put(EMeasurementHistoryField.MEASUREMENT_POSITION__FACTOR1, measurementPosition.getFactor1());
        positionState.put(EMeasurementHistoryField.MEASUREMENT_POSITION__FACTOR2, measurementPosition.getFactor2());
        positionState.put(EMeasurementHistoryField.MEASUREMENT_POSITION__FACTOR3, measurementPosition.getFactor3());
        positionState.put(EMeasurementHistoryField.MEASUREMENT_POSITION__REMARKS, measurementPosition.getRemarks());
        return positionState;
    }

    @Nonnull
    private Map<EMeasurementHistoryField, Object> releaseOrder(@NonNull ReleaseOrder releaseOrder) {
        if (releaseOrder == null) {
            throw new NullPointerException("releaseOrder is marked non-null but is null");
        }
        LinkedHashMap positionState = Maps.newLinkedHashMap();
        positionState.put(EMeasurementHistoryField.RELEASE_ORDER__NAME, releaseOrder.getName());
        positionState.put(EMeasurementHistoryField.RELEASE_ORDER__ORDER_NUMBER, releaseOrder.getOrderNumber());
        PssReleaseOrder pssReleaseOrder = releaseOrder.getPssReleaseOrder();
        if (null != pssReleaseOrder) {
            positionState.put(EMeasurementHistoryField.RELEASE_ORDER__PSS_RO__ID, pssReleaseOrder.getPssId());
            positionState.put(EMeasurementHistoryField.RELEASE_ORDER__PSS_RO__STATE, pssReleaseOrder.getPssState());
        }
        return positionState;
    }

    @Nonnull
    private Iterable<? extends HistoryItem> createHistoryItems(@NonNull Long entityId, @NonNull String details, @NonNull String referenceClearText, @NonNull Map<EMeasurementHistoryField, Object> statePrevious, @NonNull Map<EMeasurementHistoryField, Object> stateCurrent) {
        if (entityId == null) {
            throw new NullPointerException("entityId is marked non-null but is null");
        }
        if (details == null) {
            throw new NullPointerException("details is marked non-null but is null");
        }
        if (referenceClearText == null) {
            throw new NullPointerException("referenceClearText is marked non-null but is null");
        }
        if (statePrevious == null) {
            throw new NullPointerException("statePrevious is marked non-null but is null");
        }
        if (stateCurrent == null) {
            throw new NullPointerException("stateCurrent is marked non-null but is null");
        }
        ImmutableList.Builder historyItemBuilder = ImmutableList.builder();
        MapDifference difference = Maps.difference(statePrevious, stateCurrent);
        Map differenceRemoved = difference.entriesOnlyOnLeft();
        differenceRemoved.forEach((field, value) -> {
            String valueOld = StringUtils.trimToEmpty((String)MoreObjects.firstNonNull((Object)value, (Object)"").toString());
            this.createIfChanged(entityId, EHistoryOperation.DELETE, details, referenceClearText, field, (Object)valueOld, (Object)"").ifPresent(arg_0 -> ((ImmutableList.Builder)historyItemBuilder).add(arg_0));
        });
        Map differenceAdded = difference.entriesOnlyOnRight();
        differenceAdded.forEach((field, value) -> {
            String valueNew = StringUtils.trimToEmpty((String)MoreObjects.firstNonNull((Object)value, (Object)"").toString());
            this.createIfChanged(entityId, EHistoryOperation.CREATE, details, referenceClearText, field, (Object)"", (Object)valueNew).ifPresent(arg_0 -> ((ImmutableList.Builder)historyItemBuilder).add(arg_0));
        });
        Map differenceUpdated = difference.entriesDiffering();
        differenceUpdated.forEach((field, value) -> {
            Object valueOld = value.leftValue();
            Object valueNew = value.rightValue();
            this.createIfChanged(entityId, EHistoryOperation.UPDATE, details, referenceClearText, field, valueOld, valueNew).ifPresent(arg_0 -> ((ImmutableList.Builder)historyItemBuilder).add(arg_0));
        });
        return historyItemBuilder.build();
    }

    @Nonnull
    private Optional<HistoryItem> createIfChanged(@NonNull Long entityId, @NonNull EHistoryOperation operation, @NonNull String details, @NonNull String referenceClearText, @NonNull EMeasurementHistoryField field, @Nullable Object valueOld, @Nullable Object valueNew) {
        String valueNewS;
        String valueOldS;
        boolean isEqual;
        if (entityId == null) {
            throw new NullPointerException("entityId is marked non-null but is null");
        }
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        if (details == null) {
            throw new NullPointerException("details is marked non-null but is null");
        }
        if (referenceClearText == null) {
            throw new NullPointerException("referenceClearText is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (valueOld instanceof BigDecimal && valueNew instanceof BigDecimal) {
            BigDecimal valueOldBD = (BigDecimal)valueOld;
            BigDecimal valueNewBD = (BigDecimal)valueNew;
            isEqual = valueOldBD.compareTo(valueNewBD) == 0;
            valueOldS = BigDecimalHelper.asString((BigDecimal)valueOldBD);
            valueNewS = BigDecimalHelper.asString((BigDecimal)valueNewBD);
        } else if (valueOld instanceof LocalDate && valueNew instanceof LocalDate) {
            LocalDate valueOldLD = (LocalDate)valueOld;
            LocalDate valueNewLD = (LocalDate)valueNew;
            isEqual = valueOldLD.isEqual(valueNewLD);
            valueOldS = DateTimeHelper.toIsoDate((LocalDate)valueOldLD);
            valueNewS = DateTimeHelper.toIsoDate((LocalDate)valueNewLD);
        } else if (valueOld instanceof LocalDateTime && valueNew instanceof LocalDateTime) {
            LocalDateTime valueOldLDT = (LocalDateTime)valueOld;
            LocalDateTime valueNewLDT = (LocalDateTime)valueNew;
            isEqual = valueOldLDT.isEqual(valueNewLDT);
            valueOldS = DateTimeHelper.toIsoDateTime((LocalDateTime)valueOldLDT);
            valueNewS = DateTimeHelper.toIsoDateTime((LocalDateTime)valueNewLDT);
        } else {
            valueOldS = StringUtils.trimToEmpty((String)MoreObjects.firstNonNull((Object)valueOld, (Object)"").toString());
            valueNewS = StringUtils.trimToEmpty((String)MoreObjects.firstNonNull((Object)valueNew, (Object)"").toString());
            isEqual = StringUtils.equalsIgnoreCase((CharSequence)valueOldS, (CharSequence)valueNewS);
        }
        if (!isEqual) {
            return Optional.of(this.createHistoryItem(entityId, operation, EHistoryEntityAction.NONE, details, field, valueOldS, valueNewS, referenceClearText));
        }
        return Optional.empty();
    }

    @Nonnull
    private HistoryItem createHistoryItem(@NonNull Long entityId, @NonNull EHistoryOperation operation, @NonNull EHistoryEntityAction entityOperation, @NonNull String details, @NonNull EMeasurementHistoryField field, @NonNull String valueOldS, @NonNull String valueNewS, @NonNull String referenceClearText) {
        if (entityId == null) {
            throw new NullPointerException("entityId is marked non-null but is null");
        }
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        if (entityOperation == null) {
            throw new NullPointerException("entityOperation is marked non-null but is null");
        }
        if (details == null) {
            throw new NullPointerException("details is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (valueOldS == null) {
            throw new NullPointerException("valueOldS is marked non-null but is null");
        }
        if (valueNewS == null) {
            throw new NullPointerException("valueNewS is marked non-null but is null");
        }
        if (referenceClearText == null) {
            throw new NullPointerException("referenceClearText is marked non-null but is null");
        }
        HistoryItem historyItem = this.entityFactory.historyItem();
        historyItem.setEntityClass(EEntityClass.MEASUREMENT);
        historyItem.setEntityId(entityId);
        historyItem.setOperation(operation);
        historyItem.setEntityAction(entityOperation);
        historyItem.setField(HistoryHelper.fieldName((HistoryField)field));
        historyItem.setDetails(StringUtils.left((String)details, (int)250));
        historyItem.setValueOld(StringUtils.left((String)valueOldS, (int)250));
        historyItem.setValueNew(StringUtils.left((String)valueNewS, (int)250));
        historyItem.setReferenceClearText(StringUtils.left((String)referenceClearText, (int)250));
        return historyItem;
    }

    public MeasurementHistoryPreparer(EntityFactory entityFactory, MessageService messageService) {
        this.entityFactory = entityFactory;
        this.messageService = messageService;
    }
}

