/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler.impl;

import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementOrigin;
import de.qfm.erp.service.model.jpa.queue.EReferenceType;
import de.qfm.erp.service.model.jpa.sync.SyncLog;
import de.qfm.erp.service.repository.SyncLogRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.InternalAuthPersistenceHelper;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.SyncLogService;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class SyncLogHandlerImpl
extends BaseHandler<SyncLog>
implements SyncLogService {
    private static final Logger log = LogManager.getLogger(SyncLogHandlerImpl.class);
    private final SyncLogRepository repository;

    @Autowired
    public SyncLogHandlerImpl(InternalAuthPersistenceHelper persistenceHelper, SyncLogRepository repository) {
        super((PersistenceHelper)persistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    @Nonnull
    public SyncLog log(@NonNull EMeasurementOrigin origin, @NonNull EReferenceType referenceType, @NonNull Long referenceId, @NonNull String message) {
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        if (referenceType == null) {
            throw new NullPointerException("referenceType is marked non-null but is null");
        }
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        SyncLog syncLog = new SyncLog();
        this.persistenceHelper.created((EntityBase)syncLog);
        syncLog.setOrigin(origin);
        syncLog.setReferenceType(referenceType);
        syncLog.setReferenceId(referenceId);
        syncLog.setMessage(message);
        return (SyncLog)this.repository.save((Object)((SyncLog)this.baseUpdate((EntityBase)syncLog)));
    }

    @Nonnull
    public Page<SyncLog> list(int page, int size) {
        return this.repository.findAll((Pageable)PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}));
    }

    @Nonnull
    public Page<SyncLog> list(int page, int size, @NonNull EReferenceType referenceType, @NonNull Long referenceId) {
        if (referenceType == null) {
            throw new NullPointerException("referenceType is marked non-null but is null");
        }
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        return this.repository.findAll((Pageable)PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}));
    }

    protected Class<SyncLog> clazz() {
        return SyncLog.class;
    }

    @Nonnull
    protected SyncLog beforeUpdate(@NonNull SyncLog item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected SyncLog beforeDelete(@NonNull SyncLog item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected SyncLog afterUpdate(@NonNull SyncLog item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected SyncLog afterDelete(@NonNull SyncLog item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }
}

