/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.service.helper.EmployeeHelper;
import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.UserGetBucket;
import de.qfm.erp.service.model.internal.costcenter.CostCenterFilter;
import de.qfm.erp.service.model.internal.costcenter.ECostCenterFilterType;
import de.qfm.erp.service.model.internal.dashboard.IReportCountStringLong;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.jpa.EPsxNotifyState;
import de.qfm.erp.service.model.jpa.businessunit.UserCostCenter;
import de.qfm.erp.service.model.jpa.search.ESearchIndexState;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.repository.UserRepository;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageCalculatorHelper;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class UserHandler
extends BaseHandler<User> {
    private static final Logger log = LogManager.getLogger(UserHandler.class);
    private final UserRepository repository;
    private static final int COST_CENTER_MAX_LEN = 3;

    @Autowired
    public UserHandler(StandardPersistenceHelper standardPersistenceHelper, UserRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<User> clazz() {
        return User.class;
    }

    @Nonnull
    protected User beforeUpdate(@NonNull User item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        item.setSearchIndexState(ESearchIndexState.NOT_INDEXED);
        item.setPsxNotifyState(EPsxNotifyState.NOT_NOTIFIED);
        return item;
    }

    @Nonnull
    protected User beforeDelete(@NonNull User item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        item.setSearchIndexState(ESearchIndexState.NOT_INDEXED);
        item.setPsxNotifyState(EPsxNotifyState.NOT_NOTIFIED);
        return item;
    }

    @Nonnull
    protected User afterUpdate(@NonNull User item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected User afterDelete(@NonNull User item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Iterable<User> byIdsFailing(@NonNull Iterable<Long> givenIDs) {
        if (givenIDs == null) {
            throw new NullPointerException("givenIDs is marked non-null but is null");
        }
        List usersByIds = this.repository.findAllById(givenIDs);
        Iterable foundIDs = IterableHelper.stream((Iterable)usersByIds).map(User::getId).collect(Collectors.toSet());
        ImmutableSet difference = Sets.difference((Set)ImmutableSet.copyOf(givenIDs), (Set)ImmutableSet.copyOf((Iterable)foundIDs)).immutableCopy();
        if (!difference.isEmpty()) {
            String idsNotFound = ID_JOINER.join((Iterable)difference);
            throw ResourceNotFoundException.of((String)User.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ID), (String)idsNotFound);
        }
        return ImmutableList.copyOf((Collection)usersByIds);
    }

    @Nonnull
    public Iterable<User> byReferenceIdsNotFailing(@NonNull Iterable<String> referenceIds) {
        if (referenceIds == null) {
            throw new NullPointerException("referenceIds is marked non-null but is null");
        }
        List usersByReferenceIds = this.repository.findAllByReferenceIdIn(referenceIds);
        return ImmutableList.copyOf((Collection)usersByReferenceIds);
    }

    @Nonnull
    public User byNameFailing(@NonNull String username) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        Optional userCandidate = this.byNameNotFailing(username);
        if (userCandidate.isEmpty()) {
            throw ResourceNotFoundException.of((String)User.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.USER__NAME), (String)username);
        }
        return (User)userCandidate.get();
    }

    @Nonnull
    public User byPersonalNumberFailing(@NonNull Integer personalNumber) {
        if (personalNumber == null) {
            throw new NullPointerException("personalNumber is marked non-null but is null");
        }
        Optional userCandidate = this.byPersonalNumberNotFailing(personalNumber);
        if (userCandidate.isEmpty()) {
            throw ResourceNotFoundException.of((String)User.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.USER__PERSONAL_NUMBER), (String)Integer.toString(personalNumber));
        }
        return (User)userCandidate.get();
    }

    @Nonnull
    public Optional<User> byNameNotFailing(@NonNull String username) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        return this.repository.findOneByUsernameIgnoreCase(username);
    }

    @Nonnull
    public Optional<User> byPersonalNumberNotFailing(@NonNull Integer personalNumber) {
        if (personalNumber == null) {
            throw new NullPointerException("personalNumber is marked non-null but is null");
        }
        return this.repository.findOneByPersonalNumber(personalNumber);
    }

    @Nonnull
    public User byReferenceIdFailing(@NonNull String referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        Optional userCandidate = this.byReferenceIdNotFailing(referenceId);
        if (userCandidate.isEmpty()) {
            throw ResourceNotFoundException.of((String)User.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.REFERENCE_ID), (String)referenceId);
        }
        return (User)userCandidate.get();
    }

    @Nonnull
    public User byDefaultFailing() {
        Optional userCandidate = this.repository.findOneByFlagSyncDefault(true);
        if (userCandidate.isEmpty()) {
            throw ResourceNotFoundException.of((String)User.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.FLAG_SYNC_DEFAULT), (String)"true");
        }
        return (User)userCandidate.get();
    }

    @Nonnull
    public Optional<User> byReferenceIdNotFailing(@NonNull String referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        return this.repository.findOneByReferenceId(referenceId);
    }

    @Nonnull
    public Page<User> page(int page, int size, @NonNull String filterText) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        PageRequest pageRequest = PageRequest.of((int)page, (int)size);
        return this.repository.findAll(Specification.where((Specification)UserRepository.filter((String)filterText, (Range)Range.all(), (boolean)true, (boolean)true)), (Pageable)pageRequest);
    }

    public boolean anotherUserWithSameUsername(@NonNull User user, @NonNull String userName) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (userName == null) {
            throw new NullPointerException("userName is marked non-null but is null");
        }
        Long id = user.getId();
        return this.userWithSameUsername(id, userName).isPresent();
    }

    public boolean anotherUserWithSamePersonalNumber(@NonNull User user, @NonNull Integer personalNumber) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (personalNumber == null) {
            throw new NullPointerException("personalNumber is marked non-null but is null");
        }
        Long id = user.getId();
        return this.userWithSamePersonalNumber(id, personalNumber).isPresent();
    }

    @Nonnull
    public Optional<User> userWithSamePersonalNumber(@Nullable Long id, @NonNull Integer personalNumber) {
        if (personalNumber == null) {
            throw new NullPointerException("personalNumber is marked non-null but is null");
        }
        if (null != id) {
            return this.repository.findOneByPersonalNumberAndIdNot(personalNumber, id);
        }
        return this.repository.findOneByPersonalNumber(personalNumber);
    }

    @Nonnull
    public Optional<User> userWithSameUsername(@Nullable Long id, @NonNull String userName) {
        if (userName == null) {
            throw new NullPointerException("userName is marked non-null but is null");
        }
        String safeUserName = StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)userName));
        if (null != id) {
            return this.repository.findOneByUsernameIgnoreCaseAndIdNot(safeUserName, id);
        }
        return this.repository.findOneByUsernameIgnoreCase(safeUserName);
    }

    @Nonnull
    public Iterable<User> usersInCostCenter(@NonNull CostCenterFilter costCenterFilter, @NonNull LocalDate referenceDate) {
        if (costCenterFilter == null) {
            throw new NullPointerException("costCenterFilter is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        String costCenter = costCenterFilter.getCostCenter();
        ECostCenterFilterType costCenterFilterType = costCenterFilter.getCostCenterFilterType();
        if (ECostCenterFilterType.STARTS_WITH == costCenterFilterType) {
            return this.repository.usersInCostCenterStartWith(referenceDate, costCenter);
        }
        if (ECostCenterFilterType.EQ == costCenterFilterType) {
            return this.repository.usersInCostCenterEQ(referenceDate, costCenter);
        }
        if (ECostCenterFilterType.ALL == costCenterFilterType) {
            return this.repository.usersInCostCenterStartWith(referenceDate, "");
        }
        return ImmutableList.of();
    }

    @Nonnull
    public Iterable<IReportCountStringLong> usersPerCostCenter(@NonNull LocalDate referenceDate) {
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        return this.repository.usersPerCostCenter(referenceDate);
    }

    @Nonnull
    public Optional<User> currentManagerNotFailing(@NonNull CostCenterFilter costCenterFilter, @NonNull LocalDate referenceDate) {
        if (costCenterFilter == null) {
            throw new NullPointerException("costCenterFilter is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        String costCenter = costCenterFilter.getCostCenter();
        for (int i = 0; i < 3; ++i) {
            String costCenterPadded = StringUtils.rightPad((String)StringUtils.left((String)costCenter, (int)(3 - i)), (int)3, (String)"0");
            Iterable users = this.repository.managersInCostCenter(referenceDate, costCenterPadded);
            if (Iterables.isEmpty((Iterable)users)) continue;
            return Optional.ofNullable((User)Iterables.get((Iterable)users, (int)0));
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<User> currentManagerNotFailing(@NonNull User user, @NonNull LocalDate referenceDate) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        Optional costCenterCandidate = EmployeeHelper.currentUserCostCenterNotFailing((User)user, (LocalDate)referenceDate);
        return costCenterCandidate.flatMap(s -> this.currentManagerNotFailing(s, referenceDate));
    }

    @Nonnull
    public Optional<User> currentManagerNotFailing(@NonNull UserCostCenter userCostCenter, @NonNull LocalDate referenceDate) {
        String startingPoint;
        if (userCostCenter == null) {
            throw new NullPointerException("userCostCenter is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        String costCenter = userCostCenter.getCostCenter();
        Boolean flagLead = userCostCenter.getFlagLead();
        boolean fetchParent = Objects.equals(Boolean.TRUE, flagLead);
        if (fetchParent) {
            String costCenterWithoutTrailingZero = StringUtils.replaceAll((String)costCenter, (String)"0+$", (String)"");
            String costCenterParentWithoutZero = StringUtils.left((String)costCenterWithoutTrailingZero, (int)(StringUtils.length((CharSequence)costCenterWithoutTrailingZero) - 1));
            startingPoint = StringUtils.rightPad((String)costCenterParentWithoutZero, (int)3, (String)"0");
        } else {
            startingPoint = costCenter;
        }
        for (int i = 0; i < 3; ++i) {
            String costCenterPadded = StringUtils.rightPad((String)StringUtils.left((String)startingPoint, (int)(3 - i)), (int)3, (String)"0");
            Iterable users = this.repository.managersInCostCenter(referenceDate, costCenterPadded);
            if (Iterables.isEmpty((Iterable)users)) continue;
            return Optional.ofNullable((User)Iterables.get((Iterable)users, (int)0));
        }
        return Optional.empty();
    }

    @Nonnull
    public UserGetBucket userGetBucket(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        Optional costCenterCandidate = EmployeeHelper.currentUserCostCenterNotFailing((User)user, (LocalDate)DateTimeHelper.today());
        Optional managerCandidate = costCenterCandidate.flatMap(s -> this.currentManagerNotFailing(s, DateTimeHelper.today()));
        BigDecimal effectiveWagePerHour = WageCalculatorHelper.effectiveWagePerHourNullable((YearMonth)YearMonth.now(), (User)user);
        return UserGetBucket.of((User)user, (User)managerCandidate.orElse(null), (String)costCenterCandidate.map(UserCostCenter::getCostCenter).orElse(""), (BigDecimal)effectiveWagePerHour);
    }

    @Nonnull
    public Iterable<User> usersWithDisableDateLTE(@NonNull LocalDate referenceDate) {
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        return this.repository.findAllByDisableDateLessThanEqual(referenceDate);
    }

    @Nonnull
    public Page<User> page(@Nonnull Pageable pageable, @NonNull Range<LocalDate> referenceDateRange) {
        if (referenceDateRange == null) {
            throw new NullPointerException("referenceDateRange is marked non-null but is null");
        }
        return this.page(pageable, referenceDateRange, true, true);
    }

    @Nonnull
    public Page<User> page(@Nonnull Pageable pageable, @NonNull Range<LocalDate> referenceDateRange, boolean considerContract, boolean truncateDateToMonth) {
        if (referenceDateRange == null) {
            throw new NullPointerException("referenceDateRange is marked non-null but is null");
        }
        return this.repository.findAll(Specification.where((Specification)UserRepository.filter((String)"", referenceDateRange, (boolean)considerContract, (boolean)truncateDateToMonth)), pageable);
    }

    public boolean dirty() {
        return !this.repository.findAllUnIndexed((Iterable)ImmutableSet.of((Object)ESearchIndexState.UNKNOWN, (Object)ESearchIndexState.NOT_INDEXED), (Pageable)PageRequest.of((int)0, (int)1)).isEmpty();
    }

    @Nonnull
    public Iterable<User> dirtyPage(int max) {
        return this.repository.findAllUnIndexed((Iterable)ImmutableSet.of((Object)ESearchIndexState.UNKNOWN, (Object)ESearchIndexState.NOT_INDEXED), (Pageable)PageRequest.of((int)0, (int)max, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"updatedOn", "id"})));
    }

    public int markIndexed(@NonNull Iterable<User> itemsProcessed) {
        if (itemsProcessed == null) {
            throw new NullPointerException("itemsProcessed is marked non-null but is null");
        }
        ImmutableSet userIds = (ImmutableSet)Streams.stream(itemsProcessed).map(User::getId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        return this.repository.updateSearchIndexState(ESearchIndexState.INDEXED, (Iterable)userIds);
    }

    @Nonnull
    public List<User> nextNotNotified() {
        return this.repository.nextNotNotified((Pageable)PageRequest.of((int)0, (int)1));
    }

    public int markPsxNotified(long userId) {
        return this.repository.updatePsxNotifyState(EPsxNotifyState.NOTIFIED, (Iterable)ImmutableSet.of((Object)userId));
    }
}

