/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Longs;
import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.jpa.measurement.PssReleaseOrder;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.repository.PssReleaseOrderRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.InternalAuthPersistenceHelper;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class PssHandler
extends BaseHandler<PssReleaseOrder> {
    private final PssReleaseOrderRepository repository;

    @Autowired
    public PssHandler(InternalAuthPersistenceHelper persistenceHelper, PssReleaseOrderRepository repository) {
        super((PersistenceHelper)persistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<PssReleaseOrder> clazz() {
        return PssReleaseOrder.class;
    }

    @Nonnull
    protected PssReleaseOrder beforeUpdate(@NonNull PssReleaseOrder item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected PssReleaseOrder beforeDelete(@NonNull PssReleaseOrder item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected PssReleaseOrder afterUpdate(@NonNull PssReleaseOrder item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected PssReleaseOrder afterDelete(@NonNull PssReleaseOrder item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Page<PssReleaseOrder> pssReleaseOrders(@NonNull Quotation quotation, @NonNull String filterText, int page, int size) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        String quotationNumber = quotation.getQuotationNumber();
        String stageNumber = quotation.getQNumber();
        ImmutableSet quotationNumbersForSelection = ImmutableSet.of((Object)quotationNumber, (Object)stageNumber);
        String filterTextCleaned = StringUtils.left((String)filterText, (int)250);
        PageRequest pageRequest = PageRequest.of((int)page, (int)size);
        if (StringUtils.isNotBlank((CharSequence)filterTextCleaned)) {
            Specification pssReleaseOrderSpecification;
            if (StringUtils.isNumeric((CharSequence)filterTextCleaned) && StringUtils.length((CharSequence)filterTextCleaned) <= 19) {
                Long pssIdCandidate = (Long)MoreObjects.firstNonNull((Object)Longs.tryParse((String)filterTextCleaned), (Object)Long.MIN_VALUE);
                pssReleaseOrderSpecification = PssReleaseOrderRepository.quotationNumberIn((Collection)quotationNumbersForSelection).and(PssReleaseOrderRepository.textMatches((String)filterTextCleaned).or(PssReleaseOrderRepository.pssIdMatches((Long)pssIdCandidate)));
            } else {
                pssReleaseOrderSpecification = PssReleaseOrderRepository.quotationNumberIn((Collection)quotationNumbersForSelection).and(PssReleaseOrderRepository.textMatches((String)filterTextCleaned));
            }
            return this.repository.findAll(Specification.where((Specification)pssReleaseOrderSpecification), (Pageable)pageRequest);
        }
        return this.repository.findAll(Specification.where((Specification)PssReleaseOrderRepository.quotationNumberIn((Collection)quotationNumbersForSelection)), (Pageable)pageRequest);
    }

    @Nonnull
    public Optional<PssReleaseOrder> byPssReleaseOrderIdNotFailing(@NonNull Long pssReleaseOrderId) {
        if (pssReleaseOrderId == null) {
            throw new NullPointerException("pssReleaseOrderId is marked non-null but is null");
        }
        return this.repository.findByPssId(pssReleaseOrderId);
    }

    @Nonnull
    public PssReleaseOrder byExternalPssReleaseOrderIdFailing(@NonNull Long pssReleaseOrderId) {
        if (pssReleaseOrderId == null) {
            throw new NullPointerException("pssReleaseOrderId is marked non-null but is null");
        }
        Optional byExternalPssReleaseOrderId = this.byPssReleaseOrderIdNotFailing(pssReleaseOrderId);
        if (byExternalPssReleaseOrderId.isEmpty()) {
            throw ResourceNotFoundException.of((String)PssReleaseOrder.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PSS_RELEASE_ORDER_EXTERNAL_ID), (String)Long.toString(pssReleaseOrderId));
        }
        return (PssReleaseOrder)byExternalPssReleaseOrderId.get();
    }

    @Nonnull
    public PssReleaseOrder byReferenceIdFailing(@NonNull String referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        Optional byId = this.byReferenceIdNotFailing(referenceId);
        if (byId.isEmpty()) {
            throw ResourceNotFoundException.of((String)PssReleaseOrder.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.REFERENCE_ID), (String)referenceId);
        }
        return (PssReleaseOrder)byId.get();
    }

    @Nonnull
    public Optional<PssReleaseOrder> byReferenceIdNotFailing(@NonNull String referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        return this.repository.findByReferenceId(referenceId);
    }
}

