/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.model.internal.employee.payroll.AggPaidWage;
import de.qfm.erp.service.model.internal.payroll.IAggregatedPayrollUser;
import de.qfm.erp.service.model.internal.payroll.PayrollMonthFilter;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemClazz;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollMonthState;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.repository.PayrollMonthRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PayrollMonthItemHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import de.qfm.erp.service.service.security.UserService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class PayrollMonthHandler
extends BaseHandler<PayrollMonth> {
    private static final Logger log = LogManager.getLogger(PayrollMonthHandler.class);
    @PersistenceContext
    private EntityManager em;
    private final PayrollMonthRepository repository;
    private final PayrollMonthItemHandler payrollMonthItemHandler;
    private final UserService userService;

    @Autowired
    public PayrollMonthHandler(StandardPersistenceHelper standardPersistenceHelper, UserService userService, PayrollMonthRepository repository, PayrollMonthItemHandler payrollMonthItemHandler) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.userService = userService;
        this.repository = repository;
        this.payrollMonthItemHandler = payrollMonthItemHandler;
    }

    protected Class<PayrollMonth> clazz() {
        return PayrollMonth.class;
    }

    @Nonnull
    protected PayrollMonth beforeUpdate(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        return payrollMonth;
    }

    @Nonnull
    protected PayrollMonth beforeDelete(@NonNull PayrollMonth item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        List payrollMonthItems = (List)MoreObjects.firstNonNull((Object)item.getPayrollMonthItems(), (Object)ImmutableList.of());
        payrollMonthItems.forEach(arg_0 -> ((PayrollMonthItemHandler)this.payrollMonthItemHandler).beforeDelete(arg_0));
        return item;
    }

    @Nonnull
    protected PayrollMonth afterUpdate(@NonNull PayrollMonth item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected PayrollMonth afterDelete(@NonNull PayrollMonth item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Iterable<AggPaidWage> paidWagesByQuotation(@NonNull Range<LocalDate> dateRange, @NonNull Iterable<String> relevantQuotationNumbers, @NonNull Iterable<User> senders) {
        if (dateRange == null) {
            throw new NullPointerException("dateRange is marked non-null but is null");
        }
        if (relevantQuotationNumbers == null) {
            throw new NullPointerException("relevantQuotationNumbers is marked non-null but is null");
        }
        if (senders == null) {
            throw new NullPointerException("senders is marked non-null but is null");
        }
        CriteriaBuilder criteriaBuilder = this.em.getCriteriaBuilder();
        CriteriaQuery fetchQuery = criteriaBuilder.createQuery(AggPaidWage.class);
        Root fetchRoot = fetchQuery.from(PayrollMonth.class);
        Join childrenProd_P_PMI = fetchRoot.join("payrollMonthItems", JoinType.LEFT);
        Join childrenProd_PMI_Q = childrenProd_P_PMI.join("quotation", JoinType.LEFT);
        Join childrenProd_Q_P = childrenProd_PMI_Q.join("project", JoinType.LEFT);
        ArrayList predicates = Lists.newArrayList();
        PayrollMonthRepository.accountingMonthBetween(dateRange).ifPresent(item -> predicates.add(item.toPredicate(fetchRoot, fetchQuery, criteriaBuilder)));
        PayrollMonthRepository.noQuotationNumberEnded((Join)childrenProd_P_PMI).ifPresent(item -> predicates.add(item.toPredicate(fetchRoot, fetchQuery, criteriaBuilder)));
        PayrollMonthRepository.payrollItemClazzIn((Join)childrenProd_P_PMI, (Iterable)ImmutableSet.of((Object)EPayrollItemClazz.INCENTIVE_PAYMENT)).ifPresent(predicates::add);
        PayrollMonthRepository.quotationNumberIn((Join)childrenProd_P_PMI, (Iterable)ImmutableSet.copyOf(relevantQuotationNumbers)).ifPresent(predicates::add);
        PayrollMonthRepository.sendersIn((Join)childrenProd_P_PMI, (Iterable)ImmutableSet.copyOf(senders)).ifPresent(predicates::add);
        Predicate predicate = criteriaBuilder.and((Predicate[])predicates.toArray(Predicate[]::new));
        CriteriaQuery where = fetchQuery.multiselect(new Selection[]{fetchRoot.get("id").alias("id"), childrenProd_P_PMI.get("quotationNumber").alias("quotationNumber"), childrenProd_PMI_Q.get("id").alias("stageId"), childrenProd_PMI_Q.get("qNumber").alias("stageNumber"), childrenProd_PMI_Q.get("version").alias("stageVersion"), childrenProd_PMI_Q.get("alias").alias("stageAlias"), childrenProd_Q_P.get("name").alias("projectName"), childrenProd_Q_P.get("referenceId").alias("projectReferenceId"), fetchRoot.get("accountingMonth").alias("accountingMonth"), childrenProd_P_PMI.get("value").alias("value")}).where((Expression)predicate).distinct(false).orderBy(new Order[]{criteriaBuilder.asc((Expression)childrenProd_P_PMI.get("quotationNumber")), criteriaBuilder.asc((Expression)childrenProd_P_PMI.get("quotationNumber")), criteriaBuilder.asc((Expression)fetchRoot.get("accountingMonth"))});
        TypedQuery query = this.em.createQuery(where);
        List resultList = query.getResultList();
        return new PageImpl(resultList, Pageable.unpaged(), (long)resultList.size());
    }

    @Nonnull
    public Optional<PayrollMonth> findByUserAndYearMonthNotFailing(@NonNull User user, @NonNull YearMonth yearMonth) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        return this.repository.findByUserAndAccountingMonth(user, yearMonth.atDay(1));
    }

    @Nonnull
    public Iterable<PayrollMonth> findByUserAndYearMonthNotFailing(@NonNull Iterable<User> users, @NonNull YearMonth yearMonth) {
        if (users == null) {
            throw new NullPointerException("users is marked non-null but is null");
        }
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        return this.repository.findByUserInAndAccountingMonth(users, yearMonth.atDay(1));
    }

    @Nonnull
    public Page<PayrollMonth> all(@NonNull PayrollMonthFilter payrollMonthFilter) {
        if (payrollMonthFilter == null) {
            throw new NullPointerException("payrollMonthFilter is marked non-null but is null");
        }
        int page = payrollMonthFilter.getPage();
        int size = payrollMonthFilter.getSize();
        PageRequest pageRequest = PageRequest.of((int)page, (int)size);
        return this.repository.findAll(Specification.where((Specification)PayrollMonthRepository.filter((PayrollMonthFilter)payrollMonthFilter)), (Pageable)pageRequest);
    }

    @Nonnull
    public PayrollMonth updateStateToReleased(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        return (PayrollMonth)this.update((EntityBase)this.applyReleased(payrollMonth));
    }

    @Nonnull
    public PayrollMonth updateStateToUnreleased(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        return (PayrollMonth)this.update((EntityBase)this.applyUnreleased(payrollMonth));
    }

    @Nonnull
    public PayrollMonth updateSlipPrinted(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        return (PayrollMonth)this.update((EntityBase)this.applyPrintSlip(payrollMonth));
    }

    @Nonnull
    public Iterable<PayrollMonth> updateExportedFlags(@NonNull Iterable<PayrollMonth> payrollMonths) {
        if (payrollMonths == null) {
            throw new NullPointerException("payrollMonths is marked non-null but is null");
        }
        Iterable payrollMonthsExportApplied = (Iterable)Streams.stream(payrollMonths).map(arg_0 -> this.applyExported(arg_0)).collect(ImmutableList.toImmutableList());
        return this.update(payrollMonthsExportApplied);
    }

    @Nonnull
    private PayrollMonth applyExported(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        User authenticatedUser = this.userService.authenticatedUser();
        payrollMonth.setExportedWage(payrollMonth.getCurrentWage());
        payrollMonth.setExportedBy(authenticatedUser);
        payrollMonth.setExportedOn(DateTimeHelper.now());
        return payrollMonth;
    }

    @Nonnull
    private PayrollMonth applyReleased(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        User authenticatedUser = this.userService.authenticatedUser();
        payrollMonth.setPayrollMonthState(EPayrollMonthState.RELEASED);
        payrollMonth.setReleasedBy(authenticatedUser);
        payrollMonth.setReleasedOn(DateTimeHelper.now());
        return payrollMonth;
    }

    @Nonnull
    private PayrollMonth applyUnreleased(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        payrollMonth.setPayrollMonthState(EPayrollMonthState.UNRELEASED);
        payrollMonth.setReleasedBy(null);
        payrollMonth.setReleasedOn(null);
        return payrollMonth;
    }

    @Nonnull
    private PayrollMonth applyPrintSlip(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        User authenticatedUser = this.userService.authenticatedUser();
        payrollMonth.setSlipPrintedBy(authenticatedUser);
        payrollMonth.setSlipPrintedOn(DateTimeHelper.now());
        return payrollMonth;
    }

    @Nonnull
    public Iterable<IAggregatedPayrollUser> releasedPayrollIdAndUserIdForMonth(@NonNull LocalDate accountingMonth) {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        return this.repository.payrollIdAndUserIdForMonth(accountingMonth, EPayrollMonthState.RELEASED);
    }

    @Nonnull
    public Iterable<PayrollMonth> releasedPayrollMonthsByUsersAndAccountingMonth(@NonNull Iterable<User> usersToValidateReleasedState, @NonNull YearMonth accountingMonth) {
        if (usersToValidateReleasedState == null) {
            throw new NullPointerException("usersToValidateReleasedState is marked non-null but is null");
        }
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        return this.repository.findReleasedPayrollMonthsByUserInAndAccountingMonthEqualsAndPayrollMonthStateIn(usersToValidateReleasedState, accountingMonth.atDay(1), (Iterable)ImmutableSet.of((Object)EPayrollMonthState.RELEASED));
    }

    @Nonnull
    public Iterable<Long> idsSortedByName(@NonNull Iterable<Long> ids) {
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        return this.repository.idsSortedByName(ids);
    }

    @Nonnull
    public Iterable<PayrollMonth> findByAccountingMonthGreaterThanEqual(@NonNull YearMonth accountingMonth) {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        return this.repository.findByAccountingMonthGreaterThanEqual(accountingMonth.atDay(1));
    }

    @Nonnull
    public Iterable<PayrollMonth> payrollMonthsWithBadWeatherAttendances(@NonNull Long excludeUserId, @NonNull YearMonth accountingMonth) {
        if (excludeUserId == null) {
            throw new NullPointerException("excludeUserId is marked non-null but is null");
        }
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        return this.repository.payrollMonthsWithAttendanceDayTypes(excludeUserId, accountingMonth.atDay(1), (Iterable)ImmutableSet.of((Object)EAttendanceDayType.BAD_WEATHER, (Object)EAttendanceDayType.BAD_WEATHER_SICK));
    }
}

