/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.configuration.ApplicationConfig;
import de.qfm.erp.service.helper.ReferenceIdHelper;
import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.EYearMonthDateRange;
import de.qfm.erp.service.model.internal.StringSearchFilter;
import de.qfm.erp.service.model.internal.costcenter.CostCenterFilter;
import de.qfm.erp.service.model.internal.dashboard.IReportCountDateBigDecimalBigDecimal;
import de.qfm.erp.service.model.internal.dashboard.ReportDateBigDecimal;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.invoice.EPdfExtractType;
import de.qfm.erp.service.model.internal.measurement.AggMeasurementWage;
import de.qfm.erp.service.model.internal.measurement.IMeasurementListingItem;
import de.qfm.erp.service.model.internal.measurement.MeasurementAccountData;
import de.qfm.erp.service.model.internal.measurement.MeasurementAmountPriceWage;
import de.qfm.erp.service.model.internal.measurement.MeasurementDashboard;
import de.qfm.erp.service.model.internal.measurement.MeasurementExport;
import de.qfm.erp.service.model.internal.measurement.MeasurementFilter;
import de.qfm.erp.service.model.internal.measurement.PsxRelevantMeasurementState;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.measurement.MeasurementState;
import de.qfm.erp.service.model.jpa.measurement.PssReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.ReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementType;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.search.ESearchIndexState;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.repository.BaseRepository;
import de.qfm.erp.service.repository.EagerMeasurementRepository;
import de.qfm.erp.service.repository.MeasurementRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import de.qfm.erp.service.service.security.UserService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MeasurementHandler
extends BaseHandler<Measurement> {
    private static final Logger log = LogManager.getLogger(MeasurementHandler.class);
    private static final Joiner CATCH_ALL_JOINER = Joiner.on((String)" ").skipNulls();
    @PersistenceContext
    private EntityManager em;
    private final ApplicationConfig applicationConfig;
    private final EagerMeasurementRepository eagerRepository;
    private final MeasurementRepository repository;
    private final UserService userService;

    @Autowired
    public MeasurementHandler(StandardPersistenceHelper standardPersistenceHelper, ApplicationConfig applicationConfig, EagerMeasurementRepository eagerRepository, MeasurementRepository repository, UserService userService) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.applicationConfig = applicationConfig;
        this.eagerRepository = eagerRepository;
        this.repository = repository;
        this.userService = userService;
    }

    @Nonnull
    public Measurement byMeasurementNumberFailing(@NonNull String measurementNumber) {
        if (measurementNumber == null) {
            throw new NullPointerException("measurementNumber is marked non-null but is null");
        }
        Optional byId = this.byMeasurementNumberNotFailing(measurementNumber);
        if (byId.isEmpty()) {
            throw ResourceNotFoundException.of((String)Measurement.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.MEASUREMENT__MEASUREMENT_NUMBER), (String)measurementNumber);
        }
        return (Measurement)byId.get();
    }

    @Nonnull
    public Optional<Measurement> byMeasurementNumberNotFailing(@NonNull String measurementNumber) {
        if (measurementNumber == null) {
            throw new NullPointerException("measurementNumber is marked non-null but is null");
        }
        return this.repository.findByMeasurementNumber(measurementNumber);
    }

    @Nonnull
    public Page<IMeasurementListingItem> all(int page, int size, @NonNull Iterable<Long> seedIds, @NonNull String filterCostCenter, @NonNull String filterPosition, @NonNull Iterable<Quotation> filterStage, @NonNull Iterable<User> filterUsers, @NonNull Range<LocalDate> filterProjectExecution, @Nullable LocalDate filterAccountingMonth, @NonNull Iterable<String> filterPsxConstructionSiteReferenceIds, @NonNull Iterable<String> filterPsxReleaseOrderReferenceIds, @NonNull Boolean optionShowOnlyTemporary, @NonNull Boolean optionMyMeasurements, @NonNull Boolean optionIncludeDeleted, @NonNull Boolean optionRecent) {
        if (seedIds == null) {
            throw new NullPointerException("seedIds is marked non-null but is null");
        }
        if (filterCostCenter == null) {
            throw new NullPointerException("filterCostCenter is marked non-null but is null");
        }
        if (filterPosition == null) {
            throw new NullPointerException("filterPosition is marked non-null but is null");
        }
        if (filterStage == null) {
            throw new NullPointerException("filterStage is marked non-null but is null");
        }
        if (filterUsers == null) {
            throw new NullPointerException("filterUsers is marked non-null but is null");
        }
        if (filterProjectExecution == null) {
            throw new NullPointerException("filterProjectExecution is marked non-null but is null");
        }
        if (filterPsxConstructionSiteReferenceIds == null) {
            throw new NullPointerException("filterPsxConstructionSiteReferenceIds is marked non-null but is null");
        }
        if (filterPsxReleaseOrderReferenceIds == null) {
            throw new NullPointerException("filterPsxReleaseOrderReferenceIds is marked non-null but is null");
        }
        if (optionShowOnlyTemporary == null) {
            throw new NullPointerException("optionShowOnlyTemporary is marked non-null but is null");
        }
        if (optionMyMeasurements == null) {
            throw new NullPointerException("optionMyMeasurements is marked non-null but is null");
        }
        if (optionIncludeDeleted == null) {
            throw new NullPointerException("optionIncludeDeleted is marked non-null but is null");
        }
        if (optionRecent == null) {
            throw new NullPointerException("optionRecent is marked non-null but is null");
        }
        CriteriaBuilder criteriaBuilder = this.em.getCriteriaBuilder();
        CriteriaQuery countCriteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root countRoot = countCriteriaQuery.from(Measurement.class);
        Join countProd_M_MS = countRoot.join("measurementState", JoinType.LEFT);
        Join countProd_M_RO = countRoot.join("releaseOrder", JoinType.LEFT);
        Join countProd_M_Q = countRoot.join("quotation", JoinType.LEFT);
        Join countProd_M_CBU = countRoot.join("createdByUser", JoinType.LEFT);
        Join countProd_M_AU = countRoot.join("assignedUser", JoinType.LEFT);
        Join countProd_M_MP = countRoot.join("measurementPositions", JoinType.LEFT);
        ImmutableList predicatesCount = this.measurementPredicates(seedIds, filterCostCenter, filterPosition, (Iterable)ImmutableList.of(), filterStage, filterUsers, filterProjectExecution, filterAccountingMonth, optionShowOnlyTemporary, optionMyMeasurements, optionIncludeDeleted, optionRecent, (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), countProd_M_CBU, countProd_M_AU, countProd_M_MS, criteriaBuilder, countRoot, countProd_M_RO, countProd_M_Q, Optional.of(countProd_M_MP));
        Predicate predicateCount = criteriaBuilder.and((Predicate[])predicatesCount.toArray(Predicate[]::new));
        CriteriaQuery totalQuery = countCriteriaQuery.select((Selection)criteriaBuilder.countDistinct((Expression)countRoot)).where((Expression)predicateCount);
        Long total = (Long)this.em.createQuery(totalQuery).getSingleResult();
        if (size > 0) {
            CriteriaQuery dataCriteriaQuery = criteriaBuilder.createQuery(IMeasurementListingItem.class);
            Root dataRoot = dataCriteriaQuery.from(Measurement.class);
            Join childrenProd_M_MS = dataRoot.join("measurementState", JoinType.LEFT);
            Join childrenProd_M_I = dataRoot.join("invoice", JoinType.LEFT);
            Join childrenProd_I_U = childrenProd_M_I.join("primaryResponsibleUser", JoinType.LEFT);
            Join childrenProd_M_RO = dataRoot.join("releaseOrder", JoinType.LEFT);
            Join childrenProd_RO_PSSRO = childrenProd_M_RO.join("pssReleaseOrder", JoinType.LEFT);
            Join childrenProd_M_Q = dataRoot.join("quotation", JoinType.LEFT);
            Join childrenProd_Q_C = childrenProd_M_Q.join("customer", JoinType.LEFT);
            Join childrenProd_Q_P = childrenProd_M_Q.join("project", JoinType.LEFT);
            Join childrenProd_M_CBU = dataRoot.join("createdByUser", JoinType.LEFT);
            Join childrenProd_M_AU = dataRoot.join("assignedUser", JoinType.LEFT);
            Join childrenProd_U_UCU = MeasurementRepository.MeasurementSpecifications.assignedUserCostCenter((CriteriaBuilder)criteriaBuilder, (Root)dataRoot, (Join)childrenProd_M_AU);
            Join childrenProd_M_MP = dataRoot.join("measurementPositions", JoinType.LEFT);
            ImmutableList predicates = this.measurementPredicates(seedIds, filterCostCenter, filterPosition, (Iterable)ImmutableList.of(), filterStage, filterUsers, filterProjectExecution, filterAccountingMonth, optionShowOnlyTemporary, optionMyMeasurements, optionIncludeDeleted, optionRecent, filterPsxConstructionSiteReferenceIds, filterPsxReleaseOrderReferenceIds, childrenProd_M_CBU, childrenProd_M_AU, childrenProd_M_MS, criteriaBuilder, dataRoot, childrenProd_M_RO, childrenProd_M_Q, Optional.of(childrenProd_M_MP));
            Predicate predicate = criteriaBuilder.and((Predicate[])predicates.toArray(Predicate[]::new));
            CriteriaQuery measurementListingQuery = dataCriteriaQuery.multiselect(new Selection[]{dataRoot.get("id").alias("id"), dataRoot.get("createdOn").alias("createdOn"), dataRoot.get("createdBy").alias("createdBy"), dataRoot.get("updatedOn").alias("updatedOn"), dataRoot.get("updatedBy").alias("updatedBy"), dataRoot.get("measurementNumber").alias("measurementNumber"), childrenProd_M_MS.get("measurementState").alias("measurementState"), childrenProd_M_MS.get("measurementStateSince").alias("measurementStateSince"), childrenProd_M_Q.get("id").alias("stageId"), childrenProd_M_Q.get("qNumber").alias("stageNumber"), childrenProd_M_Q.get("alias").alias("stageAlias"), childrenProd_M_Q.get("version").alias("stageVersion"), childrenProd_M_Q.get("orderNumber").alias("stageOrderNumber"), childrenProd_Q_P.get("id").alias("projectId"), childrenProd_Q_P.get("name").alias("projectName"), childrenProd_Q_P.get("referenceId").alias("projectReferenceId"), childrenProd_M_RO.get("id").alias("releaseOrderId"), childrenProd_M_RO.get("name").alias("releaseOrderName"), childrenProd_RO_PSSRO.get("pssId").alias("pssReleaseOrderPSSId"), childrenProd_RO_PSSRO.get("pssState").alias("pssReleaseOrderPSSState"), childrenProd_M_RO.get("psxEntityId").alias("psxEntityId"), childrenProd_M_RO.get("psxEntityType").alias("psxEntityType"), childrenProd_M_RO.get("psxNumber").alias("psxNumber"), childrenProd_M_RO.get("psxConstructionSitePsxNumber").alias("psxConstructionSitePsxNumber"), childrenProd_M_RO.get("psxReleaseOrderPsxNumber").alias("psxReleaseOrderPsxNumber"), childrenProd_M_RO.get("psxConstructionSiteReferenceId").alias("psxConstructionSiteReferenceId"), childrenProd_M_RO.get("psxReleaseOrderReferenceId").alias("psxReleaseOrderReferenceId"), childrenProd_M_RO.get("psxConstructionSiteStateName").alias("psxConstructionSiteStateName"), childrenProd_M_RO.get("psxReleaseOrderStateName").alias("psxReleaseOrderStateName"), dataRoot.get("constructionSite").alias("constructionSite"), dataRoot.get("projectExecutionStartDate").alias("projectExecutionStartDate"), dataRoot.get("projectExecutionEndDate").alias("projectExecutionEndDate"), dataRoot.get("accountingMonth").alias("accountingMonth"), dataRoot.get("accountingMonthPlanned").alias("accountingMonthPlanned"), dataRoot.get("squadWageOverall").alias("squadWageOverall"), dataRoot.get("valueOverall").alias("valueOverall"), dataRoot.get("materialSellingPriceOverall").alias("materialSellingPriceOverall"), dataRoot.get("materialPurchasePriceOverall").alias("materialPurchasePriceOverall"), dataRoot.get("companyWageOverall").alias("companyWageOverall"), childrenProd_Q_C.get("id").alias("stageCustomerId"), childrenProd_Q_C.get("name").alias("stageCustomerName"), dataRoot.get("externalServicePurchasePriceOverall").alias("externalServicePurchasePriceOverall"), dataRoot.get("externalServiceSellingPriceOverall").alias("externalServiceSellingPriceOverall"), childrenProd_M_I.get("invoiceNumber").alias("invoiceNumber"), childrenProd_M_I.get("invoiceDate").alias("invoiceDate"), childrenProd_M_I.get("postingDate").alias("invoicePostingDate"), childrenProd_I_U.get("fullName").alias("invoicePrimaryResponsibleUserName"), childrenProd_M_AU.get("fullName").alias("assignedUserFullName"), dataRoot.get("personResponsibleAtCustomer").alias("personResponsibleAtCustomer"), dataRoot.get("addendumNumbers").alias("addendumNumbers"), dataRoot.get("measurementType").alias("measurementType"), childrenProd_U_UCU.get("costCenter").alias("assignedUserCostCenter"), dataRoot.get("remarks").alias("remarks"), dataRoot.get("remarksInternal").alias("remarksInternal")}).where((Expression)predicate).distinct(true).orderBy(new Order[]{criteriaBuilder.desc((Expression)dataRoot.get("updatedOn"))});
            PageRequest pageRequest = PageRequest.of((int)page, (int)size);
            TypedQuery dataQuery = this.em.createQuery(measurementListingQuery).setFirstResult((int)pageRequest.getOffset()).setMaxResults(pageRequest.getPageSize());
            List data = dataQuery.getResultList();
            return new PageImpl(data, (Pageable)pageRequest, total.longValue());
        }
        return new PageImpl((List)ImmutableList.of(), Pageable.unpaged(), total.longValue());
    }

    @Nonnull
    public Iterable<MeasurementAccountData> measurementAccountData(@NonNull Iterable<Long> filterStageIds) {
        if (filterStageIds == null) {
            throw new NullPointerException("filterStageIds is marked non-null but is null");
        }
        CriteriaBuilder criteriaBuilder = this.em.getCriteriaBuilder();
        CriteriaQuery dataCriteriaQuery = criteriaBuilder.createQuery(MeasurementAccountData.class);
        Root dataRoot = dataCriteriaQuery.from(Measurement.class);
        Join childrenProd_M_MS = dataRoot.join("measurementState", JoinType.LEFT);
        Join childrenProd_M_I = dataRoot.join("invoice", JoinType.LEFT);
        Join childrenProd_M_RO = dataRoot.join("releaseOrder", JoinType.LEFT);
        Join childrenProd_M_Q = dataRoot.join("quotation", JoinType.LEFT);
        Join childrenProd_M_CBU = dataRoot.join("createdByUser", JoinType.LEFT);
        Join childrenProd_M_AU = dataRoot.join("assignedUser", JoinType.LEFT);
        ImmutableList predicates = this.measurementPredicates((Iterable)ImmutableSet.of(), "", "", filterStageIds, (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), Range.all(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), childrenProd_M_CBU, childrenProd_M_AU, childrenProd_M_MS, criteriaBuilder, dataRoot, childrenProd_M_RO, childrenProd_M_Q, Optional.empty());
        Predicate predicate = criteriaBuilder.and((Predicate[])predicates.toArray(Predicate[]::new));
        CriteriaQuery measurementListingQuery = dataCriteriaQuery.multiselect(new Selection[]{dataRoot.get("id").alias("measurementId"), childrenProd_M_Q.get("id").alias("stageId"), dataRoot.get("measurementNumber").alias("measurementNumber"), childrenProd_M_MS.get("measurementState").alias("measurementState"), dataRoot.get("projectExecutionStartDate").alias("projectExecutionStartDate"), dataRoot.get("valueOverall").alias("valueOverall"), childrenProd_M_I.get("invoiceDate").alias("invoiceDate")}).where((Expression)predicate).distinct(true);
        TypedQuery dataQuery = this.em.createQuery(measurementListingQuery);
        return dataQuery.getResultList();
    }

    @Nonnull
    private ImmutableList<Predicate> measurementPredicates(Iterable<Long> seedIds, String filterCostCenter, String filterPosition, Iterable<Long> filterStageIds, Iterable<Quotation> filterStage, Iterable<User> filterUsers, Range<LocalDate> filterProjectExecution, LocalDate filterAccountingMonth, Boolean optionShowOnlyTemporary, Boolean optionMyMeasurements, Boolean optionIncludeDeleted, Boolean optionRecent, Iterable<String> filterPsxConstructionSiteReferenceIds, Iterable<String> filterPsxReleaseOrderReferenceIds, Join<Measurement, User> childrenProd_M_CBU, Join<Measurement, User> childrenProd_M_AU, Join<Measurement, MeasurementState> childrenProd_M_MS, CriteriaBuilder criteriaBuilder, Root<Measurement> fetchRoot, Join<Measurement, ReleaseOrder> childrenProd_M_RO, Join<Measurement, Quotation> childrenProd_M_Q, Optional<Join<Measurement, MeasurementPosition>> childrenProd_M_MPOpt) {
        ImmutableList.Builder predicatesBuilder = ImmutableList.builder();
        boolean hasAllMeasurementsPermission = this.userService.hasPrivilege(EPrivilege.ACCESS_MEASUREMENT_ALL);
        boolean hasOpCreateMeasurement = this.userService.hasPrivilege(EPrivilege.OP_MEASUREMENT_CREATE);
        if (!hasAllMeasurementsPermission && hasOpCreateMeasurement || Boolean.TRUE == optionMyMeasurements) {
            User user = this.userService.authenticatedUser();
            MeasurementRepository.MeasurementSpecifications.assignedUserInOrCreatedByUserIn((CriteriaBuilder)criteriaBuilder, childrenProd_M_CBU, childrenProd_M_AU, (Iterable)ImmutableList.of((Object)user)).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        } else {
            MeasurementRepository.MeasurementSpecifications.assignedUserIn(childrenProd_M_AU, filterUsers).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        }
        Iterable relevantEntityStates = Boolean.TRUE == optionIncludeDeleted ? EntityState.ENTITY_STATES__ALL : EntityState.ENTITY_STATES__NOT_DELETED;
        MeasurementRepository.MeasurementSpecifications.entityStatesIn(fetchRoot, (Iterable)relevantEntityStates).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        Set relevantMeasurementStates = Boolean.TRUE == optionShowOnlyTemporary ? EMeasurementState.NOT_ACCOUNTED_STATES : ImmutableSet.copyOf((Object[])EMeasurementState.values());
        MeasurementRepository.MeasurementSpecifications.measurementStateIn(childrenProd_M_MS, (Iterable)relevantMeasurementStates).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        CostCenterFilter costCenterFilter = CostCenterFilter.from((String)filterCostCenter);
        MeasurementRepository.MeasurementSpecifications.userCostCenter((CriteriaBuilder)criteriaBuilder, fetchRoot, childrenProd_M_AU, (CostCenterFilter)costCenterFilter).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        MeasurementRepository.MeasurementSpecifications.projectExecutionIntersect((CriteriaBuilder)criteriaBuilder, fetchRoot, filterProjectExecution).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        ImmutableSet accountingMonths = null != filterAccountingMonth ? ImmutableSet.of((Object)filterAccountingMonth) : ImmutableSet.of();
        MeasurementRepository.MeasurementSpecifications.accountingMonthIn((CriteriaBuilder)criteriaBuilder, fetchRoot, (Iterable)accountingMonths).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        MeasurementRepository.MeasurementSpecifications.psxConstructionSiteReferenceIdIn(childrenProd_M_RO, filterPsxConstructionSiteReferenceIds).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        MeasurementRepository.MeasurementSpecifications.psxReleaseOrderReferenceIdIn(childrenProd_M_RO, filterPsxReleaseOrderReferenceIds).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        if (Boolean.TRUE == optionRecent) {
            LocalDate referenceDate = DateTimeHelper.today().minusDays(this.applicationConfig.getMeasurementListingRecentDays());
            predicatesBuilder.add((Object)MeasurementRepository.MeasurementSpecifications.updatedOnDateGE((CriteriaBuilder)criteriaBuilder, fetchRoot, (LocalDateTime)referenceDate.atStartOfDay()));
        }
        if (childrenProd_M_MPOpt.isPresent()) {
            Join<Measurement, MeasurementPosition> childrenProd_M_MP = childrenProd_M_MPOpt.get();
            StringSearchFilter stringSearchFilter = StringSearchFilter.from((String)filterPosition);
            MeasurementRepository.MeasurementSpecifications.position((CriteriaBuilder)criteriaBuilder, childrenProd_M_MP, (StringSearchFilter)stringSearchFilter).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        }
        MeasurementRepository.MeasurementSpecifications.stageIn(childrenProd_M_Q, filterStage).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        MeasurementRepository.MeasurementSpecifications.stageIdIn(childrenProd_M_Q, filterStageIds).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        MeasurementRepository.MeasurementSpecifications.idsIn((CriteriaBuilder)criteriaBuilder, fetchRoot, seedIds).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        return predicatesBuilder.build();
    }

    @Nonnull
    public Page<Measurement> allEager(int page, int size, boolean includeDeleted) {
        Iterable relevantEntityStates = includeDeleted ? EntityState.ENTITY_STATES__ALL : EntityState.ENTITY_STATES__NOT_DELETED;
        PageRequest pageRequest = PageRequest.of((int)page, (int)size);
        Page idsInPage = this.repository.findEntityIds((Pageable)pageRequest, relevantEntityStates);
        ArrayList result = Lists.newArrayList();
        HashSet measurementIds = Sets.newHashSet((Iterable)idsInPage.getContent());
        if (!Iterables.isEmpty((Iterable)measurementIds)) {
            MeasurementRepository.MeasurementSpecifications.idIn((Iterable)measurementIds).ifPresent(spec -> result.addAll(this.eagerRepository.findAll(spec)));
        }
        return PageableExecutionUtils.getPage((List)result, (Pageable)pageRequest, () -> ((Page)idsInPage).getTotalElements());
    }

    @Nonnull
    public Page<Measurement> search(int page, int size, @NonNull String query, boolean includeDeleted) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        Iterable relevantEntityStates = includeDeleted ? EntityState.ENTITY_STATES__ALL : EntityState.ENTITY_STATES__NOT_DELETED;
        return this.repository.search((Pageable)PageRequest.of((int)page, (int)size), query, relevantEntityStates);
    }

    protected Class<Measurement> clazz() {
        return Measurement.class;
    }

    @Nonnull
    protected Measurement beforeUpdate(@NonNull Measurement item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        String catchAll = MeasurementHandler.catchAll((Measurement)item);
        item.setCatchAll(catchAll);
        item.setSearchIndexState(ESearchIndexState.NOT_INDEXED);
        item.getMeasurementPositions().forEach(mp -> mp.setReferenceId(ReferenceIdHelper.from((MeasurementPosition)mp)));
        return item;
    }

    @Nonnull
    protected Measurement beforeDelete(@NonNull Measurement item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        String catchAll = MeasurementHandler.catchAll((Measurement)item);
        item.setCatchAll(catchAll);
        item.setSearchIndexState(ESearchIndexState.NOT_INDEXED);
        item.getMeasurementPositions().forEach(mp -> mp.setReferenceId(ReferenceIdHelper.from((MeasurementPosition)mp)));
        return item;
    }

    @Nonnull
    protected Measurement afterUpdate(@NonNull Measurement item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected Measurement afterDelete(@NonNull Measurement item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @VisibleForTesting
    static String catchAll(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        return CATCH_ALL_JOINER.join((Object)measurement.getId(), (Object)measurement.getMeasurementNumber(), new Object[]{measurement.getConstructionSite(), measurement.getAccountingMonth()});
    }

    @Nonnull
    public Measurement byReferenceIdFailing(@NonNull String referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        Optional byId = this.byReferenceIdNotFailing(referenceId);
        if (byId.isEmpty()) {
            throw ResourceNotFoundException.of((String)Measurement.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.REFERENCE_ID), (String)referenceId);
        }
        return (Measurement)byId.get();
    }

    @Nonnull
    public Optional<Measurement> byReferenceIdNotFailing(@NonNull String referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        return this.repository.findByReferenceId(referenceId);
    }

    @Nonnull
    public Iterable<Measurement> byIdsFailing(@NonNull Iterable<Long> idsRequested) {
        if (idsRequested == null) {
            throw new NullPointerException("idsRequested is marked non-null but is null");
        }
        Iterable items = this.allByIds(idsRequested);
        Map<Long, Measurement> itemsExistingById = Streams.stream((Iterable)items).collect(Collectors.toMap(Measurement::getId, item -> item));
        Set<Long> idsExisting = itemsExistingById.keySet();
        Sets.SetView idsMissing = Sets.difference(idsExisting, (Set)ImmutableSet.copyOf(idsRequested));
        if (!idsMissing.isEmpty()) {
            String idsMissingMsg = ID_JOINER.join((Iterable)idsMissing);
            throw ResourceNotFoundException.of((String)Measurement.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ID), (String)idsMissingMsg);
        }
        return ImmutableList.copyOf((Iterable)items);
    }

    @Nonnull
    public Iterable<IReportCountDateBigDecimalBigDecimal> sumInMonth(@NonNull LocalDate referenceDate, @NonNull Iterable<User> referenceUsers) {
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        if (referenceUsers == null) {
            throw new NullPointerException("referenceUsers is marked non-null but is null");
        }
        return this.repository.measurementAmountsInMonth(referenceDate, referenceUsers);
    }

    public boolean dirty() {
        return !this.repository.findAllUnIndexed((Iterable)ImmutableSet.of((Object)ESearchIndexState.UNKNOWN, (Object)ESearchIndexState.NOT_INDEXED), (Pageable)PageRequest.of((int)0, (int)1)).isEmpty();
    }

    @Nonnull
    public Iterable<Measurement> dirtyPage(int max) {
        return this.repository.findAllUnIndexed((Iterable)ImmutableSet.of((Object)ESearchIndexState.UNKNOWN, (Object)ESearchIndexState.NOT_INDEXED), (Pageable)PageRequest.of((int)0, (int)max, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"updatedOn", "id"})));
    }

    @Nonnull
    public List<MeasurementAmountPriceWage> amountPriceWageById(@NonNull Iterable<Long> stageIds, @NonNull Iterable<String> surrogatePositionNumbers, @NonNull Iterable<EMeasurementState> measurementStates, @NonNull Range<LocalDate> projectExecutionFilterRange, @NonNull Iterable<User> assignedUsers, @NonNull Iterable<String> costCenters) {
        if (stageIds == null) {
            throw new NullPointerException("stageIds is marked non-null but is null");
        }
        if (surrogatePositionNumbers == null) {
            throw new NullPointerException("surrogatePositionNumbers is marked non-null but is null");
        }
        if (measurementStates == null) {
            throw new NullPointerException("measurementStates is marked non-null but is null");
        }
        if (projectExecutionFilterRange == null) {
            throw new NullPointerException("projectExecutionFilterRange is marked non-null but is null");
        }
        if (assignedUsers == null) {
            throw new NullPointerException("assignedUsers is marked non-null but is null");
        }
        if (costCenters == null) {
            throw new NullPointerException("costCenters is marked non-null but is null");
        }
        LocalDate dateRangeFrom = projectExecutionFilterRange.hasLowerBound() ? (LocalDate)projectExecutionFilterRange.lowerEndpoint() : BaseRepository.MIN_DATE;
        LocalDate dateRangeTo = projectExecutionFilterRange.hasUpperBound() ? (LocalDate)projectExecutionFilterRange.upperEndpoint() : BaseRepository.MAX_DATE;
        CriteriaBuilder criteriaBuilder = this.em.getCriteriaBuilder();
        CriteriaQuery fetchQuery = criteriaBuilder.createQuery(MeasurementAmountPriceWage.class);
        Root fetchRoot = fetchQuery.from(Measurement.class);
        Join childrenProd_M_MS = fetchRoot.join("measurementState", JoinType.LEFT);
        Join childrenProd_M_Q = fetchRoot.join("quotation", JoinType.LEFT);
        Join childrenProd_M_MP = fetchRoot.join("measurementPositions", JoinType.LEFT);
        Join childrenProd_MP_QP = childrenProd_M_MP.join("quotationPosition", JoinType.LEFT);
        Join childrenProd_QP_QP = childrenProd_MP_QP.join("referencePosition", JoinType.LEFT);
        Join childrenProd_QP_Q = childrenProd_MP_QP.join("quotation", JoinType.LEFT);
        Join childrenProd_Q_QE = childrenProd_QP_Q.join("qEntity", JoinType.LEFT);
        Join childrenProd_Q_P = childrenProd_QP_Q.join("project", JoinType.LEFT);
        Join childrenProd_Q_SP = childrenProd_QP_Q.join("subProject", JoinType.LEFT);
        Join childrenProd_M_U = fetchRoot.join("assignedUser", JoinType.LEFT);
        Join childrenProd_U_UCU = MeasurementRepository.MeasurementSpecifications.assignedUserCostCenter((CriteriaBuilder)criteriaBuilder, (Root)fetchRoot, (Join)childrenProd_M_U);
        ImmutableList.Builder predicatesBuilder = ImmutableList.builder();
        MeasurementRepository.MeasurementSpecifications.stageIdIn((Join)childrenProd_M_Q, stageIds).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        MeasurementRepository.MeasurementSpecifications.stageIdInQPQ((Join)childrenProd_QP_Q, stageIds).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        MeasurementRepository.MeasurementSpecifications.measurementStateIn((Join)childrenProd_M_MS, measurementStates).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        MeasurementRepository.MeasurementSpecifications.measurementPositionSPNIn((Join)childrenProd_M_MP, surrogatePositionNumbers).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        predicatesBuilder.add((Object)MeasurementRepository.MeasurementSpecifications.projectExecutionStartDateLE((CriteriaBuilder)criteriaBuilder, (Root)fetchRoot, (LocalDate)dateRangeTo));
        predicatesBuilder.add((Object)MeasurementRepository.MeasurementSpecifications.projectExecutionEndDateGE((CriteriaBuilder)criteriaBuilder, (Root)fetchRoot, (LocalDate)dateRangeFrom));
        MeasurementRepository.MeasurementSpecifications.assignedUserIn((Join)childrenProd_M_U, assignedUsers).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        MeasurementRepository.MeasurementSpecifications.assignedUserCostCentersIn((Join)childrenProd_U_UCU, costCenters).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        ImmutableList predicates = predicatesBuilder.build();
        Predicate predicate = criteriaBuilder.and((Predicate[])predicates.toArray(Predicate[]::new));
        CriteriaQuery amountPriceWageQuery = fetchQuery.multiselect(new Selection[]{fetchRoot.get("id"), childrenProd_QP_Q.get("id").alias("stageId"), childrenProd_QP_Q.get("qNumber").alias("stageNumber"), childrenProd_QP_Q.get("alias").alias("stageAlias"), childrenProd_QP_Q.get("version").alias("stageVersion"), childrenProd_Q_QE.get("id").alias("entityId"), childrenProd_Q_QE.get("qNumber").alias("entityNumber"), childrenProd_Q_QE.get("alias").alias("entityAlias"), childrenProd_Q_P.get("id").alias("projectId"), childrenProd_Q_P.get("name").alias("projectName"), childrenProd_Q_P.get("referenceId").alias("projectReferenceId"), childrenProd_Q_SP.get("id").alias("subProjectId"), childrenProd_Q_SP.get("name").alias("subProjectName"), childrenProd_MP_QP.get("id").alias("positionId"), childrenProd_QP_QP.get("id").alias("referencePositionId"), childrenProd_M_MP.get("addendumNumber").alias("addendumNumber"), childrenProd_M_MP.get("positionType").alias("positionType"), childrenProd_M_MP.get("surrogatePositionNumber").alias("surrogatePositionNumber"), childrenProd_M_MP.get("alternativePositionType").alias("alternativePositionType"), childrenProd_M_MP.get("pricePerUnit").alias("pricePerUnit"), childrenProd_M_MS.get("measurementState").alias("measurementState"), criteriaBuilder.sum((Expression)childrenProd_M_MP.get("product")).alias("product"), criteriaBuilder.sum((Expression)childrenProd_M_MP.get("priceAggregated")).alias("price"), criteriaBuilder.sum((Expression)childrenProd_M_MP.get("internalSquadWageAggregated")).alias("squadWageAggregated"), criteriaBuilder.sum((Expression)childrenProd_M_MP.get("companyWageAggregated")).alias("companyWageAggregated"), criteriaBuilder.sum((Expression)childrenProd_M_MP.get("materialSellingPriceAggregated")).alias("materialSellingPriceAggregated"), criteriaBuilder.sum((Expression)childrenProd_M_MP.get("externalServiceSellingPriceAggregated")).alias("externalServiceSellingPriceAggregated")}).where((Expression)predicate).distinct(true).groupBy(new Expression[]{fetchRoot.get("id"), childrenProd_QP_Q.get("id"), childrenProd_QP_Q.get("qNumber"), childrenProd_QP_Q.get("alias"), childrenProd_QP_Q.get("version"), childrenProd_Q_QE.get("id"), childrenProd_Q_QE.get("qNumber"), childrenProd_Q_QE.get("alias"), childrenProd_Q_P.get("id"), childrenProd_Q_P.get("name"), childrenProd_Q_P.get("referenceId"), childrenProd_Q_SP.get("id"), childrenProd_Q_SP.get("name"), childrenProd_MP_QP.get("id"), childrenProd_QP_QP.get("id"), childrenProd_M_MP.get("addendumNumber"), childrenProd_M_MP.get("positionType"), childrenProd_M_MP.get("surrogatePositionNumber"), childrenProd_M_MP.get("alternativePositionType"), childrenProd_M_MP.get("pricePerUnit"), childrenProd_M_MS.get("measurementState")});
        TypedQuery query = this.em.createQuery(amountPriceWageQuery);
        return query.getResultList();
    }

    @Nonnull
    public List<MeasurementAmountPriceWage> amountPriceWageBySPN(@NonNull Iterable<Long> stageIds, @NonNull Iterable<String> surrogatePositionNumbers, @NonNull Iterable<EMeasurementState> measurementStates, @NonNull Range<LocalDate> projectExecutionFilterRange, @NonNull Iterable<User> assignedUsers, @NonNull Iterable<String> costCenters) {
        if (stageIds == null) {
            throw new NullPointerException("stageIds is marked non-null but is null");
        }
        if (surrogatePositionNumbers == null) {
            throw new NullPointerException("surrogatePositionNumbers is marked non-null but is null");
        }
        if (measurementStates == null) {
            throw new NullPointerException("measurementStates is marked non-null but is null");
        }
        if (projectExecutionFilterRange == null) {
            throw new NullPointerException("projectExecutionFilterRange is marked non-null but is null");
        }
        if (assignedUsers == null) {
            throw new NullPointerException("assignedUsers is marked non-null but is null");
        }
        if (costCenters == null) {
            throw new NullPointerException("costCenters is marked non-null but is null");
        }
        LocalDate dateRangeFrom = projectExecutionFilterRange.hasLowerBound() ? (LocalDate)projectExecutionFilterRange.lowerEndpoint() : BaseRepository.MIN_DATE;
        LocalDate dateRangeTo = projectExecutionFilterRange.hasUpperBound() ? (LocalDate)projectExecutionFilterRange.upperEndpoint() : BaseRepository.MAX_DATE;
        CriteriaBuilder criteriaBuilder = this.em.getCriteriaBuilder();
        CriteriaQuery fetchQuery = criteriaBuilder.createQuery(MeasurementAmountPriceWage.class);
        Root fetchRoot = fetchQuery.from(Measurement.class);
        Join childrenProd_M_MS = fetchRoot.join("measurementState", JoinType.LEFT);
        Join childrenProd_M_Q = fetchRoot.join("quotation", JoinType.LEFT);
        Join childrenProd_Q_QE = childrenProd_M_Q.join("qEntity", JoinType.LEFT);
        Join childrenProd_Q_P = childrenProd_M_Q.join("project", JoinType.LEFT);
        Join childrenProd_Q_SP = childrenProd_M_Q.join("subProject", JoinType.LEFT);
        Join childrenProd_M_MP = fetchRoot.join("measurementPositions", JoinType.LEFT);
        Join childrenProd_MP_QP = childrenProd_M_MP.join("quotationPosition", JoinType.LEFT);
        Join childrenProd_QP_QP = childrenProd_MP_QP.join("referencePosition", JoinType.LEFT);
        Join childrenProd_M_U = fetchRoot.join("assignedUser", JoinType.LEFT);
        Join childrenProd_U_UCU = MeasurementRepository.MeasurementSpecifications.assignedUserCostCenter((CriteriaBuilder)criteriaBuilder, (Root)fetchRoot, (Join)childrenProd_M_U);
        ImmutableList.Builder predicatesBuilder = ImmutableList.builder();
        MeasurementRepository.MeasurementSpecifications.stageIdIn((Join)childrenProd_M_Q, stageIds).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        MeasurementRepository.MeasurementSpecifications.measurementStateIn((Join)childrenProd_M_MS, measurementStates).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        MeasurementRepository.MeasurementSpecifications.measurementPositionSPNIn((Join)childrenProd_M_MP, surrogatePositionNumbers).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        predicatesBuilder.add((Object)MeasurementRepository.MeasurementSpecifications.projectExecutionStartDateLE((CriteriaBuilder)criteriaBuilder, (Root)fetchRoot, (LocalDate)dateRangeTo));
        predicatesBuilder.add((Object)MeasurementRepository.MeasurementSpecifications.projectExecutionEndDateGE((CriteriaBuilder)criteriaBuilder, (Root)fetchRoot, (LocalDate)dateRangeFrom));
        MeasurementRepository.MeasurementSpecifications.assignedUserIn((Join)childrenProd_M_U, assignedUsers).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        MeasurementRepository.MeasurementSpecifications.assignedUserCostCentersIn((Join)childrenProd_U_UCU, costCenters).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        ImmutableList predicates = predicatesBuilder.build();
        Predicate predicate = criteriaBuilder.and((Predicate[])predicates.toArray(Predicate[]::new));
        CriteriaQuery amountPriceWageQuery = fetchQuery.multiselect(new Selection[]{fetchRoot.get("id"), childrenProd_M_Q.get("id").alias("stageId"), childrenProd_M_Q.get("qNumber").alias("stageNumber"), childrenProd_M_Q.get("alias").alias("stageAlias"), childrenProd_M_Q.get("version").alias("stageVersion"), childrenProd_Q_QE.get("id").alias("entityId"), childrenProd_Q_QE.get("qNumber").alias("entityNumber"), childrenProd_Q_QE.get("alias").alias("entityAlias"), childrenProd_Q_P.get("id").alias("projectId"), childrenProd_Q_P.get("name").alias("projectName"), childrenProd_Q_P.get("referenceId").alias("projectReferenceId"), childrenProd_Q_SP.get("id").alias("subProjectId"), childrenProd_Q_SP.get("name").alias("subProjectName"), childrenProd_MP_QP.get("id").alias("positionId"), childrenProd_QP_QP.get("id").alias("referencePositionId"), childrenProd_M_MP.get("addendumNumber").alias("addendumNumber"), childrenProd_M_MP.get("positionType").alias("positionType"), childrenProd_M_MP.get("surrogatePositionNumber").alias("surrogatePositionNumber"), childrenProd_M_MP.get("alternativePositionType").alias("alternativePositionType"), childrenProd_M_MP.get("pricePerUnit").alias("pricePerUnit"), childrenProd_M_MS.get("measurementState").alias("measurementState"), criteriaBuilder.sum((Expression)childrenProd_M_MP.get("product")).alias("product"), criteriaBuilder.sum((Expression)childrenProd_M_MP.get("priceAggregated")).alias("price"), criteriaBuilder.sum((Expression)childrenProd_M_MP.get("internalWageAggregated")).alias("internalWageAggregated"), criteriaBuilder.sum((Expression)childrenProd_M_MP.get("companyWageAggregated")).alias("companyWageAggregated"), criteriaBuilder.sum((Expression)childrenProd_M_MP.get("materialSellingPriceAggregated")).alias("materialSellingPriceAggregated"), criteriaBuilder.sum((Expression)childrenProd_M_MP.get("externalServiceSellingPriceAggregated")).alias("externalServiceSellingPriceAggregated")}).where((Expression)predicate).distinct(true).groupBy(new Expression[]{fetchRoot.get("id"), childrenProd_M_Q.get("id"), childrenProd_M_Q.get("qNumber"), childrenProd_M_Q.get("alias"), childrenProd_M_Q.get("version"), childrenProd_Q_QE.get("id"), childrenProd_Q_QE.get("qNumber"), childrenProd_Q_QE.get("alias"), childrenProd_Q_P.get("id"), childrenProd_Q_P.get("name"), childrenProd_Q_P.get("referenceId"), childrenProd_Q_SP.get("id"), childrenProd_Q_SP.get("name"), childrenProd_MP_QP.get("id"), childrenProd_QP_QP.get("id"), childrenProd_M_MP.get("addendumNumber"), childrenProd_M_MP.get("positionType"), childrenProd_M_MP.get("surrogatePositionNumber"), childrenProd_M_MP.get("alternativePositionType"), childrenProd_M_MP.get("pricePerUnit"), childrenProd_M_MS.get("measurementState")});
        TypedQuery query = this.em.createQuery(amountPriceWageQuery);
        return query.getResultList();
    }

    @Nonnull
    public Iterable<AggMeasurementWage> measurementWagesByStage(@NonNull LocalDate accountingMonth, @NonNull EYearMonthDateRange yearMonthDateRange, @NonNull Iterable<String> quotationNumbers, @NonNull Iterable<User> assignedUsers) {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        if (yearMonthDateRange == null) {
            throw new NullPointerException("yearMonthDateRange is marked non-null but is null");
        }
        if (quotationNumbers == null) {
            throw new NullPointerException("quotationNumbers is marked non-null but is null");
        }
        if (assignedUsers == null) {
            throw new NullPointerException("assignedUsers is marked non-null but is null");
        }
        Range dateRange = yearMonthDateRange.from(accountingMonth);
        CriteriaBuilder criteriaBuilder = this.em.getCriteriaBuilder();
        CriteriaQuery fetchQuery = criteriaBuilder.createQuery(AggMeasurementWage.class);
        Root fetchRoot = fetchQuery.from(Measurement.class);
        Join childrenProd_M_MS = fetchRoot.join("measurementState", JoinType.LEFT);
        Join childrenProd_M_Q = fetchRoot.join("quotation", JoinType.LEFT);
        Join childrenProd_M_U = fetchRoot.join("assignedUser", JoinType.LEFT);
        Join childrenProd_Q_P = childrenProd_M_Q.join("project", JoinType.LEFT);
        ArrayList predicates = Lists.newArrayList();
        MeasurementRepository.MeasurementSpecifications.accountingMonthBetween((Range)dateRange).ifPresent(item -> predicates.add(item.toPredicate(fetchRoot, fetchQuery, criteriaBuilder)));
        MeasurementRepository.MeasurementSpecifications.noQuotationNumberEnded((Join)childrenProd_M_Q).ifPresent(item -> predicates.add(item.toPredicate(fetchRoot, fetchQuery, criteriaBuilder)));
        MeasurementRepository.MeasurementSpecifications.assignedUserIn((Join)childrenProd_M_U, assignedUsers).ifPresent(predicates::add);
        MeasurementRepository.MeasurementSpecifications.measurementStateIn((Join)childrenProd_M_MS, (Iterable)EMeasurementState.ALL_RELEVANT_FOR_WAGE).ifPresent(predicates::add);
        MeasurementRepository.MeasurementSpecifications.quotationNumberIn((Join)childrenProd_M_Q, quotationNumbers).ifPresent(predicates::add);
        Predicate predicate = criteriaBuilder.and((Predicate[])predicates.toArray(Predicate[]::new));
        CriteriaQuery where = fetchQuery.multiselect(new Selection[]{childrenProd_M_Q.get("quotationNumber").alias("quotationNumber"), childrenProd_M_Q.get("id").alias("stageId"), childrenProd_M_Q.get("qNumber").alias("stageNumber"), childrenProd_M_Q.get("alias").alias("stageAlias"), childrenProd_M_Q.get("version").alias("stageVersion"), childrenProd_Q_P.get("name").alias("projectName"), childrenProd_Q_P.get("referenceId").alias("projectReferenceId"), fetchRoot.get("measurementNumber").alias("measurementNumber"), fetchRoot.get("accountingMonth").alias("accountingMonth"), fetchRoot.get("wageOverall").alias("wageOverall"), fetchRoot.get("squadWageOverall").alias("squadWageOverall")}).where((Expression)predicate).distinct(true).orderBy(new Order[]{criteriaBuilder.asc((Expression)childrenProd_M_Q.get("quotationNumber")), criteriaBuilder.asc((Expression)fetchRoot.get("measurementNumber")), criteriaBuilder.asc((Expression)fetchRoot.get("accountingMonth"))});
        TypedQuery query = this.em.createQuery(where);
        List resultList = query.getResultList();
        return new PageImpl(resultList, Pageable.unpaged(), (long)resultList.size());
    }

    @Nonnull
    public Iterable<String> quotationNumbersFromMeasurementsForAssignedUser(@NonNull PayrollMonth payrollMonth, @NonNull EYearMonthDateRange yearMonthDateRange) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        if (yearMonthDateRange == null) {
            throw new NullPointerException("yearMonthDateRange is marked non-null but is null");
        }
        User assignedUser = payrollMonth.getUser();
        Range dateRange = yearMonthDateRange.from(payrollMonth.getAccountingMonth());
        return ImmutableSet.copyOf((Collection)this.repository.quotationNumbersFromMeasurementsForAssignedUser(assignedUser, (LocalDate)dateRange.lowerEndpoint(), (LocalDate)dateRange.upperEndpoint()));
    }

    @Nonnull
    public Long countOtherWithPssReleaseOrderInState(@NonNull Measurement measurement, @Nullable PssReleaseOrder pssReleaseOrder, @NonNull EMeasurementType measurementType, @NonNull Iterable<EMeasurementState> mustBeInMeasurementStates) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (measurementType == null) {
            throw new NullPointerException("measurementType is marked non-null but is null");
        }
        if (mustBeInMeasurementStates == null) {
            throw new NullPointerException("mustBeInMeasurementStates is marked non-null but is null");
        }
        Long measurementId = measurement.getId();
        if (null != pssReleaseOrder && null != pssReleaseOrder.getId()) {
            ImmutableSet measurementIds = null != measurementId ? ImmutableSet.of((Object)measurementId) : ImmutableSet.of();
            return this.repository.countMeasurementsWithPSSRO((Iterable)measurementIds, (Iterable)ImmutableSet.of((Object)measurementType), (Iterable)ImmutableSet.copyOf(mustBeInMeasurementStates), (Iterable)ImmutableSet.of((Object)pssReleaseOrder));
        }
        return 0L;
    }

    @Nonnull
    public Iterable<Measurement> otherWithPssReleaseOrderInState(@NonNull Measurement measurement, @NonNull EMeasurementType measurementType, @NonNull Iterable<EMeasurementState> mustBeInMeasurementStates, int maxResults) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (measurementType == null) {
            throw new NullPointerException("measurementType is marked non-null but is null");
        }
        if (mustBeInMeasurementStates == null) {
            throw new NullPointerException("mustBeInMeasurementStates is marked non-null but is null");
        }
        ReleaseOrder releaseOrder = measurement.getReleaseOrder();
        PssReleaseOrder pssReleaseOrder = null != releaseOrder ? releaseOrder.getPssReleaseOrder() : null;
        return this.otherWithPssReleaseOrderInState(measurement, pssReleaseOrder, measurementType, mustBeInMeasurementStates, maxResults);
    }

    @Nonnull
    public Iterable<Measurement> otherWithPssReleaseOrderInState(@NonNull Measurement measurement, @Nullable PssReleaseOrder pssReleaseOrder, @NonNull EMeasurementType measurementType, @NonNull Iterable<EMeasurementState> mustBeInMeasurementStates, int maxResults) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (measurementType == null) {
            throw new NullPointerException("measurementType is marked non-null but is null");
        }
        if (mustBeInMeasurementStates == null) {
            throw new NullPointerException("mustBeInMeasurementStates is marked non-null but is null");
        }
        Long measurementId = measurement.getId();
        if (null != pssReleaseOrder && null != pssReleaseOrder.getId()) {
            ImmutableSet measurementIds = null != measurementId ? ImmutableSet.of((Object)measurementId) : ImmutableSet.of();
            return this.repository.allMeasurementsWithPSSRO((Iterable)measurementIds, (Iterable)ImmutableSet.of((Object)measurementType), (Iterable)ImmutableSet.copyOf(mustBeInMeasurementStates), (Iterable)ImmutableSet.of((Object)pssReleaseOrder), maxResults);
        }
        return ImmutableList.of();
    }

    @Nonnull
    public Page<MeasurementDashboard> dashboard(@NonNull MeasurementFilter measurementFilter) {
        if (measurementFilter == null) {
            throw new NullPointerException("measurementFilter is marked non-null but is null");
        }
        Pageable pageable = measurementFilter.getPageable();
        ImmutableSet.Builder limitToUserIdsBuilder = ImmutableSet.builder();
        boolean hasAllMeasurementsPermission = this.userService.hasPrivilege(EPrivilege.ACCESS_MEASUREMENT_ALL);
        if (!hasAllMeasurementsPermission) {
            User user = this.userService.authenticatedUser();
            limitToUserIdsBuilder.add((Object)user.getId());
        }
        ImmutableSet limitToUserIds = limitToUserIdsBuilder.build();
        CriteriaBuilder criteriaBuilder = this.em.getCriteriaBuilder();
        CriteriaQuery fetchQuery = criteriaBuilder.createQuery(MeasurementDashboard.class);
        Root fetchRoot = fetchQuery.from(Measurement.class);
        Join childrenProd_M_MS = fetchRoot.join("measurementState", JoinType.LEFT);
        Join childrenProd_M_MP = fetchRoot.join("measurementPositions", JoinType.LEFT);
        Join childrenProd_M_I = fetchRoot.join("invoice", JoinType.LEFT);
        Join childrenProd_I_PRU = childrenProd_M_I.join("primaryResponsibleUser", JoinType.LEFT);
        Join childrenProd_M_U = fetchRoot.join("assignedUser", JoinType.LEFT);
        Join childrenProd_M_Q = fetchRoot.join("quotation", JoinType.LEFT);
        Join childrenProd_Q_E = childrenProd_M_Q.join("qEntity", JoinType.LEFT);
        Join childrenProd_Q_P = childrenProd_M_Q.join("project", JoinType.LEFT);
        Join childrenProd_Q_C = childrenProd_M_Q.join("customer", JoinType.LEFT);
        Join childrenProd_M_RO = fetchRoot.join("releaseOrder", JoinType.LEFT);
        Join childrenProd_U_UCU = MeasurementRepository.MeasurementSpecifications.assignedUserCostCenter((CriteriaBuilder)criteriaBuilder, (Root)fetchRoot, (Join)childrenProd_M_U);
        Join childrenProd_RO_PSSRO = childrenProd_M_RO.join("pssReleaseOrder", JoinType.LEFT);
        List predicates = MeasurementRepository.predicates((MeasurementFilter)measurementFilter, (Root)fetchRoot, (Join)childrenProd_M_Q, (Join)childrenProd_Q_E, (Join)childrenProd_Q_P, (Join)childrenProd_M_I, (Join)childrenProd_M_MS, (Join)childrenProd_M_MP, (Join)childrenProd_M_U, (Join)childrenProd_U_UCU, (CriteriaBuilder)criteriaBuilder, (Iterable)limitToUserIds);
        Predicate predicate = criteriaBuilder.and((Predicate[])predicates.toArray(Predicate[]::new));
        CriteriaQuery where = fetchQuery.multiselect(new Selection[]{fetchRoot.get("id").alias("id"), fetchRoot.get("measurementNumber").alias("measurementNumber"), fetchRoot.get("createdOn").alias("createdOn"), fetchRoot.get("createdBy").alias("createdBy"), fetchRoot.get("updatedOn").alias("updatedOn"), fetchRoot.get("updatedBy").alias("updatedBy"), fetchRoot.get("constructionSite").alias("constructionSite"), fetchRoot.get("personResponsibleAtCustomer").alias("personResponsibleAtCustomer"), childrenProd_M_MS.get("createdOn").alias("measurementStateOn"), childrenProd_M_MS.get("createdBy").alias("measurementStateBy"), childrenProd_M_MS.get("measurementState").alias("measurementState"), fetchRoot.get("measurementType").alias("measurementType"), fetchRoot.get("projectExecutionStartDate").alias("projectExecutionStartDate"), fetchRoot.get("projectExecutionEndDate").alias("projectExecutionEndDate"), fetchRoot.get("accountingMonth").alias("accountingMonth"), fetchRoot.get("accountingMonthPlanned").alias("accountingMonthPlanned"), childrenProd_M_Q.get("quotationNumber").alias("stageQuotationNumber"), childrenProd_M_Q.get("qNumber").alias("stageQNumber"), childrenProd_M_Q.get("alias").alias("stageAlias"), childrenProd_M_Q.get("version").alias("stageVersion"), childrenProd_M_Q.get("orderNumber").alias("stageOrderNumber"), childrenProd_Q_P.get("name").alias("projectName"), childrenProd_Q_P.get("referenceId").alias("projectReferenceId"), childrenProd_Q_E.get("qNumber").alias("entityQNumber"), childrenProd_Q_E.get("alias").alias("entityAlias"), childrenProd_Q_C.get("name").alias("stageCustomerName"), childrenProd_M_RO.get("name").alias("releaseOrderName"), fetchRoot.get("internalWageOverall").alias("internalWageOverall"), fetchRoot.get("squadWageOverall").alias("squadWageOverall"), fetchRoot.get("valueOverall").alias("valueOverall"), fetchRoot.get("companyWageOverall").alias("companyWageOverall"), fetchRoot.get("materialPurchasePriceOverall").alias("materialPurchasePriceOverall"), fetchRoot.get("materialSellingPriceOverall").alias("materialSellingPriceOverall"), fetchRoot.get("externalServicePurchasePriceOverall").alias("externalServicePurchasePriceOverall"), fetchRoot.get("externalServiceSellingPriceOverall").alias("externalServiceSellingPriceOverall"), childrenProd_U_UCU.get("costCenter").alias("assignedUserCostCenter"), childrenProd_M_U.get("personalNumber").alias("assignedUserPersonalNumber"), childrenProd_M_U.get("fullName").alias("assignedUserFullName"), childrenProd_RO_PSSRO.get("pssId").alias("pssId"), childrenProd_RO_PSSRO.get("pssState").alias("pssState"), childrenProd_M_I.get("invoiceDate").alias("invoiceDate"), childrenProd_M_I.get("postingDate").alias("invoicePostingDate"), childrenProd_M_I.get("invoiceNumber").alias("invoiceNumber"), childrenProd_M_I.get("orderNumber").alias("invoiceOrderNumber"), childrenProd_I_PRU.get("fullName").alias("invoiceResponsiblePersonFullName"), fetchRoot.get("remarks").alias("remarks"), fetchRoot.get("remarksInternal").alias("remarksInternal")}).where((Expression)predicate).distinct(true).orderBy(new Order[]{criteriaBuilder.asc((Expression)fetchRoot.get("measurementNumber"))});
        CriteriaQuery cq = criteriaBuilder.createQuery(Long.class);
        Root countRoot = cq.from(Measurement.class);
        Join countProd_M_MS = countRoot.join("measurementState", JoinType.LEFT);
        Join countProd_M_MP = countRoot.join("measurementPositions", JoinType.LEFT);
        Join countProd_M_I = countRoot.join("invoice", JoinType.LEFT);
        Join countProd_M_U = countRoot.join("assignedUser", JoinType.LEFT);
        Join countProd_M_Q = countRoot.join("quotation", JoinType.LEFT);
        Join countProd_Q_E = countProd_M_Q.join("qEntity", JoinType.LEFT);
        Join countProd_Q_P = countProd_M_Q.join("project", JoinType.LEFT);
        Join countProd_U_UCU = MeasurementRepository.MeasurementSpecifications.assignedUserCostCenter((CriteriaBuilder)criteriaBuilder, (Root)countRoot, (Join)countProd_M_U);
        List predicatesCount = MeasurementRepository.predicates((MeasurementFilter)measurementFilter, (Root)countRoot, (Join)countProd_M_Q, (Join)countProd_Q_E, (Join)countProd_Q_P, (Join)countProd_M_I, (Join)countProd_M_MS, (Join)countProd_M_MP, (Join)countProd_M_U, (Join)countProd_U_UCU, (CriteriaBuilder)criteriaBuilder, (Iterable)limitToUserIds);
        Predicate predicateCount = criteriaBuilder.and((Predicate[])predicatesCount.toArray(Predicate[]::new));
        cq.select((Selection)criteriaBuilder.count((Expression)countRoot));
        cq.where((Expression)predicateCount);
        Long count = (Long)this.em.createQuery(cq).getSingleResult();
        TypedQuery query = this.em.createQuery(where);
        if (pageable.isPaged()) {
            query.setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize());
        }
        List resultList = query.getResultList();
        return new PageImpl(resultList, pageable, count.longValue());
    }

    @Nonnull
    public Stream<MeasurementExport> xls(@NonNull MeasurementFilter measurementFilter) {
        if (measurementFilter == null) {
            throw new NullPointerException("measurementFilter is marked non-null but is null");
        }
        ImmutableSet.Builder limitToUserIdsBuilder = ImmutableSet.builder();
        boolean hasAllMeasurementsPermission = this.userService.hasPrivilege(EPrivilege.ACCESS_MEASUREMENT_ALL);
        if (!hasAllMeasurementsPermission) {
            User user = this.userService.authenticatedUser();
            limitToUserIdsBuilder.add((Object)user.getId());
        }
        ImmutableSet limitToUserIds = limitToUserIdsBuilder.build();
        CriteriaBuilder criteriaBuilder = this.em.getCriteriaBuilder();
        CriteriaQuery fetchQuery = criteriaBuilder.createQuery(MeasurementExport.class);
        Root fetchRoot = fetchQuery.from(Measurement.class);
        Join childrenProd_M_MS = fetchRoot.join("measurementState", JoinType.LEFT);
        Join childrenProd_M_MP = fetchRoot.join("measurementPositions", JoinType.LEFT);
        Join childrenProd_M_U = fetchRoot.join("assignedUser", JoinType.LEFT);
        Join childrenProd_M_Q = fetchRoot.join("quotation", JoinType.LEFT);
        Join childrenProd_Q_E = childrenProd_M_Q.join("qEntity", JoinType.LEFT);
        Join childrenProd_Q_P = childrenProd_M_Q.join("project", JoinType.LEFT);
        Join childrenProd_M_I = fetchRoot.join("invoice", JoinType.LEFT);
        Join childrenProd_M_RO = fetchRoot.join("releaseOrder", JoinType.LEFT);
        Join childrenProd_RO_PSS = childrenProd_M_RO.join("pssReleaseOrder", JoinType.LEFT);
        Join childrenProd_U_UCU = MeasurementRepository.MeasurementSpecifications.assignedUserCostCenter((CriteriaBuilder)criteriaBuilder, (Root)fetchRoot, (Join)childrenProd_M_U);
        List predicates = MeasurementRepository.predicates((MeasurementFilter)measurementFilter, (Root)fetchRoot, (Join)childrenProd_M_Q, (Join)childrenProd_Q_E, (Join)childrenProd_Q_P, (Join)childrenProd_M_I, (Join)childrenProd_M_MS, (Join)childrenProd_M_MP, (Join)childrenProd_M_U, (Join)childrenProd_U_UCU, (CriteriaBuilder)criteriaBuilder, (Iterable)limitToUserIds);
        Predicate predicate = criteriaBuilder.and((Predicate[])predicates.toArray(Predicate[]::new));
        CriteriaQuery where = fetchQuery.multiselect(new Selection[]{fetchRoot.get("measurementNumber").alias("measurementNumber"), childrenProd_M_MS.get("measurementState").alias("measurementState"), fetchRoot.get("measurementType").alias("measurementType"), fetchRoot.get("constructionSite").alias("constructionSite"), fetchRoot.get("personResponsibleAtCustomer").alias("personResponsibleAtCustomer"), fetchRoot.get("projectExecutionStartDate").alias("projectExecutionStartDate"), fetchRoot.get("projectExecutionEndDate").alias("projectExecutionEndDate"), fetchRoot.get("accountingMonth").alias("accountingMonth"), fetchRoot.get("addendumNumbers").alias("addendumNumbers"), childrenProd_M_U.get("fullName").alias("assignedUserFullName"), childrenProd_U_UCU.get("costCenter").alias("costCenter"), childrenProd_M_RO.get("name").alias("releaseOrderName"), childrenProd_RO_PSS.get("pssId").alias("pssReleaseOrderId"), childrenProd_RO_PSS.get("pssState").alias("pssReleaseOrderState"), childrenProd_M_I.get("invoiceNumber").alias("invoiceNumber"), fetchRoot.get("squadWageOverall").alias("squadWageOverall"), fetchRoot.get("valueOverall").alias("valueOverall"), fetchRoot.get("materialSellingPriceOverall").alias("materialSellingPriceOverall"), fetchRoot.get("materialPurchasePriceOverall").alias("materialPurchasePriceOverall"), fetchRoot.get("externalServicePurchasePriceOverall").alias("externalServicePurchasePriceOverall"), fetchRoot.get("externalServiceSellingPriceOverall").alias("externalServiceSellingPriceOverall"), fetchRoot.get("companyWageOverall").alias("companyWageOverall"), fetchRoot.get("internalWageOverall").alias("internalWageOverall")}).where((Expression)predicate).distinct(true).orderBy(new Order[]{criteriaBuilder.asc((Expression)fetchRoot.get("measurementNumber"))});
        return this.em.createQuery(where).getResultStream();
    }

    @Nonnull
    public Page<MeasurementDashboard> notAccounted(@NonNull MeasurementFilter measurementFilter) {
        if (measurementFilter == null) {
            throw new NullPointerException("measurementFilter is marked non-null but is null");
        }
        Pageable pageable = measurementFilter.getPageable();
        ImmutableSet.Builder limitToUserIdsBuilder = ImmutableSet.builder();
        boolean hasAllMeasurementsPermission = this.userService.hasPrivilege(EPrivilege.ACCESS_MEASUREMENT_ALL);
        if (!hasAllMeasurementsPermission) {
            User user = this.userService.authenticatedUser();
            limitToUserIdsBuilder.add((Object)user.getId());
        }
        ImmutableSet limitToUserIds = limitToUserIdsBuilder.build();
        CriteriaBuilder criteriaBuilder = this.em.getCriteriaBuilder();
        CriteriaQuery fetchQuery = criteriaBuilder.createQuery(MeasurementDashboard.class);
        Root fetchRoot = fetchQuery.from(Measurement.class);
        Join childrenProd_M_MS = fetchRoot.join("measurementState", JoinType.LEFT);
        Join childrenProd_M_MP = fetchRoot.join("measurementPositions", JoinType.LEFT);
        Join childrenProd_M_U = fetchRoot.join("assignedUser", JoinType.LEFT);
        Join childrenProd_M_Q = fetchRoot.join("quotation", JoinType.LEFT);
        Join childrenProd_Q_E = childrenProd_M_Q.join("qEntity", JoinType.LEFT);
        Join childrenProd_Q_P = childrenProd_M_Q.join("project", JoinType.LEFT);
        Join childrenProd_Q_C = childrenProd_M_Q.join("customer", JoinType.LEFT);
        Join childrenProd_M_I = fetchRoot.join("invoice", JoinType.LEFT);
        Join childrenProd_M_RO = fetchRoot.join("releaseOrder", JoinType.LEFT);
        Join childrenProd_U_UCU = MeasurementRepository.MeasurementSpecifications.assignedUserCostCenter((CriteriaBuilder)criteriaBuilder, (Root)fetchRoot, (Join)childrenProd_M_U);
        Join childrenProd_RO_PSSRO = childrenProd_M_RO.join("pssReleaseOrder", JoinType.LEFT);
        Join childrenProd_I_PRU = childrenProd_M_I.join("primaryResponsibleUser", JoinType.LEFT);
        List predicates = MeasurementRepository.predicates((MeasurementFilter)measurementFilter, (Root)fetchRoot, (Join)childrenProd_M_Q, (Join)childrenProd_Q_E, (Join)childrenProd_Q_P, (Join)childrenProd_M_I, (Join)childrenProd_M_MS, (Join)childrenProd_M_MP, (Join)childrenProd_M_U, (Join)childrenProd_U_UCU, (CriteriaBuilder)criteriaBuilder, (Iterable)limitToUserIds);
        Predicate predicate = criteriaBuilder.and((Predicate[])predicates.toArray(Predicate[]::new));
        CriteriaQuery where = fetchQuery.multiselect(new Selection[]{fetchRoot.get("id").alias("id"), fetchRoot.get("measurementNumber").alias("measurementNumber"), fetchRoot.get("createdOn").alias("createdOn"), fetchRoot.get("createdBy").alias("createdBy"), fetchRoot.get("updatedOn").alias("updatedOn"), fetchRoot.get("updatedBy").alias("updatedBy"), fetchRoot.get("constructionSite").alias("constructionSite"), fetchRoot.get("personResponsibleAtCustomer").alias("personResponsibleAtCustomer"), childrenProd_M_MS.get("createdOn").alias("measurementStateOn"), childrenProd_M_MS.get("createdBy").alias("measurementStateBy"), childrenProd_M_MS.get("measurementState").alias("measurementState"), fetchRoot.get("measurementType").alias("measurementType"), fetchRoot.get("projectExecutionStartDate").alias("projectExecutionStartDate"), fetchRoot.get("projectExecutionEndDate").alias("projectExecutionEndDate"), fetchRoot.get("accountingMonth").alias("accountingMonth"), fetchRoot.get("accountingMonthPlanned").alias("accountingMonthPlanned"), childrenProd_M_Q.get("quotationNumber").alias("stageQuotationNumber"), childrenProd_M_Q.get("qNumber").alias("stageQNumber"), childrenProd_M_Q.get("alias").alias("stageAlias"), childrenProd_M_Q.get("orderNumber").alias("stageOrderNumber"), childrenProd_Q_P.get("name").alias("projectName"), childrenProd_Q_P.get("referenceId").alias("projectReferenceId"), childrenProd_Q_E.get("qNumber").alias("entityQNumber"), childrenProd_Q_E.get("alias").alias("entityAlias"), childrenProd_Q_C.get("name").alias("stageCustomerName"), childrenProd_M_RO.get("name").alias("releaseOrderName"), fetchRoot.get("internalWageOverall").alias("internalWageOverall"), fetchRoot.get("squadWageOverall").alias("squadWageOverall"), fetchRoot.get("valueOverall").alias("valueOverall"), fetchRoot.get("companyWageOverall").alias("companyWageOverall"), fetchRoot.get("materialPurchasePriceOverall").alias("materialPurchasePriceOverall"), fetchRoot.get("materialSellingPriceOverall").alias("materialSellingPriceOverall"), fetchRoot.get("externalServicePurchasePriceOverall").alias("externalServicePurchasePriceOverall"), fetchRoot.get("externalServiceSellingPriceOverall").alias("externalServiceSellingPriceOverall"), childrenProd_U_UCU.get("costCenter").alias("assignedUserCostCenter"), childrenProd_M_U.get("personalNumber").alias("assignedUserPersonalNumber"), childrenProd_M_U.get("fullName").alias("assignedUserFullName"), childrenProd_RO_PSSRO.get("pssId").alias("pssId"), childrenProd_RO_PSSRO.get("pssState").alias("pssState"), childrenProd_M_I.get("invoiceDate").alias("invoiceDate"), childrenProd_M_I.get("postingDate").alias("invoicePostingDate"), childrenProd_M_I.get("invoiceNumber").alias("invoiceNumber"), childrenProd_M_I.get("orderNumber").alias("invoiceOrderNumber"), childrenProd_I_PRU.get("fullName").alias("invoiceResponsiblePersonFullName"), fetchRoot.get("remarks").alias("remarks"), fetchRoot.get("remarksInternal").alias("remarksInternal")}).where((Expression)predicate).distinct(true).orderBy(new Order[]{criteriaBuilder.asc((Expression)childrenProd_M_Q.get("qNumber")), criteriaBuilder.asc((Expression)childrenProd_U_UCU.get("costCenter")), criteriaBuilder.asc((Expression)fetchRoot.get("measurementNumber"))});
        CriteriaQuery cq = criteriaBuilder.createQuery(Long.class);
        Root countRoot = cq.from(Measurement.class);
        Join countProd_M_MS = countRoot.join("measurementState", JoinType.LEFT);
        Join countProd_M_U = countRoot.join("assignedUser", JoinType.LEFT);
        Join countProd_M_MP = countRoot.join("measurementPositions", JoinType.LEFT);
        Join countProd_M_Q = countRoot.join("quotation", JoinType.LEFT);
        Join countProd_M_I = countRoot.join("invoice", JoinType.LEFT);
        Join countProd_Q_E = countProd_M_Q.join("qEntity", JoinType.LEFT);
        Join countProd_Q_P = countProd_M_Q.join("project", JoinType.LEFT);
        Join countProd_U_UCU = MeasurementRepository.MeasurementSpecifications.assignedUserCostCenter((CriteriaBuilder)criteriaBuilder, (Root)countRoot, (Join)countProd_M_U);
        List predicatesCount = MeasurementRepository.predicates((MeasurementFilter)measurementFilter, (Root)countRoot, (Join)countProd_M_Q, (Join)countProd_Q_E, (Join)countProd_Q_P, (Join)countProd_M_I, (Join)countProd_M_MS, (Join)countProd_M_MP, (Join)countProd_M_U, (Join)countProd_U_UCU, (CriteriaBuilder)criteriaBuilder, (Iterable)limitToUserIds);
        Predicate predicateCount = criteriaBuilder.and((Predicate[])predicatesCount.toArray(Predicate[]::new));
        cq.select((Selection)criteriaBuilder.count((Expression)countRoot));
        cq.where((Expression)predicateCount);
        Long count = (Long)this.em.createQuery(cq).getSingleResult();
        TypedQuery query = this.em.createQuery(where);
        if (pageable.isPaged()) {
            query.setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize());
        }
        List resultList = query.getResultList();
        return new PageImpl(resultList, pageable, count.longValue());
    }

    @Nonnull
    public Page<Measurement> availableInvoiceMeasurements(@NonNull Iterable<Quotation> stages, @NonNull String filterText) {
        if (stages == null) {
            throw new NullPointerException("stages is marked non-null but is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        ImmutableList.Builder specsBuilder = ImmutableList.builder();
        MeasurementRepository.MeasurementSpecifications.entityStatesIn((Iterable)EntityState.ENTITY_STATES__NOT_DELETED).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        MeasurementRepository.MeasurementSpecifications.stageIn(stages).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        MeasurementRepository.MeasurementSpecifications.measurementNumberLike((String)filterText).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        MeasurementRepository.MeasurementSpecifications.availableForInvoice().ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        ImmutableList specs = specsBuilder.build();
        PageRequest pageRequest = PageRequest.of((int)0, (int)25, (Sort)Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"measurementNumber")}));
        Specification conjunction = MeasurementRepository.MeasurementSpecifications.conjunction((Specification)MeasurementRepository.MeasurementSpecifications.identity(), (Iterable)specs);
        return this.repository.findAll(conjunction, (Pageable)pageRequest);
    }

    public int markIndexed(@NonNull Iterable<Measurement> itemsProcessed) {
        if (itemsProcessed == null) {
            throw new NullPointerException("itemsProcessed is marked non-null but is null");
        }
        ImmutableSet measurementIDs = (ImmutableSet)Streams.stream(itemsProcessed).map(Measurement::getId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        return this.repository.updateSearchIndexState(ESearchIndexState.INDEXED, (Iterable)measurementIDs);
    }

    @Nonnull
    public Iterable<Measurement> newInvoiceAutoCompleteByText(@NonNull String filterText) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        ImmutableSet tokens = ImmutableSet.copyOf((Iterable)Splitter.on((char)' ').trimResults().split((CharSequence)filterText));
        ImmutableList.Builder specsBuilder = ImmutableList.builder();
        for (String token : tokens) {
            ImmutableList.Builder localSpecsBuilder = ImmutableList.builder();
            MeasurementRepository.MeasurementSpecifications.measurementNumberLike((String)token).ifPresent(arg_0 -> ((ImmutableList.Builder)localSpecsBuilder).add(arg_0));
            ImmutableList localSpecs = localSpecsBuilder.build();
            MeasurementRepository.MeasurementSpecifications.disjunction((Iterable)localSpecs).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        }
        MeasurementRepository.MeasurementSpecifications.availableForInvoice().ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        ImmutableList globalSpecs = specsBuilder.build();
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"id")});
        PageRequest pageRequest = PageRequest.of((int)0, (int)25, (Sort)sort);
        Specification conjunction = (Specification)MeasurementRepository.MeasurementSpecifications.conjunction((Iterable)globalSpecs).get();
        return this.repository.findAll(conjunction, (Pageable)pageRequest);
    }

    @Nonnull
    public Iterable<Measurement> allRelevant(@NonNull EPdfExtractType pdfExtractType, @NonNull Iterable<String> measurementNumbers) {
        if (pdfExtractType == null) {
            throw new NullPointerException("pdfExtractType is marked non-null but is null");
        }
        if (measurementNumbers == null) {
            throw new NullPointerException("measurementNumbers is marked non-null but is null");
        }
        return this.repository.allRelevant((Iterable)ImmutableSet.copyOf(measurementNumbers), (Iterable)ImmutableSet.of((Object)pdfExtractType));
    }

    @Nonnull
    public Iterable<ReportDateBigDecimal> valueOverallOverTime(Long stageId) {
        CriteriaBuilder criteriaBuilder = this.em.getCriteriaBuilder();
        CriteriaQuery fetchQuery = criteriaBuilder.createQuery(ReportDateBigDecimal.class);
        Root fetchRoot = fetchQuery.from(Measurement.class);
        Join childrenProd_M_Q = fetchRoot.join("quotation", JoinType.LEFT);
        Join childrenProd_M_MS = fetchRoot.join("measurementState", JoinType.LEFT);
        ImmutableList.Builder predicatesBuilder = ImmutableList.builder();
        MeasurementRepository.MeasurementSpecifications.stageIdIn((Join)childrenProd_M_Q, (Iterable)ImmutableSet.of((Object)stageId)).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        MeasurementRepository.MeasurementSpecifications.measurementStateIn((Join)childrenProd_M_MS, (Iterable)EMeasurementState.ALL_RELEVANT_FOR_WAGE).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        ImmutableList predicates = predicatesBuilder.build();
        Predicate predicate = criteriaBuilder.and((Predicate[])predicates.toArray(Predicate[]::new));
        CriteriaQuery amountPriceWageQuery = fetchQuery.multiselect(new Selection[]{fetchRoot.get("accountingMonth"), criteriaBuilder.sum((Expression)fetchRoot.get("valueOverall"))}).where((Expression)predicate).groupBy(new Expression[]{fetchRoot.get("accountingMonth")});
        TypedQuery query = this.em.createQuery(amountPriceWageQuery);
        return query.getResultList();
    }

    public int patchSheetNumberValue(@NonNull Long measurementId, @NonNull Long sheetNumberValueNew) {
        if (measurementId == null) {
            throw new NullPointerException("measurementId is marked non-null but is null");
        }
        if (sheetNumberValueNew == null) {
            throw new NullPointerException("sheetNumberValueNew is marked non-null but is null");
        }
        return this.repository.patchSheetNumberValue(measurementId, sheetNumberValueNew);
    }

    @Nonnull
    public Iterable<PsxRelevantMeasurementState> psxRelevantMeasurementStates(@NonNull Iterable<String> constructionSiteReferenceIds, @NonNull Iterable<String> releaseOrderReferenceIds) {
        if (constructionSiteReferenceIds == null) {
            throw new NullPointerException("constructionSiteReferenceIds is marked non-null but is null");
        }
        if (releaseOrderReferenceIds == null) {
            throw new NullPointerException("releaseOrderReferenceIds is marked non-null but is null");
        }
        CriteriaBuilder criteriaBuilder = this.em.getCriteriaBuilder();
        CriteriaQuery fetchQuery = criteriaBuilder.createQuery(PsxRelevantMeasurementState.class);
        Root fetchRoot = fetchQuery.from(Measurement.class);
        Join childrenProd_M_MS = fetchRoot.join("measurementState", JoinType.LEFT);
        Join childrenProd_M_RO = fetchRoot.join("releaseOrder", JoinType.LEFT);
        Join childrenProd_RO_PSSRO = childrenProd_M_RO.join("pssReleaseOrder", JoinType.LEFT);
        ImmutableList.Builder predicatesBuilder = ImmutableList.builder();
        MeasurementRepository.MeasurementSpecifications.psxCSReferenceIdIn((Join)childrenProd_RO_PSSRO, constructionSiteReferenceIds).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        MeasurementRepository.MeasurementSpecifications.psxROReferenceIdIn((Join)childrenProd_RO_PSSRO, releaseOrderReferenceIds).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        MeasurementRepository.MeasurementSpecifications.measurementTypesIn((Root)fetchRoot, (Iterable)EMeasurementType.PREVENT_FURTHER_PSS_MEASUREMENT_TYPES).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        MeasurementRepository.MeasurementSpecifications.measurementStateIn((Join)childrenProd_M_MS, (Iterable)EMeasurementState.PREVENT_FURTHER_PSS_MEASUREMENT_STATE).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        ImmutableList predicates = predicatesBuilder.build();
        Predicate predicate = criteriaBuilder.and((Predicate[])predicates.toArray(Predicate[]::new));
        CriteriaQuery amountPriceWageQuery = fetchQuery.multiselect(new Selection[]{fetchRoot.get("id").alias("measurementId"), fetchRoot.get("measurementNumber").alias("measurementNumber"), fetchRoot.get("measurementType").alias("measurementType"), childrenProd_M_MS.get("measurementState").alias("measurementState"), childrenProd_M_RO.get("psxReleaseOrderReferenceId").alias("psxReleaseOrderReferenceId")}).where((Expression)predicate);
        TypedQuery query = this.em.createQuery(amountPriceWageQuery);
        return query.getResultList();
    }
}

