/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.invoice.InvoiceAttachment;
import de.qfm.erp.service.repository.InvoiceAttachmentRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class InvoiceAttachmentHandler
extends BaseHandler<InvoiceAttachment> {
    @Autowired
    public InvoiceAttachmentHandler(@NonNull StandardPersistenceHelper standardPersistenceHelper, @NonNull InvoiceAttachmentRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        if (standardPersistenceHelper == null) {
            throw new NullPointerException("standardPersistenceHelper is marked non-null but is null");
        }
        if (repository == null) {
            throw new NullPointerException("repository is marked non-null but is null");
        }
    }

    protected Class<InvoiceAttachment> clazz() {
        return InvoiceAttachment.class;
    }

    @Nonnull
    protected InvoiceAttachment beforeUpdate(@NonNull InvoiceAttachment item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected InvoiceAttachment beforeDelete(@NonNull InvoiceAttachment item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected InvoiceAttachment afterUpdate(@NonNull InvoiceAttachment item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected InvoiceAttachment afterDelete(@NonNull InvoiceAttachment item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Iterable<InvoiceAttachment> byIdsFailing(@NonNull Iterable<Long> idsRequested) {
        if (idsRequested == null) {
            throw new NullPointerException("idsRequested is marked non-null but is null");
        }
        Iterable items = this.allByIds(idsRequested);
        Map<Long, InvoiceAttachment> itemsExistingById = Streams.stream((Iterable)items).collect(Collectors.toMap(InvoiceAttachment::getId, item -> item));
        Set<Long> idsExisting = itemsExistingById.keySet();
        Sets.SetView idsMissing = Sets.difference(idsExisting, (Set)ImmutableSet.copyOf(idsRequested));
        if (!idsMissing.isEmpty()) {
            String idsMissingMsg = ID_JOINER.join((Iterable)idsMissing);
            throw ResourceNotFoundException.of((String)Invoice.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ID), (String)idsMissingMsg);
        }
        return ImmutableList.copyOf((Iterable)items);
    }
}

