/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import de.qfm.erp.service.model.jpa.history.HistoryItem;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.repository.HistoryItemRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class HistoryItemHandler
extends BaseHandler<HistoryItem> {
    private static final Logger log = LogManager.getLogger(HistoryItemHandler.class);
    private final HistoryItemRepository repository;

    @Autowired
    public HistoryItemHandler(StandardPersistenceHelper standardPersistenceHelper, HistoryItemRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<HistoryItem> clazz() {
        return HistoryItem.class;
    }

    @Nonnull
    protected HistoryItem beforeUpdate(@NonNull HistoryItem item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected HistoryItem afterUpdate(@NonNull HistoryItem item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected HistoryItem afterDelete(@NonNull HistoryItem item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected HistoryItem beforeDelete(@NonNull HistoryItem item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Iterable<HistoryItem> save(@NonNull Iterable<HistoryItem> historyItems) {
        if (historyItems == null) {
            throw new NullPointerException("historyItems is marked non-null but is null");
        }
        historyItems.forEach(arg_0 -> ((HistoryItemHandler)this).baseUpdate(arg_0));
        return this.repository.saveAll(historyItems);
    }

    @Nonnull
    public Page<HistoryItem> pageForEntity(@NonNull EEntityClass eEntityClass, long entityId, int page, int size) {
        if (eEntityClass == null) {
            throw new NullPointerException("eEntityClass is marked non-null but is null");
        }
        return this.repository.findAllByEntityClassEqualsAndEntityIdEqualsOrderByIdDesc(eEntityClass, entityId, (Pageable)PageRequest.of((int)page, (int)size));
    }
}

