/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.jpa.generic.DictionaryItem;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.repository.DictionaryItemRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class DictionaryItemHandler
extends BaseHandler<DictionaryItem> {
    private static final Logger log = LogManager.getLogger(DictionaryItemHandler.class);
    private final DictionaryItemRepository repository;

    @Autowired
    public DictionaryItemHandler(StandardPersistenceHelper standardPersistenceHelper, DictionaryItemRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<DictionaryItem> clazz() {
        return DictionaryItem.class;
    }

    @Nonnull
    protected DictionaryItem beforeUpdate(@NonNull DictionaryItem item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected DictionaryItem afterUpdate(@NonNull DictionaryItem item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected DictionaryItem afterDelete(@NonNull DictionaryItem item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected DictionaryItem beforeDelete(@NonNull DictionaryItem item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Page<DictionaryItem> pageForEntity(@NonNull EEntityClass eEntityClass, int page, int size, String filterText, boolean flagHidden) {
        if (eEntityClass == null) {
            throw new NullPointerException("eEntityClass is marked non-null but is null");
        }
        PageRequest pageRequest = PageRequest.of((int)page, (int)size, (Sort)Sort.by((String[])new String[]{"sequentialNumber"}));
        return this.repository.findAll(Specification.where((Specification)DictionaryItemRepository.filter((String)filterText, (Iterable)ImmutableSet.of((Object)eEntityClass), (Iterable)ImmutableSet.of(), (boolean)flagHidden)), (Pageable)pageRequest);
    }

    @Nonnull
    public Page<DictionaryItem> pageForEntity(@NonNull EEntityClass eEntityClass, long entityId, int page, int size, String filterText, boolean flagHidden) {
        if (eEntityClass == null) {
            throw new NullPointerException("eEntityClass is marked non-null but is null");
        }
        PageRequest pageRequest = PageRequest.of((int)page, (int)size, (Sort)Sort.by((String[])new String[]{"sequentialNumber"}));
        return this.repository.findAll(Specification.where((Specification)DictionaryItemRepository.filter((String)filterText, (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of((Object)Pair.of((Object)eEntityClass, (Object)entityId)), (boolean)flagHidden)), (Pageable)pageRequest);
    }

    @Nonnull
    public Iterable<DictionaryItem> allForEntity(@NonNull EEntityClass eEntityClass, long entityId, String filterText, boolean flagHidden) {
        if (eEntityClass == null) {
            throw new NullPointerException("eEntityClass is marked non-null but is null");
        }
        return this.repository.findAll(Specification.where((Specification)DictionaryItemRepository.filter((String)filterText, (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of((Object)Pair.of((Object)eEntityClass, (Object)entityId)), (boolean)flagHidden)), Sort.by((String[])new String[]{"sequentialNumber"}));
    }

    @Nonnull
    public Page<DictionaryItem> page(int page, int size, String filterText, boolean flagHidden) {
        PageRequest pageRequest = PageRequest.of((int)page, (int)size, (Sort)Sort.by((String[])new String[]{"sequentialNumber"}));
        return this.repository.findAll(Specification.where((Specification)DictionaryItemRepository.filter((String)filterText, (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of(), (boolean)flagHidden)), (Pageable)pageRequest);
    }

    @Nonnull
    public Iterable<DictionaryItem> byNameIgnoreCaseNotFailing(@NonNull EEntityClass clazz, @NonNull String name) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        PageRequest pageRequest = PageRequest.of((int)0, (int)1, (Sort)Sort.by((String[])new String[]{"sequentialNumber"}));
        return this.repository.findAll(Specification.where((Specification)DictionaryItemRepository.filter((String)name, (Iterable)ImmutableSet.of((Object)clazz), (Iterable)ImmutableSet.of(), (boolean)false)), (Pageable)pageRequest);
    }
}

