/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.customer.ContactPerson;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.repository.ContactPersonRepository;
import de.qfm.erp.service.repository.CustomerRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class ContactPersonHandler
extends BaseHandler<ContactPerson> {
    private static final Logger log = LogManager.getLogger(ContactPersonHandler.class);
    private final ContactPersonRepository repository;

    @Autowired
    public ContactPersonHandler(StandardPersistenceHelper standardPersistenceHelper, ContactPersonRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<ContactPerson> clazz() {
        return ContactPerson.class;
    }

    @Nonnull
    protected ContactPerson beforeUpdate(@NonNull ContactPerson item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected ContactPerson afterUpdate(@NonNull ContactPerson item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected ContactPerson afterDelete(@NonNull ContactPerson item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected ContactPerson beforeDelete(@NonNull ContactPerson item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Page<ContactPerson> page(int page, int size, @NonNull Iterable<Customer> filterCustomers, @NonNull String filterText) {
        if (filterCustomers == null) {
            throw new NullPointerException("filterCustomers is marked non-null but is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        ImmutableList.Builder specsBuilder = ImmutableList.builder();
        ContactPersonRepository.ContactPersonSpec.entityStatesIn((Iterable)EntityState.ENTITY_STATES__NOT_DELETED).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        ContactPersonRepository.ContactPersonSpec.customerIn(filterCustomers).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        ContactPersonRepository.ContactPersonSpec.text((String)filterText).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        CustomerRepository.CustomerSpec.onlyValid().ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        specsBuilder.add((Object)ContactPersonRepository.ContactPersonSpec.identity((boolean)true));
        ImmutableList specs = specsBuilder.build();
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"lastName"), Sort.Order.asc((String)"firstName")});
        PageRequest pageRequest = PageRequest.of((int)page, (int)size, (Sort)sort);
        Specification conjunction = ContactPersonRepository.ContactPersonSpec.conjunction((Specification)ContactPersonRepository.ContactPersonSpec.identity((boolean)true), (Iterable)specs);
        return this.repository.findAll(conjunction, (Pageable)pageRequest);
    }
}

