/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.consumer;

import de.qfm.erp.service.model.internal.eventbus.InvoiceChangeMessage;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.queue.EQueueItemType;
import de.qfm.erp.service.model.jpa.queue.EReferenceType;
import de.qfm.erp.service.service.handler.QueueService;
import lombok.NonNull;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class InvoiceChangeMessageConsumer
implements ApplicationListener<InvoiceChangeMessage> {
    public final QueueService queueService;

    public void onApplicationEvent(@NonNull InvoiceChangeMessage invoiceChangeMessage) {
        if (invoiceChangeMessage == null) {
            throw new NullPointerException("invoiceChangeMessage is marked non-null but is null");
        }
        Invoice entity = (Invoice)invoiceChangeMessage.getEntity();
        Long id = entity.getId();
        this.queueService.append(EQueueItemType.UPDATED, EReferenceType.INVOICE, id);
    }

    public InvoiceChangeMessageConsumer(QueueService queueService) {
        this.queueService = queueService;
    }
}

