/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.calculator;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.internal.employee.payroll.EWageTypeCalculationResultType;
import de.qfm.erp.service.model.internal.employee.payroll.WageTypeCalculationResult;
import de.qfm.erp.service.model.internal.payroll.PayrollMonthCalculationBucket;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.calculator.wagetype.EWageType;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageCalculatorHelper;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageTypeCalculator;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class WageTypeTimesAsListCalculator
extends WageTypeCalculator {
    protected WageTypeTimesAsListCalculator(@NonNull EWageType wageType) {
        super(wageType);
        if (wageType == null) {
            throw new NullPointerException("wageType is marked non-null but is null");
        }
    }

    @Nonnull
    public Iterable<WageTypeCalculationResult> calculate(@NonNull PayrollMonthCalculationBucket payrollMonthCalculationBucket) {
        if (payrollMonthCalculationBucket == null) {
            throw new NullPointerException("payrollMonthCalculationBucket is marked non-null but is null");
        }
        PayrollMonth payrollMonth = payrollMonthCalculationBucket.getPayrollMonth();
        PayrollItemType payrollItemType = payrollMonthCalculationBucket.getPayrollItemType();
        User employee = payrollMonth.getUser();
        YearMonth yearMonth = WageCalculatorHelper.yearMonth((PayrollMonth)payrollMonth);
        List allPayrollMonthItems = payrollMonth.getPayrollMonthItems();
        Iterable auxiliaryPaymentPayrollMonthItems = this.auxiliaryPaymentWithPayrollMonthType((Iterable)allPayrollMonthItems, payrollItemType);
        BigDecimal amount = Streams.stream((Iterable)auxiliaryPaymentPayrollMonthItems).map(PayrollMonthItem::getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal effectiveWagePerHour = WageCalculatorHelper.effectiveWagePerHour((YearMonth)yearMonth, (User)employee);
        BigDecimal valueOverall = WageTypeTimesAsListCalculator.effectiveWageTotal((BigDecimal)amount, (BigDecimal)effectiveWagePerHour);
        WageTypeCalculationResult aggregationRow = WageTypeCalculationResult.of((EWageType)this.getWageType(), (PayrollItemType)payrollItemType, (LocalDate)yearMonth.atEndOfMonth(), (EWageTypeCalculationResultType)EWageTypeCalculationResultType.STANDARD, (Integer)0, (String)"", (BigDecimal)BigDecimal.ZERO, (BigDecimal)amount, (BigDecimal)effectiveWagePerHour, (BigDecimal)valueOverall, (String)"");
        ImmutableList.Builder detailRowsBuilder = ImmutableList.builder();
        AtomicInteger counter = new AtomicInteger();
        for (PayrollMonthItem auxiliaryPaymentPayrollMonthItem : auxiliaryPaymentPayrollMonthItems) {
            BigDecimal times = auxiliaryPaymentPayrollMonthItem.getValue();
            BigDecimal valuePerItem = WageTypeTimesAsListCalculator.effectiveWageTotal((BigDecimal)times, (BigDecimal)effectiveWagePerHour);
            detailRowsBuilder.add((Object)WageTypeTimesAsListCalculator.detail((EWageType)this.getWageType(), (LocalDate)yearMonth.atEndOfMonth(), (AtomicInteger)counter, (PayrollItemType)payrollItemType, (PayrollMonthItem)auxiliaryPaymentPayrollMonthItem, (BigDecimal)times, (BigDecimal)effectiveWagePerHour, (BigDecimal)valuePerItem));
        }
        ImmutableList detailRows = detailRowsBuilder.build();
        return ImmutableList.builder().add((Object)aggregationRow).addAll((Iterable)detailRows).build();
    }

    @Nonnull
    protected static WageTypeCalculationResult detail(@NonNull EWageType wageType, @NonNull LocalDate date, @NonNull AtomicInteger order, @NonNull PayrollItemType payrollItemType, @NonNull PayrollMonthItem payrollMonthItem, @NonNull BigDecimal times, @NonNull BigDecimal factor, @NonNull BigDecimal value) {
        if (wageType == null) {
            throw new NullPointerException("wageType is marked non-null but is null");
        }
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        if (order == null) {
            throw new NullPointerException("order is marked non-null but is null");
        }
        if (payrollItemType == null) {
            throw new NullPointerException("payrollItemType is marked non-null but is null");
        }
        if (payrollMonthItem == null) {
            throw new NullPointerException("payrollMonthItem is marked non-null but is null");
        }
        if (times == null) {
            throw new NullPointerException("times is marked non-null but is null");
        }
        if (factor == null) {
            throw new NullPointerException("factor is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        BigDecimal descriptionValue = (BigDecimal)MoreObjects.firstNonNull((Object)payrollMonthItem.getValue(), (Object)BigDecimal.ZERO);
        Project project = payrollMonthItem.getProject();
        String costBearer = null != project ? project.getCostBearer() : "";
        String projectName = null != project ? project.getName() : "";
        String remarks = payrollMonthItem.getRemarks();
        String description = null != project ? StringUtils.left((String)(costBearer + " " + remarks), (int)30) : remarks;
        return WageTypeCalculationResult.of((EWageType)wageType, (PayrollItemType)payrollItemType, (LocalDate)date, (EWageTypeCalculationResultType)EWageTypeCalculationResultType.DETAIL_UNGROUPED, (Integer)order.getAndIncrement(), (String)description, (BigDecimal)descriptionValue, (BigDecimal)times, (BigDecimal)factor, (BigDecimal)value, (String)costBearer);
    }
}

