/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.calculator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.internal.employee.payroll.EWageTypeCalculationResultType;
import de.qfm.erp.service.model.internal.employee.payroll.WageTypeCalculationResult;
import de.qfm.erp.service.model.internal.payroll.PayrollMonthCalculationBucket;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.service.calculator.wagetype.EWageType;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageCalculatorHelper;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageTypeCalculator;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class WageTypeNumberAggregateWageTypeCalculator
extends WageTypeCalculator {
    protected WageTypeNumberAggregateWageTypeCalculator(@NonNull EWageType wageType) {
        super(wageType);
        if (wageType == null) {
            throw new NullPointerException("wageType is marked non-null but is null");
        }
    }

    @Nonnull
    public Iterable<WageTypeCalculationResult> calculate(@NonNull PayrollMonthCalculationBucket payrollMonthCalculationBucket) {
        if (payrollMonthCalculationBucket == null) {
            throw new NullPointerException("payrollMonthCalculationBucket is marked non-null but is null");
        }
        PayrollMonth payrollMonth = payrollMonthCalculationBucket.getPayrollMonth();
        PayrollItemType payrollItemType = payrollMonthCalculationBucket.getPayrollItemType();
        YearMonth yearMonth = WageCalculatorHelper.yearMonth((PayrollMonth)payrollMonth);
        List allPayrollMonthItems = payrollMonth.getPayrollMonthItems();
        Iterable auxiliaryPaymentPayrollMonthItems = this.auxiliaryPaymentWithPayrollMonthType((Iterable)allPayrollMonthItems, payrollItemType);
        BigDecimal auxiliaryPayrollMonthItemsSum = Streams.stream((Iterable)auxiliaryPaymentPayrollMonthItems).map(PayrollMonthItem::getValue).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        String firstDescription = WageTypeNumberAggregateWageTypeCalculator.firstDescription((Iterable)auxiliaryPaymentPayrollMonthItems);
        ImmutableList.Builder detailRowsBuilder = ImmutableList.builder();
        AtomicInteger counter = new AtomicInteger();
        for (PayrollMonthItem auxiliaryPaymentPayrollMonthItem : auxiliaryPaymentPayrollMonthItems) {
            BigDecimal value = auxiliaryPaymentPayrollMonthItem.getValue();
            detailRowsBuilder.add((Object)WageTypeNumberAggregateWageTypeCalculator.detail((EWageType)this.getWageType(), (LocalDate)yearMonth.atEndOfMonth(), (AtomicInteger)counter, (PayrollItemType)payrollItemType, (PayrollMonthItem)auxiliaryPaymentPayrollMonthItem, (BigDecimal)value, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)value));
        }
        ImmutableList detailRows = detailRowsBuilder.build();
        WageTypeCalculationResult aggregate = WageTypeCalculationResult.of((EWageType)this.getWageType(), (PayrollItemType)payrollItemType, (LocalDate)yearMonth.atEndOfMonth(), (EWageTypeCalculationResultType)EWageTypeCalculationResultType.STANDARD, (Integer)0, (String)firstDescription, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)auxiliaryPayrollMonthItemsSum, (String)"");
        return ImmutableList.builder().add((Object)aggregate).addAll((Iterable)detailRows).build();
    }

    @Nonnull
    protected static WageTypeCalculationResult detail(@NonNull EWageType wageType, @NonNull LocalDate date, @NonNull AtomicInteger order, @NonNull PayrollItemType payrollItemType, @NonNull PayrollMonthItem payrollMonthItem, @NonNull BigDecimal descriptionValue, @NonNull BigDecimal times, @NonNull BigDecimal factor, @NonNull BigDecimal value) {
        if (wageType == null) {
            throw new NullPointerException("wageType is marked non-null but is null");
        }
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        if (order == null) {
            throw new NullPointerException("order is marked non-null but is null");
        }
        if (payrollItemType == null) {
            throw new NullPointerException("payrollItemType is marked non-null but is null");
        }
        if (payrollMonthItem == null) {
            throw new NullPointerException("payrollMonthItem is marked non-null but is null");
        }
        if (descriptionValue == null) {
            throw new NullPointerException("descriptionValue is marked non-null but is null");
        }
        if (times == null) {
            throw new NullPointerException("times is marked non-null but is null");
        }
        if (factor == null) {
            throw new NullPointerException("factor is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        Project project = payrollMonthItem.getProject();
        String costBearer = null != project ? project.getCostBearer() : "";
        String projectName = null != project ? project.getName() : "";
        String remarks = payrollMonthItem.getRemarks();
        String description = null != project ? StringUtils.left((String)(costBearer + " " + remarks), (int)30) : remarks;
        return WageTypeCalculationResult.of((EWageType)wageType, (PayrollItemType)payrollItemType, (LocalDate)date, (EWageTypeCalculationResultType)EWageTypeCalculationResultType.DETAIL_UNGROUPED, (Integer)order.getAndIncrement(), (String)description, (BigDecimal)descriptionValue, (BigDecimal)times, (BigDecimal)factor, (BigDecimal)value, (String)costBearer);
    }
}

