/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.calculator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.service.model.internal.employee.payroll.EWageTypeCalculationResultType;
import de.qfm.erp.service.model.internal.employee.payroll.WageTypeCalculationResult;
import de.qfm.erp.service.model.internal.payroll.PayrollMonthCalculationBucket;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemClazz;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemUnit;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.generic.EDayType;
import de.qfm.erp.service.service.calculator.wagetype.EWageType;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class WageTypeCalculator {
    private final EWageType wageType;
    @Nonnull
    public static Predicate<PayrollMonthItem> DEDUCT_FROM_WAGE = payrollMonthItem -> {
        PayrollItemType payrollItemType = payrollMonthItem.getPayrollItemType();
        return null != payrollItemType && Objects.equals(payrollItemType.getFlagDeductFromWage(), Boolean.TRUE);
    };

    @Nonnull
    public abstract Iterable<WageTypeCalculationResult> calculate(@NonNull PayrollMonthCalculationBucket var1);

    @Nonnull
    protected Iterable<Attendance> workingAttendances(Iterable<Attendance> attendances) {
        Iterable standardAttendances = this.standardAttendances(attendances);
        Iterable badWeatherAttendances = this.badWeatherAttendances(attendances);
        return ImmutableList.builder().addAll(standardAttendances).addAll(badWeatherAttendances).build();
    }

    @Nonnull
    public Iterable<Attendance> badWeatherAttendances(@NonNull Iterable<Attendance> attendances) {
        if (attendances == null) {
            throw new NullPointerException("attendances is marked non-null but is null");
        }
        return WageTypeCalculator.attendances(attendances, (Iterable)ImmutableSet.of((Object)EAttendanceDayType.BAD_WEATHER, (Object)EAttendanceDayType.BAD_WEATHER_SICK));
    }

    @Nonnull
    public Iterable<Attendance> standardAttendances(@NonNull Iterable<Attendance> attendances) {
        if (attendances == null) {
            throw new NullPointerException("attendances is marked non-null but is null");
        }
        return WageTypeCalculator.attendances(attendances, (EAttendanceDayType)EAttendanceDayType.STANDARD);
    }

    @Nonnull
    public Iterable<Attendance> onyDutyAttendances(@NonNull Iterable<Attendance> attendances) {
        if (attendances == null) {
            throw new NullPointerException("attendances is marked non-null but is null");
        }
        return WageTypeCalculator.attendances(attendances, (EAttendanceDayType)EAttendanceDayType.ON_DUTY);
    }

    @Nonnull
    public Iterable<Attendance> attendances(@NonNull Iterable<Attendance> attendances, @NonNull EDayType dayType) {
        if (attendances == null) {
            throw new NullPointerException("attendances is marked non-null but is null");
        }
        if (dayType == null) {
            throw new NullPointerException("dayType is marked non-null but is null");
        }
        return (Iterable)IterableHelper.stream(attendances).filter(item -> dayType == item.getDayType()).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public static Iterable<Attendance> attendances(@NonNull Iterable<Attendance> attendances, @NonNull EAttendanceDayType attendanceDayType) {
        if (attendances == null) {
            throw new NullPointerException("attendances is marked non-null but is null");
        }
        if (attendanceDayType == null) {
            throw new NullPointerException("attendanceDayType is marked non-null but is null");
        }
        return WageTypeCalculator.attendances(attendances, (Iterable)ImmutableSet.of((Object)attendanceDayType));
    }

    @Nonnull
    public static Iterable<Attendance> attendances(@NonNull Iterable<Attendance> attendances, @NonNull Iterable<EAttendanceDayType> attendanceDayTypes) {
        if (attendances == null) {
            throw new NullPointerException("attendances is marked non-null but is null");
        }
        if (attendanceDayTypes == null) {
            throw new NullPointerException("attendanceDayTypes is marked non-null but is null");
        }
        return (Iterable)IterableHelper.stream(attendances).filter(item -> Iterables.contains((Iterable)attendanceDayTypes, (Object)item.getEmployeeDayType())).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    protected Iterable<PayrollMonthItem> auxiliaryPaymentWithPayrollMonthType(@NonNull Iterable<PayrollMonthItem> payrollMonthItems, @NonNull PayrollItemType payrollItemType) {
        if (payrollMonthItems == null) {
            throw new NullPointerException("payrollMonthItems is marked non-null but is null");
        }
        if (payrollItemType == null) {
            throw new NullPointerException("payrollItemType is marked non-null but is null");
        }
        return (Iterable)IterableHelper.stream((Iterable)WageTypeCalculator.payrollMonthItems(payrollMonthItems, (EPayrollItemClazz)EPayrollItemClazz.AUXILIARY_WAGE)).filter(item -> null != item.getPayrollItemType()).filter(item -> Objects.equals(item.getPayrollItemType(), payrollItemType)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    protected static Iterable<PayrollMonthItem> auxiliaryWages(@NonNull Iterable<PayrollMonthItem> payrollMonthItems) {
        if (payrollMonthItems == null) {
            throw new NullPointerException("payrollMonthItems is marked non-null but is null");
        }
        return WageTypeCalculator.payrollMonthItems(payrollMonthItems, (EPayrollItemClazz)EPayrollItemClazz.AUXILIARY_WAGE);
    }

    @Nonnull
    protected static Iterable<PayrollMonthItem> incentivePayment(@NonNull Iterable<PayrollMonthItem> payrollMonthItems) {
        if (payrollMonthItems == null) {
            throw new NullPointerException("payrollMonthItems is marked non-null but is null");
        }
        return WageTypeCalculator.payrollMonthItems(payrollMonthItems, (EPayrollItemClazz)EPayrollItemClazz.INCENTIVE_PAYMENT);
    }

    @Nonnull
    protected static Iterable<PayrollMonthItem> wageAccountPayment(@NonNull Iterable<PayrollMonthItem> payrollMonthItems) {
        if (payrollMonthItems == null) {
            throw new NullPointerException("payrollMonthItems is marked non-null but is null");
        }
        return WageTypeCalculator.payrollMonthItems(payrollMonthItems, (EPayrollItemClazz)EPayrollItemClazz.WAGE_ACCOUNT);
    }

    @Nonnull
    protected static Iterable<PayrollMonthItem> auxiliaryMappedAsIncentivePayment(@NonNull Iterable<PayrollMonthItem> payrollMonthItems) {
        if (payrollMonthItems == null) {
            throw new NullPointerException("payrollMonthItems is marked non-null but is null");
        }
        Iterable auxiliaryWages = WageTypeCalculator.payrollMonthItems(payrollMonthItems, (EPayrollItemClazz)EPayrollItemClazz.AUXILIARY_WAGE);
        return (Iterable)IterableHelper.stream((Iterable)auxiliaryWages).filter(item -> null != item.getPayrollItemType()).filter(item -> null != item.getPayrollItemType().getSbsValuePayrollItemType()).filter(item -> Objects.equals(item.getPayrollItemType().getSbsValuePayrollItemType().getWageType(), EWageType.INCENTIVE_WAGE)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    protected static Iterable<PayrollMonthItem> payrollMonthItems(@NonNull Iterable<PayrollMonthItem> payrollMonthItems, @NonNull EPayrollItemClazz payrollItemClazz) {
        if (payrollMonthItems == null) {
            throw new NullPointerException("payrollMonthItems is marked non-null but is null");
        }
        if (payrollItemClazz == null) {
            throw new NullPointerException("payrollItemClazz is marked non-null but is null");
        }
        return (Iterable)IterableHelper.stream(payrollMonthItems).filter(item -> payrollItemClazz == item.getPayrollItemClazz()).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    protected String description(@NonNull Multimap<EWageType, PayrollItemType> payrollItemTypeByWageTypeNumber) {
        Collection payrollItemTypes;
        if (payrollItemTypeByWageTypeNumber == null) {
            throw new NullPointerException("payrollItemTypeByWageTypeNumber is marked non-null but is null");
        }
        if (payrollItemTypeByWageTypeNumber.containsKey((Object)this.wageType) && !(payrollItemTypes = payrollItemTypeByWageTypeNumber.get((Object)this.wageType)).isEmpty()) {
            return ((PayrollItemType)payrollItemTypes.iterator().next()).getDescription();
        }
        return "";
    }

    @Nonnull
    protected static String firstDescription(@NonNull Iterable<PayrollMonthItem> payrollMonthItems) {
        if (payrollMonthItems == null) {
            throw new NullPointerException("payrollMonthItems is marked non-null but is null");
        }
        for (PayrollMonthItem payrollMonthItem : payrollMonthItems) {
            if (!StringUtils.isNotBlank((CharSequence)payrollMonthItem.getRemarks())) continue;
            return StringUtils.trimToEmpty((String)payrollMonthItem.getRemarks());
        }
        return "";
    }

    @Nonnull
    protected static BigDecimal effectiveWageTotal(@NonNull BigDecimal hours, @NonNull BigDecimal wageRatePerHour) {
        if (hours == null) {
            throw new NullPointerException("hours is marked non-null but is null");
        }
        if (wageRatePerHour == null) {
            throw new NullPointerException("wageRatePerHour is marked non-null but is null");
        }
        return wageRatePerHour.multiply(hours).setScale(2, RoundingMode.HALF_UP);
    }

    @Nonnull
    protected static BigDecimal deductibleHours(@NonNull Iterable<PayrollMonthItem> payrollMonthItems) {
        if (payrollMonthItems == null) {
            throw new NullPointerException("payrollMonthItems is marked non-null but is null");
        }
        Iterable auxiliaryWages = WageTypeCalculator.auxiliaryWages(payrollMonthItems);
        Iterable deductibleAuxiliaryWages = (Iterable)Streams.stream((Iterable)auxiliaryWages).filter(item -> null != item.getPayrollItemType()).filter(item -> Objects.equals(item.getPayrollItemType().getUnit(), EPayrollItemUnit.HOUR)).filter(DEDUCT_FROM_WAGE).collect(ImmutableList.toImmutableList());
        return Streams.stream((Iterable)deductibleAuxiliaryWages).map(PayrollMonthItem::getValue).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Nonnull
    protected static WageTypeCalculationResult groupedDetails(@NonNull EWageType wageType, @NonNull AtomicInteger order, @NonNull LocalDate date, @NonNull PayrollItemType payrollItemType, @NonNull Pair<Range<LocalDate>, Iterable<Attendance>> groupedAttendance) {
        if (wageType == null) {
            throw new NullPointerException("wageType is marked non-null but is null");
        }
        if (order == null) {
            throw new NullPointerException("order is marked non-null but is null");
        }
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        if (payrollItemType == null) {
            throw new NullPointerException("payrollItemType is marked non-null but is null");
        }
        if (groupedAttendance == null) {
            throw new NullPointerException("groupedAttendance is marked non-null but is null");
        }
        return WageTypeCalculator.groupedDetails((EWageType)wageType, (AtomicInteger)order, (LocalDate)date, (PayrollItemType)payrollItemType, groupedAttendance, (T attendances) -> BigDecimal.valueOf(Iterables.size((Iterable)attendances)), (T attendances) -> BigDecimal.ZERO, (T attendances) -> BigDecimal.ZERO, (T attendances) -> BigDecimal.ZERO);
    }

    @Nonnull
    protected static WageTypeCalculationResult groupedDetails(@NonNull EWageType wageType, @NonNull AtomicInteger order, @NonNull LocalDate date, @NonNull PayrollItemType payrollItemType, @NonNull Pair<Range<LocalDate>, Iterable<Attendance>> groupedAttendance, @NonNull Function<Iterable<Attendance>, BigDecimal> detailsFn, @NonNull Function<Iterable<Attendance>, BigDecimal> timesFn, @NonNull Function<Iterable<Attendance>, BigDecimal> factorFn, @NonNull Function<Iterable<Attendance>, BigDecimal> valueFn) {
        if (wageType == null) {
            throw new NullPointerException("wageType is marked non-null but is null");
        }
        if (order == null) {
            throw new NullPointerException("order is marked non-null but is null");
        }
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        if (payrollItemType == null) {
            throw new NullPointerException("payrollItemType is marked non-null but is null");
        }
        if (groupedAttendance == null) {
            throw new NullPointerException("groupedAttendance is marked non-null but is null");
        }
        if (detailsFn == null) {
            throw new NullPointerException("detailsFn is marked non-null but is null");
        }
        if (timesFn == null) {
            throw new NullPointerException("timesFn is marked non-null but is null");
        }
        if (factorFn == null) {
            throw new NullPointerException("factorFn is marked non-null but is null");
        }
        if (valueFn == null) {
            throw new NullPointerException("valueFn is marked non-null but is null");
        }
        return WageTypeCalculator.groupedDetails((EWageType)wageType, (AtomicInteger)order, (LocalDate)date, (PayrollItemType)payrollItemType, groupedAttendance, detailsFn, timesFn, factorFn, valueFn, (boolean)false, (T item) -> BigDecimal.ZERO);
    }

    @Nonnull
    protected static WageTypeCalculationResult groupedDetails(@NonNull EWageType wageType, @NonNull AtomicInteger order, @NonNull LocalDate date, @NonNull PayrollItemType payrollItemType, @NonNull Pair<Range<LocalDate>, Iterable<Attendance>> groupedAttendance, @NonNull Function<Iterable<Attendance>, BigDecimal> detailsFn, @NonNull Function<Iterable<Attendance>, BigDecimal> timesFn, @NonNull Function<Iterable<Attendance>, BigDecimal> factorFn, @NonNull Function<Iterable<Attendance>, BigDecimal> valueFn, boolean correctionFactorEnabled, @NonNull Function<Iterable<Attendance>, BigDecimal> correctionFactorFn) {
        if (wageType == null) {
            throw new NullPointerException("wageType is marked non-null but is null");
        }
        if (order == null) {
            throw new NullPointerException("order is marked non-null but is null");
        }
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        if (payrollItemType == null) {
            throw new NullPointerException("payrollItemType is marked non-null but is null");
        }
        if (groupedAttendance == null) {
            throw new NullPointerException("groupedAttendance is marked non-null but is null");
        }
        if (detailsFn == null) {
            throw new NullPointerException("detailsFn is marked non-null but is null");
        }
        if (timesFn == null) {
            throw new NullPointerException("timesFn is marked non-null but is null");
        }
        if (factorFn == null) {
            throw new NullPointerException("factorFn is marked non-null but is null");
        }
        if (valueFn == null) {
            throw new NullPointerException("valueFn is marked non-null but is null");
        }
        if (correctionFactorFn == null) {
            throw new NullPointerException("correctionFactorFn is marked non-null but is null");
        }
        Range dateRange = (Range)groupedAttendance.getLeft();
        Iterable relatedAttendances = (Iterable)groupedAttendance.getRight();
        LocalDate start = (LocalDate)dateRange.lowerEndpoint();
        LocalDate end = (LocalDate)dateRange.upperEndpoint();
        String startAsString = DateTimeHelperService.germanDate((LocalDate)start);
        String endAsString = DateTimeHelperService.germanDate((LocalDate)end);
        String dateRangeAsString = String.format("%s-%s Tage: ", startAsString, endAsString);
        BigDecimal detailsValue = detailsFn.apply(relatedAttendances);
        BigDecimal timesValue = timesFn.apply(relatedAttendances);
        BigDecimal factorValue = factorFn.apply(relatedAttendances);
        BigDecimal valueValue = valueFn.apply(relatedAttendances);
        BigDecimal correctionFactor = correctionFactorFn.apply(relatedAttendances);
        return WageTypeCalculationResult.of((EWageType)wageType, (PayrollItemType)payrollItemType, (LocalDate)date, (EWageTypeCalculationResultType)EWageTypeCalculationResultType.DETAIL_GROUPED, (Integer)order.getAndIncrement(), (String)dateRangeAsString, (BigDecimal)detailsValue, (BigDecimal)timesValue, (BigDecimal)factorValue, (BigDecimal)valueValue, (String)"", (boolean)correctionFactorEnabled, (BigDecimal)correctionFactor);
    }

    @Nonnull
    protected static Iterable<WageTypeCalculationResult> ungroupedDetails(@NonNull EWageType wageType, @NonNull AtomicInteger order, @NonNull PayrollItemType payrollItemType, @NonNull Pair<Range<LocalDate>, Iterable<Attendance>> groupedAttendance, @NonNull Function<Attendance, BigDecimal> detailsFn, @NonNull Function<Attendance, BigDecimal> timesFn, @NonNull Function<Attendance, BigDecimal> factorFn, @NonNull Function<Attendance, BigDecimal> valueFn, boolean correctionFactorEnabled, @NonNull Function<Attendance, BigDecimal> correctionFactorFn) {
        if (wageType == null) {
            throw new NullPointerException("wageType is marked non-null but is null");
        }
        if (order == null) {
            throw new NullPointerException("order is marked non-null but is null");
        }
        if (payrollItemType == null) {
            throw new NullPointerException("payrollItemType is marked non-null but is null");
        }
        if (groupedAttendance == null) {
            throw new NullPointerException("groupedAttendance is marked non-null but is null");
        }
        if (detailsFn == null) {
            throw new NullPointerException("detailsFn is marked non-null but is null");
        }
        if (timesFn == null) {
            throw new NullPointerException("timesFn is marked non-null but is null");
        }
        if (factorFn == null) {
            throw new NullPointerException("factorFn is marked non-null but is null");
        }
        if (valueFn == null) {
            throw new NullPointerException("valueFn is marked non-null but is null");
        }
        if (correctionFactorFn == null) {
            throw new NullPointerException("correctionFactorFn is marked non-null but is null");
        }
        Iterable relatedAttendances = (Iterable)groupedAttendance.getRight();
        ImmutableList.Builder ungroupedDetailsBuilder = ImmutableList.builder();
        relatedAttendances.forEach(attendance -> {
            LocalDate date = attendance.getDate();
            String dateAsString = DateTimeHelperService.germanDate((LocalDate)date);
            String dateRangeAsString = String.format("%s", dateAsString);
            BigDecimal detailsValue = (BigDecimal)detailsFn.apply((Attendance)attendance);
            BigDecimal timesValue = (BigDecimal)timesFn.apply((Attendance)attendance);
            BigDecimal factorValue = (BigDecimal)factorFn.apply((Attendance)attendance);
            BigDecimal valueValue = (BigDecimal)valueFn.apply((Attendance)attendance);
            BigDecimal correctionFactor = (BigDecimal)correctionFactorFn.apply((Attendance)attendance);
            String costBearer = StringUtils.trimToEmpty((String)attendance.getCostBearer());
            ungroupedDetailsBuilder.add((Object)WageTypeCalculationResult.of((EWageType)wageType, (PayrollItemType)payrollItemType, (LocalDate)date, (EWageTypeCalculationResultType)EWageTypeCalculationResultType.DETAIL_UNGROUPED, (Integer)order.getAndIncrement(), (String)dateRangeAsString, (BigDecimal)detailsValue, (BigDecimal)timesValue, (BigDecimal)factorValue, (BigDecimal)valueValue, (String)costBearer, (boolean)correctionFactorEnabled, (BigDecimal)correctionFactor));
        });
        return ungroupedDetailsBuilder.build();
    }

    @Nonnull
    @VisibleForTesting
    static Iterable<Pair<Range<LocalDate>, Iterable<Attendance>>> group(@NonNull Iterable<Attendance> attendances) {
        if (attendances == null) {
            throw new NullPointerException("attendances is marked non-null but is null");
        }
        ImmutableList.Builder groupedAttendancesBuilder = ImmutableList.builder();
        ImmutableList attendancesSorted = ImmutableList.sortedCopyOf(Comparator.comparing(Attendance::getDate), attendances);
        if (!attendancesSorted.isEmpty()) {
            ArrayList currentAttendances = Lists.newArrayList();
            LocalDate start = null;
            LocalDate end = null;
            int currentDays = 1;
            for (Attendance attendance : attendancesSorted) {
                LocalDate expect;
                LocalDate currentDate = attendance.getDate();
                if (null == start) {
                    start = currentDate;
                    end = currentDate;
                    currentAttendances.add(attendance);
                    continue;
                }
                if ((expect = start.plusDays(currentDays++)).isEqual(currentDate)) {
                    currentAttendances.add(attendance);
                    end = currentDate;
                    continue;
                }
                Range dateRange = Range.closed((Comparable)start, (Comparable)end);
                groupedAttendancesBuilder.add((Object)Pair.of((Object)dateRange, (Object)ImmutableList.copyOf((Collection)currentAttendances)));
                start = currentDate;
                end = currentDate;
                currentAttendances.clear();
                currentAttendances.add(attendance);
                currentDays = 1;
            }
            Range dateRange = Range.closed(start, end);
            groupedAttendancesBuilder.add((Object)Pair.of((Object)dateRange, (Object)ImmutableList.copyOf((Collection)currentAttendances)));
        }
        return groupedAttendancesBuilder.build();
    }

    protected WageTypeCalculator(EWageType wageType) {
        this.wageType = wageType;
    }

    public EWageType getWageType() {
        return this.wageType;
    }

    public String toString() {
        return "WageTypeCalculator(wageType=" + String.valueOf(this.getWageType()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WageTypeCalculator)) {
            return false;
        }
        WageTypeCalculator other = (WageTypeCalculator)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        EWageType this$wageType = this.getWageType();
        EWageType other$wageType = other.getWageType();
        return !(this$wageType == null ? other$wageType != null : !this$wageType.equals(other$wageType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WageTypeCalculator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EWageType $wageType = this.getWageType();
        result = result * 59 + ($wageType == null ? 43 : $wageType.hashCode());
        return result;
    }
}

