/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.calculator;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.internal.employee.payroll.EWageTypeCalculationResultType;
import de.qfm.erp.service.model.internal.employee.payroll.WageTypeCalculationResult;
import de.qfm.erp.service.model.internal.payroll.PayrollMonthCalculationBucket;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.calculator.wagetype.EWageType;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageCalculatorHelper;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageTypeCalculator;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AbsentDaysBadWeatherSick_WageTypeCalculator
extends WageTypeCalculator {
    private static final Function<Attendance, BigDecimal> BAD_WEATHER_SICK_FUNCTION = attendance -> WageCalculatorHelper.hours((Duration)((Duration)MoreObjects.firstNonNull((Object)attendance.getContractualWorkTimeDuration(), (Object)Duration.ZERO)));

    public AbsentDaysBadWeatherSick_WageTypeCalculator() {
        super(EWageType.ABSENT_DAYS__BAD_WEATHER__SICK);
    }

    @Nonnull
    public Iterable<WageTypeCalculationResult> calculate(@NonNull PayrollMonthCalculationBucket payrollMonthCalculationBucket) {
        if (payrollMonthCalculationBucket == null) {
            throw new NullPointerException("payrollMonthCalculationBucket is marked non-null but is null");
        }
        PayrollMonth payrollMonth = payrollMonthCalculationBucket.getPayrollMonth();
        PayrollItemType payrollItemType = payrollMonthCalculationBucket.getPayrollItemType();
        User employee = payrollMonth.getUser();
        YearMonth yearMonth = WageCalculatorHelper.yearMonth((PayrollMonth)payrollMonth);
        List attendances = payrollMonth.getAttendances();
        Iterable absentDays = AbsentDaysBadWeatherSick_WageTypeCalculator.attendances((Iterable)attendances, (Iterable)ImmutableSet.of((Object)EAttendanceDayType.BAD_WEATHER_SICK));
        Duration duration = WageCalculatorHelper.durationInHours((Iterable)absentDays, Attendance::getContractualWorkTimeDuration);
        BigDecimal durationInHours = WageCalculatorHelper.hours((Duration)duration);
        BigDecimal effectiveWagePerHour = WageCalculatorHelper.effectiveWagePerHour((YearMonth)yearMonth, (User)employee);
        BigDecimal total = AbsentDaysBadWeatherSick_WageTypeCalculator.effectiveWageTotal((BigDecimal)durationInHours, (BigDecimal)effectiveWagePerHour);
        WageTypeCalculationResult aggregationRow = WageTypeCalculationResult.of((EWageType)this.getWageType(), (PayrollItemType)payrollItemType, (LocalDate)yearMonth.atEndOfMonth(), (EWageTypeCalculationResultType)EWageTypeCalculationResultType.STANDARD, (Integer)0, (String)"", (BigDecimal)BigDecimal.ZERO, (BigDecimal)durationInHours, (BigDecimal)effectiveWagePerHour, (BigDecimal)total, (String)"");
        Iterable groupedAttendances = AbsentDaysBadWeatherSick_WageTypeCalculator.group((Iterable)absentDays);
        ImmutableList.Builder detailRowsBuilder = ImmutableList.builder();
        AtomicInteger counter = new AtomicInteger();
        for (Pair groupedAttendance : groupedAttendances) {
            detailRowsBuilder.add((Object)AbsentDaysBadWeatherSick_WageTypeCalculator.groupedDetails((EWageType)this.getWageType(), (AtomicInteger)counter, (LocalDate)yearMonth.atEndOfMonth(), (PayrollItemType)payrollItemType, (Pair)groupedAttendance));
            detailRowsBuilder.addAll(AbsentDaysBadWeatherSick_WageTypeCalculator.ungroupedDetails((EWageType)this.getWageType(), (AtomicInteger)counter, (PayrollItemType)payrollItemType, (Pair)groupedAttendance, relatedAttendances -> BigDecimal.ONE, (Function)BAD_WEATHER_SICK_FUNCTION, relatedAttendances -> BigDecimal.ZERO, relatedAttendances -> BigDecimal.ZERO, (boolean)false, relatedAttendance -> BigDecimal.ZERO));
        }
        ImmutableList detailRows = detailRowsBuilder.build();
        return ImmutableList.builder().add((Object)aggregationRow).addAll((Iterable)detailRows).build();
    }
}

