/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.aggregator;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAggregatedAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.service.calculator.wagetype.aggregator.AttendanceDurationAggregator;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class VacationAttendanceDurationAggregator
extends AttendanceDurationAggregator {
    public VacationAttendanceDurationAggregator() {
        super(EAggregatedAttendanceDayType.AGG_VACATION);
    }

    @Nonnull
    public Map<EAggregatedAttendanceDayType, Duration> duration(@NonNull Attendance attendance) {
        if (attendance == null) {
            throw new NullPointerException("attendance is marked non-null but is null");
        }
        EAttendanceDayType employeeDayType = attendance.getEmployeeDayType();
        Duration contractualWorkTimeDuration = (Duration)MoreObjects.firstNonNull((Object)attendance.getContractualWorkTimeDuration(), (Object)Duration.ZERO);
        if (!contractualWorkTimeDuration.isZero() && EAttendanceDayType.VACATION == employeeDayType) {
            return ImmutableMap.of((Object)EAggregatedAttendanceDayType.AGG_VACATION, (Object)contractualWorkTimeDuration);
        }
        return ImmutableMap.of();
    }
}

