/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.aggregator;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAggregatedAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.model.jpa.generic.EDayType;
import de.qfm.erp.service.service.calculator.wagetype.aggregator.AttendanceDurationAggregator;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class AbsentAttendanceDurationAggregator
extends AttendanceDurationAggregator {
    private static final Logger log = LogManager.getLogger(AbsentAttendanceDurationAggregator.class);
    private static final Set<EAttendanceDayType> ABSENT_DAY_TYPES = ImmutableSet.of();
    private static final Set<EAttendanceDayType> STANDARD_DAY_TYPES = ImmutableSet.of((Object)EAttendanceDayType.STANDARD, (Object)EAttendanceDayType.BAD_WEATHER, (Object)EAttendanceDayType.BAD_WEATHER_SICK, (Object)EAttendanceDayType.ABSENT, (Object)EAttendanceDayType.PARENTAL_LEAVE, (Object)EAttendanceDayType.NONE, (Object[])new EAttendanceDayType[0]);

    public AbsentAttendanceDurationAggregator() {
        super(EAggregatedAttendanceDayType.AGG_ABSENT);
    }

    @Nonnull
    public Map<EAggregatedAttendanceDayType, Duration> duration(@NonNull Attendance attendance) {
        if (attendance == null) {
            throw new NullPointerException("attendance is marked non-null but is null");
        }
        EDayType dayType = attendance.getDayType();
        if (dayType == EDayType.STANDARD) {
            EAttendanceDayType employeeDayType = attendance.getEmployeeDayType();
            Duration contractualWorkTimeDuration = (Duration)MoreObjects.firstNonNull((Object)attendance.getContractualWorkTimeDuration(), (Object)Duration.ZERO);
            Duration workDuration = (Duration)MoreObjects.firstNonNull((Object)attendance.getWorkDuration(), (Object)Duration.ZERO);
            Duration badWeatherDuration = (Duration)MoreObjects.firstNonNull((Object)attendance.getBadWeatherDuration(), (Object)Duration.ZERO);
            Duration contractualWorkTime = (Duration)MoreObjects.firstNonNull((Object)attendance.getContractualWorkTimeDuration(), (Object)Duration.ZERO);
            Duration gapWorkTimeVsContractSum = contractualWorkTime.minus(workDuration.plus(badWeatherDuration));
            if (!contractualWorkTimeDuration.isZero() && ABSENT_DAY_TYPES.contains(employeeDayType)) {
                return ImmutableMap.of((Object)EAggregatedAttendanceDayType.AGG_ABSENT, (Object)contractualWorkTimeDuration);
            }
            if (!gapWorkTimeVsContractSum.isZero() && STANDARD_DAY_TYPES.contains(employeeDayType)) {
                return ImmutableMap.of((Object)EAggregatedAttendanceDayType.AGG_ABSENT, (Object)gapWorkTimeVsContractSum);
            }
            if (!badWeatherDuration.isZero() && EAttendanceDayType.BAD_WEATHER_SICK == employeeDayType) {
                return ImmutableMap.of((Object)EAggregatedAttendanceDayType.AGG_ABSENT, (Object)badWeatherDuration);
            }
            return ImmutableMap.of((Object)EAggregatedAttendanceDayType.AGG_ABSENT, (Object)Duration.ZERO);
        }
        return ImmutableMap.of();
    }
}

