/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EWageType implements Translatable
{
    NONE,
    STANDARD_WAGE,
    INCENTIVE_WAGE,
    AUXILIARY_WAGE_AS_IS,
    AUXILIARY_WAGE_AS_IS_LIST,
    AUXILIARY_WAGE_TIMES_AS_IS_LIST,
    AUXILIARY_WAGE_HOUR,
    AUXILIARY_WAGE_VALUE,
    ABSENT_DAYS__SUM,
    ABSENT_DAYS__BAD_WEATHER,
    ABSENT_DAYS__VACATION,
    ABSENT_DAYS__BANKING_HOLIDAY,
    ABSENT_DAYS__CHILD_SICK,
    ABSENT_DAYS__ON_DUTY__ATTENDANCE_COST_BEARER,
    ABSENT_DAYS__ON_DUTY__AUXILIARY_COST_BEARER,
    ABSENT_DAYS__PARENTAL_LEAVE,
    ABSENT_DAYS__SICK,
    ABSENT_DAYS__BAD_WEATHER__SICK,
    ABSENT_DAYS__BAD_WEATHER__WORKING_HOURS,
    PRESENT_DAYS__WORKING_HOURS,
    SQUAD_LEADER_BONUS;

    private static final Map<String, EWageType> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EWageType lookup(@NonNull String candidate, @NonNull EWageType defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EWageType.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EWageType> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EWageType.key((String)candidate);
        return Optional.ofNullable((EWageType)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EWageType item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EWageType.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @NonNull
    public static EWageType lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EWageType.key((String)candidate);
        EWageType payrollItemUnit = (EWageType)LOOKUP.get(key);
        if (null == payrollItemUnit) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_ITEM_TYPE__WAGE_TYPE), (String)candidate, EWageType.class, EWageType::allowedKeys);
        }
        return payrollItemUnit;
    }

    @Nonnull
    public String messageCode() {
        return "enum.payroll_item_wage_type." + EWageType.key((EWageType)this);
    }

    public String toString() {
        return "EWageType." + this.name();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EWageType value : EWageType.values()) {
            String key = EWageType.key((EWageType)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

