/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.quotation;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.UserComparator;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.StageNotifyUser;
import de.qfm.erp.service.model.jpa.quotation.StageResponsibleUser;
import de.qfm.erp.service.model.jpa.quotation.StageSignatureUser;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.quotation.StageCalculator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class StageReferencesCalculator
extends StageCalculator {
    static final int ORDERING = -2;
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.STANDARD);

    public StageReferencesCalculator() {
        super(PROPERTIES, -2);
    }

    void calculateAndApply(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        Set stageNotifyUsers = (Set)MoreObjects.firstNonNull((Object)stage.getStageNotifyUsers(), (Object)ImmutableSet.of());
        ImmutableSet notifyUsers = (ImmutableSet)stageNotifyUsers.stream().map(StageNotifyUser::getUser).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        String stageNotifyUsersTxt = this.usersTxt((Iterable)notifyUsers);
        stage.setStageNotifyUsersText(stageNotifyUsersTxt);
        Set stageResponsibleUsers = (Set)MoreObjects.firstNonNull((Object)stage.getStageResponsibleUsers(), (Object)ImmutableSet.of());
        ImmutableSet responsibleUsers = (ImmutableSet)stageResponsibleUsers.stream().map(StageResponsibleUser::getUser).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        String stageResponsibleUsersTxt = this.usersTxt((Iterable)responsibleUsers);
        stage.setStageResponsibleUsersText(stageResponsibleUsersTxt);
        Set stageSignatureUsers = (Set)MoreObjects.firstNonNull((Object)stage.getStageSignatureUsers(), (Object)ImmutableSet.of());
        ImmutableSet signatureUsers = (ImmutableSet)stageSignatureUsers.stream().map(StageSignatureUser::getUser).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        String stageSignatureUsersTxt = this.usersTxt((Iterable)signatureUsers);
        stage.setStageSignatureUsersText(stageSignatureUsersTxt);
    }

    @Nonnull
    private String usersTxt(@NonNull Iterable<User> users) {
        if (users == null) {
            throw new NullPointerException("users is marked non-null but is null");
        }
        return Streams.stream(users).sorted(UserComparator.of()).map(User::getFullName).filter(Objects::nonNull).collect(Collectors.joining("; "));
    }
}

