/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.measurement;

import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.helper.ProductCalculatorHelper;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.measurement.MeasurementPositionCalculator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Order(value=2)
public class MeasurementPositionProductCalculator
extends MeasurementPositionCalculator {
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.STANDARD, (Object)ECalculatorProperty.SYNC);
    static final int ORDERING = 2;

    public MeasurementPositionProductCalculator() {
        super(PROPERTIES, 2);
    }

    public void calculateAndApply(@NonNull MeasurementPosition measurementPosition) {
        if (measurementPosition == null) {
            throw new NullPointerException("measurementPosition is marked non-null but is null");
        }
        BigDecimal amount = MeasurementPositionProductCalculator.normalize((BigDecimal)measurementPosition.getAmount(), (int)3);
        BigDecimal factor1 = MeasurementPositionProductCalculator.normalize((BigDecimal)measurementPosition.getFactor1(), (int)2);
        BigDecimal factor2 = MeasurementPositionProductCalculator.normalize((BigDecimal)measurementPosition.getFactor2(), (int)2);
        BigDecimal factor3 = MeasurementPositionProductCalculator.normalize((BigDecimal)measurementPosition.getFactor3(), (int)2);
        BigDecimal product = ProductCalculatorHelper.product((BigDecimal)amount, (BigDecimal)factor1, (BigDecimal)factor2, (BigDecimal)factor3);
        measurementPosition.setAmount(amount);
        measurementPosition.setFactor1(factor1);
        measurementPosition.setFactor2(factor2);
        measurementPosition.setFactor3(factor3);
        measurementPosition.setProduct(product);
    }

    @Nullable
    private static BigDecimal normalize(@Nullable BigDecimal value, int scale) {
        if (null != value) {
            return value.setScale(scale, RoundingMode.HALF_UP);
        }
        return null;
    }
}

