/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.measurement;

import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.helper.MapperHelper;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.measurement.MeasurementPositionCalculator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=5)
public class MeasurementPositionPriceCalculator
extends MeasurementPositionCalculator {
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.STANDARD);
    static final int ORDERING = 5;

    public MeasurementPositionPriceCalculator() {
        super(PROPERTIES, 5);
    }

    public void calculateAndApply(@NonNull MeasurementPosition measurementPosition) {
        if (measurementPosition == null) {
            throw new NullPointerException("measurementPosition is marked non-null but is null");
        }
        BigDecimal product = measurementPosition.getProduct();
        BigDecimal materialSellingPricePerUnit = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getMaterialSellingPricePerUnit());
        BigDecimal materialPurchasePricePerUnit = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getMaterialPurchasePriceIncludingDiscountPerUnit());
        BigDecimal externalServicePurchasePricePerUnit = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getExternalServicePurchasePricePerUnit());
        BigDecimal externalServiceSellingPricePerUnit = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getExternalServiceSellingPricePerUnit());
        BigDecimal pricePerUnit = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getPricePerUnit());
        BigDecimal priceAggregated = pricePerUnit.multiply(product);
        measurementPosition.setPricePerUnit(pricePerUnit.setScale(2, RoundingMode.HALF_UP));
        measurementPosition.setPriceAggregated(priceAggregated.setScale(2, RoundingMode.HALF_UP));
        BigDecimal materialPurchasePriceIncludingDiscountAggregated = materialPurchasePricePerUnit.multiply(product);
        measurementPosition.setMaterialPurchasePriceIncludingDiscountAggregated(materialPurchasePriceIncludingDiscountAggregated.setScale(2, RoundingMode.HALF_UP));
        BigDecimal materialSellingPriceAggregated = materialSellingPricePerUnit.multiply(product);
        measurementPosition.setMaterialSellingPriceAggregated(materialSellingPriceAggregated.setScale(2, RoundingMode.HALF_UP));
        BigDecimal externalServicePurchasePriceAggregated = externalServicePurchasePricePerUnit.multiply(product);
        measurementPosition.setExternalServicePurchasePriceAggregated(externalServicePurchasePriceAggregated.setScale(2, RoundingMode.HALF_UP));
        BigDecimal externalServiceSellingPriceAggregated = externalServiceSellingPricePerUnit.multiply(product);
        measurementPosition.setExternalServiceSellingPriceAggregated(externalServiceSellingPriceAggregated.setScale(2, RoundingMode.HALF_UP));
    }
}

