/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.measurement;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.helper.MapperHelper;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.measurement.MeasurementPositionCalculator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Order(value=6)
public class MeasurementPositionDiscountCalculator
extends MeasurementPositionCalculator {
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.STANDARD);
    static final int ORDERING = 6;

    public MeasurementPositionDiscountCalculator() {
        super(PROPERTIES, 6);
    }

    public void calculateAndApply(@NonNull MeasurementPosition measurementPosition) {
        if (measurementPosition == null) {
            throw new NullPointerException("measurementPosition is marked non-null but is null");
        }
        BigDecimal companyWageAggregated = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getCompanyWageAggregated());
        BigDecimal materialSellingPriceAggregated = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getMaterialSellingPriceAggregated());
        BigDecimal externalServicePriceAggregated = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getExternalServiceSellingPriceAggregated());
        BigDecimal priceAggregated = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getPriceAggregated());
        BigDecimal discountFactor = MeasurementPositionDiscountCalculator.discountFactor((MeasurementPosition)measurementPosition);
        BigDecimal materialSellingPriceAggregatedDiscount = MeasurementPositionDiscountCalculator.discount((BigDecimal)materialSellingPriceAggregated, (BigDecimal)discountFactor);
        measurementPosition.setMaterialSellingPriceAggregatedDiscount(materialSellingPriceAggregatedDiscount);
        BigDecimal priceAggregatedDiscount = MeasurementPositionDiscountCalculator.discount((BigDecimal)priceAggregated, (BigDecimal)discountFactor);
        measurementPosition.setPriceAggregatedDiscount(priceAggregatedDiscount);
        BigDecimal companyWageAggregatedDiscount = MeasurementPositionDiscountCalculator.discount((BigDecimal)companyWageAggregated, (BigDecimal)discountFactor);
        measurementPosition.setCompanyWageAggregatedDiscount(companyWageAggregatedDiscount);
    }

    @Nonnull
    static BigDecimal discountFactor(@NonNull MeasurementPosition measurementPosition) {
        if (measurementPosition == null) {
            throw new NullPointerException("measurementPosition is marked non-null but is null");
        }
        BigDecimal generalDiscount = (BigDecimal)MoreObjects.firstNonNull((Object)measurementPosition.getDiscount(), (Object)BigDecimal.ZERO);
        BigDecimal otherDiscount = (BigDecimal)MoreObjects.firstNonNull((Object)measurementPosition.getOtherDiscount(), (Object)BigDecimal.ZERO);
        BigDecimal d1 = generalDiscount.add(otherDiscount);
        BigDecimal d2 = generalDiscount.multiply(otherDiscount);
        return d1.subtract(d2);
    }

    @Nonnull
    static BigDecimal discount(@NonNull BigDecimal value, @NonNull BigDecimal discountFactor) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (discountFactor == null) {
            throw new NullPointerException("discountFactor is marked non-null but is null");
        }
        BigDecimal valueDiscountRatio = value.multiply(discountFactor).setScale(4, RoundingMode.HALF_UP);
        return value.subtract(valueDiscountRatio).setScale(2, RoundingMode.HALF_UP);
    }
}

