/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import de.qfm.erp.common.request.measurement.MeasurementPositionUpdateItem;
import de.qfm.erp.common.request.quotation.StagePositionModificationItem;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.shared.EAlternativePositionType;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class SurrogatePositionNumberHelper {
    private static final Joiner JOINER = Joiner.on((char)'.').skipNulls();

    @Nonnull
    public static String surrogatePositionNumber(@NonNull MeasurementPosition measurementPosition) {
        if (measurementPosition == null) {
            throw new NullPointerException("measurementPosition is marked non-null but is null");
        }
        ArrayList values = Lists.newArrayList();
        values.add(StringUtils.trimToEmpty((String)measurementPosition.getGroupingElementLevel1()));
        values.add(StringUtils.trimToEmpty((String)measurementPosition.getGroupingElementLevel2()));
        values.add(StringUtils.trimToEmpty((String)measurementPosition.getGroupingElementLevel3()));
        values.add(StringUtils.trimToEmpty((String)measurementPosition.getGroupingElementLevel4()));
        values.add(StringUtils.trimToEmpty((String)measurementPosition.getQuotationPositionNumber()));
        Integer quotationSubPositionNumber = measurementPosition.getQuotationSubPositionNumber();
        if (null != quotationSubPositionNumber) {
            values.add("" + quotationSubPositionNumber);
        }
        EAlternativePositionType alternativePositionType = (EAlternativePositionType)MoreObjects.firstNonNull((Object)measurementPosition.getAlternativePositionType(), (Object)EAlternativePositionType.NO);
        String alternativePositionTypeTxt = SurrogatePositionNumberHelper.alternativePositionTypeTxt((EAlternativePositionType)alternativePositionType);
        values.add(alternativePositionTypeTxt);
        return JOINER.join(values.stream().filter(StringUtils::isNotBlank).iterator());
    }

    @Nonnull
    public static String surrogatePositionNumber(@NonNull MeasurementPositionUpdateItem measurementPositionUpdateItem) {
        if (measurementPositionUpdateItem == null) {
            throw new NullPointerException("measurementPositionUpdateItem is marked non-null but is null");
        }
        return measurementPositionUpdateItem.surrogatePositionNumber();
    }

    @Nonnull
    public static String surrogatePositionNumber(@NonNull QuotationPosition quotationPosition) {
        if (quotationPosition == null) {
            throw new NullPointerException("quotationPosition is marked non-null but is null");
        }
        ArrayList values = Lists.newArrayList();
        values.add(StringUtils.trimToEmpty((String)quotationPosition.getGroupingElementLevel1()));
        values.add(StringUtils.trimToEmpty((String)quotationPosition.getGroupingElementLevel2()));
        values.add(StringUtils.trimToEmpty((String)quotationPosition.getGroupingElementLevel3()));
        values.add(StringUtils.trimToEmpty((String)quotationPosition.getGroupingElementLevel4()));
        values.add(StringUtils.trimToEmpty((String)quotationPosition.getPositionNumber()));
        Integer subPositionNumber = quotationPosition.getSubPositionNumber();
        if (null != subPositionNumber) {
            values.add("" + subPositionNumber);
        }
        EAlternativePositionType alternativePositionType = (EAlternativePositionType)MoreObjects.firstNonNull((Object)quotationPosition.getAlternativePositionType(), (Object)EAlternativePositionType.NO);
        String alternativePositionTypeTxt = SurrogatePositionNumberHelper.alternativePositionTypeTxt((EAlternativePositionType)alternativePositionType);
        values.add(alternativePositionTypeTxt);
        return JOINER.join(values.stream().filter(StringUtils::isNotBlank).iterator());
    }

    @Nonnull
    public static String groupingLevel(@NonNull QuotationPosition quotationPosition) {
        if (quotationPosition == null) {
            throw new NullPointerException("quotationPosition is marked non-null but is null");
        }
        ArrayList values = Lists.newArrayList();
        values.add(StringUtils.trimToEmpty((String)quotationPosition.getGroupingElementLevel1()));
        values.add(StringUtils.trimToEmpty((String)quotationPosition.getGroupingElementLevel2()));
        values.add(StringUtils.trimToEmpty((String)quotationPosition.getGroupingElementLevel3()));
        values.add(StringUtils.trimToEmpty((String)quotationPosition.getGroupingElementLevel4()));
        return JOINER.join(values.stream().filter(StringUtils::isNotBlank).iterator());
    }

    @Nonnull
    public static String positionNumber(@NonNull QuotationPosition quotationPosition) {
        if (quotationPosition == null) {
            throw new NullPointerException("quotationPosition is marked non-null but is null");
        }
        ArrayList values = Lists.newArrayList();
        values.add(StringUtils.trimToEmpty((String)quotationPosition.getGroupingElementLevel1()));
        values.add(StringUtils.trimToEmpty((String)quotationPosition.getGroupingElementLevel2()));
        values.add(StringUtils.trimToEmpty((String)quotationPosition.getGroupingElementLevel3()));
        values.add(StringUtils.trimToEmpty((String)quotationPosition.getGroupingElementLevel4()));
        values.add(StringUtils.trimToEmpty((String)quotationPosition.getPositionNumber()));
        Integer subPositionNumber = quotationPosition.getSubPositionNumber();
        if (null != subPositionNumber) {
            values.add("" + subPositionNumber);
        }
        return JOINER.join(values.stream().filter(StringUtils::isNotBlank).iterator());
    }

    @Nonnull
    public static String surrogatePositionNumber(@NonNull StagePositionModificationItem modificationItem) {
        if (modificationItem == null) {
            throw new NullPointerException("modificationItem is marked non-null but is null");
        }
        ArrayList values = Lists.newArrayList();
        values.add(StringUtils.trimToEmpty((String)modificationItem.getGroupingElementLevel1()));
        values.add(StringUtils.trimToEmpty((String)modificationItem.getGroupingElementLevel2()));
        values.add(StringUtils.trimToEmpty((String)modificationItem.getGroupingElementLevel3()));
        values.add(StringUtils.trimToEmpty((String)modificationItem.getGroupingElementLevel4()));
        values.add(StringUtils.trimToEmpty((String)modificationItem.getPositionNumber()));
        Integer subPositionNumber = modificationItem.getSubPositionNumber();
        if (null != subPositionNumber) {
            values.add("" + subPositionNumber);
        }
        String alternativePositionType = StringUtils.trimToEmpty((String)modificationItem.getAlternativePositionType());
        String alternativePositionTypeTxt = SurrogatePositionNumberHelper.alternativePositionTypeTxt((String)alternativePositionType);
        values.add(alternativePositionTypeTxt);
        return JOINER.join(values.stream().filter(StringUtils::isNotBlank).iterator());
    }

    @Nonnull
    private static String alternativePositionTypeTxt(@NonNull String alternativePositionTypeCand) {
        if (alternativePositionTypeCand == null) {
            throw new NullPointerException("alternativePositionTypeCand is marked non-null but is null");
        }
        EAlternativePositionType alternativePositionType = EAlternativePositionType.lookup((String)alternativePositionTypeCand, (EAlternativePositionType)EAlternativePositionType.NO);
        return SurrogatePositionNumberHelper.alternativePositionTypeTxt((EAlternativePositionType)alternativePositionType);
    }

    @Nonnull
    private static String alternativePositionTypeTxt(@NonNull EAlternativePositionType alternativePositionType) {
        if (alternativePositionType == null) {
            throw new NullPointerException("alternativePositionType is marked non-null but is null");
        }
        if (EAlternativePositionType.YES__EXCLUDE_FROM_CALCULATION == alternativePositionType) {
            return "x";
        }
        if (EAlternativePositionType.YES__INCLUDE_IN_CALCULATION == alternativePositionType) {
            return "o";
        }
        return "";
    }
}

