/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.request.tracking.TrackingPointUpdateRequest;
import de.qfm.erp.common.response.tracking.TrackingPointCommon;
import de.qfm.erp.service.service.route.TrackingPointRoute;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.validation.Valid;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/erp/trackingpoints"})
@ApiResponses(value={@ApiResponse(responseCode="400", description="Something went wrong"), @ApiResponse(responseCode="403", description="Access denied"), @ApiResponse(responseCode="401", description="Expired or invalid JWT token")})
public class TrackingPointResource {
    private static final Logger log = LogManager.getLogger(TrackingPointResource.class);
    private final TrackingPointRoute route;

    @Operation(summary="Create a Tracking Point under given Category")
    @PostMapping(value={"/{category}/"}, consumes={"application/json"}, produces={"application/json"})
    public TrackingPointCommon createOrUpdate(@PathVariable(value="category") String categoryCandidate, @Valid @RequestBody TrackingPointUpdateRequest request) {
        return this.route.createOrUpdate(categoryCandidate, request);
    }

    public TrackingPointResource(TrackingPointRoute route) {
        this.route = route;
    }
}

