/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.request.taxkey.TaxKeyUpdateRequest;
import de.qfm.erp.common.response.taxkey.TaxKeyCommon;
import de.qfm.erp.common.response.taxkey.TaxKeyPageCommon;
import de.qfm.erp.service.service.route.TaxKeyRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Tax Key Management Resource", name="TaxKeyResource")
@OpenAPIDefinition(tags={@Tag(name="TaxKeyResource", description="All Operations around TaxKeys")})
@ApiResponses(value={@ApiResponse(responseCode="400", description="Something went wrong"), @ApiResponse(responseCode="403", description="Access denied"), @ApiResponse(responseCode="401", description="Expired or invalid JWT token")})
@RestController
@RequestMapping(value={"/api/v1/erp/taxkeys"})
public class TaxKeyResource {
    private static final Logger log = LogManager.getLogger(TaxKeyResource.class);
    private final TaxKeyRoute route;

    @Operation(summary="Tax Key List / Paging")
    @GetMapping(value={"/"})
    public TaxKeyPageCommon list(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size, @RequestParam(value="filter_invoice_type", defaultValue="") String filterInvoiceType, @RequestParam(value="filter_flag_subcontractor_as_external_service_accounting", defaultValue="false") boolean flagSubContractorAsExternalServiceAccounting, @RequestParam(value="filter_flag_company_group", defaultValue="false") boolean flagCompanyGroup) {
        return this.route.page(page, size, StringUtils.trimToEmpty((String)filterInvoiceType), flagSubContractorAsExternalServiceAccounting, flagCompanyGroup);
    }

    @Operation(summary="Tax Key for Id")
    @GetMapping(value={"/{id}/"}, produces={"application/json"})
    public TaxKeyCommon getById(@PathVariable(value="id") long id) {
        return this.route.byId(id);
    }

    @Operation(summary="Tax Key for Id")
    @DeleteMapping(value={"/{id}/"}, produces={"application/json"})
    public TaxKeyCommon deleteById(@PathVariable(value="id") long id) {
        return this.route.deleteById(id);
    }

    @Operation(summary="Create a Customer")
    @PostMapping(value={"/"}, consumes={"application/json"}, produces={"application/json"})
    public TaxKeyCommon update(@RequestBody TaxKeyUpdateRequest updateRequest) {
        return this.route.update(updateRequest);
    }

    @Operation(summary="Update Customer by Id")
    @PostMapping(value={"/{id}/"}, consumes={"application/json"}, produces={"application/json"})
    public TaxKeyCommon updateForId(@PathVariable(value="id") long id, @RequestBody TaxKeyUpdateRequest updateRequest) {
        return this.route.update(id, updateRequest);
    }

    public TaxKeyResource(TaxKeyRoute route) {
        this.route = route;
    }
}

