/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.response.measurement.MeasurementCommon;
import de.qfm.erp.common.response.measurement.ReleaseOrderCommonV1;
import de.qfm.erp.common.response.pss.PssReleaseOrderCommon;
import de.qfm.erp.common.response.user.UserCommon;
import de.qfm.erp.common.response.user.UserPageCommon;
import de.qfm.erp.service.service.route.MeasurementRoute;
import de.qfm.erp.service.service.route.PssRoute;
import de.qfm.erp.service.service.route.ReleaseOrderRoute;
import de.qfm.erp.service.service.route.UserRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Sync Resource", name="SyncResource")
@OpenAPIDefinition(tags={@Tag(name="SyncResource", description="All Operations around Syncing Data between this Service and ELAN. This Endpoint is protected with a special Mechanism to prevent standard Authentication to force Sync Updates")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v1/erp-sync"})
public class SyncResource {
    private static final Logger log = LogManager.getLogger(SyncResource.class);
    private final MeasurementRoute measurementRoute;
    private final PssRoute pssRoute;
    private final ReleaseOrderRoute releaseOrderRoute;
    private final UserRoute userRoute;

    @GetMapping(value={"/"})
    public String pingGet() {
        return "Sync Resource (GET Ping)";
    }

    @PostMapping(value={"/"})
    public String pingPost() {
        return "Sync Resource (POST Ping)";
    }

    @Operation(summary="Paged Users Listing")
    @GetMapping(value={"/users/"}, produces={"application/json"})
    public UserPageCommon listUsers(@Parameter(description="Filter by 'any' Text") @RequestParam(value="filter_text", defaultValue="") String filterText, @Parameter(description="The Page index starting at 0", example="0") @RequestParam(value="page", defaultValue="0") int page, @Parameter(description="The Page Size", example="100") @RequestParam(value="size", defaultValue="100") int size) {
        return this.userRoute.page(filterText, page, size);
    }

    @Operation(summary="Get User via Reference Id")
    @GetMapping(value={"/users/refId={refId}/"}, produces={"application/json"})
    public UserCommon userByReferenceId(@PathVariable(value="refId") String refId) {
        return this.userRoute.byReferenceId(refId);
    }

    @Operation(summary="Get PSS Release Order for Reference Id")
    @GetMapping(value={"/pss/releaseorders/refId={refId}/"}, produces={"application/json"})
    public PssReleaseOrderCommon pssReleaseOrderByReferenceId(@PathVariable(value="refId") String refId) {
        return this.pssRoute.byReferenceId(refId);
    }

    @Operation(summary="Get Release Order for Reference Id")
    @GetMapping(value={"/releaseorders/refId={refId}/"}, produces={"application/json"})
    public ReleaseOrderCommonV1 releaseOrderByReferenceId(@PathVariable(value="refId") String refId) {
        return this.releaseOrderRoute.byReferenceId(refId);
    }

    @Operation(summary="Update Measurement via MeasurementSyncRequest")
    @DeleteMapping(value={"/measurements/refId={refId}/"}, produces={"application/json"})
    public MeasurementCommon updateMeasurement(@PathVariable(value="refId") String refId) {
        return this.measurementRoute.delete(refId);
    }

    @Operation(summary="Get Release Order for Reference Id")
    @GetMapping(value={"/measurements/refId={refId}/"}, produces={"application/json"})
    public MeasurementCommon measurementByReferenceId(@PathVariable(value="refId") String refId) {
        return this.measurementRoute.byReferenceId(refId);
    }

    @Operation(summary="Set new State for Measurement with Id")
    @PostMapping(value={"/{id}/_state/{new_state}/"}, consumes={"application/json"}, produces={"application/json"})
    public MeasurementCommon updateStateForId(@Parameter(description="Measurement Id of the Measurement to Update", required=true) @PathVariable(value="id") long id, @Parameter(description="new State for Measurement", example="TEMPORARY, APPROVED", required=true) @PathVariable(value="new_state") String newStateCandidate) {
        return this.measurementRoute.updateStateForId(id, newStateCandidate);
    }

    public SyncResource(MeasurementRoute measurementRoute, PssRoute pssRoute, ReleaseOrderRoute releaseOrderRoute, UserRoute userRoute) {
        this.measurementRoute = measurementRoute;
        this.pssRoute = pssRoute;
        this.releaseOrderRoute = releaseOrderRoute;
        this.userRoute = userRoute;
    }
}

