/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.response.synclog.SyncLogPageCommon;
import de.qfm.erp.service.service.route.SyncLogRoute;
import io.swagger.v3.oas.annotations.Operation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/erp/synclog"})
public class SyncLogResource {
    private static final Logger log = LogManager.getLogger(SyncLogResource.class);
    private final SyncLogRoute route;

    @Operation(summary="Sync Log List / most recent first")
    @GetMapping(value={"/"})
    public SyncLogPageCommon list(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size) {
        return this.route.list(page, size);
    }

    @Operation(summary="Sync Log By ReferenceType nad ReferenceId / most recent first")
    @GetMapping(value={"/{reference_type}/{reference_id}/"})
    public SyncLogPageCommon listByTypeAndId(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size, @PathVariable(name="reference_type") String referenceType, @PathVariable(name="reference_id") String referenceId) {
        return this.route.list(page, size);
    }

    public SyncLogResource(SyncLogRoute route) {
        this.route = route;
    }
}

